/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.io;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Stack;
import jlibs.core.graph.Filter;
import jlibs.core.graph.Path;
import jlibs.core.graph.Processor;
import jlibs.core.graph.WalkerUtil;
import jlibs.core.graph.walkers.PreorderWalker;
import jlibs.core.io.FileNavigator;
import jlibs.core.io.IOUtil;
import jlibs.core.lang.ImpossibleException;
import jlibs.core.lang.StringUtil;

public class FileUtil {
    public static final String PATH_SEPARATOR = File.pathSeparator;
    public static final String SEPARATOR = File.separator;
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final File JAVA_HOME = new File(System.getProperty("java.home"));
    public static final File USER_HOME = new File(System.getProperty("user.home"));
    public static final File USER_DIR = new File(System.getProperty("user.dir"));
    public static final File TMP_DIR = new File(System.getProperty("java.io.tmpdir"));
    private static final FileCreator CREATOR = new FileCreator(){

        @Override
        public void createFile(File sourceFile, File targetFile) throws IOException {
            FileUtil.mkdirs(targetFile.getParentFile());
            IOUtil.pump(new FileInputStream(sourceFile), new FileOutputStream(targetFile), true, true);
        }

        @Override
        public String translate(String name) {
            return name;
        }
    };

    public static URL toURL(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException ex) {
            throw new ImpossibleException(ex);
        }
    }

    public static String[] split(String fileName) {
        int dot = fileName.lastIndexOf(46);
        if (dot == -1) {
            return new String[]{fileName, null};
        }
        return new String[]{fileName.substring(0, dot), fileName.substring(dot + 1)};
    }

    public static String getName(String fileName) {
        int dot = fileName.lastIndexOf(46);
        return dot == -1 ? fileName : fileName.substring(0, dot);
    }

    public static String getExtension(String fileName) {
        int dot = fileName.lastIndexOf(46);
        return dot == -1 ? null : fileName.substring(dot + 1);
    }

    public static File findFreeFile(final File dir, String pattern, boolean tryEmptyVar) {
        String name = StringUtil.suggest(new Filter<String>(){

            @Override
            public boolean select(String name) {
                return !new File(dir, name).exists();
            }
        }, pattern, tryEmptyVar);
        return new File(dir, name);
    }

    public static File findFreeFile(File file) {
        if (!file.exists()) {
            return file;
        }
        String[] parts = FileUtil.split(file.getName());
        String pattern = parts[1] == null ? parts[0] + "${i}" : parts[0] + "${i}." + parts[1];
        return FileUtil.findFreeFile(file.getParentFile(), pattern, true);
    }

    public static void delete(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        if (file.isFile()) {
            if (!file.delete()) {
                throw new IOException("couldn't delete file :" + file);
            }
        } else {
            try {
                WalkerUtil.walk(new PreorderWalker<File>(file, FileNavigator.INSTANCE), new Processor<File>(){

                    @Override
                    public boolean preProcess(File file, Path path) {
                        return true;
                    }

                    @Override
                    public void postProcess(File file, Path path) {
                        try {
                            if (!file.delete()) {
                                throw new IOException("couldn't delete file :" + file);
                            }
                        }
                        catch (IOException ex) {
                            throw new RuntimeException(ex);
                        }
                    }
                });
            }
            catch (RuntimeException ex) {
                if (ex.getCause() instanceof IOException) {
                    throw (IOException)ex.getCause();
                }
                throw ex;
            }
        }
    }

    public static void deleteEmptyDirs(File directory) throws IOException {
        if (directory.isFile()) {
            return;
        }
        PreorderWalker<File> walker = new PreorderWalker<File>(directory, new FileNavigator(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        }));
        try {
            WalkerUtil.walk(walker, new Processor<File>(){

                @Override
                public boolean preProcess(File file, Path path) {
                    return true;
                }

                @Override
                public void postProcess(File file, Path path) {
                    try {
                        if (file.list().length == 0) {
                            FileUtil.delete(file);
                        }
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            });
        }
        catch (RuntimeException ex) {
            if (ex.getCause() instanceof IOException) {
                throw (IOException)ex.getCause();
            }
            throw ex;
        }
    }

    public static void mkdir(File dir) throws IOException {
        if (!dir.exists() && !dir.mkdir()) {
            throw new IOException("couldn't create directory: " + dir);
        }
    }

    public static void mkdirs(File dir) throws IOException {
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("couldn't create directory: " + dir);
        }
    }

    public static void copyInto(File source, File targetDir) throws IOException {
        FileUtil.copyInto(source, targetDir, CREATOR);
    }

    public static void copy(File source, File target) throws IOException {
        FileUtil.copy(source, target, CREATOR);
    }

    public static void copyInto(File source, File targetDir, FileCreator creator) throws IOException {
        File target = new File(targetDir, creator.translate(source.getName()));
        FileUtil.copy(source, target, creator);
    }

    public static void copy(File source, File target, final FileCreator creator) throws IOException {
        if (source.isFile()) {
            creator.createFile(source, target);
        } else {
            try {
                FileUtil.mkdirs(target);
                PreorderWalker<File> walker = new PreorderWalker<File>(source, FileNavigator.INSTANCE);
                walker.next();
                final Stack<File> stack = new Stack<File>();
                stack.push(target);
                WalkerUtil.walk(walker, new Processor<File>(){

                    @Override
                    public boolean preProcess(File source, Path path) {
                        File result = (File)stack.peek();
                        result = new File(result, creator.translate(source.getName()));
                        stack.push(result);
                        try {
                            if (source.isDirectory()) {
                                FileUtil.mkdirs(result);
                            } else {
                                creator.createFile(source, result);
                            }
                        }
                        catch (IOException ex) {
                            throw new RuntimeException(ex);
                        }
                        return true;
                    }

                    @Override
                    public void postProcess(File source, Path path) {
                        stack.pop();
                    }
                });
            }
            catch (IOException ex) {
                if (ex.getCause() instanceof IOException) {
                    throw (IOException)ex.getCause();
                }
                throw ex;
            }
        }
    }

    public static void main(String[] args) throws IOException {
        FileUtil.copyInto(new File("/Users/santhosh/Downloads/xml-schemas"), new File("/Users/santhosh/Downloads/Incomplete"));
    }

    public static interface FileCreator {
        public void createFile(File var1, File var2) throws IOException;

        public String translate(String var1);
    }
}

