/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.graph.sequences;

import jlibs.core.graph.Sequence;
import jlibs.core.graph.sequences.Element;

public abstract class AbstractSequence<E>
implements Sequence<E> {
    private boolean advanced = false;
    private E next;
    protected Element<E> current = new Element();

    protected AbstractSequence() {
        this._reset();
    }

    @Override
    public boolean hasNext() {
        if (this.current.finished()) {
            return false;
        }
        if (!this.advanced) {
            this.next = this.findNext();
            this.advanced = true;
        }
        return this.next != null;
    }

    @Override
    public final E next() {
        if (this.current.finished()) {
            return null;
        }
        if (this.advanced) {
            this.advanced = false;
            this.current.set(this.next);
            this.next = null;
        } else {
            this.current.set(this.findNext());
        }
        return this.current.get();
    }

    @Override
    public final E next(int count) {
        if (this.current.finished()) {
            return null;
        }
        if (count <= 0) {
            return this.current();
        }
        if (count == 1) {
            return this.next();
        }
        if (this.advanced) {
            this.next();
            return this.next(count - 1);
        }
        Element<E> elem = this.findNext(count);
        if (elem == null) {
            while (count > 0 && this.next() != null) {
                --count;
            }
        } else {
            this.current = elem;
        }
        return this.current();
    }

    protected abstract E findNext();

    protected Element<E> findNext(int count) {
        return null;
    }

    @Override
    public int index() {
        return this.current.index();
    }

    @Override
    public final E current() {
        return this.current.get();
    }

    @Override
    public int length() {
        Sequence seq = this.copy();
        int len = 0;
        while (seq.next() != null) {
            ++len;
        }
        return len;
    }

    private void _reset() {
        this.current.reset();
        this.next = null;
        this.advanced = false;
    }

    @Override
    public void reset() {
        this._reset();
    }
}

