/*
 * Decompiled with CFR 0.152.
 */
package com.eed3si9n.jarjar.misplaced;

import com.eed3si9n.jarjar.util.EntryStruct;
import com.eed3si9n.jarjar.util.JarProcessor;
import java.io.IOException;
import org.objectweb.asm.ClassReader;

public abstract class MisplacedClassProcessor
implements JarProcessor {
    public static String VERSIONED_CLASS_FOLDER = "META-INF/versions/";

    public abstract void handleMisplacedClass(EntryStruct var1, String var2);

    public abstract boolean shouldTransform();

    public abstract boolean shouldKeep();

    @Override
    public boolean process(EntryStruct entryStruct) throws IOException {
        String string;
        String string2;
        if (!entryStruct.name.endsWith(".class")) {
            return true;
        }
        try {
            string2 = new ClassReader(entryStruct.data).getClassName() + ".class";
        }
        catch (Exception exception) {
            System.err.println("Unable to read classname from bytecode in " + entryStruct.name);
            System.err.println("Shading is therefore impossible, so this entry will be skipped.");
            System.err.println(exception.getClass().getName() + ": " + exception.getMessage());
            entryStruct.skipTransform = true;
            return true;
        }
        String string3 = string = entryStruct.name.startsWith(VERSIONED_CLASS_FOLDER) ? entryStruct.name.substring(entryStruct.name.indexOf("/", VERSIONED_CLASS_FOLDER.length()) + 1) : entryStruct.name;
        if (!string2.equals(string)) {
            System.err.println(this.formatMisplacedClassMessage(entryStruct, string2));
            this.handleMisplacedClass(entryStruct, string2);
            if (!this.shouldTransform()) {
                entryStruct.skipTransform = true;
            }
            return this.shouldKeep();
        }
        return true;
    }

    protected String formatMisplacedClassMessage(EntryStruct entryStruct, String string) {
        return "Fully-qualified classname does not match jar entry:\n  jar entry: " + entryStruct.name + "\n  class name: " + string;
    }
}

