/*
 *    WMAcpiLoad - A dockapp to monitor ACPI status
 *    Copyright (C) 2002  Thomas Nemeth <tnemeth@free.fr>
 *
 *    Patch by Alan Carriou <cariou_alan@yahoo.fr> (C) 2004-2005
 *
 *    Based on work by Seiichi SATO <ssato@sh.rim.or.jp>
 *    Copyright (C) 2001,2002  Seiichi SATO <ssato@sh.rim.or.jp>
 *    and on work by Mark Staggs <me@markstaggs.net>
 *    Copyright (C) 2002  Mark Staggs <me@markstaggs.net>

 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.

 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.

 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef H_WMACPILOAD
#  define H_WMACPILOAD

/************************************************************************
 * Macros and default values
 ************************************************************************/

/* default number of seconds between updates */
#  define DEFAULT_UPDATE_TIME       10
/* default battery status under which alarm mode is set (percentage) */
#  define DEFAULT_ALARM_BAT_LEVEL   20
/* default temperature over which alarm mode is set (celcius degrees) */
#  define DEFAULT_ALARM_TEMPERATURE 70

#  define MAXSTRLEN                512  /* ? */
#  define MAX_HISTORY               16  /* ? */
#  define CPUNUM_NONE               -1  /* ? */

/*
 * "safe" free macro.
 * "data" is evaluated twice, so don't put in any fancy thing like "*t++",
 * because it just won't work.
 */
#  define MYFREE(data)                                                    \
	do {                                                              \
	    free(data);                                                   \
	    (data) = NULL;                                                \
	} while (0)

/************************************************************************
 * Global variable declarations (defined in main.c)
 ************************************************************************/

/*
 * Non-null value causes debug messages on standard output.
 * The higher the value, the more talkative it is.
 */
extern unsigned int verbose;

/* Name of an ACPI device we want to ignore */
extern char *ignored_device;

/*
 * Following variable is set to 1 to say that this kind of device if 
 * enabled, and to 0 when they are disabled (i.e. we totally ignore them)
 */
extern int batteries_enabled;

/* variable to hold every useful acpi information about the machine */
extern AcpiInfos cur_acpi_infos;

#endif                          /* H_WMACPILOAD */
