/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.gui.IzPanelConstraints;
import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.LayoutConstants;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.LayoutHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PathSelectionPanel
extends JPanel
implements ActionListener,
LayoutConstants {
    private static final long serialVersionUID = 3618700794577105718L;
    private JTextField textField;
    private JButton browseButton;
    private IzPanel parent;
    private InstallData idata;

    public PathSelectionPanel(IzPanel izPanel, InstallData installData) {
        this.parent = izPanel;
        this.idata = installData;
        this.createLayout();
    }

    protected void createLayout() {
        LayoutHelper layoutHelper = new LayoutHelper(this);
        layoutHelper.startLayout(new IzPanelLayout());
        IzPanelConstraints izPanelConstraints = IzPanelLayout.getDefaultConstraint(1);
        izPanelConstraints.setXStretch(1.0);
        this.textField = new JTextField(this.idata.getInstallPath(), 10);
        this.textField.addActionListener(this);
        this.parent.setInitialFocus(this.textField);
        this.add((Component)this.textField, izPanelConstraints);
        this.add(IzPanelLayout.createHorizontalFiller(3));
        this.browseButton = ButtonFactory.createButton(this.parent.getInstallerFrame().langpack.getString("TargetPanel.browse"), this.parent.getInstallerFrame().icons.getImageIcon("open"), this.idata.buttonsHColor);
        this.browseButton.addActionListener(this);
        this.add(this.browseButton);
    }

    public Dimension getMinimumSize() {
        Dimension dimension = super.getPreferredSize();
        Dimension dimension2 = this.parent.getSize();
        dimension2.height = dimension.height;
        return dimension2;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.browseButton) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setCurrentDirectory(new File(this.textField.getText()));
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.setFileSelectionMode(1);
            jFileChooser.addChoosableFileFilter(jFileChooser.getAcceptAllFileFilter());
            if (jFileChooser.showSaveDialog(this) == 0) {
                String string = jFileChooser.getSelectedFile().getAbsolutePath();
                this.textField.setText(string);
            }
        } else if (this.parent instanceof ActionListener) {
            ((ActionListener)((Object)this.parent)).actionPerformed(actionEvent);
        }
    }

    public String getPath() {
        return this.textField.getText();
    }

    public void setPath(String string) {
        this.textField.setText(string);
    }

    public JTextField getPathInputField() {
        return this.textField;
    }

    public JButton getBrowseButton() {
        return this.browseButton;
    }
}

