/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.framework.builder;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.jsdl.action.ActionBuilder;
import com.jgoodies.common.swing.internal.IActionObject;
import com.jgoodies.components.JGCheckBoxMenuItem;
import com.jgoodies.components.JGComponentFactory;
import com.jgoodies.components.JGMenuItem;
import com.jgoodies.components.JGRadioButtonMenuItem;
import com.jgoodies.components.util.Mode;
import com.jgoodies.components.util.Modes;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.function.Consumer;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public final class PopupMenuBuilder {
    private static Mode iconVisibleDefaultMode = Modes.LAF_NON_AQUA;
    private Mode iconVisibleMode;
    private String title;
    private JPopupMenu popupMenu;
    private IActionObject actionProvider;
    private JGComponentFactory factory;

    public PopupMenuBuilder() {
        this(null, null, null);
    }

    public PopupMenuBuilder(String titleText) {
        this(null, null, null);
        this.title(titleText);
    }

    public PopupMenuBuilder(IActionObject actionProvider) {
        this(null, null, null);
        this.actionProvider(actionProvider);
    }

    public PopupMenuBuilder(JPopupMenu menu, IActionObject actionProvider, JGComponentFactory factory) {
        this.popupMenu(menu);
        this.actionProvider(actionProvider);
        this.factory(factory);
        this.iconVisibleMode(PopupMenuBuilder.getIconVisibleDefaultMode());
    }

    public static Mode getIconVisibleDefaultMode() {
        return iconVisibleDefaultMode;
    }

    public static void setIconVisibleDefaultMode(Mode newDefaultMode) {
        iconVisibleDefaultMode = newDefaultMode;
    }

    public PopupMenuBuilder title(String text) {
        this.title = text;
        return this;
    }

    public PopupMenuBuilder popupMenu(JPopupMenu popupMenu) {
        Preconditions.checkArgument(this.popupMenu == null, "The popup menu must be set only once.");
        this.popupMenu = popupMenu;
        return this;
    }

    public PopupMenuBuilder actionProvider(IActionObject actionProvider) {
        this.actionProvider = actionProvider;
        return this;
    }

    public PopupMenuBuilder factory(JGComponentFactory factory) {
        this.factory = factory;
        return this;
    }

    public PopupMenuBuilder iconVisibleMode(Mode newMode) {
        this.iconVisibleMode = newMode;
        return this;
    }

    public PopupMenuBuilder clientProperty(Object key, Object value) {
        this.getPopupMenu().putClientProperty(key, value);
        return this;
    }

    public PopupMenuBuilder noIcons() {
        this.clientProperty("jgoodies.noIcons", Boolean.TRUE);
        return this;
    }

    public PopupMenuBuilder doWith(Consumer<PopupMenuBuilder> consumer) {
        consumer.accept(this);
        return this;
    }

    public JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu(this.title);
        }
        return this.popupMenu;
    }

    public JPopupMenu build() {
        int count;
        JPopupMenu menu = this.getPopupMenu();
        if (menu.getComponentCount() > 0 && menu.getComponent(0) instanceof JPopupMenu.Separator) {
            menu.remove(0);
        }
        if ((count = menu.getComponentCount()) > 0 && menu.getComponent(count - 1) instanceof JPopupMenu.Separator) {
            menu.remove(count - 1);
        }
        return menu;
    }

    public void show(MouseEvent evt) {
        this.build().show(evt.getComponent(), evt.getX(), evt.getY());
    }

    public void show(ActionEvent evt) {
        Component source = (Component)evt.getSource();
        this.build().show(source, 0, source.getHeight());
    }

    public PopupMenuBuilder action(Action action) {
        Preconditions.checkNotNull(action, "The %s must not be null.", "action");
        this.item(this.getFactory().createMenuItem(action));
        return this;
    }

    public PopupMenuBuilder action(String actionName) {
        return this.action(this.getTarget(), actionName);
    }

    public PopupMenuBuilder action(IActionObject actionProvider, String actionName) {
        Preconditions.checkNotNull(actionProvider, "The %s must not be null.", "action provider");
        Preconditions.checkNotNull(actionName, "The %s must not be null.", "action name");
        this.action(actionProvider.getAction(actionName));
        return this;
    }

    public PopupMenuBuilder item(String markedText, Consumer<ActionEvent> handler) {
        return this.item(markedText, handler, true);
    }

    public PopupMenuBuilder item(String markedText, Consumer<ActionEvent> handler, boolean enabled) {
        return this.action(new ActionBuilder().handler(handler).text(markedText, new Object[0]).enabled(enabled).build());
    }

    public PopupMenuBuilder item(String markedText) {
        this.item(this.getFactory().createMenuItem(markedText));
        return this;
    }

    public PopupMenuBuilder item(String markedText, Icon icon) {
        this.item(this.getFactory().createMenuItem(markedText, icon));
        return this;
    }

    public PopupMenuBuilder item(JMenuItem item) {
        this.getPopupMenu().add(item);
        return this;
    }

    public PopupMenuBuilder item(JGMenuItem item) {
        item.setIconVisibleMode(this.iconVisibleMode);
        this.item((JMenuItem)item);
        return this;
    }

    public PopupMenuBuilder item(JGRadioButtonMenuItem item) {
        item.setIconVisibleMode(this.iconVisibleMode);
        this.item((JMenuItem)item);
        return this;
    }

    public PopupMenuBuilder item(JGCheckBoxMenuItem item) {
        item.setIconVisibleMode(this.iconVisibleMode);
        this.item((JMenuItem)item);
        return this;
    }

    public PopupMenuBuilder separator() {
        this.getPopupMenu().addSeparator();
        return this;
    }

    private JGComponentFactory getFactory() {
        if (this.factory == null) {
            this.factory = JGComponentFactory.getCurrent();
        }
        return this.factory;
    }

    private IActionObject getTarget() {
        Preconditions.checkNotNull(this.actionProvider, "To use the #action(String) feature, a default action provider must be set, see #target.");
        return this.actionProvider;
    }
}

