/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.components.internal;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.base.Strings;
import com.jgoodies.common.swing.internal.RenderingUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;

public final class PromptSupport {
    public static final String PROPERTY_PROMPT = "prompt";
    public static final String PROPERTY_PROMPT_STYLE = "promptStyle";
    public static final String PROPERTY_PROMPT_VISIBLE_WHEN_FOCUSED = "promptVisibleWhenFocused";
    public static final String PROPERTY_PROMPT_HORIZONTAL_ALIGNMENT = "promptHorizontalAlignment";
    private static final String PROPERTY_LAST_FOCUS_GAIN_WAS_ACTIVATION = "lastFocusGainWasActivation";
    private static FocusListener focusHandler = null;
    private static Rectangle paintIconR = new Rectangle();
    private static Rectangle paintTextR = new Rectangle();
    private static Rectangle paintViewR = new Rectangle();
    private static Insets paintViewInsets = new Insets(0, 0, 0, 0);

    private PromptSupport() {
    }

    public static String getPrompt(JTextComponent c) {
        return (String)c.getClientProperty(PROPERTY_PROMPT);
    }

    public static void setPrompt(JTextComponent c, String newPrompt) {
        String oldPrompt = PromptSupport.getPrompt(c);
        if (Objects.equals(oldPrompt, newPrompt)) {
            return;
        }
        if (Strings.isNotBlank(newPrompt)) {
            c.addFocusListener(PromptSupport.getFocusHandler());
        } else {
            c.removeFocusListener(PromptSupport.getFocusHandler());
        }
        c.putClientProperty(PROPERTY_PROMPT, newPrompt);
        c.repaint();
    }

    public static int getPromptStyle(JTextComponent c) {
        Integer style = (Integer)c.getClientProperty(PROPERTY_PROMPT_STYLE);
        return style != null ? style : 2;
    }

    public static void setPromptStyle(JTextComponent c, int newStyle) {
        Preconditions.checkArgument(newStyle == 2 || newStyle == 0, "The style must be one of: Font.ITALIC, FONT.PLAIN");
        int oldStyle = PromptSupport.getPromptStyle(c);
        if (oldStyle == newStyle) {
            return;
        }
        c.putClientProperty(PROPERTY_PROMPT_STYLE, newStyle);
        c.repaint();
    }

    public static boolean isPromptVisibleWhenFocused(JTextComponent c) {
        return Boolean.TRUE.equals(c.getClientProperty(PROPERTY_PROMPT_VISIBLE_WHEN_FOCUSED));
    }

    public static void setPromptVisibleWhenFocused(JTextComponent c, boolean newValue) {
        boolean oldValue = PromptSupport.isPromptVisibleWhenFocused(c);
        if (oldValue == newValue) {
            return;
        }
        c.putClientProperty(PROPERTY_PROMPT_VISIBLE_WHEN_FOCUSED, newValue);
        c.repaint();
    }

    public static boolean isPromptPainted(JTextComponent c) {
        return c.isVisible() && (!c.isFocusOwner() || PromptSupport.isPromptVisibleWhenFocused(c) || PromptSupport.getLastFocusGainWasActivation(c)) && c.getDocument().getLength() == 0 && Strings.isNotBlank(PromptSupport.getPrompt(c));
    }

    public static void paintPrompt(JTextComponent c, Graphics g) {
        if (!PromptSupport.isPromptPainted(c)) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        Font font = c.getFont().deriveFont(PromptSupport.getPromptStyle(c));
        FontMetrics fm = g2.getFontMetrics(font);
        Insets insets = c.getInsets(paintViewInsets);
        PromptSupport.paintViewR.x = insets.left;
        PromptSupport.paintViewR.y = insets.top;
        PromptSupport.paintViewR.width = c.getWidth() - (insets.left + insets.right);
        PromptSupport.paintViewR.height = c.getHeight() - (insets.top + insets.bottom);
        PromptSupport.paintIconR.height = 0;
        PromptSupport.paintIconR.width = 0;
        PromptSupport.paintIconR.y = 0;
        PromptSupport.paintIconR.x = 0;
        PromptSupport.paintTextR.height = 0;
        PromptSupport.paintTextR.width = 0;
        PromptSupport.paintTextR.y = 0;
        PromptSupport.paintTextR.x = 0;
        String prompt = PromptSupport.getPrompt(c);
        String clippedText = PromptSupport.layoutPrompt(c, prompt, fm, paintViewR, paintTextR);
        Color color = UIManager.getColor("textInactiveText");
        int x = PromptSupport.paintTextR.x;
        int y = PromptSupport.paintTextR.y + fm.getAscent();
        PromptSupport.drawString(c, g2, clippedText, x, y, color, font);
    }

    private static String layoutPrompt(JTextComponent c, String prompt, FontMetrics fontMetrics, Rectangle viewR, Rectangle textR) {
        int horizontalAlignment = PromptSupport.getPromptHorizontalAlignment(c);
        return SwingUtilities.layoutCompoundLabel(c, fontMetrics, prompt, null, 0, horizontalAlignment, 0, 10, viewR, paintIconR, textR, 0);
    }

    private static void drawString(JComponent c, Graphics2D g2, String text, int x, int y, Color color, Font font) {
        Font oldFont = g2.getFont();
        Color oldColor = g2.getColor();
        g2.setFont(font);
        g2.setColor(color);
        RenderingUtils.drawString(c, g2, text, x, y);
        g2.setColor(oldColor);
        g2.setFont(oldFont);
    }

    private static boolean getLastFocusGainWasActivation(JTextComponent c) {
        return Boolean.TRUE.equals(c.getClientProperty(PROPERTY_LAST_FOCUS_GAIN_WAS_ACTIVATION));
    }

    private static void setLastFocusGainWasActivation(JTextComponent c, boolean b) {
        c.putClientProperty(PROPERTY_LAST_FOCUS_GAIN_WAS_ACTIVATION, b);
    }

    private static int getPromptHorizontalAlignment(JTextComponent c) {
        Object value = c.getClientProperty(PROPERTY_PROMPT_HORIZONTAL_ALIGNMENT);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (c instanceof JTextField) {
            return ((JTextField)c).getHorizontalAlignment();
        }
        return 10;
    }

    private static FocusListener getFocusHandler() {
        if (focusHandler == null) {
            focusHandler = new FocusHandler();
        }
        return focusHandler;
    }

    private static final class FocusHandler
    implements FocusListener {
        private FocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent evt) {
            JTextComponent c = (JTextComponent)evt.getSource();
            boolean activation = evt.getOppositeComponent() == null;
            PromptSupport.setLastFocusGainWasActivation(c, activation);
            c.repaint();
        }

        @Override
        public void focusLost(FocusEvent evt) {
            JTextComponent c = (JTextComponent)evt.getSource();
            c.repaint();
        }
    }
}

