/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.common.swing.internal;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.Window;
import java.awt.dnd.DropTargetEvent;
import java.util.EventObject;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public final class AncestorSupport {
    private AncestorSupport() {
    }

    public static Object getSourceFor(EventObject evt) {
        if (evt == null) {
            return null;
        }
        if (evt instanceof DropTargetEvent) {
            DropTargetEvent dte = (DropTargetEvent)evt;
            return dte.getDropTargetContext().getComponent();
        }
        return evt.getSource();
    }

    public static Component getComponentFor(Object eventSource) {
        MenuContainer mParent;
        if (eventSource instanceof Component) {
            return (Component)eventSource;
        }
        if (eventSource instanceof MenuComponent && (mParent = ((MenuComponent)eventSource).getParent()) instanceof Component) {
            return (Component)mParent;
        }
        return null;
    }

    public static Window getWindowFor(EventObject evt) {
        return AncestorSupport.getWindowFor(AncestorSupport.getSourceFor(evt));
    }

    public static Window getWindowFor(Object eventSource) {
        Component c = AncestorSupport.getComponentFor(eventSource);
        if (c != null) {
            return AncestorSupport.getWindowFor(c);
        }
        if (eventSource != null && eventSource.getClass().getName().equals("com.apple.eawt.Application")) {
            return JOptionPane.getRootFrame();
        }
        return null;
    }

    public static Window getWindowFor(Component c) {
        Component p = c;
        while (p != null) {
            if (p instanceof JPopupMenu) {
                p = ((JPopupMenu)p).getInvoker();
                continue;
            }
            if (p instanceof Frame || p instanceof Dialog) {
                return (Window)p;
            }
            p = p.getParent();
        }
        return null;
    }
}

