/* This file is part of OpenBubbles.
 *
 * OpenBubbles is an SDL clone of Bubbles.
 * Copyright (C) 2004  Benny Sperisen
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * miscellaneous.cpp is the implementation file of miscellaneous.h.
 *
 * Written by:
 *  Benny Sperisen
 *  lasindi@gmail.com
 *  www.freewebs.com/lasindi
 *****************************************************************************/

#include "miscellaneous.h"

bool fadingOn;
bool soundOn;
 
const char* numberToString(int number)
{
  string tempstring,thestring;
  if(number==0)
    return "0";
  if(number<0)
  {
    thestring="-";
    number*=-1;
  }
  while(number>0)
  {
    // Append the proper character for this digit.
    switch((int)number%10)
    {
    case 0:
      tempstring+="0";
      break;
    case 1:
      tempstring+="1";
      break;
    case 2:
      tempstring+="2";
      break;
    case 3:
      tempstring+="3";
      break;
    case 4:
      tempstring+="4";
      break;
    case 5:
      tempstring+="5";
      break;
    case 6:
      tempstring+="6";
      break;
    case 7:
      tempstring+="7";
      break;
    case 8:
      tempstring+="8";
      break;
    default:
      tempstring+="9";
    }
    number=(int)(number/10); // Drop this digit.
  }
  // Because the string is backwards, we have to reverse the characters.
  for(int i=tempstring.length()-1;i>=0;i--)
    thestring+=tempstring.substr(i,1);
  return thestring.c_str();
}

int random_int(int max)
{
  return (int)(max*(float)rand()/RAND_MAX);
}

double random_double(double max)
{
  return max*(float)rand()/RAND_MAX;
}

void saveEverything()
{
  string datadir;
  ofstream tofile;
  datadir=getenv("HOME");
  datadir+="/.openbubbles";
  tofile.open(datadir.c_str());
  if(!tofile.is_open())
    cerr<<"Error!\n";
  tofile<<"Don't mess with this file! If you do, and OpenBubbles crashes, dele"
				<<"te it and let OpenBubbles create a new one."
				<<"\nfading "<<(int)fadingOn<<"\nsound "<<(int)soundOn;
  for(unsigned int i=0;i<high_scores.size();i++)
    tofile<<endl<<high_scores[i].name()<<"| "<<high_scores[i].score();
	for(unsigned int i=high_scores.size();i<NUMBER_OF_SCORES;i++)
		tofile<<endl<<"Nobody| 0";
  tofile.close();
}

void loadSettings()
{
  string datadir,namebuffer;
  ifstream fromfile;
  ofstream tofile;
  datadir=getenv("HOME");
  datadir+="/.openbubbles";
	fadingOn=soundOn=true; // default to true
  fromfile.open(datadir.c_str());
  if(fromfile.is_open())
  {
		getline(fromfile,namebuffer); // Skip the warning.
    while(!fromfile.eof())
    {
			getline(fromfile,namebuffer);
			if(namebuffer.substr(0,6)=="fading")
			{
				if(namebuffer.length()>=8)
					if(namebuffer[7]=='0')
						fadingOn=false;
					else
						fadingOn=true;
				else
				{
					cerr<<"ERROR: ~/.openbubbles was corrupted; try restarting OpenBub"
							<<"bles.\n";
					fromfile.close();
					tofile.open(datadir.c_str());
					tofile<<"Don't mess with this file! If you do, and OpenBubbles cra"
								<<"shes, delete it and let OpenBubbles create a new one.\nfa"
								<<"ding 1\nsound 1\n";
					for(int i=0;i<NUMBER_OF_SCORES;i++)
						tofile<<"\nNobody| 0";
					tofile.close();
					exit(1);
				}
			}
			else if(namebuffer.substr(0,5)=="sound")
			{
				if(namebuffer.length()>=7)
					if(namebuffer[6]=='0')
						soundOn=false;
					else
						soundOn=true;
				else
					if(fromfile.eof())
					{
						cerr<<"ERROR: ~/.openbubbles was corrupted; try restarting OpenBub"
								<<"bles.\n";
						fromfile.close();
						tofile.open(datadir.c_str());
						tofile<<"Don't mess with this file! If you do, and OpenBubbles cra"
									<<"shes, delete it and let OpenBubbles create a new one.\nfa"
									<<"ding: 1\nsound 1\n";
						for(int i=0;i<NUMBER_OF_SCORES;i++)
							tofile<<"\nNobody| 0";
						tofile.close();
						exit(1);
					}
			}
    }
    fromfile.close();
  }
	else
	{
		tofile<<"Don't mess with this file! If you do, and OpenBubbles crashes"
					<<", delete it and let OpenBubbles create a new one.\nfading 1"
					<<"\nsound 1\n";
		for(int i=0;i<NUMBER_OF_SCORES;i++)
			tofile<<"\nNobody 0";
		tofile.close();
	}
}
