/* -*-c-*- */
/*
 * This is an all new program to set the root window to an Xpm pixmap.
 * Copyright 1993, Rob Nation
 * You may use this file for anything you want, as long as the copyright
 * is kept intact. No guarantees of any sort are made in any way regarding
 * this program or anything related to it.
 */

/*
 *  xffm-root additional code by
 *
 *   Copyright (c) 2005 Edscott Wilson Garcia <edscott@xfce.org>
 *
 * You may use this file for anything you want, as long as the copyright
 * is kept intact. No guarantees of any sort are made in any way regarding
 * this program or anything related to it.
 *
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include <gmodule.h>
#include <math.h>
#include "rfm_libs.h"


static
    void
mb_util_set_root_pixmap (Pixmap rootImage) {
    Atom prop = None;
    Atom e_prop = None;
    Atom m_prop = None;
    Bool e_killed = False;
    Atom type;
    int format;
    unsigned long length,
      after;
    unsigned char *data = NULL;
    Display *dpy;

    dpy = XOpenDisplay (NULL);

    TRACE ("MB setting pixmap to 0x%x", (unsigned)rootImage);

        prop = XInternAtom (dpy, "_XSETROOT_ID", False);
    (void)XGetWindowProperty (dpy, GDK_ROOT_WINDOW (), prop, 0L, 1L, True, AnyPropertyType, &type, &format, &length, &after, &data);
    if(type == XA_PIXMAP && format == 32 && length == 1 && after == 0 && *((Pixmap *) data) != None) {
        XKillClient (dpy, *((Pixmap *) data));
    }

    if(data != NULL)
        XFree (data);
    data = NULL;
    e_prop = XInternAtom (dpy, "ESETROOT_PMAP_ID", False);
    (void)XGetWindowProperty (dpy, GDK_ROOT_WINDOW (), e_prop, 0L, 1L, True, AnyPropertyType,
                              &type, &format, &length, &after, &data);
    if(type == XA_PIXMAP && format == 32 && length == 1 && after == 0 && *((Pixmap *) data) != None) {
        e_killed = True;
        XKillClient (dpy, *((Pixmap *) data));
    }
    if(e_killed) {
        m_prop = XInternAtom (dpy, "_XROOTPMAP_ID", False);
        XDeleteProperty (dpy, GDK_ROOT_WINDOW (), m_prop);
    }

    {
        if(data != NULL)
            XFree (data);
        data = NULL;
        XSetCloseDownMode (dpy, RetainPermanent);
        if(e_prop == None)
            e_prop = XInternAtom (dpy, "ESETROOT_PMAP_ID", False);
        if(m_prop == None)
            m_prop = XInternAtom (dpy, "_XROOTPMAP_ID", False);
        XChangeProperty (dpy, GDK_ROOT_WINDOW (), e_prop, XA_PIXMAP, 32, PropModeReplace, (unsigned char *)&rootImage, 1);
        XChangeProperty (dpy, GDK_ROOT_WINDOW (), m_prop, XA_PIXMAP, 32, PropModeReplace, (unsigned char *)&rootImage, 1);
    }

    XCloseDisplay (dpy);

    return;

}

int
main (int argc, char **argv) {
    Pixmap pixmap;
    gchar *fullpath;

    if(fork () != 0) {          //RetainPermanent does not work since pixmap disappears
        rfm_threadwait ();
        _exit (1);
    }
    if(!g_thread_supported ())
        g_thread_init (NULL);
    gdk_threads_init ();
    gdk_threads_enter ();
    gtk_init (&argc, &argv);

    if(argc < 2) {
        g_warning ("usage: %s image_file", argv[0]);
	exit (1);
    }
    if(!rfm_g_file_test (argv[1], G_FILE_TEST_EXISTS)) {
        g_warning ("%s does not exist", argv[1]);
	exit (1);
    }
    /*harakiri: if (!g_spawn_command_line_async("killall rodent-root",&error)){
       g_error_free(error);
       } */

    pixmap = rfm_create_background_pixmap (argv[1]);
    Display *display=gdk_x11_display_get_xdisplay(gdk_display_get_default());
    XSetWindowBackgroundPixmap (display, GDK_ROOT_WINDOW (), pixmap);
    XClearWindow (display, GDK_ROOT_WINDOW ());
    mb_util_set_root_pixmap (pixmap);

    if(g_path_is_absolute (argv[1])) {
        fullpath = g_strdup (argv[1]);
    } else {
        gchar *dir = g_get_current_dir ();
        fullpath = g_build_filename (dir, argv[1], NULL);
    }
    TRACE ("call to rfm_init_env");
    rfm_init_env ();            /* allocate memory for dynamic environment variables */
    rfm_setenv ("PWD", (gchar *) GETWD, FALSE);

    rfm_void (MODULE_DIR, "settings", "mcs_shm_start");
    rfm_rational (MODULE_DIR, "settings", (void *)"RFM_DESKTOP_IMAGE", (void *)fullpath, "mcs_set_var");

    gtk_main ();
    rfm_void (MODULE_DIR, "settings", "mcs_shm_stop");
    _exit (1);
}
