/*
 * C 2003-2012 Edscott Wilson Garcia under GPL <edscott@xfce.org>
 * This software is bound by the GPL, see accompanying files for
 * more information.
 *
 * <edscott@xfce.org>
 *
 *  */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif
#include <unistd.h>
#include <gtk/gtk.h>
#include <string.h>
#include <gmodule.h>
#include <errno.h>
#include <libxml/parser.h>
#include <libxml/tree.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <signal.h>

#include "rodent-mime_gui.h"
#include "rodent-mime_support.h"
#include "rodent-mime_callbacks.h"
#include "rfm_libs.h"
#include "rfm_modules.h"

#define RODENT_MIME_ICON_SIZE 36
static GtkLabel *moving_label;

static GtkTreeView *treeview;
static GtkTreeView *treeview2;
static GtkTreeStore *store;
static GtkTreeStore *store2;
static GtkWidget *xfmime_edit;
static gboolean redlight = TRUE;
void toggle_label (const gchar * txt);

enum {
    DND_NONE,
    DND_MOVE,
    DND_COPY,
    DND_LINK
};

static GtkTargetEntry target_table[] = {
    {"text/uri-list", 0, TARGET_URI_LIST},
    {"text/plain", 0, TARGET_PLAIN},
    {"STRING", 0, TARGET_STRING}
};

#define NUM_TARGETS (sizeof(target_table)/sizeof(GtkTargetEntry))


static gchar *xml_file = NULL;
static gchar *icon_theme_name = NULL;
static GHashTable *generic_icon_hash = NULL;

gboolean
get_xml_files () {
    g_free (xml_file);
    //ICON_open_theme(name);
    xml_file = ICON_get_local_xml_file ();
    if(!xml_file || !rfm_g_file_test (xml_file, G_FILE_TEST_EXISTS)) {
        g_free (xml_file);
        xml_file = ICON_get_global_xml_file ();
    }
    TRACE ("xml file is %s\n", (xml_file) ? xml_file : "NULL");
    return TRUE;
}

static char *dnd_data = NULL;

void
on_treeview2_drag_data_get (GtkWidget * widget,
                            GdkDragContext * drag_context,
                            GtkSelectionData * selection_data, guint info, guint time, gpointer user_data) {
    TRACE ("on_treeview2_drag_data_get drag get\n");
    GtkTreeView *treeview = (GtkTreeView *) widget;
    GtkTreeIter iter;
    GtkTreeSelection *selection = gtk_tree_view_get_selection (treeview);
    gchar *n;
    if(dnd_data)
        g_free (dnd_data);
    dnd_data = NULL;
    gtk_tree_selection_get_selected (selection, (GtkTreeModel **) (&store2), &iter);
    /* GtkTreeModel **model,GtkTreeIter *iter); */
    gchar *path;
    gtk_tree_model_get ((GtkTreeModel *) store2, &iter, M_ICON_COLUMN, &n, M_PATH_COLUMN, &path, -1);
    if(n && path) {
        dnd_data = g_strconcat ("file:", path, NULL);
        gtk_selection_data_set (selection_data, 
		gtk_selection_data_get_selection(selection_data), 
		8, (const guchar *)dnd_data, strlen (dnd_data) + 1);
        TRACE ("dnd_data=%s\n", dnd_data);

    }

    return;

}

xmlNodePtr rootM;
static gboolean
xmladd (GtkTreeModel * treemodel, GtkTreePath * treepath, GtkTreeIter * iter, gpointer data) {
    gchar *i,
     *n;
    xmlNodePtr node;
    gtk_tree_model_get (treemodel, iter, M_NAME_COLUMN, &n, -1);
    gtk_tree_model_get (treemodel, iter, M_ICON_COLUMN, &i, -1);
    TRACE ("n=%s i=%s\n", n, i);
    if(i && strlen (i)) {
        node = xmlNewTextChild (rootM, NULL, (const xmlChar *)"mime-type", NULL);
        xmlSetProp (node, (const xmlChar *)"type", (const xmlChar *)n);
        xmlSetProp (node, (const xmlChar *)"icon", (const xmlChar *)i);
    }

    return FALSE;
}

static void
writexml (void
    ) {
    xmlDocPtr doc;
    char *mimefile = NULL;

    if(!icon_theme_name) {
        g_warning ("!icon_theme_name");
    }

    mimefile = ICON_get_local_xml_file ();

    {
        doc = xmlNewDoc ((const xmlChar *)"1.0");
        doc->children = xmlNewDocRawNode (doc, NULL, (const xmlChar *)"mime-info", NULL);

        rootM = (xmlNodePtr) doc->children;
        xmlDocSetRootElement (doc, rootM);
    }

    /* write xml out */
    gtk_tree_model_foreach ((GtkTreeModel *) store, xmladd, NULL);

    xmlSaveFormatFile (mimefile, doc, 1);

    xmlFreeDoc (doc);
    {
        GtkWidget *dialog = gtk_message_dialog_new ((GtkWindow *) xfmime_edit,
                                                    GTK_DIALOG_DESTROY_WITH_PARENT,
                                                    GTK_MESSAGE_INFO,
                                                    GTK_BUTTONS_CLOSE,
                                                    "%s",
                                                    mimefile);
        gtk_dialog_run (GTK_DIALOG (dialog));
        gtk_widget_destroy (dialog);
    }
    g_free (mimefile);

}

void
on_save_clicked (GtkButton * button, gpointer user_data) {
    writexml ();
}

void
on_quit_clicked (GtkButton * button, gpointer user_data) {
    gtk_main_quit ();
}

gboolean
on_drag_motion (GtkWidget * widget, GdkDragContext * dc, gint x, gint y, guint t, gpointer data) {
    GdkDragAction action;

    /*TRACE("TRACE:  on_drag_motion \n"); */

    /* Insert code to get our default action here. */
    action = GDK_ACTION_COPY;

    gdk_drag_status (dc, GDK_ACTION_COPY, t);
    /*fTRACE(stderr,"dbg: drag motion done...\n"); */

    return (TRUE);
}

static GdkPixbuf *
render_icon (gchar * b) {
    GdkPixbuf *icon;
    TRACE (">>render_icon %s \n", b);
    icon = rfm_get_pixbuf (b, RODENT_MIME_ICON_SIZE);
    return icon;
}

static GdkPixbuf *
dead_icon (const gchar * file) {
    g_warning ("cannot create icon for %s", file);
    GdkPixbuf *icon = NULL;
    icon = rfm_get_pixbuf ("xffm/stock_missing-image", 48);
    return icon;
}

// treeview 1:
void
on_drag_data (GtkWidget * widget,
              GdkDragContext * context, gint x, gint y, GtkSelectionData * data, guint info, guint time, void *client) {
    gchar *g,
     *b;
    int title_offset = 0;
    GtkTreePath *treepath;
    GtkTreeIter iter;
    GdkPixbuf *icon = NULL;
    GtkTreeView *treeview = (GtkTreeView *) widget;
    TRACE ("treeview 1:on_drag_data\n");
//    if(!widget || data->length < 0 || data->format != 8) {
    if(!widget) {
        gtk_drag_finish (context, FALSE, FALSE, time);
        return;
    }

    if(!(info == TARGET_STRING) && !(info == TARGET_URI_LIST)) {
        gtk_drag_finish (context, FALSE, FALSE, time);
        return;
    }

    if(gtk_tree_view_get_headers_visible (treeview)) {
        PangoRectangle logical_rect;
        PangoLayout *layout = gtk_widget_create_pango_layout ((GtkWidget *) treeview, "W");
        pango_layout_get_pixel_extents (layout, NULL, &logical_rect);
        title_offset = PANGO_ASCENT (logical_rect) + PANGO_DESCENT (logical_rect);
        g_object_unref (layout);
        title_offset += 8;
    }

    if(!strstr ((const char *)gtk_selection_data_get_data (data), "file:")) {
        gtk_drag_finish (context, FALSE, FALSE, time);
        return;
    }
    g = g_strdup ((const char *)gtk_selection_data_get_data (data) + strlen ("file:"));
    if(strstr (g, "\n"))
        *(strstr (g, "\n")) = 0;
    if(strstr (g, "\r"))
        *(strstr (g, "\r")) = 0;

    b = g_path_get_basename (g);
    if(strchr (b, '.'))
        *strrchr (b, '.') = 0;

    //TRACE("   on_drag_data: b=%s \n",b);

    icon = render_icon (g);
    if(!icon)
        icon = dead_icon (g);
    if(icon) {
        if(!gtk_tree_view_get_path_at_pos (treeview, x, y - title_offset, &treepath, NULL, NULL, NULL)) {
            gtk_drag_finish (context, FALSE, FALSE, time);
            return;
        }
        GtkTreeModel *model = gtk_tree_view_get_model (treeview);

        gtk_tree_model_get_iter (model, &iter, treepath);
        if(!gtk_tree_store_iter_is_valid ((GtkTreeStore *) model, &iter)) {
            g_warning ("!gtk_tree_store_iter_is_valid ((GtkTreeStore *)model,&iter)");
        }
        gtk_tree_store_set ((GtkTreeStore *) model, &iter, M_PIXBUF_COLUMN, icon, -1);
        gtk_tree_store_set ((GtkTreeStore *) model, &iter, M_ICON_COLUMN, b, -1);
        gtk_tree_path_free (treepath);

    }

    g_free (g);
    g_free (b);
    gtk_drag_finish (context, TRUE, FALSE, time);
}

typedef struct m_column_info_t {
    int id;
    GType type;
} m_column_info_t;

gchar *
compare_p (gchar * na) {
    gchar *pa;
    /*if (strncmp(na,"application/x-",strlen("application/x-"))==0){
       pa = na + strlen("application/x-");
       } else if (strncmp(na,"application/",strlen("application/"))==0){
       pa = na + strlen("application/");
       } else */
    pa = na;
    return pa;
}

gint
IterCompareFunc (GtkTreeModel * treemodel, GtkTreeIter * a, GtkTreeIter * b, gpointer user_data) {
    gchar *na,
     *nb,
     *pa = NULL,
        *pb = NULL;
    gtk_tree_model_get (treemodel, a, M_NAME_COLUMN, &na, -1);
    gtk_tree_model_get (treemodel, b, M_NAME_COLUMN, &nb, -1);
    if(!na && !nb) {
        return 0;
    }
    if(!na) {
        return 1;
    }
    if(!nb) {
        return -1;
    }

    pa = compare_p (na);
    pb = compare_p (nb);
    /*TRACE("TRACE %s==%s\n",pa,pb); */
    return strcmp (pa, pb);
}

gint
IterCompareFunc2 (GtkTreeModel * treemodel, GtkTreeIter * a, GtkTreeIter * b, gpointer user_data) {
    gchar *na,
     *nb,
     *pa = NULL,
        *pb = NULL;
    gtk_tree_model_get (treemodel, a, M_ICON_COLUMN, &na, -1);
    gtk_tree_model_get (treemodel, b, M_ICON_COLUMN, &nb, -1);
    if(!na && !nb) {
        return 0;
    }
    if(!na) {
        return 1;
    }
    if(!nb) {
        return -1;
    }

    pa = compare_p (na);
    pb = compare_p (nb);
    /*TRACE("TRACE %s==%s\n",pa,pb); */
    return strcmp (pa, pb);
}

GtkTreeStore *
create_treestore (void) {
    GtkTreeStore *ts;
    GtkTreeSortable *sortable;
    m_column_info_t column_info[] = {

        {M_PIXBUF_COLUMN, GDK_TYPE_PIXBUF},
        {M_GROUP_COLUMN, G_TYPE_STRING},
        {M_NAME_COLUMN, G_TYPE_STRING},
        {M_ICON_COLUMN, G_TYPE_STRING},
        {M_PATH_COLUMN, G_TYPE_STRING}
    };
    ts = gtk_tree_store_new (M_TREE_COLUMNS,
                             column_info[M_PIXBUF_COLUMN].type,
                             column_info[M_GROUP_COLUMN].type,
                             column_info[M_NAME_COLUMN].type, column_info[M_ICON_COLUMN].type, column_info[M_PATH_COLUMN].type);

    sortable = GTK_TREE_SORTABLE ((GtkTreeStore *) ts);
    gtk_tree_sortable_set_sort_func (sortable, M_NAME_COLUMN, IterCompareFunc, NULL, NULL);
    gtk_tree_sortable_set_sort_column_id (sortable, M_NAME_COLUMN, GTK_SORT_ASCENDING);
    return ts;
}

GtkTreeStore *
create_treestore2 (void) {
    GtkTreeStore *ts;
    GtkTreeSortable *sortable;
    m_column_info_t column_info[] = {

        {M_PIXBUF_COLUMN, GDK_TYPE_PIXBUF},
        {M_GROUP_COLUMN, G_TYPE_STRING},
        {M_NAME_COLUMN, G_TYPE_STRING},
        {M_ICON_COLUMN, G_TYPE_STRING},
        {M_PATH_COLUMN, G_TYPE_STRING}

    };
    ts = gtk_tree_store_new (M_TREE_COLUMNS,
                             column_info[M_PIXBUF_COLUMN].type,
                             column_info[M_GROUP_COLUMN].type,
                             column_info[M_NAME_COLUMN].type, column_info[M_ICON_COLUMN].type, column_info[M_PATH_COLUMN].type);

    sortable = GTK_TREE_SORTABLE ((GtkTreeStore *) ts);
    gtk_tree_sortable_set_sort_func (sortable, M_ICON_COLUMN, IterCompareFunc2, NULL, NULL);
    gtk_tree_sortable_set_sort_column_id (sortable, M_ICON_COLUMN, GTK_SORT_ASCENDING);
    return ts;
}

gboolean group_found;
gboolean name_found;
gchar *path_found = NULL;
xmlChar *icon_name;

static gboolean
find_path (GtkTreeModel * treemodel, GtkTreePath * treepath, GtkTreeIter * iter, gpointer data) {
    const char *name = data;
    gchar *n;
    if(path_found)
        return TRUE;
    gtk_tree_model_get (treemodel, iter, M_ICON_COLUMN, &n, -1);
    if(n && strcmp (n, name) == 0) {
        gtk_tree_model_get (treemodel, iter, M_PATH_COLUMN, &path_found, -1);
    }
    return FALSE;

}

static gboolean
find_row (GtkTreeModel * treemodel, GtkTreePath * treepath, GtkTreeIter * iter, gpointer data) {
    char *id = data;
    char *n;

    if(name_found)
        return TRUE;

    gtk_tree_model_get (treemodel, iter, M_NAME_COLUMN, &n, -1);

    if(n && strcmp (n, id) == 0) {
        path_found = NULL;

        TRACE ("id found=%s icon_name=%s\n", n, icon_name);
 	if (icon_name) {
            gtk_tree_model_foreach ((GtkTreeModel *) store2, find_path, icon_name);
            if(path_found) {
                if (!id) TRACE ("%s: generic icon path_found=%s\n", icon_name, path_found);
                GdkPixbuf *icon = rfm_get_pixbuf (path_found, RODENT_MIME_ICON_SIZE);
                if(icon) {
                    gtk_tree_store_set ((GtkTreeStore *) store, iter, M_ICON_COLUMN, icon_name, M_PIXBUF_COLUMN, icon, -1);
                }
                path_found = NULL;
            } else {
                TRACE ("path not found for %s\n", icon_name);
                GdkPixbuf *icon = rfm_get_pixbuf ("xffm/stock_missing-image", RODENT_MIME_ICON_SIZE);
                if(icon) {
                    gtk_tree_store_set ((GtkTreeStore *) store, iter, M_ICON_COLUMN, icon_name, M_PIXBUF_COLUMN, icon, -1);
                }

            }
        } 

        /*TRACE("duplicate %s==%s, looking for icon %s\n",n,name,id); */
        name_found = TRUE;
    }

    return FALSE;
}

#if 0
static gboolean
set_generic_icon (GtkTreeModel * treemodel, GtkTreePath * treepath, GtkTreeIter * iter, gpointer data) {
    char *id = data;
    char *n;

    if(name_found)
        return TRUE;

    gtk_tree_model_get (treemodel, iter, M_NAME_COLUMN, &n, -1);

    if(!id || (n && strcmp (n, id) == 0)) {
        path_found = NULL;

        TRACE ("id found=%s icon_name=%s\n", n, icon_name);
        if(!id){
	    //set generic icon from hash.
	    icon_name=g_hash_table_lookup(generic_icon_hash, n);
	}
	if (icon_name) {
            gtk_tree_model_foreach ((GtkTreeModel *) store2, find_path, icon_name);
            if(path_found) {
                if (!id) TRACE ("%s: generic icon path_found=%s\n", icon_name, path_found);
                GdkPixbuf *icon = rfm_get_pixbuf (path_found, RODENT_MIME_ICON_SIZE);
                if(icon) {
                    gtk_tree_store_set ((GtkTreeStore *) store, iter, M_ICON_COLUMN, icon_name, M_PIXBUF_COLUMN, icon, -1);
                }
                path_found = NULL;
            } else {
                TRACE ("path not found for %s\n", icon_name);
                GdkPixbuf *icon = rfm_get_pixbuf ("xffm/stock_missing-image", RODENT_MIME_ICON_SIZE);
                if(icon) {
                    gtk_tree_store_set ((GtkTreeStore *) store, iter, M_ICON_COLUMN, icon_name, M_PIXBUF_COLUMN, icon, -1);
                }

            }
        } 

        /*TRACE("duplicate %s==%s, looking for icon %s\n",n,name,id); */
        name_found = TRUE;
    }

    return FALSE;
}
#endif

void insert_generic_icon (gpointer key, gpointer value, gpointer user_data){
    gchar *id=key;
    icon_name=value;
    name_found = FALSE;
    gtk_tree_model_foreach ((GtkTreeModel *) store, find_row, id);
    if(name_found) {
	TRACE("inserted generic icon for %s (%s)\n", id, (gchar *)value);
    } 
    //else g_warning ("id=\"%s\" with icon_value=\"%s\" name_found==FALSE!", id, icon_name);
}

gboolean
unref_row (GtkTreeModel * model, GtkTreePath * path, GtkTreeIter * iter, gpointer data) {
    gtk_tree_model_unref_node (model, iter);
    return FALSE;
}

static gboolean
find_name (GtkTreeModel * treemodel, GtkTreePath * treepath, GtkTreeIter * iter, gpointer data) {
    char *name = (gchar *) data;
    gchar *n;
    if(name_found)
        return TRUE;
    gtk_tree_model_get (treemodel, iter, M_NAME_COLUMN, &n, -1);
    if(strcmp (name, n) == 0) {
        name_found = TRUE;
        return TRUE;
    }
    return FALSE;
}

static gboolean
find_type (GtkTreeModel * treemodel, GtkTreePath * treepath, GtkTreeIter * iter, gpointer data) {
    char *name = g_strdup ((const gchar *)data);
    char *n,
     *g,
     *group;

    if(name_found)
        return TRUE;
    if(!strstr (name, "/")) {
        g_free (name);
        return FALSE;
    }
    group = g_strdup (name);
    *(strchr (group, '/')) = 0; /* group = strtok(group,"/"); */
    gtk_tree_model_get (treemodel, iter, M_GROUP_COLUMN, &g, M_NAME_COLUMN, &n, -1);
    if(g && strcmp (g, group) == 0) {
        GtkTreeIter child;
        group_found = TRUE;
        if(!name_found && strcmp (n, name) != 0) {
            gtk_tree_store_insert (store, &child, iter, 0);
            /*if (strstr(name,"pgp"))TRACE("TRACE:adding now %s\n",name); */
            gtk_tree_store_set ((GtkTreeStore *) store, &child, M_NAME_COLUMN, name, -1);
            name_found = TRUE;
        }
    }
    g_free (name);
    g_free (group);
    return FALSE;
}

int
insert_dir (const gchar * in_theme_dir, const gchar * subdir, GtkTreeIter * parent) {
    GtkTreeIter child,
      grandchild;
    gboolean ok = FALSE;
    gchar *dirname = g_build_filename (in_theme_dir, subdir, NULL);
    toggle_label (dirname);
    TRACE("TRACE: inserting %s\n",dirname);
    if(rfm_g_file_test (dirname, G_FILE_TEST_IS_DIR)) {
        GDir *gdir;
        const char *file;
        gtk_tree_store_insert (store2, &child, parent, 0);
        gtk_tree_store_set ((GtkTreeStore *) store2, &child, M_ICON_COLUMN, subdir, -1);
        if((gdir = g_dir_open (dirname, 0, NULL)) != NULL) {
            while((file = g_dir_read_name (gdir))) {
                gchar *path = g_build_filename (dirname, file, NULL);
                if(rfm_g_file_test (path, G_FILE_TEST_IS_DIR)) {
                    int r = insert_dir ((const gchar *)dirname, file, &child);
                    if(r)
                        ok = TRUE;
                    g_free (path);
                    path = NULL;
                    continue;
                }
                if(file && (strstr (file, ".xpm") || strstr (file, ".png")
                            || strstr (file, ".svg"))) {
                    GdkPixbuf *icon = NULL;
                    *strrchr (file, '.') = 0;
                    ok = TRUE;
                    gtk_tree_store_append (store2, &grandchild, &child);
                    gtk_tree_store_set ((GtkTreeStore *) store2, &grandchild, M_ICON_COLUMN, file, -1);
                    //TRACE("rendering %s\n",file);
                    //icon=render_icon((gchar *)file);
                    icon = render_icon (path);
                    if(!icon) {
                        g_warning ("unable to render %s from %s (is the directory listed in index.theme?)\n", file, dirname);
                        icon = dead_icon (path);
                    }

                    if(icon) {
                        gtk_tree_store_set ((GtkTreeStore *) store2, &grandchild, M_PIXBUF_COLUMN, icon, M_PATH_COLUMN, path, -1);
                    }
                } else
                    TRACE ("%s is not rendered\n", file);
            }
            g_dir_close (gdir);
            if(!ok) {
                gtk_tree_store_remove (store2, &child);
            }
        }
    }

    g_free (dirname);
    return ok;
}

static gboolean
create_icon_tree2 () {
    GtkTreeIter iter;
    //GtkTreeIter child;
    gchar *in_theme_dir = NULL;

    if(store2) {
        gtk_tree_model_foreach ((GtkTreeModel *) store2, unref_row, NULL);
        gtk_tree_store_clear (store2);
    } else
        store2 = create_treestore2 ();
// Selected icon theme name, defaults to Rodent.

    in_theme_dir = g_build_filename(RODENT_THEME, NULL);
    TRACE("in_theme_dir = %s \n", in_theme_dir);
    if(in_theme_dir && rfm_g_file_test (in_theme_dir, G_FILE_TEST_IS_DIR)) {
        gtk_tree_store_insert (store2, &iter, NULL, 0);
        gtk_tree_store_set ((GtkTreeStore *) store2, &iter, M_ICON_COLUMN, in_theme_dir, -1);
        if(rfm_svg_supported ()) {
            insert_dir (in_theme_dir, "scalable", &iter);
        } 
	insert_dir (in_theme_dir, "48x48", &iter);
    }
    g_free(in_theme_dir);
    return TRUE;
}

static gboolean
create_icon_tree (void
    ) {
    gchar *typesfile;
    xmlDocPtr doc;
    xmlNodePtr node;

    if(store) {
        gtk_tree_model_foreach ((GtkTreeModel *) store, unref_row, NULL);
        gtk_tree_store_clear (store);
    } else
        store = create_treestore ();

    if(!get_xml_files ())
        goto error_xml;

    /*********************** 
     * types defined in applications-module.xml 
     * and xffm.org.xml ***/
    typesfile = g_build_filename (APPLICATION_MIME_FILE, NULL);



    if(access (typesfile, F_OK) != 0) {
        g_warning ("cannot open %s for read", typesfile);
        return FALSE;

    }
    xmlKeepBlanksDefault (0);
    if((doc = xmlParseFile (typesfile)) == NULL) {
        g_warning ("xmlParseFile(%s) != NULL", typesfile);
        return FALSE;

    }
    node = xmlDocGetRootElement (doc);
    if(!xmlStrEqual (node->name, (const xmlChar *)"mime-info")) {
        xmlFreeDoc (doc);
        return FALSE;

    }
    for(node = node->children; node; node = node->next) {
        if(xmlStrEqual (node->name, (const xmlChar *)"mime-key")) {
            xmlChar *id;
            id = xmlGetProp (node, (const xmlChar *)"type");
            if(id && strchr ((const char *)id, '/')) {
                GtkTreeIter iter;
                GtkTreeIter child;
                name_found = group_found = FALSE;
                gtk_tree_model_foreach ((GtkTreeModel *) store, find_name, id);
                if(!name_found) {
                    gtk_tree_model_foreach ((GtkTreeModel *) store, find_type, id);
                    if(!group_found) {
                        gchar *n,
                         *g = strdup ((const char *)id);
                        *(strchr (g, '/')) = 0; /*g=strtok(g,"/"); */
                        n = g_strconcat (g, "/default", NULL);
                        gtk_tree_store_insert (store, &iter, NULL, 0);
                        gtk_tree_store_set ((GtkTreeStore *) store, &iter, M_GROUP_COLUMN, g, M_NAME_COLUMN, n, -1);
                        //TRACE ("TRACE:adding %s\n", n);
                        gtk_tree_store_insert (store, &child, &iter, 0);
                        gtk_tree_store_set ((GtkTreeStore *) store, &child, M_NAME_COLUMN, id, -1);
                    }
                }
		//continue;
            }
	    xmlNodePtr subnode;  
	    for(subnode = node->children; subnode; subnode = subnode->next) {
                if(xmlStrEqual (subnode->name, (const xmlChar *)"generic-icon")) {
                    xmlChar *value = xmlGetProp (subnode, (const xmlChar *)"name");
		    if (!generic_icon_hash){
			generic_icon_hash = g_hash_table_new (g_str_hash, g_str_equal);
		    }
		    TRACE("generic icon %s --> %s\n", id, (gchar *)value);
		    g_hash_table_replace (generic_icon_hash, 
				(gpointer) id, (gpointer) value);
		    continue;
		}
	    }
        }

    }
    xmlFreeDoc (doc);
    g_free (typesfile);

    /***********************************/
    // Set generic icons: these are the default mimetype icons.
    g_hash_table_foreach (generic_icon_hash, insert_generic_icon, NULL);
  
    
    /********************   application specific icons ***************/
    // These are the customized values in the icons.mime.xml file
    //
    xmlKeepBlanksDefault (0);

    if((doc = xmlParseFile (xml_file)) == NULL) {
      error_xml:
        g_warning ("xmlParseFile(%s) != NULL", xml_file);
        return FALSE;
    }
    node = xmlDocGetRootElement (doc);
    if(!xmlStrEqual (node->name, (const xmlChar *)"mime-info")) {
        xmlFreeDoc (doc);
        goto error_xml;
    }


    /* Now parse the xml tree */
    /*TRACE("TRACE: parsing %s\n",mimefile); */
    for(node = node->children; node; node = node->next) {
        if(xmlStrEqual (node->name, (const xmlChar *)"mime-type")) {
            xmlChar *id = xmlGetProp (node, (const xmlChar *)"type");
            icon_name = xmlGetProp (node, (const xmlChar *)"icon");

            if(id && icon_name) {
                name_found = FALSE;
                gtk_tree_model_foreach ((GtkTreeModel *) store, find_row, id);
                if(!name_found) {
                    g_warning ("id=\"%s\" with icon_value=\"%s\" name_found==FALSE!", id, icon_name);
                }

            }
            g_free (icon_name);
            icon_name = NULL;
            g_free (id);
        }
    }

    xmlFreeDoc (doc);

/*time2return:*/
    return TRUE;
}

#if 10

GtkWidget *
make_dialog (gchar * txt) {
    GtkWidget *dialog,
     *image;
    GdkPixbuf *pb;
    static GdkCursor *cursor = NULL;
    if(!cursor)
        cursor = gdk_cursor_new (GDK_WATCH);

    if(!get_xml_files ())
        return NULL;
    dialog = gtk_dialog_new ();
    GtkWidget *vbox = rfm_vbox_new(FALSE, 2);
    gtk_box_pack_start (GTK_BOX (
		gtk_dialog_get_action_area(GTK_DIALOG (dialog))), 
	    vbox, TRUE, TRUE, 0);
    gtk_widget_show(vbox);

    pb = rfm_get_pixbuf ("xffm/actions_insert-image", 48);
    image = gtk_image_new_from_pixbuf (pb);
    gtk_box_pack_start (GTK_BOX (vbox), 
	    image, TRUE, TRUE, 0);

    moving_label = (GtkLabel *) gtk_label_new ("\n");
    gtk_box_pack_start (GTK_BOX (vbox), 
	    (GtkWidget *) moving_label, TRUE, TRUE, 0);
    moving_label = (GtkLabel *) gtk_label_new ("Rodent Icon Theme\n");
    gtk_box_pack_start (GTK_BOX (vbox), 
	     (GtkWidget *) moving_label, TRUE, TRUE, 0);
    moving_label = (GtkLabel *) gtk_label_new ("by");
    gtk_box_pack_start (GTK_BOX (vbox), 
	     (GtkWidget *) moving_label, TRUE, TRUE, 0);
    moving_label = (GtkLabel *) gtk_label_new ("François Le Clainche");
    gtk_box_pack_start (GTK_BOX (vbox), 
	     (GtkWidget *) moving_label, TRUE, TRUE, 0);
    moving_label = (GtkLabel *) gtk_label_new ("<fleclainche at wanadoo.fr>");
    gtk_box_pack_start (GTK_BOX (vbox), 
	     (GtkWidget *) moving_label, TRUE, TRUE, 0);
/*    moving_label=(GtkLabel *)gtk_label_new(icon_theme_name);
    gtk_box_pack_start (GTK_BOX(GTK_DIALOG(dialog)->vbox), (GtkWidget *)moving_label, TRUE, TRUE, 0); */

    moving_label = (GtkLabel *) gtk_label_new ("");
    gtk_box_pack_start (GTK_BOX (vbox), 
	     (GtkWidget *) moving_label, TRUE, TRUE, 0);

    moving_label = (GtkLabel *)
        gtk_label_new (_("Loading data"));
    gtk_box_pack_start (GTK_BOX (vbox), 
	     (GtkWidget *) moving_label, TRUE, TRUE, 0);
    gtk_window_set_position ((GtkWindow *) dialog, GTK_WIN_POS_CENTER);
    /*GTK_WIN_POS_MOUSE); */
    /*GTK_WIN_POS_CENTER); */
    gtk_widget_realize (dialog);
    gdk_window_set_decorations (gtk_widget_get_window(dialog), GDK_DECOR_BORDER);
    gdk_window_set_cursor (gtk_widget_get_window(dialog), cursor);
    gtk_window_move (GTK_WINDOW (dialog), 100, 100);

    /*gtk_window_set_decorated ((GtkWindow *)dialog,FALSE); */

    gtk_widget_show_all (dialog);
    return dialog;
}

void
toggle_label (const gchar * txt) {
    gchar *g = g_strdup_printf ("\n%s...\n", txt);
    gtk_label_set_text (moving_label, g);
    g_free (g);
    while(gtk_events_pending ())
        gtk_main_iteration ();
}

#endif

static gboolean
icon_changed (GtkCellRendererText * cell, const gchar * path_string, const gchar * new_text, gpointer data) {
    GtkTreeModel *model = (GtkTreeModel *) store;
    GtkTreePath *path = gtk_tree_path_new_from_string (path_string);
    GtkTreeIter iter;
    GdkPixbuf *icon = NULL;

    gint *column;

    column = g_object_get_data (G_OBJECT (cell), "column");

    gtk_tree_model_get_iter (model, &iter, path);

    if(GPOINTER_TO_INT (column) == M_ICON_COLUMN) {
        gchar *old_text;
        gtk_tree_model_get (model, &iter, column, &old_text, -1);
        g_free (old_text);
        if(!new_text)
            gtk_tree_store_set (store, &iter, column, "", -1);
        else
            gtk_tree_store_set (store, &iter, column, new_text, -1);
        if(new_text && strlen (new_text)) {
            icon = render_icon ((gchar *) new_text);
            if(!icon)
                icon = dead_icon (new_text);
        }
        gtk_tree_store_set (store, &iter, M_PIXBUF_COLUMN, icon, -1);
        /*if (!icon){ 
           GtkWidget *dialog = gtk_message_dialog_new ((GtkWindow *)xfmime_edit,
           GTK_DIALOG_DESTROY_WITH_PARENT,
           GTK_MESSAGE_ERROR,
           GTK_BUTTONS_CLOSE,"%s\n",new_text);
           gtk_dialog_run (GTK_DIALOG (dialog));
           gtk_widget_destroy (dialog);
           } */

    }
    gtk_tree_path_free (path);

    return FALSE;
}

void
mk_treeview () {
    GtkCellRenderer *cell;
    GtkTreeViewColumn *column;
    treeview = (GtkTreeView *) lookup_widget ((GtkWidget *) xfmime_edit, "treeview1");
    gtk_tree_view_set_model (treeview, (GtkTreeModel *) store);
    gtk_tree_view_set_headers_visible (treeview, FALSE);

    gtk_drag_dest_set ((GtkWidget *) treeview,
                       GTK_DEST_DEFAULT_DROP | GTK_DEST_DEFAULT_HIGHLIGHT,
                       target_table, NUM_TARGETS, GDK_ACTION_MOVE | GDK_ACTION_COPY | GDK_ACTION_LINK);

    gtk_drag_source_set ((GtkWidget *) treeview,
                         GDK_BUTTON1_MASK | GDK_BUTTON2_MASK, target_table,
                         NUM_TARGETS, GDK_ACTION_MOVE | GDK_ACTION_COPY | GDK_ACTION_LINK);

    /* create the pixbuf column */
    column = gtk_tree_view_column_new ();
    gtk_tree_view_column_set_sizing (column, GTK_TREE_VIEW_COLUMN_AUTOSIZE);
    gtk_tree_view_column_set_resizable (column, FALSE);
    gtk_tree_view_column_set_reorderable (column, FALSE);
    gtk_tree_view_column_set_spacing (column, 2);

    cell = gtk_cell_renderer_pixbuf_new ();
    gtk_tree_view_column_pack_start (column, cell, FALSE);
    gtk_tree_view_column_set_attributes (column, cell,
                                         "pixbuf", M_PIXBUF_COLUMN,
                                         "pixbuf_expander_closed", M_PIXBUF_COLUMN, "pixbuf_expander_open", M_PIXBUF_COLUMN, NULL);

    gtk_tree_view_append_column (GTK_TREE_VIEW (treeview), column);
    gtk_tree_view_set_expander_column (treeview, column);

    /* group */

    column = gtk_tree_view_column_new ();
    gtk_tree_view_column_set_sizing (column, GTK_TREE_VIEW_COLUMN_AUTOSIZE);
    gtk_tree_view_column_set_resizable (column, FALSE);
    gtk_tree_view_column_set_reorderable (column, FALSE);
    gtk_tree_view_column_set_spacing (column, 2);
    cell = gtk_cell_renderer_text_new ();
    g_object_set (G_OBJECT (cell), "editable", FALSE, NULL);
    gtk_tree_view_column_set_clickable (column, TRUE);

    gtk_tree_view_column_pack_start (column, cell, FALSE);
    gtk_tree_view_column_set_attributes (column, cell, "text", M_GROUP_COLUMN, NULL);
    gtk_tree_view_append_column (GTK_TREE_VIEW (treeview), column);

    /* name */
    column = gtk_tree_view_column_new ();
    gtk_tree_view_column_set_sizing (column, GTK_TREE_VIEW_COLUMN_AUTOSIZE);
    gtk_tree_view_column_set_resizable (column, FALSE);
    gtk_tree_view_column_set_reorderable (column, FALSE);
    gtk_tree_view_column_set_spacing (column, 2);
    cell = gtk_cell_renderer_text_new ();
    g_object_set (G_OBJECT (cell), "editable", FALSE, NULL);
    gtk_tree_view_column_set_clickable (column, TRUE);

    gtk_tree_view_column_pack_start (column, cell, FALSE);
    gtk_tree_view_column_set_attributes (column, cell, "text", M_NAME_COLUMN, NULL);
    gtk_tree_view_append_column (GTK_TREE_VIEW (treeview), column);

    /* iconfile */
    column = gtk_tree_view_column_new ();
    gtk_tree_view_column_set_sizing (column, GTK_TREE_VIEW_COLUMN_AUTOSIZE);
    gtk_tree_view_column_set_resizable (column, FALSE);
    gtk_tree_view_column_set_reorderable (column, FALSE);
    gtk_tree_view_column_set_spacing (column, 2);
    cell = gtk_cell_renderer_text_new ();
    g_object_set (G_OBJECT (cell), "editable", TRUE, NULL);
    g_signal_connect (G_OBJECT (cell), "edited", G_CALLBACK (icon_changed), NULL);
    g_object_set_data (G_OBJECT (cell), "column", (gint *) M_ICON_COLUMN);

    gtk_tree_view_column_set_clickable (column, TRUE);

    gtk_tree_view_column_pack_start (column, cell, FALSE);
    gtk_tree_view_column_set_attributes (column, cell, "text", M_ICON_COLUMN, NULL);
    gtk_tree_view_append_column (GTK_TREE_VIEW (treeview), column);

}

void
mk_treeview2 (void
    ) {
    GtkCellRenderer *cell;
    GtkTreeViewColumn *column;
    treeview2 = (GtkTreeView *) lookup_widget ((GtkWidget *) xfmime_edit, "treeview2");
    gtk_tree_view_set_model (treeview2, (GtkTreeModel *) store2);

    gtk_tree_view_set_headers_visible (treeview2, FALSE);

    gtk_drag_source_set ((GtkWidget *) treeview2,
                         GDK_BUTTON1_MASK | GDK_BUTTON2_MASK, target_table,
                         NUM_TARGETS, GDK_ACTION_MOVE | GDK_ACTION_COPY | GDK_ACTION_LINK);

    /* create the pixbuf column */
    column = gtk_tree_view_column_new ();
    gtk_tree_view_column_set_sizing (column, GTK_TREE_VIEW_COLUMN_AUTOSIZE);
    gtk_tree_view_column_set_resizable (column, FALSE);
    gtk_tree_view_column_set_reorderable (column, FALSE);
    gtk_tree_view_column_set_spacing (column, 2);

    cell = gtk_cell_renderer_pixbuf_new ();
    gtk_tree_view_column_pack_start (column, cell, FALSE);
    gtk_tree_view_column_set_attributes (column, cell,
                                         "pixbuf", M_PIXBUF_COLUMN,
                                         "pixbuf_expander_closed", M_PIXBUF_COLUMN, "pixbuf_expander_open", M_PIXBUF_COLUMN, NULL);

    gtk_tree_view_append_column (GTK_TREE_VIEW (treeview2), column);
    gtk_tree_view_set_expander_column (treeview2, column);

    /* name */
    column = gtk_tree_view_column_new ();
    gtk_tree_view_column_set_sizing (column, GTK_TREE_VIEW_COLUMN_AUTOSIZE);
    gtk_tree_view_column_set_resizable (column, FALSE);
    gtk_tree_view_column_set_reorderable (column, FALSE);
    gtk_tree_view_column_set_spacing (column, 2);
    cell = gtk_cell_renderer_text_new ();
    g_object_set (G_OBJECT (cell), "editable", FALSE, NULL);
    gtk_tree_view_column_set_clickable (column, TRUE);

    gtk_tree_view_column_pack_start (column, cell, FALSE);
    gtk_tree_view_column_set_attributes (column, cell, "text", M_ICON_COLUMN, NULL);
    gtk_tree_view_append_column (GTK_TREE_VIEW (treeview2), column);

    /* path */
    column = gtk_tree_view_column_new ();
    gtk_tree_view_column_set_sizing (column, GTK_TREE_VIEW_COLUMN_AUTOSIZE);
    gtk_tree_view_column_set_resizable (column, FALSE);
    gtk_tree_view_column_set_reorderable (column, FALSE);
    gtk_tree_view_column_set_spacing (column, 2);
    cell = gtk_cell_renderer_text_new ();
    g_object_set (G_OBJECT (cell), "editable", FALSE, NULL);
    gtk_tree_view_column_set_clickable (column, TRUE);

    gtk_tree_view_column_pack_start (column, cell, FALSE);
    gtk_tree_view_column_set_attributes (column, cell, "text", M_PATH_COLUMN, NULL);
    gtk_tree_view_append_column (GTK_TREE_VIEW (treeview2), column);

}

char **restart_argv;

static void
finishit (int sig) {
    TRACE ("got signal %d (SIGUSR1=%d)", sig, SIGUSR1);
    if(sig == SIGUSR2) {
        /*execvp(restart_argv[0],restart_argv); */
        return;
    }
}

static void
signal_connections (void
    ) {
#ifdef HAVE_SIGACTION
    struct sigaction act;
    act.sa_handler = finishit;
    sigemptyset (&act.sa_mask);
# ifdef SA_RESTART
    act.sa_flags = SA_RESTART;
# else
    act.sa_flags = 0;
# endif
    sigaction (SIGUSR2, &act, NULL);
#else
    signal (SIGUSR2, finishit);
#endif
}

int
main (int argc, char *argv[]
    ) {
    GtkWidget *dialog;
    if(!g_thread_supported ()){
        g_thread_init (NULL);
	gdk_threads_init ();
    }

    setlocale (LC_ALL, "");

    gtk_init (&argc, &argv);
    // set gtk properties
    GtkSettings *settings = gtk_settings_get_default();
    if (settings){
	/* make sure the type is realized */
	g_type_class_unref (g_type_class_ref (GTK_TYPE_IMAGE_MENU_ITEM));
	g_type_class_unref (g_type_class_ref (GTK_TYPE_BUTTON));
	g_object_set(G_OBJECT(settings), 
	    "gtk-button-images", TRUE,
	    "gtk-menu-images", TRUE,
	    NULL);    }

    signal_connections ();

    /* read in shm settings: this will also pull in icon module... */
    rfm_void (MODULE_DIR, "settings", "mcs_shm_start");

    TRACE ("starting %s\n", argv[0]);
    if(!g_module_supported ()) {
        g_error ("g_modules not supported!\n");
        exit (1);
    }

    icon_theme_name = g_strdup ("Rodent");
    get_xml_files ();


    if(argc > 1) {
        g_free (icon_theme_name);
        icon_theme_name = g_strdup (argv[1]);
    }
    TRACE ("--> ICON_load_theme\n");
    ICON_load_theme (icon_theme_name);
    dialog = make_dialog (icon_theme_name);
    while(gtk_events_pending ())
        gtk_main_iteration ();

    TRACE ("icon_theme_name is %s\n", (icon_theme_name ? icon_theme_name : "null"));

    if(icon_theme_name)
        toggle_label (icon_theme_name);

    TRACE ("--> create_xfmime_edit\n");
    xfmime_edit = create_xfmime_edit (icon_theme_name);
    if(xml_file)
        toggle_label (xml_file);

    TRACE ("--> create_icon_tree2\n");
    create_icon_tree2 ();
    while(gtk_events_pending ())
        gtk_main_iteration ();
    TRACE ("--> mk_treeview2\n");
    mk_treeview2 ();
    while(gtk_events_pending ())
        gtk_main_iteration ();

    TRACE ("--> create_icon_tree model\n");
    create_icon_tree ();
    while(gtk_events_pending ())
        gtk_main_iteration ();

    /* treeview */
    TRACE ("--> mk_treeview\n");
    mk_treeview ();
    gtk_widget_hide (dialog);
    gtk_widget_destroy (dialog);
    gtk_widget_show (xfmime_edit);
    {
        GdkPixbuf *icon_pixbuf;
        ICON_load_theme ("Rodent");
        icon_pixbuf = rfm_get_pixbuf ("xffm/actions_insert-image", 48);
        if(icon_pixbuf) {
            gtk_window_set_icon (GTK_WINDOW (xfmime_edit), icon_pixbuf);
        } else
            g_warning ("cannot create application icon");
    }

    g_signal_connect ((gpointer) xfmime_edit, "destroy", G_CALLBACK (on_quit_clicked), NULL);

    redlight = FALSE;

    gtk_main ();
    return 0;
}
