/*
 * Copyright 2005-2012 Edscott Wilson Garcia 
 * license: GPL v.3
 */
#define NON_RELEASE

#define __RFM_MAIN_C__
#include  "config.h"



#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include <glob.h>
#include <limits.h>
#include <memory.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <dirent.h>

#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include <gmodule.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>

#include "rodent_libs.h"

#ifdef ICONVIEW_BINARY
# include "gridview_lib.h"
#endif
#ifdef DESKVIEW_BINARY
# include "deskview_lib.h"
#endif

#define FORCE_CORE
#ifdef FORCE_CORE
# include <sys/time.h>
# include <sys/resource.h>
#endif

extern gchar *rfm_iconpath;

static void
finishit (int sig) {
    TRACE ("got signal %d (SIGUSR1=%d,SIGUSR2=%d)", sig, SIGUSR1, SIGUSR2);
    fflush (NULL);
    if(sig == SIGUSR1) {
        return;
    } else if(sig == SIGUSR2) {
        return;
    } else {
        g_warning ("Rodent: signal %d received. \n", sig);
        //cleanup_tmpfiles();
        rfm_void (MODULE_DIR, "settings", "mcs_shm_stop");
        exit (1);
    }
}

static void
signal_connections (void
    ) {
#ifdef HAVE_SIGACTION
    struct sigaction act;
    act.sa_handler = finishit;
    sigemptyset (&act.sa_mask);
# ifdef SA_RESTART
    act.sa_flags = SA_RESTART;
# else
    act.sa_flags = 0;
# endif

//      sigaction(SIGHUP,&act,NULL);
//      sigaction(SIGTERM,&act,NULL);
# ifndef DEBUG
//      sigaction(SIGINT,&act,NULL);
//      sigaction(SIGQUIT,&act,NULL);
//      sigaction(SIGABRT,&act,NULL);
//      sigaction(SIGBUS,&act,NULL);
#  ifndef FORCE_CORE
    sigaction (SIGSEGV, &act, NULL);
#  endif
//      sigaction(SIGFPE,&act,NULL);

    sigaction (SIGUSR1, &act, NULL);
    sigaction (SIGUSR2, &act, NULL);
# endif
#else
//      signal(SIGHUP, finishit);
//      signal(SIGTERM, finishit);
# ifndef DEBUG
//      signal(SIGINT, finishit);
//      signal(SIGQUIT, finishit);
//      signal(SIGABRT, finishit);
//      signal(SIGBUS, finishit);
#  ifndef FORCE_CORE
    signal (SIGSEGV, finishit);
#  endif
//      signal(SIGFPE, finishit);
    signal (SIGUSR1, finishit);
    signal (SIGUSR2, finishit);
# endif
#endif
}

static void
rfm_global_init (int argc, char *argv[]) {
    TRACE("rfm_global_init...\n");
    if(rfm_global_p) return;
    rfm_global_p = (rfm_global_t *) malloc (sizeof (rfm_global_t));
    memset (rfm_global_p, 0, sizeof (rfm_global_t));
    rfm_global_p->argv = (char **)malloc ((argc + 3) * sizeof (char *));
    memset (rfm_global_p->argv, 0, (argc + 3) * sizeof (char *));
    rfm_global_p->argv[0] = g_path_get_basename (argv[0]);
    int i;
    for(i = 1; i < argc; i++) {
        rfm_global_p->argv[i] = g_strdup (argv[i]);
    }
    rfm_global_p->argc = argc;
    // main thread...
    rfm_global_p->self = g_thread_self();
    rfm_global_p->pid = getpid();
    g_static_rw_lock_init(&(rfm_global_p->icon_theme_lock));
    g_static_rw_lock_init(&(rfm_global_p->view_list_lock));
    rfm_global_p->janitor_signal = g_cond_new();

    // main loop semaphore
    rfm_global_p->setup_semaphore = (sem_t *) malloc (sizeof (sem_t));
    if (!rfm_global_p->setup_semaphore){
	g_error("malloc: %s\n", strerror(errno));
    }
    memset (rfm_global_p->setup_semaphore, 0, sizeof (sem_t));
    sem_init (rfm_global_p->setup_semaphore, 0, 0);

    TRACE("rfm_global_init(): self=0x%x\n",
	    GPOINTER_TO_INT(rfm_global_p->self));    
}

static gboolean
version_query (int argc, char *argv[]
    ) {
    int i;
    for(i = 0; i < argc; i++) {
        if(strcmp (argv[i], "--version") == 0) {
            fprintf (stdout, "%c[31m\tRodent uses the following programs:\n", 0x1B);
            //fprintf (stdout, "%c[0m",0x1B);
            //fprintf (stderr, "\tDBH version-%s, ", DBH_VERSION);
            gchar **pp;
#if THIS_IS_LINUX
            gchar *shell = g_strdup_printf ("%s --version", getenv ("SHELL"));
            FILE *pipef;
            gchar *commands[] = { "cp --version", "mv --version", "ln --version",
                "rm --version", "mount --version", "grep --version",
                "fgr --V",
                "sudo -V", shell, "", NULL
            };
            for(pp = commands; pp && *pp; pp++) {
                pipef = popen (*pp, "r");
                fprintf (stdout, "%c[35m-------------------------------------------------------------------\n", 0x1B);
                if(pipef) {
                    char line[2048];
                    memset (line, 0, 2048);
                    while(fgets (line, 2047, pipef) && !feof (pipef)) {
                        fprintf (stdout, "%c[32m%s", 0x1B, line);
                    }
                    pclose (pipef);
                }
            }
	    g_free(shell);
#else
            gchar *commands[] = { "cp", "mv", "ln", "rm", "mount", "grep","fgr", "sudo", getenv ("SHELL"),  NULL};
            for(pp = commands; pp && *pp; pp++) {
		gchar *path=g_find_program_in_path(*pp);
                fprintf (stdout, "%c[32m%s", 0x1B, path);
		g_free(path);
	    }

#endif
            fprintf (stdout, "%c[31m\tThis is %s %s (%s build %s)\n", 0x1B, PACKAGE_NAME, TAG, VERSION, BUILD);
            fprintf (stdout, "%c[31m\t%s\n", 0x1B, COPYRIGHT);
            fprintf (stdout, "%c[31m\tBuilt with GTK+-%d.%d.%d,linked with GTK+-%d.%d.%d.\n",
                     0x1B, GTK_MAJOR_VERSION, GTK_MINOR_VERSION, GTK_MICRO_VERSION,
                     gtk_major_version, gtk_minor_version, gtk_micro_version);
            fprintf (stdout, "%c[31m\tSend bug reports to %s\n", 0x1B, PACKAGE_BUGREPORT);
            fprintf (stdout, "%c[0m\n", 0x1B);
            exit (0);
        }

    }
    return FALSE;
}

static gboolean enable_desktop = FALSE;
static gboolean synchronize_X = FALSE;

static void
process_arg (int *argc, char ***argv) {
    int i;
    int out_argc = 0;
    static char **out_argv;

    out_argv = (char **)malloc ((*argc + 2) * sizeof (char *));
    out_argv[*argc - 1] = out_argv[*argc] = NULL;
    for(i = 0; i < *argc; i++) {
	if (strcmp(*((*argv) + i), "--sync")==0) {
	    synchronize_X = TRUE;
	    continue;
	}
        out_argv[out_argc] = *((*argv) + i);
        TRACE ("out_argcv[%d]=%s\n", out_argc, out_argv[out_argc]);
        out_argc++;
    }
    /* do variable substitution for $HOME or ~ */
    if(strcmp (out_argv[out_argc - 1], "$HOME") == 0)
        out_argv[out_argc - 1] = g_strdup(g_get_home_dir ());
    if(strcmp (out_argv[out_argc - 1], "~") == 0)
        out_argv[out_argc - 1] = g_strdup(g_get_home_dir ());
    if (rfm_g_file_test(out_argv[out_argc - 1], G_FILE_TEST_IS_DIR)){
	// change to absolute path
	if (!g_path_is_absolute (out_argv[out_argc - 1])){
	    gchar *original= g_get_current_dir();
	    if (chdir(out_argv[out_argc - 1]) < 0){
		g_warning("chdir(%s): %s", out_argv[out_argc - 1], strerror(errno));
	    }
	    out_argv[out_argc - 1] = g_get_current_dir();
	    if (chdir(original) < 0){
		g_warning("chdir(%s): %s", original, strerror(errno));
	    }
	    g_free(original);
	}
    }
    /* if no directory specified, use current WD */
 /*   if (out_argc < *argc + 1 && strstr(out_argv[0],"rodent-forked")==NULL)  {
        // USE EXTRA POINTER INITIALLY ALLOCATED TO NULL 
        out_argv[out_argc] = g_get_current_dir ();
        out_argc++;
    }*/
  /*  if(!rfm_g_file_test (out_argv[out_argc - 1], G_FILE_TEST_IS_DIR)
	    && strstr(out_argv[0],"rodent-forked")==NULL) {
        // USE EXTRA POINTER INITIALLY ALLOCATED TO NULL 
        out_argv[out_argc] = g_get_current_dir ();
        out_argc++;
    }*/
    *argv = out_argv;
    *argc = out_argc;
}

GMutex *x_gdk_mutex=NULL;
GThread *x_gdk_thread=NULL;

static void
enter_fn(void){
    if (!x_gdk_mutex) {
	x_gdk_mutex = g_mutex_new();
    }
    if (rfm_global_p
	    && 
	    rfm_global_p->self == g_thread_self()
	    &&
	  x_gdk_thread ==  rfm_global_p->self ) {
	TRACE("GDK_THREADS_ENTER(): recursive (but harmless) mutex call from main thread... \n");
	return; // This return makes it harmless...
    }

    NOOP(stdout, "GDK_THREADS_ENTER(): GDK mutex lock requested by thread: 0x%x (%x)\n", 
		GPOINTER_TO_INT(rfm_global_p->self),
		GPOINTER_TO_INT(g_thread_self()));
    g_mutex_lock(x_gdk_mutex);
    NOOP(stdout, "GDK_THREADS_ENTER(): GDK mutex locked by thread: 0x%x\n",
	    GPOINTER_TO_INT(g_thread_self()));
    x_gdk_thread = g_thread_self();
}

static void
leave_fn(void){
    if (!x_gdk_mutex) {
	NOOP("GDK_THREADS_ENTER(): this is absurd (but harmless): calling GDK_THREAD_LEAVE() before GDK_THREADS_ENTER()\n");
	return;
    }
    x_gdk_thread = NULL;
    g_mutex_unlock(x_gdk_mutex);
    NOOP(stdout, "GDK_THREADS_ENTER(): GDK mutex lock off by thread: 0x%x\n",
	    GPOINTER_TO_INT(g_thread_self()));
}


int
main (int argc, char *argv[]
    ) {
    NOOP ("Rodent: program name is = %s\n", argv[0]);

    // In order for SSH_ASKPASS to work (for sshfs or for executing
    // ssh commands at the lpterminal) we must detach the tty. 
    // This interferes with stepwise debugging with gdb.
    // The other caveat with gdb is that rfm_g_file_test_with_wait()
    // will detect the timeout under stepwise gdb.
#if defined DEBUG || defined DEBUG_TRACE
#else
    // was: if(strstr (argv[0], "rodent-forked") != NULL)
    // is now:
    if(strstr (argv[0], "rodent-getpass") == NULL)
    {

        if(fork ()){
	    gboolean initial = FALSE;
	    gchar *setup_file = g_build_filename(SETUP_FILE, NULL);
	    if (!g_file_test(setup_file, G_FILE_TEST_EXISTS)) {
		initial = TRUE;
		fprintf(stderr, "Initial set up of rodent disk based hashtables. Please wait."); fflush(stderr);
	    } else {
		NOOP(stderr, "Loading Rodent"); fflush(stderr);
		if (unlink(setup_file));
	    }
	    do {
		if (initial) fprintf(stderr, "."); fflush(stderr);
		sleep(1);
	    } while(!g_file_test(setup_file, G_FILE_TEST_EXISTS));
	    g_free(setup_file);
	    _exit (123);
	}
	setsid();
    } 
#endif

   /* g_thread_supported is geeky. returns true if g_threads are already 
     * initialized, not whether they are supported on the current platform! */
    XInitThreads ();
    gdk_threads_set_lock_functions (enter_fn, leave_fn);
#if 0
    // gtk-3.4 this is borked. g_thread_supported () and g_thread_init()
    // are no longer in api documentation!
    if(g_thread_supported ()){
	//g_error("BARF! threads already initialized!");
	g_warning("threads already initialized!");
    } else {
	//g_thread_init (NULL);
    }
#endif
    g_thread_init (NULL);
    gdk_threads_init ();


    // this is a must. Nothing interesting in stdin anyways.
    int fd = fileno (stdin);
    fclose (stdin);
    FILE *nullfd = fopen ("/dev/null", "rb");
    dup2 (fileno (nullfd), fd);

    /* ignore hangups? */
    (void)signal (SIGHUP, SIG_IGN);

    gchar *g = g_strdup_printf ("%s/%s", g_get_user_cache_dir (), RC_DIR);
    g_mkdir_with_parents (g, 0700);
    g_free (g);
    g = g_strdup_printf ("%s/%s", g_get_user_data_dir (), RC_DIR);
    g_mkdir_with_parents (g, 0700);
    g_free (g);
    g = g_strdup_printf ("%s/%s", g_get_user_config_dir (), RC_DIR);
    g_mkdir_with_parents (g, 0700);
    g_free (g);

#ifdef DEBUG 
    struct rlimit rlim;
    if (!strstr(argv[0], "getpass")) {
	g_warning("Development version, enabling core dumps...");
    }
    rlim.rlim_cur = RLIM_INFINITY;
    rlim.rlim_max = RLIM_INFINITY;
    setrlimit (RLIMIT_CORE, &rlim);
#else
#ifdef CORE
    struct rlimit rlim;
    if (!strstr(argv[0], "getpass")) {
	g_warning("Enabling core dumps...");
    }
    rlim.rlim_cur = RLIM_INFINITY;
    rlim.rlim_max = RLIM_INFINITY;
    setrlimit (RLIMIT_CORE, &rlim);

#endif
#endif
    /* do the following before allowing any dynamic library
     * to be loaded to memory (except glib)... */
    rfm_sanity_check (argc, argv, LIBRFM_SERIAL);
    if(version_query (argc, argv))
        exit (1);
    process_arg (&argc, &argv);
    if(!g_module_supported ()) {
        g_error ("g_module_supported() != TRUE\n");
        exit (1);
    }
    signal_connections ();

    rfm_global_init (argc, argv);

    /***************************************************/
    /* start loading required dynamic libraries here... */
#ifdef ENABLE_NLS
    /* this binds rfm domain: */
    bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);

    bindtextdomain ("librfm", PACKAGE_LOCALE_DIR);
    bindtextdomain ("rfm-gui", PACKAGE_LOCALE_DIR);
# ifdef HAVE_BIND_TEXTDOMAIN_CODESET
    bind_textdomain_codeset ("librfm", "UTF-8");
    bind_textdomain_codeset ("rfm-gui", "UTF-8");
# endif
# ifdef HAVE_BIND_TEXTDOMAIN_CODESET
    TRACE ("Rodent: binding %s, at %s\n", GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
    bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
# endif
#endif
 
    setlocale (LC_ALL, "");

    gtk_init (&argc, &argv);

    if (synchronize_X) {
	    TRACE("Synchronizing X events!!!!\n");
	    Display *display=gdk_x11_display_get_xdisplay(gdk_display_get_default());
	    XSynchronize(display, True);
    }

    // set gtk properties
    GtkSettings *settings = gtk_settings_get_default();
    if (settings){
	/* make sure the type is realized */
	g_type_class_unref (g_type_class_ref (GTK_TYPE_IMAGE_MENU_ITEM));
	g_type_class_unref (g_type_class_ref (GTK_TYPE_BUTTON));
	g_object_set(G_OBJECT(settings), 
	    "gtk-button-images", TRUE,
	    "gtk-menu-images", TRUE,
	    NULL);
    }

    /* read in shm settings: this will also pull in icon module... */
    NOOP("Rodent: Loading settings dialog module\n");
    rfm_void (MODULE_DIR, "settings", "mcs_shm_start");
    // Check if icon module was available to load
    if(!rfm_void(MODULE_DIR, "icons", "module_active")){
        TRACE ("Rodent: Cannot load icon theme module: proceeding with Rodent basic and gtk built-in icons.\n");
    }
    if(strstr (argv[0], "-getpass")) {
	GDK_THREADS_ENTER();
        gchar *p;
	const gchar *sudo_command=getenv("RFM_SUDO_COMMAND");

	gchar *string=g_strdup_printf("%s", _("Enter password"));
	if (sudo_command && strlen(sudo_command)) {
	    gchar *p = (gchar *)sudo_command;
	    gchar *markup=g_strdup("");
	    for (;p && *p; p++){
		gchar *g;
		if (*p == '&') g = g_strdup_printf("%s&amp;", markup);
		else g = g_strdup_printf("%s%c", markup, *p );
		g_free(markup);
		markup = g;
	    }
	    g_free(string);
	    string=g_strdup_printf("%s\n%s:", markup, _("Enter password"));
	    g_free(markup);
	}
	
        p = rfm_get_password (NULL, string);

	g_free(string);
	if (p && strlen(p)) {
	    fprintf (stdout, "%s\n", p);
	    memset(p, 0, strlen(p));
	} else {
	    // No password, either cancel or close, then
	    // send interrupt signal to parent
	    pid_t parent = getppid();
	    kill(parent, SIGINT);
	}
	g_free(p);

	exit(0);
    }


    rfm_init_env ();            /* allocate memory for dynamic environment variables */
    rfm_setenv ("PWD", (gchar *) GETWD, FALSE);


    if(strstr (argv[0], "rodent-desk") != NULL){
        enable_desktop = FALSE;
    } else if(getenv ("RFM_ENABLE_DESKTOP") && strlen (getenv ("RFM_ENABLE_DESKTOP"))){
        enable_desktop = GPOINTER_TO_INT(rfm_void(MODULE_DIR, "settings", "localhost_check"));
    }

    NOOP ("enable_desktop=%d\n", enable_desktop);
    if(enable_desktop) {
	Display *display=gdk_x11_display_get_xdisplay(
		gdk_display_get_default());
        GError *error = NULL;
        Atom selection_atom = XInternAtom (display, "RODENT_DESK_ATOM", True);
        Window xid = (selection_atom != None)?
	    XGetSelectionOwner (display, selection_atom):
	    None;
        NOOP ("enabling desktop=%d atom=%d xid=%d\n", 
		enable_desktop, (gint)selection_atom, (gint)xid);
        if(selection_atom != None && xid != None) 
	{
            TRACE ("rodent-desk already running\n");
        } else if(!g_spawn_command_line_async ("rodent-desk", &error)) {
            g_warning ("%s", error->message);
        }
    } else {
        NOOP ("Auto deskview disabled\n");
    }
#if 0
    if(strstr (argv[0], "rfm-run") || strstr (argv[0], "rfm-find")) {
        smc_connect (argc, argv, SmRestartNever);
    } else {
# ifdef ICONVIEW_BINARY
        smc_connect (argc, argv, SmRestartIfRunning);
# endif
# ifdef DESKVIEW_BINARY
        smc_connect (argc, argv, SmRestartImmediately);
# endif

    }
#endif


#ifndef PACKAGE_URL
# define PACKAGE_URL "http://xffm.org"
#endif

#ifdef ICONVIEW_BINARY
    TRACE("Rodent: create_gridview ()\n");
    rfm_global_p->window = create_gridview ();
#endif

#ifdef DESKVIEW_BINARY
    TRACE("Rodent: create_desktop ()\n");
    rfm_global_p->window = create_desktop ();
#endif

    SETWD();

    TRACE("Rodent: wait on setup semaphore\n");
    sem_wait (rfm_global_p->setup_semaphore);
    {
	gchar *setup_file = g_build_filename(SETUP_FILE, NULL);
	FILE *f=fopen(setup_file, "w");
	if (f) fclose(f);
	g_free(setup_file);
    }
    
// Mutex is redundant... gtk unlocks mutex on entering loop,
// and Rodent specific mutex allows recursion.
    TRACE("Rodent: entering event loop\n");
    GDK_THREADS_ENTER(); 
    gtk_main ();
    GDK_THREADS_LEAVE();
    TRACE("Rodent: exited event loop\n");

    // Free shared memory reference to shm settings 
    rfm_void (MODULE_DIR, "settings", "mcs_shm_stop");
    

    return 0;
}
