/*
 * Copyright 2005-2011 Edscott Wilson Garcia 
 * license: GPL v.3
 */

#define __RFM_FGR_C__
#include  "config.h"



#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include <glob.h>
#include <limits.h>
#include <memory.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <dirent.h>

#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include <gmodule.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>

#include "rodent_libs.h"

#ifdef ICONVIEW_BINARY
# include "gridview_lib.h"
#endif
#ifdef DESKVIEW_BINARY
# include "deskview_lib.h"
#endif

#define FORCE_CORE
#ifdef FORCE_CORE
# include <sys/time.h>
# include <sys/resource.h>
#endif

int
main (int argc, char *argv[]
    ) {


     if(!g_module_supported ()) {
        g_error ("g_module_supported() != TRUE\n");
        exit (1);
    }
     /***************************************************/
    /* start loading required dynamic libraries here... */
#ifdef ENABLE_NLS
    /* this binds rfm domain: */
    bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);

    bindtextdomain ("librfm", PACKAGE_LOCALE_DIR);
    bindtextdomain ("rfm-gui", PACKAGE_LOCALE_DIR);
# ifdef HAVE_BIND_TEXTDOMAIN_CODESET
    bind_textdomain_codeset ("librfm", "UTF-8");
    bind_textdomain_codeset ("rfm-gui", "UTF-8");
# endif
# ifdef HAVE_BIND_TEXTDOMAIN_CODESET
    TRACE ("binding %s, at %s", GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
    bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
# endif
#endif
    /* g_thread_supported is geeky. returns true if g_threads are already 
     * initialized, not whether they are supported on the current platform! */
    if(!g_thread_supported ())
        g_thread_init (NULL);
    gdk_threads_init ();
    gdk_threads_enter ();

    TRACE ("call to setlocale");
    setlocale (LC_ALL, "");
    TRACE ("call to gtk_init");
    gtk_init (&argc, &argv);
    // set gtk properties
    GtkSettings *settings = gtk_settings_get_default();
    if (settings){
	/* make sure the type is realized */
	g_type_class_unref (g_type_class_ref (GTK_TYPE_IMAGE_MENU_ITEM));
	g_type_class_unref (g_type_class_ref (GTK_TYPE_BUTTON));
	g_object_set(G_OBJECT(settings), 
	    "gtk-button-images", TRUE,
	    "gtk-menu-images", TRUE,
	    NULL);
    }

    rfm_rational(MODULE_DIR, "fgr", NULL, NULL, "do_find_standalone"); 


    //gtk_main ();
    return 0;
}
