
/*  
 *  Copyright (C)  1999-2011 Edscott Wilson Garcia under GNU GPL
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/


#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <dirent.h>
#include <ctype.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include <gmodule.h>

#include "rfm_libs.h"
#include "rfm_modules.h"

#include "rfm-diff.h"

static void *
hideshow_menus (gpointer data);
#include "rfm-diff-core.i"
#include "rfm-diff-misc.i"
#include "rfm-diff-callbacks.i"
#include "rfm-diff-gui.i"

// process input arguments
static void
process_arguments(diff_t *diff_p, int argc, gchar **argv){
    gint leftA = 1;
    gint rightA = 2;
    gint i;
    if(argc >= 2) for(i = 1; i < argc; i++) {
	// help string printout
            if((strcmp (argv[i], "-h") == 0) || (strcmp (argv[i], "--help") == 0)) {
#ifndef TAG
#define TAG ""
#endif
		g_print ("%s %s: %s (%s)", PACKAGE_NAME, TAG, _("Compare Files or Folders"), VERSION);
                g_print ("\n");
                g_print ("\n");
		gchar *g=g_strdup_printf("%s [%s-1] [%s-2]",argv[0], _("FILENAME"), _("FILENAME"));
                g_print (_("Usage: %s\n"), g);
		g_free(g);
                g_print ("-h, %s\n", _("Help"));
                g_print ("\n");
                g_print ("%s %s\n", argv[0], COPYRIGHT);
                g_print ("\n");
                exit (1);
            }
        }
    // left file specification
    if(argc >= leftA + 1) {
        if(diff_p->diff_flags & PATCHING){
            //fileD = assign (fileD, argv[leftA]);
	} else if (rfm_g_file_test(argv[leftA], G_FILE_TEST_EXISTS)){
            diff_p->left_file = g_strdup(argv[leftA]);
	}
    }
    // right file specification (only if left file specified)
    if(argc >= rightA + 1) {
        if(diff_p->diff_flags & PATCHING){
            //fileP = assign (fileP, argv[rightA]);
	} else if (rfm_g_file_test(argv[rightA], G_FILE_TEST_EXISTS)){
            diff_p->right_file = g_strdup(argv[rightA]);
	}
    }
    return;
}


gint
main (gint argc, gchar *argv[]) {
    // set intltool translations
#ifdef ENABLE_NLS
    bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
# ifdef HAVE_BIND_TEXTDOMAIN_CODESET
    bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
# endif
    textdomain (GETTEXT_PACKAGE);
#endif
    setlocale (LC_ALL, "");

    // initialize thread environment
    if (!XInitThreads()) g_error("XInitThreads returns FALSE\n");
    // initialize glib thread environment
    g_thread_init (NULL);
    gdk_threads_init ();
    // initialize gtk toolkit
    gtk_init (&argc, &argv);
    // set gtk properties
    GtkSettings *settings = gtk_settings_get_default();
    if (settings){
	/* make sure the type is realized */
	g_type_class_unref (g_type_class_ref (GTK_TYPE_IMAGE_MENU_ITEM));
	g_type_class_unref (g_type_class_ref (GTK_TYPE_BUTTON));
	g_object_set(G_OBJECT(settings), 
	    "gtk-button-images", TRUE,
	    "gtk-menu-images", TRUE,
	    NULL);
    }

    /* read in shm settings: this will also pull in icon module... */
    rfm_void (MODULE_DIR, "settings", "mcs_shm_start");
    // initialize diff memory structure. This is done in a 
    // thread to test if threads are working all right.
    GError *error=NULL;
    GThread *joinable=g_thread_create(diff_init, NULL, TRUE, &error);
    if (error) {
	g_error("%s: Error in initialization thread (%s)",
		argv[0], error->message);
    }
    diff_t *diff_p=g_thread_join(joinable);
    diff_p->self = g_thread_self();
    // process input arguments to set diff targets
    process_arguments(diff_p, argc, argv);
    // create gtk interface
    create_diff_window((void*) diff_p);
    gdk_flush();

    // do an initial diff based on file sizes 
    // (if arguments specified on command line)
    diff_p->left_count =
	update_combo_model(diff_p, TRUE, NULL);
    diff_p->right_count =
	update_combo_model(diff_p, FALSE, NULL);
    gdk_flush();


    // do an initial diff run if files (not directories)
    // were specified on the command line. 
    gboolean valid_startup = 
	diff_p->left_file && diff_p->right_file &&
	!rfm_g_file_test(diff_p->left_file ,G_FILE_TEST_IS_DIR) && 
	!rfm_g_file_test(diff_p->right_file ,G_FILE_TEST_IS_DIR) ;

    if(valid_startup) {
	do_diff (diff_p);
    } else {
	g_thread_create(hideshow_menus, diff_p, FALSE, NULL);
    }
    // enter gtk event loop
    gtk_main ();
    // cleanup
    g_free(diff_p);
    return (0);
}
