
dnl RFM_ENABLE_PLUGIN(varname, optionname, option string, option string 2, [default])
dnl
dnl This macro automatically adds a commandline switch based on the "optionname"
dnl parameter (--enable-optionname/--disable-optionname), which allows the
dnl user to explicitly control whether this option should be
dnl enabled or not. The "option string" parameter gives a brief description
dnl about this switch.
dnl
dnl If the user chose to enable this option defines a WITH_"varname" for
dnl use in Makefile.am
dnl
AC_DEFUN([RFM_ENABLE_PLUGIN],
[

  AC_ARG_ENABLE([$2],
AC_HELP_STRING([--enable-$2], [Create "$3" $4 (default=m4_default([$5], [yes]))])
AC_HELP_STRING([--disable-$2], [Do not create "$3" $4]),
     [case "${enableval}" in
       yes) $2=yes ;;
       no)  $2=no ;;
       *) AC_MSG_ERROR([bad value ${enableval} for --enable-$2 (use either yes or no)]) ;;
     esac],
     [$2=$5])
  AM_CONDITIONAL([WANT_$1], [test x$$2 = xyes])
  if test x$$2 = xyes; then
	AC_SUBST(WITH_$1) WITH_$1=yes
	AC_DEFINE_UNQUOTED([$1_CONFIGURED],[x$$2],[$1 selected at configure time])
  else
	AC_SUBST(WITH_$1) WITH_$1=no
  fi
])

AC_DEFUN([RFM_PLUGIN_STATUS],
[
if test x"$$1" = xyes; then
 echo '* $2 $3 (yes)'
else
 echo '  $2 $3 (no)'
fi
])

AC_DEFUN([RFM_CORE],
[
AC_ARG_WITH(core, [  --with-core            enable core dumps])
if test "$with_core" = "yes"
then
	AC_SUBST(WITH_CORE) WITH_CORE=yes
	AC_SUBST(CORE)
	AC_DEFINE_UNQUOTED([CORE],[$with_core],[enable CORE])
	AC_MSG_NOTICE([You enabled core dumps. Good for you.])
elif test "$with_core" != ""
then
	AC_SUBST(WITH_CORE) WITH_CORE=yes
	AC_MSG_NOTICE([Your specific kind of core dumps is $with_core])
	AC_SUBST(CORE)
	AC_DEFINE_UNQUOTED([CORE],[$with_core],[enable CORE])

else
	AC_SUBST(WITH_CORE) WITH_CORE=no
	AC_MSG_NOTICE([No core dumps for you.])
fi
])


AC_DEFUN([RFM_DEBUG],
[
AC_ARG_WITH(debug, [  --with-debug            enable debug])
if test "$with_debug" = "yes"
then
	AC_SUBST(WITH_DEBUG) WITH_DEBUG=yes
	AC_SUBST(DEBUG)
	AC_DEFINE_UNQUOTED([DEBUG],[$with_debug],[enable DEBUG])
	AC_MSG_NOTICE([You enabled debug. Good for you.])
	DB=--with-debug
elif test "$with_debug" != ""
then
	AC_SUBST(WITH_DEBUG) WITH_DEBUG=yes
	AC_MSG_NOTICE([Your specific kind of debug is $with_debug])
	AC_SUBST(DEBUG)
	AC_DEFINE_UNQUOTED([DEBUG],[$with_debug],[enable DEBUG])

else
	AC_SUBST(WITH_DEBUG) WITH_DEBUG=no
	AC_MSG_NOTICE([No debug for you.])
fi
])

AC_DEFUN([RFM_TRACE],
[
AC_ARG_WITH(trace, [  --with-trace            enable trace])

if test "$with_trace" = "yes"
then
	AC_MSG_NOTICE([You enabled trace. Good for you.])
	AC_SUBST(WITH_TRACE) WITH_TRACE=yes
	DEBUG_TRACE=yes
	AC_SUBST(DEBUG_TRACE)
	AC_DEFINE_UNQUOTED([DEBUG_TRACE],[$with_trace],[enable DEBUG_TRACE])
	TR=--with-trace
elif test "$with_trace" != ""
then
	AC_SUBST(WITH_TRACE) WITH_TRACE=yes
	DEBUG_TRACE=yes
	AC_SUBST(DEBUG_TRACE)
	AC_DEFINE_UNQUOTED([DEBUG_TRACE],[$with_trace],[enable DEBUG_TRACE])
	AC_MSG_NOTICE([Your specific kind of trace is $with_trace])
else
	AC_SUBST(WITH_TRACE) WITH_TRACE=no
	AC_SUBST(DEBUG_TRACE)
	AC_MSG_NOTICE([No trace for you.])
fi
])

AC_DEFUN([RFM_RODENT_ICON_THEME],
[
     AC_ARG_ENABLE([icontheme],
     [  --enable-icontheme      Install Rodent icon theme (default=yes)],
     [case "${enableval}" in
       yes) icontheme=true ;;
       no)  icontheme=false ;;
       *) AC_MSG_ERROR([bad value ${enableval} for --enable-icontheme (use either yes or no)]) ;;
     esac],[icontheme=true])
     AM_CONDITIONAL([WANT_ICONTHEME], [test x$icontheme = xtrue])

if test "$icontheme" != "true"
then
    AC_SUBST(WITH_ICONTHEME) WITH_ICONTHEME=no
  with_gtk_icons=yes
else
    AC_SUBST(WITH_ICONTHEME) WITH_ICONTHEME=yes
fi
if test "$with_gtk_icons" = "yes"
then
	AC_MSG_NOTICE([Rodent will default to the GTK icon theme.])
	AC_SUBST(GTK_ICONTHEME)
	AC_DEFINE_UNQUOTED([GTK_ICONTHEME],[1],[enable GTK_ICONTHEME])
elif test "$with_gtk_icons" != ""
then
	AC_SUBST(GTK_ICONTHEME)
	AC_DEFINE_UNQUOTED([GTK_ICONTHEME],[1],[enable GTK_ICONTHEME])
	AC_MSG_NOTICE([Rodent will default to the GTK icon theme.])
else
	AC_MSG_NOTICE([Rodent will not default to the GTK icon theme.])
fi
])

AC_DEFUN([RFM_GNU_CP],
[
AC_MSG_CHECKING([for GNU cp])
GAWK_VERSION=`cp --version`
INDEX=`expr "$GAWK_VERSION" : "[.*GNU]"`

if test $INDEX -gt  0 ; then
    AC_MSG_RESULT([GNU cp found])
    GNU_CP=1
    AC_SUBST(WITH_GNU_CP) WITH_GNU_CP=yes
    AC_SUBST(GNU_CP)
    AC_DEFINE_UNQUOTED([GNU_CP],[$GNU_CP],[enable GNU cp])
else
    AC_SUBST(WITH_GNU_CP) WITH_GNU_CP=no
    AC_MSG_RESULT([cp is not GNU. Some features will not be enabled!])
fi
])

AC_DEFUN([RFM_GNU_MV],
[
AC_MSG_CHECKING([for GNU mv])
GAWK_VERSION=`mv --version`
INDEX=`expr "$GAWK_VERSION" : "[.*GNU]"`

if test $INDEX -gt  0 ; then
    AC_MSG_RESULT([GNU mv found])
    GNU_MV=1
    AC_SUBST(WITH_GNU_MV) WITH_GNU_MV=yes
    AC_SUBST(GNU_MV)
    AC_DEFINE_UNQUOTED([GNU_MV],[$GNU_MV],[enable GNU mv])
else
    AC_SUBST(WITH_GNU_MV) WITH_GNU_MV=no
    AC_MSG_RESULT([mv is not GNU. Some features will not be enabled!])
fi
])

AC_DEFUN([RFM_GNU_LN],
[
AC_MSG_CHECKING([for GNU ln])
GAWK_VERSION=`ln --version`
INDEX=`expr "$GAWK_VERSION" : "[.*GNU]"`

if test $INDEX -gt  0 ; then
    AC_MSG_RESULT([GNU ln found])
    GNU_LN=1
    AC_SUBST(WITH_GNU_LN) WITH_GNU_LN=yes
    AC_SUBST(GNU_LN)
    AC_DEFINE_UNQUOTED([GNU_LN],[$GNU_LN],[enable GNU ln])
else
    AC_SUBST(WITH_GNU_LN) WITH_GNU_LN=no
    AC_MSG_RESULT([ln is not GNU. Some features will not be enabled!])
fi
])

AC_DEFUN([RFM_GNU_RM],
[
AC_MSG_CHECKING([for GNU rm])
GAWK_VERSION=`rm --version`
INDEX=`expr "$GAWK_VERSION" : "[.*GNU]"`
#echo "INDEX=$INDEX"

if test $INDEX -gt 0 ; then
    AC_MSG_RESULT([GNU rm found])
    GNU_RM=1
    AC_SUBST(WITH_GNU_RM) WITH_GNU_RM=yes
    AC_SUBST(GNU_RM)
    AC_DEFINE_UNQUOTED([GNU_RM],[$GNU_RM],[enable GNU rm])
else
    AC_SUBST(WITH_GNU_RM) WITH_GNU_RM=no
    AC_MSG_RESULT([rm is not GNU. Some features will not be enabled!])
fi
])

AC_DEFUN([RFM_GNU_SHRED],
[
AC_MSG_CHECKING([for GNU shred])
GAWK_VERSION=`shred --version`
INDEX=`expr "$GAWK_VERSION" : "[.*GNU]"`
#echo "INDEX=$INDEX"

if test $INDEX -gt 0 ; then
    AC_MSG_RESULT([GNU shred found])
    GNU_SHRED=1
    AC_SUBST(WITH_GNU_SHRED) WITH_GNU_SHRED=yes
    AC_SUBST(GNU_SHRED)
    AC_DEFINE_UNQUOTED([GNU_SHRED],[$GNU_SHRED],[enable GNU shred])
else
    AC_SUBST(WITH_GNU_SHRED) WITH_GNU_SHRED=no
    AC_MSG_RESULT([shred is not GNU. Some features will not be enabled!])
fi
])

AC_DEFUN([RFM_GNU_GHOSTSCRIPT],
[
AC_MSG_CHECKING([for GNU Ghostscript])
GS_VERSION=`gs --version`
if test x"$GS_VERSION" = x; then
    AC_SUBST(WITH_GNU_GS) WITH_GNU_GS=no
    AC_MSG_RESULT([GNU Ghostscript not found])
else
    AC_SUBST(WITH_GNU_GS) WITH_GNU_GS=yes
    AC_MSG_RESULT([Ghostscript found])
fi
])

AC_DEFUN([RFM_BROKEN_SEMAPHORES],
[
AC_MSG_CHECKING(for broken shared semaphores);
result=`uname -a | grep Linux`
    if test x"${result}" = x; then
	AC_MSG_RESULT([no.])
	AC_MSG_RESULT([This is not Linux. Assuming broken shared semaphores.])
	AC_SUBST(BROKEN_SHARED_SEMAPHORES)
	AC_DEFINE_UNQUOTED([BROKEN_SHARED_SEMAPHORES], [1], [Define if system does not support shared semaphores (FreeBSD or BSD generic at least)])
    else 
	AC_SUBST(THIS_IS_LINUX)
	AC_DEFINE_UNQUOTED([THIS_IS_LINUX], [1], [Define if system is Linux kernel])
	AC_MSG_RESULT([System is Linux: shared semaphores should work.])
    fi
])

AC_DEFUN([RFM_LINUX_HOST],
[
AC_MSG_CHECKING(for FreeBSD or OpenBSD)
ac_uname_s=`uname -s`
echo "system: $ac_uname_s"
AM_CONDITIONAL(WANT_FREEBSD, [test "$ac_uname_s"=FreeBSD || "$ac_uname_s"=OpenBSD])
AC_MSG_CHECKING(for Linux host)
result_linux=`uname -a | grep Linux`
    if test x"${result_linux}" = x; then
	AC_MSG_RESULT([This is not Linux.])
	AC_MSG_CHECKING(for gmake);
	result_gmake=`gmake --version`
	if test x"${result_gmake}" = x; then
	    AC_MSG_ERROR([GNU make (gmake) not found! Please install and then rerun configure.])
	else 
	    echo "$result_gmake"
	fi
    else 
	AC_SUBST(THIS_IS_LINUX)
	AC_DEFINE_UNQUOTED([THIS_IS_LINUX], [1], [Define if system is Linux kernel and posix shared memory is at /dev/shm])
	AC_MSG_RESULT([System is Linux. Assuming shared memory resides in /dev/shm])
    fi
])

AC_DEFUN([RFM_GNU_AWK],
[
AC_MSG_CHECKING([for GNU Awk])
GAWK_VERSION=`gawk --version`
INDEX=`expr "$GAWK_VERSION" : "[GNU Awk]"`
#echo "INDEX=$INDEX"
if test $INDEX -gt 0 ; then
    AC_MSG_RESULT([GNU gawk found])
else
    AC_MSG_ERROR([GNU gawk not found! Please install and then rerun configure.])
fi
])

AC_DEFUN([RFM_CHECK_DISTRO],
[
AC_MSG_CHECKING(distro);
result=`ls -l /sbin/yast 2>/dev/null | grep yast2`
    if test x"${result}" = x; then
	AC_MSG_RESULT([ not Suse.])
	AC_SUBST(LIBRSVG_NAME) LIBRSVG_NAME=librsvg2
	AC_SUBST(DISTRO_X) DISTRO_X=libSM-devel
	AC_SUBST(DISTRO_X_VERSION) DISTRO_X_VERSION=1.2

    else 
	AC_MSG_RESULT([ Suse.])
	AC_SUBST(LIBRSVG_NAME) LIBRSVG_NAME=librsvg
	AC_SUBST(DISTRO_X) DISTRO_X=xorg-x11-devel
	AC_SUBST(DISTRO_X_VERSION) DISTRO_X_VERSION=7.6
    fi

AC_MSG_CHECKING(for gentoo emerge)
AC_CHECK_PROG(cv_emerge, emerge, yes, no)
AM_CONDITIONAL(WANT_GENTOO, [test "$cv_emerge"=yes])

AC_MSG_CHECKING(for debian dpkg)
AC_CHECK_PROG(cv_dpkg, dpkg, yes, no)
AM_CONDITIONAL(WANT_DEBIAN, [test "$cv_dpkg"=yes])

])

