#ifndef RODENT_POPUP_H
# define RODENT_POPUP_H

# define RODENT_HOOKUP_OBJECT(x, y, z) rodent_set_widget_by_name(x, z, y)

# define MENU_PIXMAP 	0
# define BIGGER_MENU_PIXMAP 	10
# define BUTTON_PIXMAP	1
# define BIGGER_BUTTON_PIXMAP	11
# define OTHER_PIXMAP	2
gpointer
  rodent_create_popup_bythread(gpointer data);

GtkWidget *
  rodent_get_widget_by_name (GtkWidget * parent, const gchar * name);

void
  rodent_set_widget_by_name (GtkWidget * parent, const gchar * name, GtkWidget * widget);

gboolean 
  rodent_common_mask_key (GdkEventKey * event, void *data);

GtkWidget *
  rodent_mk_pixmap_menu (const gchar * file, GtkWidget * parent, int caso);

GtkWidget *
  rodent_mk_menu (widgets_t * widgets_p, const gchar * label, 
	  const gchar * name, GtkWidget * parent, 
	  gpointer callback, const gchar * iconfile);
/*
int
rodent_get_response_integer(widgets_t * widgets_p,
                                              const gchar * title_txt,
                                              const gchar * label_txt);*/
gchar *
rodent_get_radio_response (widgets_t * widgets_p, const gchar * title_txt, const gchar * label_txt, gchar **radio_options);

const gchar *
  rodent_get_response (widgets_t * widgets_p, const gchar * title_txt, 
	  const gchar * label_txt, const gchar * default_txt);

const gchar *
  rodent_get_response_history (widgets_t * widgets_p,
                                          const gchar * title_txt,
                                          const gchar * label_txt,
                                          const gchar * extra_txt,
                                          gchar * history_file,
                                          const gchar * path,
                                          const gchar * entry_text,
                                          gchar * flagfile,
                                          const gchar * check_label, 
					  int filechooser_action, 
// preload folder
					  const gchar * folder,
// completion_type: MATCH_COMMAND, MATCH_FILE, MATCH_HISTORY,MATCH_NONE
					  gint completion_type);

/* for button press events: */
void
  rodent_do_popup (view_t * view_p, const population_t * population_p, 
	  GdkEventButton * event);

/* for keyboard press events (wrapper): */
GtkWidget *
  rodent_mk_popup_menu (GtkWidget * parent, 
	  GtkAccelGroup * accel_group, view_t * view_p);

/* used by double click events directly: */
void
  rodent_open_with (widgets_t * widgets_p, record_entry_t * en);

int
  rodent_thread_monitor_off (view_t * view_p);

int
  rodent_refresh (widgets_t * widgets_p, record_entry_t * in_en);

/*used by delete key directly: */
void
  rodent_remove_activate (GtkMenuItem * menuitem, gpointer user_data);

void
  rodent_push_view_go_history (view_t * view_p);

void
  rodent_glob_activate (GtkMenuItem * menuitem, gpointer user_data);

void
  rodent_refresh_activate (GtkMenuItem * menuitem, gpointer user_data);

void
  rodent_back_activate (GtkMenuItem * menuitem, gpointer user_data);

void
  rodent_jump_to_activate (GtkMenuItem * menuitem, gpointer user_data);

void
  rodent_home_activate (GtkMenuItem * menuitem, gpointer user_data);

void
  rodent_host_activate (GtkMenuItem * menuitem, gpointer user_data);

void
rodent_add_navigation_menu_items (widgets_t * widgets_p, GtkWidget *target_menu);

void
rodent_add_general_menu_items (widgets_t * widgets_p, GtkWidget *target_menu);

void
rodent_add_file_menu_items (widgets_t * widgets_p, GtkWidget *target_menu);

void
rodent_add_exec_menu_items (widgets_t * widgets_p, GtkWidget *target_menu);

void
rodent_add_fileexec_menu_items (widgets_t * widgets_p, GtkWidget *target_menu);

void
rodent_add_size_menu_items (widgets_t * widgets_p, GtkWidget *target_menu);

#endif
