//
//
/* this file is included by rodent_population.c */


static void
mk_logical_rect (PangoLayout * layout, PangoRectangle * logical_rect) {
    NOOP (">> mk_logical_rect\n");
    if(layout) {
        pango_layout_get_pixel_extents (layout, NULL, logical_rect);
        /* ++ because zero is actually unity, not nonexistance */
        logical_rect->width++;
        logical_rect->height++;
    }
}

static void
mk_layouts (view_t * view_p, gchar * tag, 
		PangoLayout ** layout, PangoLayout ** layout2,
		PangoLayout ** layout_full) {
    NOOP (">> rfm_mk_layouts\n");
    int i;
    gchar *optimal_chars = " .-_";
    static gchar *optimal_set[4] = { NULL, NULL, NULL, NULL };
    PangoRectangle logical_rect;
    gchar *tag_copy = NULL,
        *the_tag = NULL;

    if(!layout || !layout2){
		g_warning("mk_layouts(): one of the layout pointers is null");
        return;
	}
    /* cleanup first */
    if(*layout){
        g_object_unref (*layout);
	}
    if(*layout2){
        g_object_unref (*layout2);
	}
    if(*layout_full){
        g_object_unref (*layout_full);
	}
    *layout = *layout2 =  *layout_full = NULL;

    if(!tag || !strlen (tag)){
		DBG("mk_layouts(): tag is null or empty!\n");
        return;
    }

    // Easy part: full layout.
    *layout_full = gtk_widget_create_pango_layout (view_p->widgets.paper, tag);
 
    if(!optimal_set[0]) {
        for(i = 0; i < strlen (optimal_chars); i++) {
            gchar c[2] = { 0, 0 };
            c[0] = optimal_chars[i];
            optimal_set[i] = rfm_utf_string (c);
        }
    }

    /* new method... */
    /* get width of string
     * string MUST be a validated utf string here. */
    the_tag = g_strdup (tag);
    *layout = gtk_widget_create_pango_layout (view_p->widgets.paper, the_tag);


    //LOCK_DISPLAY();
    pango_layout_get_pixel_extents (*layout, NULL, &(logical_rect));
    //UNLOCK_DISPLAY();
    gint max_width=CELLWIDTH(view_p) - 2 * TEXTSPACING;
    if (view_p->view_layout.icon_size == TINY_ICON_SIZE) max_width -= TINY_ICON_SIZE;

    if(view_p->view_layout.icon_size < TINY_ICON_SIZE ||
        logical_rect.width + 1 <= max_width) 
    {
        /* if it fits, or < TINY_ICON_SIZE, were all done */
        NOOP (stderr, "no cut necessary for %s\n", tag);
        g_free (the_tag);
        return;
    }
    /* shucks, it doesn't fit. Let's work with a copy of the tag */
    NOOP (stderr, "shucks, it doesn't fit: %d > %d\n", logical_rect.width + 1, max_width);
    tag_copy = g_strdup (the_tag);
    while(strlen (tag_copy) > 1 && logical_rect.width + 1 > max_width) {
        gchar *rear;
        int length = strlen (tag_copy);
        gchar *p = tag_copy + length - 1;
        rear = g_utf8_find_prev_char (tag_copy, p);
        length = strlen (rear);
        memset (rear, 0, length);
        g_object_unref (*layout);
        *layout = gtk_widget_create_pango_layout (view_p->widgets.paper, tag_copy);
        pango_layout_get_pixel_extents (*layout, NULL, &(logical_rect));
    }
    if (view_p->view_layout.icon_size >= TINY_ICON_SIZE && view_p->view_layout.icon_size < SMALL_ICON_SIZE){
	// this is compact view, so we don't care about layout2
        g_object_unref (*layout);
	gchar *compact_tag=g_strdup_printf("%s...", tag_copy);
        *layout = gtk_widget_create_pango_layout (view_p->widgets.paper, compact_tag);
        pango_layout_get_pixel_extents (*layout, NULL, &(logical_rect));
	g_free (compact_tag);
	g_free (the_tag);
	g_free (tag_copy);
        return;
    }
    NOOP (stderr, "\"%s\" cut to \"%s\"\n", the_tag, tag_copy);
    /* Now the first part fits, but the split may not be optimum
     * we must now look for one in " .-_" to do the split, but the
     * character search must be done in utf */
    /* is the cut optimal? */
    {
        int cut_location = strlen (tag_copy);
        gchar *optimal_ch = NULL;
        gchar *p = the_tag + (cut_location - 1);
        gchar *optimal_cut_p = NULL;
    NOOP (stderr, "1. p == \"%s\"\n", p);
        p = g_utf8_find_prev_char (the_tag, p); /* previous validated location */
    NOOP (stderr, "2. p == \"%s\"\n", p);
        p = g_utf8_find_next_char (p, NULL);    /* validated location */
    NOOP (stderr, "3. p == \"%s\"\n", p);

        for(i = 0; i < strlen (optimal_chars); i++) {
            if(strncmp (p, optimal_set[i], strlen (optimal_set[i])) == 0) {
                optimal_ch = optimal_set[i];
                optimal_cut_p = p;
                NOOP ("optimal cut found for %s\n", tag);
                break;
            }
        }
        if(optimal_cut_p)
            goto go_on;

        for(i = 0; i < strlen (optimal_chars); i++) {
            gchar *g = g_utf8_strrchr (tag_copy, -1, g_utf8_get_char (optimal_set[i]));

            if(g) {
                int diff = strlen (tag_copy) - strlen (g);
                g = the_tag + diff + 1;
                *layout2 = gtk_widget_create_pango_layout (view_p->widgets.paper, g);
                pango_layout_get_pixel_extents (*layout2, NULL, &(logical_rect));
                if(logical_rect.width + 1 <= max_width) {
                    NOOP ("might improve cut for %s\n", tag);
                    g_object_unref (*layout);
                    memset (tag_copy + diff + 1, 0, strlen (tag_copy + diff + 1));
                    *layout = gtk_widget_create_pango_layout (view_p->widgets.paper, tag_copy);

                    goto done;
                } else {
                    NOOP ("NOT improveable: %s (could look for another cut char)\n", tag);
                    g_object_unref (*layout2);
                }
                break;
            }
        }
    }

    /* So we don't have an optimal split. Let's construct the rest. */
  go_on:
    if(strlen (tag_copy) && strlen (the_tag) > strlen (tag_copy)) {
        gchar *p = the_tag + (strlen (tag_copy));
        /* XXX should do this for all spaces, not just the first  */
        if(strncmp (p, optimal_set[0], strlen (optimal_set[0])) == 0)
            p = g_utf8_find_next_char (p, NULL);

        *layout2 = gtk_widget_create_pango_layout (view_p->widgets.paper, p);
        /* final question, does it fit? */
        pango_layout_get_pixel_extents (*layout2, NULL, &(logical_rect));
        while(logical_rect.width + 1 > max_width) {
            gchar *g;
            NOOP ("second line does not fit (%s)\n", p);
            g_object_unref (*layout2);
            p = g_utf8_find_next_char (p, NULL);
            g = g_strconcat ("~", p, NULL);
            *layout2 = gtk_widget_create_pango_layout (view_p->widgets.paper, g);
            pango_layout_get_pixel_extents (*layout2, NULL, &(logical_rect));
            g_free (g);
        }

    }
    /* finally we free our copies of the tag */
  done:
    g_free (tag_copy);
    g_free (the_tag);
    return;
}


void
destroy_population_item (population_t * population_p) {
    if(!population_p)
        return;
    /* objects that need to be unreffed: 
     * (tagged as referrence in types.h) */

    if(population_p->preview_pixbuf)
        g_object_unref (population_p->preview_pixbuf);

    if(population_p->layout)
        g_object_unref (population_p->layout);
    if(population_p->layout2)
        g_object_unref (population_p->layout2);
    if(population_p->layout_full)
        g_object_unref (population_p->layout_full);
    rfm_destroy_entry (population_p->en);
    g_free(population_p->icon_id);
    g_free (population_p);
}
 
static void
transfer_population (view_t * view_p, xfdir_t *new_xfdir_p) {
     // Construct hash table for reloaded population_pp;
    // (skip up element)
    // (hashed items are dir_t *)
    GHashTable *new_hash = g_hash_table_new(g_str_hash, g_str_equal);
    gint i;
    DBG ("transfer(0x%x): pathc = %d\n", GPOINTER_TO_INT(g_thread_self()),
	    (gint)new_xfdir_p->pathc);
    for(i = 0; i < new_xfdir_p->pathc; i++) {
        if(!new_xfdir_p->gl[i].en) continue;
        //DBG ("transfer(): new_hash: %s\n", new_xfdir_p->gl[i].en->path);
	g_hash_table_insert(new_hash, new_xfdir_p->gl[i].en->path, (new_xfdir_p->gl)+i);
    }

    GHashTable *old_hash = g_hash_table_new(g_str_hash, g_str_equal);
    population_t **population_pp = view_p->population_pp;
    // Construct hash table for current view population_pp.
    // (skip up element)
    // (hashed items are population_t *)
    GSList *remove_list = NULL;
    // this is buggy if more than one dummy item (so do not skip):
    // if (population_pp && *population_pp) population_pp++;
    for(; population_pp && *population_pp; population_pp++) {
	population_t *population_p = *population_pp;
	if (!population_p->en || !population_p->en->path) continue;
	g_hash_table_insert(old_hash, population_p->en->path, population_p);
	// Construct list of remove items.
	if (!g_hash_table_lookup(new_hash, population_p->en->path)){
            DBG ("transfer(): adding to remove list: %s\n", population_p->en->path);
	    remove_list = g_slist_prepend(remove_list, population_p);
	}

    }

    // create new population_pp
    population_pp = rodent_mk_grid_elements (view_p, new_xfdir_p->pathc);
    // Transfer transferable items and create new items.
//    if (view_p->population_pp) {population_pp[0] = view_p->population_pp[0]; }
    
    for(i = 0; i < new_xfdir_p->pathc; i++) {
	if ( new_xfdir_p->gl[i].en && !new_xfdir_p->gl[i].en->path ){
            g_warning("transfer_population(): this is bad....\n");
	    continue;
	}
	population_t *population_p = NULL;
	if (new_xfdir_p->gl[i].en){
	    population_p = g_hash_table_lookup(old_hash, new_xfdir_p->gl[i].en->path);
	}
	if (population_p){
            population_pp[i] = population_p;
            /*  update the stat record */
            if(population_pp[i]->en->st && new_xfdir_p->gl[i].en->st) {
		if (memcmp(population_pp[i]->en->st,
			new_xfdir_p->gl[i].en->st,
			sizeof(struct stat))) {
		    memcpy (population_pp[i]->en->st,
			    new_xfdir_p->gl[i].en->st, 
			    sizeof (struct stat));
		    // remove any previous popup preview image, including the thumbnail file.
		    // (see xfdir.i:674)
		    if (population_pp[i]->preview_pixbuf) {
			NOOP (stderr, "removing preview pixbuf at transfer_population\n"); 
			population_pp[i]->preview_pixbuf = NULL;
			gchar *thumbnail = 
			    rfm_get_thumbnail_path (population_pp[i]->en->path, PREVIEW_IMAGE_SIZE);
			if (unlink(thumbnail));
			g_free(thumbnail);
			// We might get a new preview here.
		    }
		}
	    }
	} else {
	    // create a new population item.
            DBG ("transfer(): Creating new population item for %s\n",
		    (new_xfdir_p->gl[i].en)?new_xfdir_p->gl[i].en->path:"ROOT");
            population_pp[i] = 
		rodent_create_population_t (view_p, new_xfdir_p->gl[i].en, i, NULL, new_xfdir_p->gl[i].pathv);
	    // create mimetype icon
            DBG ("transfer(): Creating new mimetype icon for %s\n",
		    (new_xfdir_p->gl[i].en)?new_xfdir_p->gl[i].en->path:"ROOT");
	    
	    gchar *id=rfm_get_entry_icon_id(new_xfdir_p->gl[i].en, TRUE);
	    NOOP(stderr, "id is %s\n",id);
	    
	    population_pp[i]->pixbuf = 
		rfm_get_pixbuf (id, REDUCED_ICONSIZE(view_p));

	    g_free(population_pp[i]->icon_id);
	    if (GDK_IS_PIXBUF(population_pp[i]->pixbuf)){
		population_pp[i]->icon_id = id;
	    } else {
		DBG("transfer_population(): pixbuf creation failed for %s\n", id);
		g_free(id);
		population_pp[i]->icon_id = g_strdup("xffm/stock_file");
		population_pp[i]->pixbuf = 
		    rfm_get_pixbuf ("xffm/stock_file", REDUCED_ICONSIZE(view_p));
	    }
	}
    }

    // That done, update the population selection list. 

    GSList *tmp = view_p->selection_list;
    for(; tmp && tmp->data; tmp = tmp->next) {
        record_entry_t *en = (record_entry_t *) tmp->data;
	if (!en->path) continue;
	if (!g_hash_table_lookup(new_hash, en->path)){
            DBG ("transfer(): removing from selection list: %s\n", en->path);
            view_p->selection_list = g_slist_remove (view_p->selection_list, en);
	}
    }

    // Time to do the switch to the new population pp.
    // old population is now obsolete. Pointer array
    // is no longer necessary (we have the remove list).
    population_t **obsolete_population_pp = view_p->population_pp;
    view_p->population_pp = population_pp;
    g_free(obsolete_population_pp);

    // Remove obsolete population items
    // (this is a leak watch point)
    for (tmp = remove_list; tmp && tmp->data; tmp = tmp->next){
	population_t *population_p = tmp->data;
        DBG ("transfer(): destroying  population item: %s\n", population_p->en->path);
	destroy_population_item (population_p);
    }


    // Clean up temporary hash tables and remove list.
    g_hash_table_destroy(old_hash);
    g_hash_table_destroy(new_hash);
    g_slist_free(remove_list);

    // all done!
    return;
}

static void
transfer_operations(view_t *view_p, xfdir_t *new_xfdir_p){
    /* make new population_pp and transfer old population_pp elements,
     * creating new elements for those not in old population_pp
     * and eliminating those in old population_pp no longer present
     * */
    rodent_init_grid (view_p, new_xfdir_p->pathc);
    transfer_population (view_p, new_xfdir_p);
    
    if(view_p->flags.type == ICONVIEW_TYPE) {
	NOOP ("init_grid at short_reload...\n");
        // this uses initgrid info but also may generate an expose
        // so must be placed after transfer_population()
        rodent_restore_view_size (view_p);
    } 
    // recalculate x,y
    // get x,y coordinates for each population_p
    // or correct row, column
    rodent_recalc_population_geometry (view_p);
 
    if(view_p->en && view_p->en->st){
        memcpy (view_p->en->st, new_xfdir_p->en->st, sizeof (struct stat));
    }
    gdk_flush ();

    // fire off pending preview threads, (thread managed):
    NOOP("softreload: rfm_fireup_previews\n");
    rfm_fireup_previews (view_p);
}



static void
increase_population_serial (view_t * view_p) {
    g_mutex_lock (view_p->mutexes.population_serial);
    view_p->flags.population_serial++;
    g_mutex_unlock (view_p->mutexes.population_serial);

}


static gpointer
destroy_view_f(void *data){
    view_t *view_p=data;
//    sleep(1);
    // Cleanup view population 
    if (rfm_population_write_lock (view_p)){
	rodent_destroy_population (view_p);
	rfm_population_write_unlock (view_p);
    } else {
	NOOP(stderr, "ABSURD: no write lock for view 0x%x, \n", GPOINTER_TO_INT(view_p));
    }
	
    view_p->population_pp = NULL;

    rfm_destroy_view(view_p);
    return NULL;
}

// This is a thread function, must have GDK mutex set for gtk commands...
static
gpointer
janitor(gpointer data){
    GMutex *mutex = g_mutex_new();
    GSList *cleanup_list = NULL;
    TRACE("starting janitor...\n");
    //GtkWidget *window=data;
    do {

	g_mutex_lock(mutex);
	gint load_timeout = 2;
	NOOP(stderr, "janitor at timed wait\n");
#if GLIB_MAJOR_VERSION==2 && GTK_MINOR_VERSION<32
	GTimeVal tv;
	g_get_current_time (&tv);
	tv.tv_sec += load_timeout;
	if (!g_cond_timed_wait(rfm_global_p->janitor_signal, 
		    mutex, &tv))
#else
	gint64 end_time;
	end_time = g_get_monotonic_time () + load_timeout * G_TIME_SPAN_SECOND;
	if (!g_cond_wait_until (rfm_global_p->janitor_signal, 
		    mutex, end_time))
#endif
	{
	    NOOP(stderr, "Janitor timeout loop\n");
	} else {
	    NOOP(stderr, "Janitor got the signal\n");
	}

	g_mutex_unlock(mutex);	

	g_static_rw_lock_writer_lock (&(rfm_global_p->view_list_lock));
	    NOOP(stderr, "Janitor got the view_list_lock\n");
	GSList *view_list = rfm_global_p->window_view_list;
	for (; view_list && view_list->data; view_list=view_list->next){
	    view_t *view_p = view_list->data;
	    if (view_p->flags.status != STATUS_EXIT) continue;
	    if (!g_slist_find(cleanup_list, view_list->data)){
		cleanup_list = g_slist_prepend(cleanup_list, view_list->data);
	    }
	    rfm_global_p->window_view_list = 
		g_slist_remove (rfm_global_p->window_view_list, view_p);
	    break;
	}
	gint active_views = g_slist_length(rfm_global_p->window_view_list);
	g_static_rw_lock_writer_unlock (&(rfm_global_p->view_list_lock));

	view_list = cleanup_list;
	for (; view_list && view_list->data; view_list=view_list->next){
	    view_t *view_p=view_list->data;
	    if(!g_static_rw_lock_writer_trylock(&(view_p->mutexes.view_lock))){
		DBG("janitor: view 0x%x is still in use\n",
			GPOINTER_TO_INT(view_p));
		continue;
	    }
	    NOOP(stderr, "Janitor got the mutexes.view_lock\n");

	    g_static_rw_lock_writer_unlock(&(view_p->mutexes.view_lock));

	    TRACE("janitor() will now destroy view 0x%x\n", 
		    GPOINTER_TO_INT(view_p));
	    destroy_view_f(view_p);
	    cleanup_list = g_slist_remove(cleanup_list, view_p);
	    if (!cleanup_list) break;
	    view_list = cleanup_list;
	}

	if (active_views == 0 && g_slist_length(cleanup_list) == 0) {
	    TRACE("Janitor exiting now.\n");
	    // No more pages, we should destroy window,
	    // but this is not necessary. program is on 
	    // exit track and window will be destroyed
	    // anyways.
	    gtk_main_quit();
	    return NULL;
	}

    } while (1); // loop
    return NULL;
}


static
    void
set_application_icon (widgets_t * widgets_p, const gchar * icon_id) {
    GdkPixbuf *icon_pixbuf = rfm_get_pixbuf (icon_id, SIZE_ICON);
    if(icon_pixbuf) {
        gtk_window_set_icon (GTK_WINDOW (widgets_p->window), icon_pixbuf);
    }
}

static
void
set_icon_name (GtkWidget * widget, const gchar * path) {
    gchar *iconname;
    NOOP ("set_icon_name\n");
    if(!path) {
        iconname = rfm_utf_string (g_get_host_name());
    } else if(rfm_g_file_test (path, G_FILE_TEST_EXISTS)) {
	//gchar *display_host = rfm_display_host_name(widget); 


        gchar *basename = g_path_get_basename (path);
        gchar *pathname = g_strdup (path);
        gchar *b = rfm_utf_string (basename);   // non chopped
        rfm_chop_excess (pathname);
        gchar *q = rfm_utf_string (pathname);   // non chopped

        g_free (basename);
        g_free (pathname);
	//iconname = g_strconcat (display_host, ":  ", b, " (", q, ")", NULL);
	iconname = g_strconcat (b, " (", q, ")", NULL);
        g_free (q);
        g_free (b);
    } else {
        iconname = rfm_utf_string (path);
        rfm_chop_excess (iconname);
    }

#ifdef DEBUG
    gchar *gg = g_strdup_printf("%s-%d", iconname, getpid());
    g_free(iconname);
    iconname = gg;
#else
#ifdef CORE
    gchar *gg = g_strdup_printf("%s-%d", iconname, getpid());
    g_free(iconname);
    iconname = gg;
#endif
#endif
   
    gtk_window_set_title (GTK_WINDOW (gtk_widget_get_toplevel (widget)), iconname);
    //gdk_flush ();
    g_free (iconname);
}

    

static
void
set_deepest_dir (view_t * view_p) {
    if(view_p->en && view_p->en->path && rfm_g_file_test (view_p->en->path, G_FILE_TEST_IS_DIR)) {
        if(!view_p->deepest_dir || !strstr (view_p->deepest_dir, view_p->en->path)) {
            g_free (view_p->deepest_dir);
            view_p->deepest_dir = g_strdup_printf ("%s/.", view_p->en->path);
        }
    } else {
        //g_warning("cannot set deepest dir");
    }
}

static
GdkPixbuf *get_population_pixbuf(view_t * view_p,
	population_t *population_p,
	const gchar * icon_id){
    if (!population_p || !icon_id){
	g_warning("get_population_pixbuf() !population_p || !icon_id\n");
	return NULL;
    }

    NOOP ("get_population_pixbuf: rfm_get_pixbuf(%s)\n", icon_id);
    if (population_p->en == NULL) {
	return rfm_get_pixbuf (icon_id, REDUCED_ICONSIZE(view_p));
    }


    GdkPixbuf *pixbuf = rfm_get_pixbuf (icon_id, REDUCED_ICONSIZE(view_p));
    if (GDK_IS_PIXBUF(pixbuf)) {
	g_free(population_p->icon_id);
	population_p->icon_id = g_strdup(icon_id);
	return pixbuf;
    }
    DBG("cannot get pixbuf for icon=%s\n", icon_id);
    icon_id = "xffm/stock_file/composite/stock_close";
    pixbuf = get_population_pixbuf(view_p, population_p, "xffm/stock_file/composite/stock_close");
    g_free(population_p->icon_id);
    population_p->icon_id = g_strdup(icon_id);
    return pixbuf;
}

// This function sets the iconsize scale in gridview windows to the 
// size saved for the particular directory in the view.
static void
set_icon_size_scale(view_t *view_p){
    if (view_p->widgets.size_scale == NULL){
	return;
    }
    gtk_range_set_value (GTK_RANGE(view_p->widgets.size_scale), view_p->view_layout.icon_size);

    gchar *size_string=g_strdup_printf("%d", view_p->view_layout.icon_size);
    gchar *format;
    switch (view_p->view_layout.icon_size) {
	case BIG_ICON_SIZE:
	    format =g_strdup_printf(_("Huge (%sx%s)"),
			size_string, size_string);
	    break;
	case MEDIUM_ICON_SIZE:
	    format =g_strdup_printf(_("Large (%sx%s)"),
			size_string, size_string);
	    break;
	case SMALL_ICON_SIZE:
	    format =g_strdup_printf(_("Medium (%sx%s)"),
			size_string, size_string);
	    break;
	case TINY_ICON_SIZE:
	    format =g_strdup_printf(_("Small (%sx%s)"),
			size_string, size_string);
	    break;
	case LIST_ICON_SIZE:
	    format =g_strdup_printf("%s (%dx%d)",
		    _("List View"), TINY_ICON_SIZE, TINY_ICON_SIZE);
	    break;
	default:
	    g_warning("non group icon size is dumb");
	    format=g_strdup_printf("%s %sx%s", _("Icon size:"), 
			size_string, size_string);
    }

    
    gchar *tip_text;
    if (view_p->view_layout.icon_size==SMALL_ICON_SIZE) {
	tip_text = g_strdup_printf(_("Icon size: %s pixels (standard size)"),
		format);
    } else {
	tip_text = g_strdup_printf(_("Icon size: %s pixels"),
		format);
    }
    
    gtk_widget_set_tooltip_text (view_p->widgets.size_scale,tip_text);
    NOOP("set_icon_size_scale: %s\n", format);
    g_free(format);
    g_free(tip_text);
    g_free(size_string);
    return;
}

static void 
save_environment_desktop_dir(view_t *view_p, record_entry_t *target_en){
    // save the default desktop dir to the environment...
    if(view_p->flags.type != DESKVIEW_TYPE) {
	return;
    }
    g_free (view_p->desktop_dir);
    if (!target_en) {
	view_p->desktop_dir = g_strdup("");
    } else if (target_en->module) {
	if (rfm_void (PLUGIN_DIR, target_en->module, "module_name")) {
	    view_p->desktop_dir = g_strdup_printf ("module:%s",
		(gchar *)rfm_void (PLUGIN_DIR, target_en->module, "module_name"));
	} else {
	    view_p->desktop_dir = g_strdup (target_en->module);
	}
    } else {
	view_p->desktop_dir = g_strdup (target_en->path);
    }
    rfm_setenv ( "RFM_DESKTOP_DIR", view_p->desktop_dir, TRUE);
    // save configuration too
    rfm_rational (MODULE_DIR, "settings", (void *) "RFM_DESKTOP_DIR", (void *) view_p->desktop_dir, "mcs_set_var");
    NOOP(" setting RFM_DESKTOP_DIR to %s\n",view_p->desktop_dir);
    return;
}


