/*
 * 
 * Copyright 2003-2012 under GNU/GPL v3 or later, which means what it means.
 * Edscott Wilson Garcia <edscott@xfce.org>
 *
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "rodent_libs.h"

gboolean
rodent_cp (gint mode, widgets_t * widgets_p, GList * in_list, const gchar * target_path) {
    const void *vector[]={GINT_TO_POINTER(mode), widgets_p, in_list, (void *)target_path};
    return GPOINTER_TO_INT(rfm_vector_run(MODULE_DIR, "ops", GINT_TO_POINTER(4),
		    vector, "m_cp"));

}

////////////////////   ENTRY  //////////////////////////////////

/* entry function: */
void
rodent_mk_text_entry (view_t * view_p, const population_t * population_p, int caso) {
    rfm_complex(MODULE_DIR, "ops", view_p, (void *)population_p, GINT_TO_POINTER(caso),
		    "m_mk_text_entry");
    return;
}

void 
rodent_done_with_rename (gpointer data) {
    view_t *view_p = (view_t *) data;
    gchar *path;

    TRACE ("rodent_done_with_rename\n");
    if(!view_p->widgets.rename) {
        TRACE ("!view_p->widgets.rename\n");
        return ;
    }
    path = g_object_get_data (G_OBJECT (view_p->widgets.rename), "path");
    gint caso = GPOINTER_TO_INT(g_object_get_data (G_OBJECT (view_p->widgets.rename), "caso"));
    g_free (path);


    TRACE ("gtk_widget_destroy(GTK_WIDGET(view_p->widgets.rename));\n");
    gtk_widget_destroy (GTK_WIDGET (view_p->widgets.rename));
    rfm_status (&(view_p->widgets), "xffm/stock_dialog-info", 
	    (caso==0)?_("Rename"):
	    (caso==1)?_("Duplicate"):
	    (caso==2)?_("Create Symbolic Link"): "Invalid case in rodent_entry.c",
	    ": ", _("Cancelled"), NULL);
    view_p->widgets.rename = NULL;
    return ;
}

/////////////////////  RM  /////////////////////////////////////


// this is the thread function called by the callback,
// and it is consecutively called if "apply to all"
// toggle is unset.
// This is a thread function, must have GDK mutex set for gtk commands...
gpointer
rodent_remove (gpointer data) {
    return rfm_natural(MODULE_DIR, "ops", data, "m_remove");
}


