#ifndef RODENT_EXPOSE_H
#define RODENT_EXPOSE_H

void 
rodent_clean_paper(widgets_t *widgets_p);

void
  rodent_expose_all (view_t * view_p);

gint 
rodent_columns(view_t * view_p, gint width);

gint
rodent_rows(view_t * view_p,  gint width);

const 
population_t *
  rodent_find_in_population (view_t * view_p, gdouble x, gdouble y);

const 
population_t *
  rodent_find_in_labels (view_t * view_p, gdouble x, gdouble y);

GSList *
rodent_find_items_in_rectangle(view_t * view_p, GdkRectangle *rect, gboolean icons);

GdkColor *
get_gdk_color (view_t *view_p, int p);

const GdkColor *
rodent_select_pen (view_t * view_p, int p);
  
void 
  rodent_erase_deskview_geometries (void);

void
  rodent_save_deskview_geometry (const gchar * fullpath, int x, int y);

void
  rodent_recalc_population_geometry (view_t * view_p);

#ifdef USE_GTK2
void
  rodent_expose (GtkWidget * widget, GdkEventExpose * event, gpointer data);
#else
void
  rodent_draw (GtkWidget * widget, cairo_t *cr, gpointer data);
#endif

#endif
  




