//
//
/*
 * Copyright (C) 2002-2012 Edscott Wilson Garcia
 * EMail: edscott@xfce.org
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "rodent_libs.h"

typedef struct deskview_geometry_t {
    int x;
    int y;
} deskview_geometry_t;


void 
rodent_erase_deskview_geometries (void) {
    gchar *f = g_build_filename (DESK_GEOMETRY_FILE, NULL);
    if(rfm_g_file_test (f, G_FILE_TEST_EXISTS)) {
	unlink(f);
    }
    g_free (f);
    return;
}

void
rodent_save_deskview_geometry (const gchar * fullpath, int x, int y) {
    DBHashTable *preferences;
    GString *gs;
    gchar *f;
    deskview_geometry_t deskview_geometry;

    if(!fullpath || !strlen (fullpath))
        return;
    static GMutex *mutex=NULL;
    if (mutex==NULL) mutex=g_mutex_new();

    f = g_build_filename (DESK_GEOMETRY_FILE, NULL);
    g_mutex_lock(mutex);
    preferences = dbh_new (f, NULL, DBH_PARALLEL_SAFE);
    
    if(!preferences) {
        DBG ("Creating preferences file: %s", f);
	unsigned char keylength=11;
        preferences = dbh_new (f, &keylength, DBH_CREATE|DBH_PARALLEL_SAFE);
    } 

    if(!preferences) {
        g_warning ("Cannot open deskview geometry preferences table: %s", f);
        g_free (f);
        return;
    }
    g_free (f);

    gs = g_string_new (fullpath);
    sprintf ((char *)DBH_KEY (preferences), "%10u", g_string_hash (gs));
    g_string_free (gs, TRUE);

    deskview_geometry.x = x;
    deskview_geometry.y = y;

    memcpy (DBH_DATA (preferences), &deskview_geometry, sizeof (deskview_geometry_t));
    dbh_set_recordsize (preferences, sizeof (deskview_geometry_t));

    if(!dbh_update (preferences)) {
        g_warning ("!dbh_update(deskview_geometry preferences)");
    }
    dbh_close (preferences);
    g_mutex_unlock(mutex);
    NOOP ("saved deskview_geometry preferences with key=%s\n", fullpath);
    return;
}


