//
//
/*
|  Copyright (C) 1999-2004 Bill Wilson
|
|  Author:  Bill Wilson    bill@gkrellm.net
|  Latest versions might be found at:  http://gkrellm.net
|
|  This program is free software which I release under the GNU General Public
|  License. You may redistribute and/or modify this program under the terms
|  of that license as published by the Free Software Foundation; either
|  version 2 of the License, or (at your option) any later version.
|
|  This program is distributed in the hope that it will be useful,
|  but WITHOUT ANY WARRANTY; without even the implied warranty of
|  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
|  GNU General Public License for more details.  Version 2 is in the
|  COPYRIGHT file in the top level directory of this distribution.
| 
|  To get a copy of the GNU General Puplic License, write to the Free Software
|  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
static gchar *client_id;

static void
cb_smc_save_yourself (SmcConn smc_conn,
                      SmPointer client_data, gint save_type, gboolean shutdown, gint interact_style, gboolean fast) {
    SmcSaveYourselfDone (smc_conn, True);
}

static void
cb_smc_die (SmcConn smc_conn, SmPointer client_data) {
    SmcCloseConnection (smc_conn, 0, NULL);
    gtk_main_quit ();
}

static void
cb_smc_save_complete (SmcConn smc_conn, SmPointer client_data) {
}

static void
cb_smc_shutdown_cancelled (SmcConn smc_conn, SmPointer client_data) {
}

//static void
//cb_ice_connection_messages (IceConn ice_connection, gint source, GdkInputCondition condition) {

static gboolean
cb_ice_connection_messages (GIOChannel *source, GIOCondition condition, IceConn ice_connection) {
    IceProcessMessages (ice_connection, NULL, NULL);
    return TRUE; // the function should return FALSE if the event source should be removed
}

static SmcConn smc_connection = (SmcConn) 0;

G_MODULE_EXPORT void
smc_set_properties (gint argc, gchar ** argv, CARD8 style_hint) {
    struct passwd *pwd;
    gchar pid_str[16],
      userid_string[256];
    gint i,
      j;
    uid_t uid;
    SmProp userid,
      program,
      restart,
      restart_style,
      clone,
      pid,
     *props[6];
    SmPropValue userid_val,
      pid_val,
      restart_style_val;
    CARD8 restartstyle;
    /* Session manager properties - 4 are required.
     */
    if(!smc_connection)
        return;
    userid.name = SmUserID;
    userid.type = SmARRAY8;
    userid.num_vals = 1;
    userid.vals = &userid_val;
    uid = getuid ();
    if((pwd = getpwuid (uid)) != NULL)
        snprintf (userid_string, sizeof (userid_string), "%s", pwd->pw_name);
    else
        snprintf (userid_string, sizeof (userid_string), "%d", uid);
    userid_val.value = userid_string;
    userid_val.length = strlen (userid_string);

    pid.name = SmProcessID;
    pid.type = SmARRAY8;
    pid.num_vals = 1;
    pid.vals = &pid_val;
    sprintf (pid_str, "%i", getpid ());
    pid_val.value = (SmPointer) pid_str;
    pid_val.length = strlen (pid_str);

    restart.name = SmRestartCommand;
    restart.type = SmLISTofARRAY8;
    restart.vals = g_new0 (SmPropValue, argc + 3);
    j = 0;
    for(i = 0; i < argc; ++i) {
        if(strcmp (argv[i], "--sm-client-id")) {
            restart.vals[j].value = (SmPointer) argv[i];
            restart.vals[j++].length = strlen (argv[i]);
        } else
            i++;
    }
    restart.vals[j].value = (SmPointer) "--no-desktop";
    restart.vals[j++].length = strlen ("--no-desktop");
    restart.vals[j].value = (SmPointer) "--sm-client-id";
    restart.vals[j++].length = strlen ("--sm-client-id");
    restart.vals[j].value = (SmPointer) client_id;
    restart.vals[j++].length = strlen (client_id);
    restart.num_vals = j;

    restartstyle = style_hint;
    restart_style.name = SmRestartStyleHint;
    restart_style.type = SmCARD8;
    restart_style.num_vals = 1;
    restart_style.vals = &restart_style_val;
    restart_style_val.value = (SmPointer) & restartstyle;
    restart_style_val.length = 1;

    clone.name = SmCloneCommand;
    clone.type = SmLISTofARRAY8;
    clone.vals = restart.vals;
    clone.num_vals = restart.num_vals - 2;

    program.name = SmProgram;
    program.type = SmARRAY8;
    program.vals = restart.vals;
    program.num_vals = 1;

    props[0] = &program;
    props[1] = &userid;
    props[2] = &restart;
    props[3] = &clone;
    props[4] = &pid;
#if 0
    /* Make this an option? */
    props[5] = &restart_style;
    SmcSetProperties (smc_connection, 6, props);
#else
    SmcSetProperties (smc_connection, 5, props);
#endif

    g_free (restart.vals);
}

G_MODULE_EXPORT void
smc_connect (gint argc, gchar ** argv, CARD8 style_hint) {
    gchar error_string[256];
    SmcCallbacks *callbacks;
    IceConn ice_connection;
    gulong mask;
    gint i;

    char *previous_id = NULL;

    /* Session manager callbacks
     */
    callbacks = g_new0 (SmcCallbacks, 1);
    callbacks->save_yourself.callback = cb_smc_save_yourself;
    callbacks->die.callback = cb_smc_die;
    callbacks->save_complete.callback = cb_smc_save_complete;
    callbacks->shutdown_cancelled.callback = cb_smc_shutdown_cancelled;

    mask = SmcSaveYourselfProcMask | SmcDieProcMask | SmcSaveCompleteProcMask | SmcShutdownCancelledProcMask;

    for(i = 0; i < argc; i++) {
        if(strcmp (argv[i], "--sm-client-id") == 0) {
            previous_id = argv[i + 1];
            break;
        }
    }

    smc_connection = SmcOpenConnection (NULL /* SESSION_MANAGER env variable */ ,
                                        NULL /* share ICE connection */ ,
                                        SmProtoMajor, SmProtoMinor, mask,
                                        callbacks, previous_id, &client_id, sizeof (error_string), error_string);
    g_free (callbacks);
    if(!smc_connection)
        return;

    /*TRACE("client_id=%s",client_id); */

#if GTK_MAJOR_VERSION==2 && GTK_MINOR_VERSION<24
    // this is deprecated...
    gdk_set_sm_client_id (client_id);
#else
    gdk_x11_set_sm_client_id (client_id);
#endif

    smc_set_properties (argc, argv, style_hint);
    ice_connection = SmcGetIceConnection (smc_connection);

/*void                (*GdkInputFunction)                 (gpointer data,
                                                         gint source,
                                                         GdkInputCondition condition);   gboolean            (*GIOFunc)                          (GIOChannel *source,
                                                         GIOCondition condition,
                                                         gpointer data);

gdk_input_add (IceConnectionNumber (ice_connection), 
		    GDK_INPUT_READ,
                   (GdkInputFunction) cb_ice_connection_messages, 
		   ice_connection);*/

    GIOChannel *icechannel =
       	g_io_channel_unix_new (IceConnectionNumber (ice_connection));
     g_io_add_watch (icechannel, 	//GIOChannel *channel,
                     G_IO_IN, 		//GIOCondition condition,
                     (GIOFunc) cb_ice_connection_messages, 
                     //GIOFunc func,
                     ice_connection );	//gpointer user_data);
}
