#ifndef PRIMARY_ICONS_H
# define PRIMARY_ICONS_H

typedef struct preview_manager_t{
    view_t *view_p;
    gint population_serial;
    GtkWidget **diagnostics;
    GtkWidget **diagnostics_window;
} preview_manager_t;

typedef struct fireup_thread_manager_t {
     population_t *population_p;
     gint flags;
     gchar *path;
     gint type;
     preview_manager_t preview_manager_v;
} fireup_thread_manager_t;

void
rfm_change_icontheme(view_t * view_p);

gboolean
rfm_is_dark_background(view_t *view_p);

GdkColor *
rfm_get_gdk_color (view_t *view_p, int p);

Pixmap
rfm_create_background_pixmap (char *file);

GdkPixbuf *
rfm_create_background_pixbuf (const char *file, int width, int height);

gchar *
  rfm_get_thumbnail_path (const gchar * file, gint size);

void  
  rfm_fireup_previews (view_t * view_p);

gpointer 
  rfm_preview_thread_f (gpointer data);

gboolean 
  rfm_is_image (record_entry_t * en);

GdkPixbuf *
  rfm_get_pixbuf (const gchar * key, int size);

GdkPixbuf *
  rfm_get_from_pixbuf_hash (const gchar * key, int size);

gchar *
rfm_get_entry_icon_id(record_entry_t *en, gboolean magic_icon);

//////   module wraparounds:
gint 
  rfm_svg_supported (void);

GdkPixbuf *
rfm_pixbuf_scale_simple (GdkPixbuf *in_pixbuf, gint width, 
			 gint size, gint type);

GdkPixbuf *
rfm_pixbuf_new_from_file (const gchar *path, GError **error);
#endif
