//
//

typedef struct environ_t {
    char *env_var;
    char *env_string;
    char *env_text;
} environ_t;

enum {
    /* check buttons: */
    /* general:: */
    RFM_DOUBLE_CLICK_NAVIGATION,/* toggle */
    RFM_USE_GTK_ICON_THEME,     // fallback to default system gtk icon theme 
    RFM_DRAG_DOES_MOVE,         /* toggle */
    RFM_CONTENT_FOLDER_ICONS,
    RFM_ENABLE_TIPS,           /* toggle */
    RFM_ENABLE_LABEL_TIPS,           /* toggle */
    RFM_DIAGNOSTICS_FONT_SIZE,      /* size selector */
    RFM_DEFAULT_ICON_SIZE,      /* size selector */
    TERMINAL_CMD,               /* path selector */
    EDITOR,                 /* path selector */
    RFM_MAXIMUM_COMPLETION_OPTIONS, 
    RFM_MAXIMUM_DIAGNOSTIC_LINES, 
    RFM_LOAD_TIMEOUT, 
    /* desktop:: */
    RFM_ENABLE_DESKTOP,         /* toggle */
    RFM_ENABLE_DESKTOP_DIAGNOSTICS,    /* toggle */
    RFM_NAVIGATE_DESKTOP,       /* toggle */
    RFM_DESKTOP_TOP_MARGIN,     /* spin button*/
    RFM_DESKTOP_BOTTOM_MARGIN,  /* spin button*/
    RFM_DESKTOP_RIGHT_MARGIN,   /* spin button*/
    RFM_DESKTOP_LEFT_MARGIN,    /* spin button*/
    RFM_DESKTOP_DIR,            /* path selector */
    RFM_DESKTOP_IMAGE,          /* path selector */
    RFM_DESKTOP_COLOR,          /* color selector desktop */
    RFM_ICONVIEW_COLOR,         /* color selector iconview */
    RFM_TRANSPARENCY,           /* opacity selector, iconview */
    /* copy:: */
    RFM_CP_A,                   /* toggle */
    RFM_CP_RR,                  /* toggle */
    RFM_CP_L,                   /* toggle */
    RFM_CP_LL,                  /* toggle */
    RFM_CP_N,                   /* toggle */
    RFM_CP_PP,                  /* toggle */
    RFM_CP_P,                   /* toggle */
#ifdef GNU_CP
    RFM_CP_X,                   /* toggle */
    RFM_CP_D,                   /* toggle */
    RFM_CP_S,                   /* toggle */
    RFM_CP_B,                   /* toggle */
    RFM_CP_U,                   /* toggle */
#endif
    RFM_CP_HH,                  /* toggle */
#ifdef GNU_MV
    RFM_MV_B,
    RFM_MV_U,
#endif
    RFM_MV_N,
    RFM_LN_S,
#ifdef GNU_LN
    RFM_LN_B,
    RFM_LN_L,
    RFM_LN_P,
#endif
    RFM_LN_N,
    ///// cp/mv/rm ////
#ifdef GNU_CP
    VERSION_CONTROL,
#endif
    RFM_CP_VERBOSE,
// remove:
#ifdef GNU_RM
    RFM_RM_ONE_FILE_SYSTEM,     /* toggle */
#endif
    RFM_RM_VERBOSE,             /* toggle */
// shred:
#ifdef GNU_SHRED
    RFM_SHRED_REMOVE,           /* toggle */
    RFM_SHRED_ZERO,             /* toggle */
    RFM_SHRED_VERBOSE,             /* toggle */
    RFM_SHRED_ITERATIONS,       /* spinbutton */
#endif
    SMB_USER,                   /* input text */
    SUDO_ASKPASS,
    SSH_ASKPASS,
    RFM_PASTEBOARD_SERIAL,
    RFM_BOOKMARK_SERIAL,
    /* what's this for? */
    PWD,                        //XXX
    RFM_MONITOR_ICON_THEME,
    RFM_OPTIONS
};
/* increment version number for MCS_SHM_PLUGIN_FILE on configuration changes
 * (i.e. adding or removing configuration environment variables) */
// MCS_SHM_PLUGIN_FILE depends on CONFIG_BUILD, so that CONFIG_BUILD id 
// should be incremented with each modification to rfm environment variables.
// For rodent Gamma: build is 5190 (see files.h)
// For rodent Delta-unstable: build is 5858 (see files.h)

# ifdef RFM_PRIMARY_C
rfm_global_t *rfm_global_p = NULL;
/* the size of env_string must coincide with that of env_vars! 
*/
environ_t environ_v[RFM_OPTIONS + 1] = {        
    // +1 because zero does not count in enum...
    /* general:: */
    { "RFM_DOUBLE_CLICK_NAVIGATION", NULL, N_("Activate items with a double click")}, 
#ifdef GTK_ICONTHEME
    { "RFM_USE_GTK_ICON_THEME", "yes", N_("Icon Theme Specification")}, 
#else
    { "RFM_USE_GTK_ICON_THEME", NULL, N_("Icon Theme Specification")}, 
#endif
    { "RFM_DRAG_DOES_MOVE", "Yes", N_("Drag: move")}, 
    { "RFM_CONTENT_FOLDER_ICONS", N_("Yes"), N_("Emblems")},
    { "RFM_ENABLE_TIPS", N_("Yes"), N_("Enable tooltips")},
    { "RFM_ENABLE_LABEL_TIPS", N_("Yes"), N_("Enable tooltips")},
    { "RFM_DIAGNOSTICS_FONT_SIZE", "9", N_("Text: Font Size")},
    { "RFM_DEFAULT_ICON_SIZE", "Normal", N_("Default Size")},
    { "TERMINAL_CMD", "roxterm", N_("Terminal Emulator")}, 
    { "EDITOR", "gvim -f", N_("Text Editor")},
    { "RFM_MAXIMUM_COMPLETION_OPTIONS", "104", "Maximum completion options displayed"},
    { "RFM_LOAD_TIMEOUT", "5", "Maximum time (seconds) to wait for a load directory"},
    { "RFM_MAXIMUM_DIAGNOSTIC_LINES", "1000", "Maximum lines in lp terminal buffer"},
    /* desktop:: */
    { "RFM_ENABLE_DESKTOP", NULL, N_("Show Desktop Grid")}, 
    { "RFM_ENABLE_DESKTOP_DIAGNOSTICS", N_("Yes"), N_ ("Console Message Viewer")},
    { "RFM_NAVIGATE_DESKTOP", NULL, N_("Navigation Window")}, 

    { "RFM_DESKTOP_TOP_MARGIN", "20", N_("Top Margin")},
    { "RFM_DESKTOP_BOTTOM_MARGIN", "40", N_("Bottom Margin")},
    { "RFM_DESKTOP_RIGHT_MARGIN", "25", N_("Right margin")},
    { "RFM_DESKTOP_LEFT_MARGIN", "50", N_("Left Margin")},
   
    { "RFM_DESKTOP_DIR", NULL, N_("Desktop path:")},
    { "RFM_DESKTOP_IMAGE", PREFIX"/share/images/juchi-2007.jpg", N_("Background image")}, 
    { "RFM_DESKTOP_COLOR", "#4C1E0C", N_("Background color")}, 
    { "RFM_ICONVIEW_COLOR", "#383C3F", N_("Background color")},
    { "RFM_TRANSPARENCY", NULL, N_("Background transparency:")},
    ///// cp //////
    { "RFM_CP_A", NULL, "-a, --archive (-dR, --preserve=all)"}, 
    { "RFM_CP_RR", N_("Yes"), "-R, -r, --recursive"}, 
    { "RFM_CP_L", NULL, "-l, --link"},
    { "RFM_CP_LL", NULL, "-L, --dereference"}, 
    { "RFM_CP_N", NULL, "-n, --no-clobber"}, 
    { "RFM_CP_PP", N_("Yes"), "-P, --no-dereference"},
    { "RFM_CP_P", N_("Yes"), "-p, (--preserve=mode,ownership,timestamps)"}, 
#ifdef GNU_CP
    { "RFM_CP_X", NULL, "-x, --one-file-system"}, 
    { "RFM_CP_D", N_("Yes"), "-d, (--no-dereference --preserve=links)"},
    { "RFM_CP_S", NULL, "-s, --symbolic-link"}, 
    { "RFM_CP_B", N_("Yes"), "-b, (--backup)"},
    { "RFM_CP_U", NULL, "-u, --update"},
#endif
    { "RFM_CP_HH", NULL, "-H"},
    ////// mv ////////
#ifdef GNU_MV
    { "RFM_MV_B", N_("Yes"), "-b, (--backup)"},
    { "RFM_MV_U", NULL, "-u, --update"},
#endif
    { "RFM_MV_N", NULL, "-n, --no-clobber"},
    ////// ln ///////
    { "RFM_LN_S", N_("Yes"), "-s, --symbolic"},
#ifdef GNU_LN
    { "RFM_LN_B", N_("Yes"), "-b, (--backup)"},
    { "RFM_LN_L", NULL, "-L, --logical"},
    { "RFM_LN_P", NULL, "-P, --physical"},
#endif
    { "RFM_LN_N", NULL, "-n, --no-dereference"},
    ///// cp/mv/rm ////
#ifdef GNU_CP
    { "VERSION_CONTROL", "existing", "--backup="},
#endif
    { "RFM_CP_VERBOSE", NULL, N_("Verbose")}, // ok translation
    ////////////////////////////////////////
    ////// rm //////
    { "RFM_RM_VERBOSE", NULL, N_("Verbose")},
#ifdef GNU_RM
    { "RFM_RM_ONE_FILE_SYSTEM", N_("Yes"), "--one-file-system"},
#endif
    ////// shred ////
#ifdef GNU_SHRED
    // Truncate and remove file after overwriting
    { "RFM_SHRED_REMOVE", NULL, "-u, --remove"}, 
    // Add a final overwrite with zeros to hide shredding
    { "RFM_SHRED_ZERO", N_("Yes"), "-z, --zero"},
    // 
    { "RFM_SHRED_VERBOSE", NULL, N_("Verbose")},
    { "RFM_SHRED_ITERATIONS", NULL, "-n, --iterations="},
    // XXX (RFM_SHRED_ITERATIONS inactive yet)
#endif
    {"SMB_USER", NULL, "Samba default remote user"}, 
    // XXX (SMB_USER inactive yet)
    {"SUDO_ASKPASS", PREFIX"/bin/rodent-getpass", "Sudo ask password program"}, 
    {"SSH_ASKPASS", PREFIX"/bin/rodent-getpass", "Ssh ask passphrase program"}, 
    // XXX (inactive yet)

    {"RFM_PASTEBOARD_SERIAL", "0", "Pasteboard serial control"},
    // XXX needs translation fix... (inactive yet)
    {"RFM_BOOKMARK_SERIAL", "0", "Bookmark serial control"},
    /* Third party environment */
    { "PWD", NULL, "third party stuff"}, 
    /* Extra stuff, not in settings dialog checkboxes */
    {"RFM_MONITOR_ICON_THEME", "yes", "Monitor third party gtk icon theme"},

    { NULL, NULL, NULL}

};

const gchar *font_sizes_v[] = {
    "8",
    "9",
    "10",
    "11",
    "12",
    "14",
    NULL
};

const gchar *icon_sizes_v[] = {
    "Normal",
    "Details",
    "Compact",
    "Big",
    "Huge",
    NULL
};

const gchar *terminals_v[] = {
	"roxterm", 
	"sakura",
	"gnome-terminal", 
	"Eterm", 
	"konsole", 
	"Terminal", 
	"aterm", 
	"xterm", 
	"kterm", 
	"wterm", 
	"multi-aterm", 
	"evilvte",
	"mlterm",
	"xvt",
	"rxvt",
	"urxvt",
	"mrxvt",
	"tilda",
	NULL
};

const gchar *editors_v[] = {
	"gvim -f",  
	"mousepad", 
	"gedit", 
	"kate", 
	"xemacs", 
	"nano",
	"vi",
	"xterm -e nano",
	"xterm -e vi",
	NULL
};

# else
extern rfm_global_t *rfm_global_p;
extern environ_t environ_v[];
extern const gchar *terminals_v[];
extern const gchar *editors_v[];
extern const gchar *icon_sizes_v[];
extern const gchar *font_sizes_v[];
# endif

