/*
 * Edscott Wilson Garcia Copyright 2012
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifdef HAVE_CONFIG_H
# include <config.h>
#endif
#include "rodent_libs.h"
/* this should be first 2 lines after headers: */
G_MODULE_EXPORT LIBRFM_MODULE

#define MODULE_NAME "workgroup"
#define SUBMODULE_NAME "shares" 
#define MODULE_LABEL _("Windows workgroup")
#define MODULE_ICON_ID "xffm/status_network-transmit"

#define MODULE_ENTRY_TIP _("SMB workgroup")
#define PARENT_MODULE_NAME "smb"
#define MODULE_DATA_ID "smb_wg_data_p"

#include "module-skeleton.h"
// Skeleton definitions

G_MODULE_EXPORT RFM_MODULE_NAME
G_MODULE_EXPORT RFM_SUBMODULE_NAME
G_MODULE_EXPORT RFM_MODULE_LABEL
G_MODULE_EXPORT RFM_MODULE_ICON_ID
G_MODULE_EXPORT RFM_MODULE_ENTRY_TIP

G_MODULE_EXPORT RFM_MODULE_PREFERENCES_KEY("RODENT-WORKGROUP")
G_MODULE_EXPORT RFM_IS_ROOT_MODULE(FALSE)
G_MODULE_EXPORT RFM_PLUGIN_INFO(_("Windows workgroup"))
G_MODULE_EXPORT RFM_MODULE_ACTIVE(TRUE)
G_MODULE_EXPORT RFM_MODULE_MONITOR(TRUE)
G_MODULE_EXPORT RFM_IS_SELECTABLE(FALSE)

#include "passfile.i"
#include "samba-common.i"

// This is a hashtable-mutex combo for server netbios names. Data item
// is a GSList for server netbios names listed in the workgroup.
// The key to access each list is the netbios name of the workgroup
// master browser.
static GStaticMutex list_mutex = G_STATIC_MUTEX_INIT;


void *    
g_module_check_init (GModule * module) {
    BIND_TEXT_DOMAIN;
    return NULL;
}

// This is a thread function, must have GDK mutex set for gtk commands...
static void 
stdout_smb_wg (void *user_data, void *stream, int childFD){
// thread function
    widgets_t *widgets_p = user_data;
    view_t *view_p = widgets_p->view_p;
    char *line;
    line = (char *)stream;
    NOOP ("FORK stdout: %s\n", line);
    smb_data_t *smb_data_p = 
	g_object_get_data(G_OBJECT(view_p->widgets.paper), MODULE_DATA_ID); 
    const gchar *smb_server = g_object_get_data(G_OBJECT(view_p->widgets.paper), 
	    "smb_server");
    if (!smb_server) smb_server = g_object_get_data(G_OBJECT(view_p->widgets.window), 
	    "smb_server");
    gchar *server_list = g_strconcat(smb_server, "List", NULL);
    GSList **list_p = g_object_get_data(G_OBJECT(view_p->widgets.window), server_list );
    g_free(server_list);

    NOOP(stderr, "LOCK/LOCKOK for %s\n", smb_server);
    if (list_p == NULL){
	g_warning("list_p for %s is NULL. This should not happen\n", 
		smb_server);
    }

    if(line[0] == '\n') return;
    if (strstr (line, "NT_STATUS_LOGON_FAILURE") ||
        strstr (line, "NT_STATUS_UNSUCCESSFUL"))  {
      //  clear smb-user here.
	gchar *user = 
	    g_object_get_data(G_OBJECT(widgets_p->paper), 
	    "smb-user");  
	g_free(user);
	g_object_set_data(G_OBJECT(widgets_p->paper), 
		"smb-user", NULL);
GDK_THREADS_ENTER ();
      rfm_diagnostics (widgets_p,  "xffm_tag/stderr", line, "\n",NULL);
      rfm_diagnostics (widgets_p, "xffm/stock_dialog-error", NULL); 
      rfm_diagnostics (widgets_p, "xffm_tag/stderr", 
	      _("Temporary authentication failure"), "\n",NULL);
      rfm_diagnostics (widgets_p, NULL, 
	      "This probably means that your server requires you to specify the Windows domain name \nas part of your username (eg, quot;DOMAIN\\userquot;).\n\nOr you might have just typed your password wrong.",
	      "\n",NULL); 
GDK_THREADS_LEAVE ();
	return ;
    } 

    if(strncmp (line, "Tubo-id exit:", strlen ("Tubo-id exit:")) == 0) {
            if(strchr (line, '\n')) *strchr (line, '\n') = 0;
// debug:
	// get list
      GSList *list = (list_p)? *list_p : NULL;
GDK_THREADS_ENTER ();
      //rfm_diagnostics (widgets_p, "xffm_tag/command_id", "stdout_smb_wg DONE\n",NULL); 
      NOOP(stderr, "examining list at 0x%x\n", GPOINTER_TO_INT(list_p));

      for (;list && list->data; list = list->next){
            rfm_diagnostics (widgets_p, "xffm_tag/command_id", "list: ", 
		    (gchar *)list->data, "\n", NULL);
      }
GDK_THREADS_LEAVE ();


GDK_THREADS_ENTER ();
      rfm_diagnostics (widgets_p, "xffm/stock_stop", NULL);
      rfm_diagnostics (widgets_p, "xffm_tag/command_id", strchr (line, ':') + 1, ".", NULL);
      rfm_diagnostics (widgets_p, NULL, "\n", NULL);
GDK_THREADS_LEAVE ();
	g_mutex_lock(smb_data_p->mutex);
	smb_data_p->condition |= QUERY_DONE; 
	smb_data_p->condition |= RELOAD; 
	NOOP(stderr, "Now condition is set to 0x%x\n",
		smb_data_p->condition);
	g_cond_signal(smb_data_p->signal);
	g_mutex_unlock(smb_data_p->mutex);
    } else {
//#ifdef DEBUG
GDK_THREADS_ENTER ();
          rfm_diagnostics (widgets_p, NULL, line, NULL);
GDK_THREADS_LEAVE ();
//#endif
  if ( (strstr (line, "Workgroup") && strstr (line, "Master")) ||
       (strstr (line, "Sharename") && strstr (line, "Comment")) ) {
	g_mutex_lock(smb_data_p->mutex);
      smb_data_p->condition &= (PARSE ^ 0xffffffff);
	g_mutex_unlock(smb_data_p->mutex);

    return;
  }
  if (strstr (line, "Server") && strstr (line, "Comment"))  {
	g_mutex_lock(smb_data_p->mutex);
      smb_data_p->condition |= PARSE;
	g_mutex_unlock(smb_data_p->mutex);

    return ;
  }
  if (strstr (line, "--------")) return;
	g_mutex_lock(smb_data_p->mutex);
    gboolean parse = smb_data_p->condition & PARSE;
	g_mutex_unlock(smb_data_p->mutex);

  if (parse){
      g_strstrip(line);
      gchar *server;
      if (strchr(line, ' ')) *strchr(line, ' ') = 0;
      if (strchr(line, '\n')) *strchr(line, '\n') = 0;
      if (strchr(line, '\t')) *strchr(line, '\t') = 0;
      /* workaround IS~ stuff */
      if (strncmp(line,"IS~",strlen("IS~"))==0) server = line + strlen("IS~");
      else server = line;
      g_static_mutex_lock(&list_mutex);


      GSList *list = (list_p)? *list_p : NULL;
      gboolean found = FALSE;
      for (; list && list->data; list=list->next){
	  if (strcmp((gchar *)list->data, server)==0){
	      found = TRUE;
	      break;
	  }
      }
      if (!found) {
	NOOP(stderr, "adding %s to list 0x%x\n", server, GPOINTER_TO_INT(list_p));
	*list_p = g_slist_prepend(*list_p, g_strdup(server));
      }
      
      g_static_mutex_unlock(&list_mutex);
      
GDK_THREADS_ENTER ();
      rfm_diagnostics(widgets_p, "xffm_tag/red", _("Server:"), " ", NULL);
      rfm_diagnostics(widgets_p, "xffm_tag/green", server, "\n", NULL);
GDK_THREADS_LEAVE ();

  }


    }
    return;
}

// This is a thread function, must have GDK mutex set for gtk commands...
static void 
stderr_smb_wg (void *user_data, void *stream, int childFD){
// thread function
    widgets_t *widgets_p = user_data;
    char *line;
    line = (char *)stream;
    NOOP ("FORK stdout: %s\n", line);

    if(line[0] == '\n') return;

GDK_THREADS_ENTER ();
    rfm_diagnostics (widgets_p, "xffm/stock_dialog-error", NULL);
    rfm_diagnostics (widgets_p, "xffm_tag/stderr", line, NULL);
    rfm_diagnostics (widgets_p, NULL, "\n", NULL);
GDK_THREADS_LEAVE ();
    return;
}

// This is a thread function, must have GDK mutex set for gtk commands...
static
void
fork_finished_function (void *user_data) {
    widgets_t *safe_widgets_p = user_data;

    gchar *passfile = g_object_get_data(G_OBJECT(safe_widgets_p->paper), "passfile");
    g_object_set_data(G_OBJECT(safe_widgets_p->paper), "passfile", NULL);
    g_free(passfile);

    gchar *g = g_strdup_printf ("%d> (%d).", Tubo_id () - 1, getpid());
GDK_THREADS_ENTER ();
    if(rfm_diagnostics_is_visible (safe_widgets_p)) {
        rfm_diagnostics (safe_widgets_p, "xffm_tag/command_id", g, NULL);
        rfm_diagnostics (safe_widgets_p, "xffm/stock_no", "\n", NULL);
        GDK_THREADS_LEAVE ();
    }
GDK_THREADS_LEAVE ();
    g_free (g);
    g_free (safe_widgets_p);

}


static
void *
query_workgroup(void *data){
  void **p=data;
  widgets_t *widgets_p = p[0];
  gchar *server = p[1];
  gchar *passfile = p[2];



  gchar *argument[20];
  
  NOOP(stderr, "****** query workgroup\n");

  gint i=0;
  argument[i++]=  "smbclient";
  argument[i++]=  "-N";
  if (passfile) {
    argument[i++]=  "-A";
    argument[i++]=  passfile;
  } else {
      NOOP(stderr, "XXXX smb_data_p->authentication_file==NULL\n");
  }
  argument[i++]=  "-L";
  argument[i++]=  server;
  argument[i++]=  0;

GDK_THREADS_ENTER ();
  rfm_show_text(widgets_p);
  rfm_diagnostics (widgets_p, "xffm/status_network-transmit", NULL);
  for (i=0; argument[i]; i++) {
      rfm_diagnostics (widgets_p, "xffm_tag/command", " ", argument[i], NULL);
  }
  rfm_diagnostics (widgets_p, "xffm_tag/command","\n", NULL);
GDK_THREADS_LEAVE ();
 
  //rfm_thread_run_argv_with_stdout (widgets_p, argument, FALSE, stdout_smb_wg);
  rfm_thread_run_argv_full (widgets_p, argument, FALSE, NULL, stdout_smb_wg, stderr_smb_wg, fork_finished_function);
  if (passfile) {
    THREAD_CREATE(zap_passfile, g_strdup(passfile), "zap_passfile");
  }
  g_free(p);
  return NULL;

}


static 
void cache_xfdir_setup(xfdir_t *xfdir_p, smb_data_t *smb_data_p) {


    if (!smb_data_p){
	g_error("this is broken: smb_data_p==NULL\n");
    }
    view_t *view_p = smb_data_p->view_p;
	
    gchar *smb_server = g_object_get_data(G_OBJECT(view_p->widgets.paper), 
	    "smb_server");
    g_free(smb_server);
    smb_server = g_object_get_data(G_OBJECT(view_p->widgets.window), 
	    "smb_server");
    g_free(smb_server);

    smb_server = g_strdup(xfdir_p->en->path);
    g_object_set_data(G_OBJECT(view_p->widgets.paper), "smb_server", smb_server);
    g_object_set_data(G_OBJECT(view_p->widgets.window), "smb_server", g_strdup(smb_server));

       
    gchar *tag = g_object_get_data(G_OBJECT(view_p->widgets.paper), 
	    "tag");
    g_free(tag);
    tag = g_strdup(xfdir_p->en->tag);
    g_object_set_data(G_OBJECT(view_p->widgets.paper), "tag", tag);

    gchar *wg = g_object_get_data(G_OBJECT(view_p->widgets.paper), 
	    "smb_workgroup");
    g_free(wg);
    wg = g_object_get_data(G_OBJECT(view_p->widgets.window), 
	    "smb_workgroup");
    g_free(wg);

    if (xfdir_p->en->pseudo_path){
	wg = g_strdup(xfdir_p->en->pseudo_path);
    } else {
	g_warning("pseudo_path not set");
    }
    g_object_set_data(G_OBJECT(view_p->widgets.paper), "smb_workgroup", wg);
    g_object_set_data(G_OBJECT(view_p->widgets.window), "smb_workgroup", (wg)?
	    g_strdup(wg):NULL);
    
    // Server list shared across views.
    gchar *server_list = g_strconcat(smb_server, "List", NULL);
    GSList **list_p = g_object_get_data(G_OBJECT(view_p->widgets.window), server_list );
    if (list_p == NULL){
	list_p = (GSList **)malloc(sizeof(GSList *));
	if (!list_p) g_error("malloc: %s", strerror(errno));
	*list_p = NULL;
	NOOP(stderr, "New list for %s --> 0x%x\n",
		  smb_server, GPOINTER_TO_INT(list_p));
	g_object_set_data(G_OBJECT(view_p->widgets.window), server_list, list_p);
    } 
    g_free(server_list);

    g_static_mutex_lock(&list_mutex);
    gint load_count = (*list_p)?g_slist_length(*list_p):0;
    DBG("mastersip list length count load = %d\n", load_count);

    xfdir_p->pathc = load_count + 1;	
    xfdir_p->gl = (dir_t *)malloc(xfdir_p->pathc*sizeof(dir_t));
    if (!xfdir_p->gl) g_error("malloc: %s", strerror(errno));
    memset(xfdir_p->gl,0,xfdir_p->pathc*sizeof(dir_t));
    set_up_item(xfdir_p);
    if (load_count==0) {
	g_static_mutex_unlock(&list_mutex);
	return;
    }

    GSList *tmp = *list_p;
    gint i = 1;
    for (; tmp && tmp->data; tmp=tmp->next, i++){
	xfdir_p->gl[i].en=rfm_mk_entry(0);
	xfdir_p->gl[i].en->st = NULL;
	xfdir_p->gl[i].en->parent_module = MODULE_NAME;
	 xfdir_p->gl[i].en->module = "shares"; 
	
	// get share info from list data
	xfdir_p->gl[i].en->path= g_strdup((gchar *)tmp->data);
	xfdir_p->gl[i].en->tag = g_strdup_printf("%s //%s",
	    _("Server:"),(gchar *)tmp->data);
	xfdir_p->gl[i].pathv = g_strdup((gchar *)tmp->data);
	DBG("count adding %s\n", xfdir_p->gl[i].en->tag);
    }
    g_static_mutex_unlock(&list_mutex);
    return;
}

// gboolean
// This function fills in previously allocated xfdir_p
// with glob records and entries of the module population.
// Records which are filled in are:
// xfdir_p->pathc: Number of icons for Rodent to display
// xfdir_p->gl[0 ... pathc-1].pathv: Labels to display with each icon
// xfdir_p->gl[0 ... pathc-1].en: Record_entry_t of each icon 
// 				  (NULL entries will point to Rodent root) 
G_MODULE_EXPORT
void *
module_xfdir_get (void *p) {
    DBG("module_xfdir_get\n");
    view_t *view_p = ((xfdir_t *)p)->view_p;
    // Check whether necessary program is installed or not.
    if (!smb_check_program(&(view_p->widgets), "smbclient")) {
	return NULL;
    }

    smb_data_t *smb_data_p = 
	g_object_get_data(G_OBJECT(view_p->widgets.paper), MODULE_DATA_ID);

    if (!smb_data_p) {
	smb_data_p = (smb_data_t *)malloc(sizeof(smb_data_t));
	if (!smb_data_p) g_error("malloc: %s", strerror(errno));
        memset(smb_data_p, 0, sizeof(smb_data_t));	
	smb_data_p->mutex = g_mutex_new();
	smb_data_p->signal = g_cond_new();
    } 
    smb_data_p->xfdir_p = p;
    smb_data_p->view_p = smb_data_p->xfdir_p->view_p;
    g_object_set_data(G_OBJECT(view_p->widgets.paper), MODULE_DATA_ID, smb_data_p);
    
    NOOP(stderr, "THREAD 0x%x condition=0x%x\n",
		GPOINTER_TO_INT(g_thread_self()),
		smb_data_p->condition);
#if 0
    // check for list...
    gchar *server_list = g_strconcat(smb_data_p->xfdir_p->en->path, "List", NULL);
    GSList **list_p = g_object_get_data(G_OBJECT(view_p->widgets.window), server_list );
    g_free(server_list);
	g_mutex_lock(smb_data_p->mutex);
    if (list_p == NULL || *list_p == NULL) {
	// No cache list.
	smb_data_p->condition = 0;
    } else {
	smb_data_p->condition = QUERY_DONE|QUERY_LOADED;
    }
	g_mutex_unlock(smb_data_p->mutex);
#endif

    gboolean cache_load = TRUE;

    
    if (!(smb_data_p->condition & QUERY_DONE)) {
	// rodent reload thread enters here.
	// Set initial load items:
	xfdir_t *xfdir_p = smb_data_p->xfdir_p;

	cache_xfdir_setup(xfdir_p, smb_data_p);
	// Create passfile, either from memory data or dialogs
	passfile_double_click(&(view_p->widgets), view_p->en);
	gchar *passfile = g_object_get_data(G_OBJECT(view_p->widgets.paper),
		"passfile");

	NOOP(stderr, "THREAD 0x%x creating query_workgroup thread\n",
		GPOINTER_TO_INT(g_thread_self()));
	void **q=(void *)malloc(3*sizeof(void *));
	if (!q) g_error("malloc: %s", strerror(errno));
	q[0] = &(view_p->widgets);
	q[1] = xfdir_p->en->path;
	q[2] = passfile;
	THREAD_CREATE(query_workgroup, q, "query_workgroup");
	NOOP(stderr, "THREAD 0x%x return on !QUERY_DONE: QUERY_DONE=%d\n",
		GPOINTER_TO_INT(g_thread_self()),
		smb_data_p->condition);

	cache_load = FALSE;
	return xfdir_p;
    }
    // From here on down, the monitor thread is at work.
    // QUERY is DONE. Reload IPs.
    //
    if (smb_data_p->condition & RELOAD && 
	    !(smb_data_p->condition & QUERY_LOADED)) {
	NOOP(stderr, "1a. THREAD 0x%x will RELOAD, condition 0x%x \n",
		GPOINTER_TO_INT(g_thread_self()),
		smb_data_p->condition);
	xfdir_t *xfdir_p = smb_data_p->xfdir_p;
	cache_xfdir_setup(xfdir_p, smb_data_p);
	g_mutex_lock(smb_data_p->mutex);
	smb_data_p->condition |= QUERY_LOADED;
	g_mutex_unlock(smb_data_p->mutex);
	NOOP(stderr, "1b. THREAD 0x%x, RELOADED. condition set to 0x%x \n",
		GPOINTER_TO_INT(g_thread_self()),
		smb_data_p->condition);

	cache_load = FALSE;
	return xfdir_p;
    }
    NOOP(stderr, "2. THREAD 0x%x  condition 0x%x \n",
		GPOINTER_TO_INT(g_thread_self()),
		smb_data_p->condition);
    // QUERY is COMPLETE, RELOAD is still active for monitor thread.
    // 
    if (cache_load && (smb_data_p->condition & QUERY_LOADED) ) {
	NOOP(stderr, "THREAD 0x%x cache load\n",
		GPOINTER_TO_INT(g_thread_self()));
	xfdir_t *xfdir_p = smb_data_p->xfdir_p;
	cache_xfdir_setup(xfdir_p, smb_data_p);
    }
    // Monitor thread is of no more use.
    NOOP(stderr, "5. THREAD 0x%x  condition 0x%x \n",
		GPOINTER_TO_INT(g_thread_self()),
		smb_data_p->condition);
    g_mutex_lock(smb_data_p->mutex);
    smb_data_p->condition &= (RELOAD ^ 0xffffffff);
    smb_data_p->condition |= DELAY_MONITOR;
    g_mutex_unlock(smb_data_p->mutex);
    // This fouls up the reload menu action
    // since we rely on the monitor:
    // rfm_increment_monitor((xfdir_t *)p);
	NOOP(stderr, "return on RESOLVE_COMPLETE (2)\n");
    return p;
}

// const gchar * 
// This function returns a const pointer to the entry's icon
// identifier. 
// Parameter p is the item's entry pointer. 
// Identifier may be returned as a mimetype or an absolute path.
G_MODULE_EXPORT
void *
item_icon_id (void *p) {
    record_entry_t *en = p;
    if (!en) return "xffm/actions_log-out"; //error
    if (IS_UP_TYPE(en->type)) return "xffm/places_network-workgroup/composite3/stock_go-up";
    if (en->module && strcmp(en->module, "workgroup")==0 ){
	return "xffm/places_network-workgroup";
    }
    // shares
    return "xffm/places_network-server";
}

// gboolean
// This function informs Rodent by returning TRUE that the double click
// action will be processed by the module. If function returns FALSE
// (or is not defined in the module) then Rodent will attempt the default
// double click action.
// Parameter p is the view's widgets_p pointer.
// Parameter q is the icon's record entry.
G_MODULE_EXPORT
void *
double_click(void * p, void *q){
    passfile_double_click(p, q);
    return NULL;
}


G_MODULE_EXPORT 
void *
reload (void *p) {
    view_t *view_p = p;
    smb_data_t *smb_data_p = 
	g_object_get_data(G_OBJECT(view_p->widgets.paper), MODULE_DATA_ID);
    const gchar *smb_server = g_object_get_data(G_OBJECT(view_p->widgets.paper), 
	    "smb_server");
    if (!smb_server) smb_server = g_object_get_data(G_OBJECT(view_p->widgets.window), 
	    "smb_server");    
    if (!smb_server) return NULL;

    g_mutex_lock(smb_data_p->mutex);
    if (smb_data_p) smb_data_p->condition = 0;
    g_mutex_unlock(smb_data_p->mutex);
    gchar *server_list = g_strconcat(smb_server, "List", NULL);
      g_static_mutex_lock(&list_mutex);
    GSList **list_p = g_object_get_data(G_OBJECT(view_p->widgets.window), server_list );
    GSList *list= *list_p;
    for (; list && list->data; list=list->next){
	g_free(list->data);
    }
    g_slist_free(*list_p);
    g_object_set_data(G_OBJECT(view_p->widgets.window), server_list, NULL);
    g_free(server_list);
      g_static_mutex_unlock(&list_mutex);
    return NULL; 
}

