/*
 * Edscott Wilson Garcia Copyright 2012
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */



#ifdef HAVE_CONFIG_H
# include <config.h>
#endif
#include "rodent_libs.h"
/* this should be first 2 lines after headers: */
G_MODULE_EXPORT LIBRFM_MODULE

#define MODULE_NAME "smb"
#define SUBMODULE_NAME "workgroup"
//#define MODULE_LABEL _("Network domains")
#define MODULE_LABEL _("SMB Browser")
//#define MODULE_LABEL _("Nearby Computers")
#define MODULE_ICON_ID "xffm/places_network-workgroup/composite3/places_network-server"

#define MODULE_ENTRY_TIP _("SMB Browser")
#define PARENT_MODULE_NAME "cifs"
#define MODULE_DATA_ID "nmb_data_p"

#include "module-skeleton.h"
// Skeleton definitions

G_MODULE_EXPORT RFM_MODULE_NAME
G_MODULE_EXPORT RFM_SUBMODULE_NAME
G_MODULE_EXPORT RFM_MODULE_LABEL
G_MODULE_EXPORT RFM_MODULE_ICON_ID
G_MODULE_EXPORT RFM_MODULE_ENTRY_TIP

G_MODULE_EXPORT RFM_MODULE_PREFERENCES_KEY("RODENT-SAMBA")
G_MODULE_EXPORT RFM_IS_ROOT_MODULE(TRUE)
G_MODULE_EXPORT RFM_PLUGIN_INFO(_("SMB Browser"))
G_MODULE_EXPORT RFM_MODULE_ACTIVE(TRUE)
G_MODULE_EXPORT RFM_MODULE_MONITOR(TRUE)
G_MODULE_EXPORT RFM_IS_SELECTABLE(FALSE)


#include "passfile.i"
#include "samba-common.i"

// GSList-mutex combo for master browsers (IP records)
// These are shared across view, so that's why they are static global
static 
GSList *mastersIP = NULL;
static
GMutex *mastersIP_mutex = NULL;

static
GHashTable *master_hash = NULL;
static
GMutex *master_mutex = NULL;

static
GHashTable *workgroup_hash = NULL;
static
GMutex *workgroup_mutex = NULL;
#include "query_masters.i"
#include "resolve_masters.i"

void *    
g_module_check_init (GModule * module) {
    BIND_TEXT_DOMAIN;
    if (!mastersIP_mutex) mastersIP_mutex = g_mutex_new();
    if (!master_mutex) master_mutex = g_mutex_new();
    if (!workgroup_mutex) workgroup_mutex = g_mutex_new();
    return NULL;
}


// const gchar * 
// This function returns a const pointer to the entry's icon
// identifier. 
// Parameter p is the item's entry pointer. 
// Identifier may be returned as a mimetype or an absolute path.

// This routine solve for two icons, namely,
//   1. the plugin icon shown on rodent root (or fuse-module)
//   2. the up icon shown in modules contained by this module.
G_MODULE_EXPORT
void *
item_icon_id (void *p) {
    record_entry_t *en = p;
    if (!en) return NULL;
    if (IS_UP_TYPE(en->type)) return "xffm/places_network-workgroup/composite3/stock_go-up/places_network-server";
    return "xffm/places_network-workgroup/composite3/places_network-server";
}



static 
void cache_xfdir_setup(xfdir_t *xfdir_p, smb_data_t *smb_data_p) {

    // mastersIP list is shared across views.
    g_mutex_lock(mastersIP_mutex);
    gint load_count = (mastersIP)?g_slist_length(mastersIP):0;
    DBG("mastersip list length count load = %d\n", load_count);
    xfdir_p->pathc = load_count + 1;	
    xfdir_p->gl = (dir_t *)malloc(xfdir_p->pathc*sizeof(dir_t));
    if (!xfdir_p->gl) g_error("malloc: %s", strerror(errno));
    memset(xfdir_p->gl,0,xfdir_p->pathc*sizeof(dir_t));
    set_up_item(xfdir_p);
    if (load_count==0) {
	g_mutex_unlock(mastersIP_mutex);
	return;
    }

    GSList *tmp = mastersIP;
    gint i = 1;
    for (; tmp && tmp->data; tmp=tmp->next, i++){
	const gchar *ip = tmp->data;
	xfdir_p->gl[i].en=rfm_mk_entry(0);
	xfdir_p->gl[i].en->st = NULL;
	xfdir_p->gl[i].en->parent_module = MODULE_NAME;
	xfdir_p->gl[i].en->module = "workgroup";
	xfdir_p->gl[i].en->path = g_strdup(ip);  
    }
    g_mutex_unlock(mastersIP_mutex);

    for (i = 1; i < xfdir_p->pathc; i++){
	gchar *ip = xfdir_p->gl[i].en->path;
	const gchar *c = NULL;
	gchar *s = NULL;
	g_mutex_lock(master_mutex);
	if (master_hash) {
	    c = g_hash_table_lookup(master_hash, ip);
	    if (c) s = g_strdup(c);
	}
	g_mutex_unlock(master_mutex);

	gchar *wg = NULL;
	g_mutex_lock(workgroup_mutex);
	if (workgroup_hash) {
	    c = g_hash_table_lookup(workgroup_hash, ip);
	    if (c) wg = g_strdup(c);
	}
	g_mutex_unlock(workgroup_mutex);

	// Replace ip for netbios name, if netbios name is resolved:
	if (s) xfdir_p->gl[i].en->path = s;  


	xfdir_p->gl[i].en->tag = g_strdup_printf("%s %s (%s)",
		_("Workgroup:"),
		(wg)?wg:_("Unresolved alias"), ip);
	xfdir_p->gl[i].en->pseudo_path = g_strdup((wg)?wg:ip);

	if (s && wg) {
	    xfdir_p->gl[i].pathv = g_strdup_printf("%s (@%s)",
		wg, s);
	} else {
	    xfdir_p->gl[i].pathv = g_strdup_printf("%s %s",
		_("Workgroup:"),(wg)?wg:ip);
	}
	g_free(wg);
	// If netbios name is resolved, we no longer have any use for ip
	if (s) g_free(ip);
	NOOP(stderr, "+*+*+*+*+*+*+* %s\n", xfdir_p->gl[i].en->tag);
    } 
     
	
    set_up_item(xfdir_p);
    return;
}

// gboolean
// This function fills in previously allocated xfdir_p
// with glob records and entries of the module population.
// Records which are filled in are:
// xfdir_p->pathc: Number of icons for Rodent to display
// xfdir_p->gl[0 ... pathc-1].pathv: Labels to display with each icon
// xfdir_p->gl[0 ... pathc-1].en: Record_entry_t of each icon 
// 				  (NULL entries will point to Rodent root) 
//
// SMB Browser: This is a thread based background reload. This is done this 
// 	        way because the SMB queries are wall clock expensive. Thus,
// 	        to keep the user's eye busy, the actual load is done by the
// 	        background monitor.
//
G_MODULE_EXPORT
void *
module_xfdir_get (void *p) {
    DBG("module_xfdir_get\n");
    view_t *view_p = ((xfdir_t *)p)->view_p;
    if (!view_p || view_p->flags.status == STATUS_EXIT) return NULL;
    // Check whether necessary program is installed or not.
    if (!smb_check_program(&(view_p->widgets), "nmblookup")) {
	xfdir_exit_monitor(view_p);
	return NULL;
    }

    smb_data_t *smb_data_p = 
	g_object_get_data(G_OBJECT(view_p->widgets.paper), MODULE_DATA_ID);

    if (!smb_data_p) {
	smb_data_p = (smb_data_t *)malloc(sizeof(smb_data_t));
	if (!smb_data_p) g_error("malloc: %s", strerror(errno));
        memset(smb_data_p, 0, sizeof(smb_data_t));	
	smb_data_p->mutex = g_mutex_new();
	smb_data_p->signal = g_cond_new();
    } 
    smb_data_p->xfdir_p = p;
    smb_data_p->view_p = smb_data_p->xfdir_p->view_p;
    g_object_set_data(G_OBJECT(view_p->widgets.paper), MODULE_DATA_ID, smb_data_p);
    
    DBG( "THREAD 0x%x condition=0x%x\n",
		GPOINTER_TO_INT(g_thread_self()),
		smb_data_p->condition);


#if 10
    gboolean cache_load = TRUE;
    if (!(smb_data_p->condition & QUERY_DONE)) {
	// rodent reload thread enters here.
	// Set initial load items:
	//xfdir_t *xfdir_p = get_new_xfdir_p(smb_data_p->xfdir_p);
	xfdir_t *xfdir_p = smb_data_p->xfdir_p;

	cache_xfdir_setup(xfdir_p, smb_data_p);
	if (!(smb_data_p->condition & QUERY_ACTIVE)) {
	    g_mutex_lock(smb_data_p->mutex);
	    smb_data_p->condition |= QUERY_ACTIVE;
	    g_mutex_unlock(smb_data_p->mutex);
	    TRACE( "THREAD 0x%x creating query_masters thread\n",
		    GPOINTER_TO_INT(g_thread_self()));
	    THREAD_CREATE(query_masters, smb_data_p, "query_masters");
	    TRACE( "THREAD 0x%x return on !QUERY_DONE: QUERY_DONE=%d\n",
		GPOINTER_TO_INT(g_thread_self()),
		smb_data_p->condition);
	    
	}

	cache_load = FALSE;
	return xfdir_p;
    }

    // From here on down, the monitor thread is at work.
    // QUERY is DONE. Reload IPs.
    //
    if (smb_data_p->condition & RELOAD && 
	    !(smb_data_p->condition & QUERY_LOADED)) {
	NOOP( "1a. THREAD 0x%x will RELOAD, condition 0x%x \n",
		GPOINTER_TO_INT(g_thread_self()),
		smb_data_p->condition);
	xfdir_t *xfdir_p = smb_data_p->xfdir_p;
	//xfdir_t *xfdir_p = get_new_xfdir_p(smb_data_p->xfdir_p);
	//xfdir_t *xfdir_p = p;	
	cache_xfdir_setup(xfdir_p, smb_data_p);
	g_mutex_lock(smb_data_p->mutex);
	smb_data_p->condition |= QUERY_LOADED;
	g_mutex_unlock(smb_data_p->mutex);
	NOOP( "1b. THREAD 0x%x, RELOADED. condition set to 0x%x \n",
		GPOINTER_TO_INT(g_thread_self()),
		smb_data_p->condition);

	cache_load = FALSE;
	return xfdir_p;
    }

    NOOP( "2. THREAD 0x%x  condition 0x%x \n",
		GPOINTER_TO_INT(g_thread_self()),
		smb_data_p->condition);
   // QUERY is COMPLETE, RELOAD is still active for monitor thread.
    //
    // Monitor thread is of no more use.
    // rfm_increment_monitor((xfdir_t *)p);
    // return p;
    //
    //
    //     step 2, RESOLVE. The difference here is that the
    //     monitor thread will do the initial load thread
    //     creation...
    //
    //
    if (!(smb_data_p->condition & RESOLVE_DONE)
	    && !(smb_data_p->condition & RESOLVE_ACTIVE)) {
	xfdir_t *xfdir_p = smb_data_p->xfdir_p;
	cache_xfdir_setup(xfdir_p, smb_data_p);
	NOOP( "3a. THREAD 0x%x  condition 0x%x \n",
		GPOINTER_TO_INT(g_thread_self()),
		smb_data_p->condition);
	// Here we just fire up the RESOLVE thread
	// We do not send the monitor into wait state
	// because we *are* the monitor thread.
	if (!(smb_data_p->condition & RESOLVE_ACTIVE)){
	    g_mutex_lock(smb_data_p->mutex);
	    smb_data_p->condition |= RESOLVE_ACTIVE;
	    //smb_data_p->condition = smb_data_p->condition & (RELOAD ^ 0xffffffff);
	    g_mutex_unlock(smb_data_p->mutex);
	    // setup and start resolve thread:
	    NMBmastersResolve (smb_data_p);
	    NOOP( "3b. resolve thread now started....  condition 0x%x\n",
		    smb_data_p->condition);
	}
	cache_load = FALSE;
	return xfdir_p;
    }

    // RESOLVE is DONE 
    //
   NOOP( "4a. THREAD 0x%x  condition 0x%x \n",
		GPOINTER_TO_INT(g_thread_self()),
		smb_data_p->condition);
   if ((smb_data_p->condition & RELOAD) && 
	(smb_data_p->condition & RESOLVE_DONE) &&
	!(smb_data_p->condition & RESOLVE_LOADED)) {
	NOOP( "4b. THREAD 0x%x  condition 0x%x \n",
		GPOINTER_TO_INT(g_thread_self()),
		smb_data_p->condition);
	xfdir_t *xfdir_p = smb_data_p->xfdir_p;
	cache_xfdir_setup(xfdir_p, smb_data_p);
	g_mutex_lock(smb_data_p->mutex);
	smb_data_p->condition |= RESOLVE_LOADED;
	g_mutex_unlock(smb_data_p->mutex);
	NOOP( "return on !RESOLVE_COMPLETE\n");
	cache_load = FALSE;
	return xfdir_p;
    }
    // RESOLVE is COMPLETE
    // 
    if (cache_load && (smb_data_p->condition & QUERY_LOADED)
	    && 
	  (smb_data_p->condition & RESOLVE_LOADED)  ) {
	NOOP( "5a. THREAD 0x%x cache load. Condition=0x%x\n",
		GPOINTER_TO_INT(g_thread_self()),smb_data_p->condition);
	xfdir_t *xfdir_p = smb_data_p->xfdir_p;
	cache_xfdir_setup(xfdir_p, smb_data_p);
    }

    // Monitor thread is of no more use. (until a reload, of course)
    NOOP( "5b. THREAD 0x%x  condition 0x%x \n",
		GPOINTER_TO_INT(g_thread_self()),
		smb_data_p->condition);
    g_mutex_lock(smb_data_p->mutex);
    smb_data_p->condition &= (RELOAD ^ 0xffffffff);
    smb_data_p->condition |= DELAY_MONITOR;

    g_mutex_unlock(smb_data_p->mutex);
	NOOP( "return on RESOLVE_COMPLETE (2)\n");
    return p;
#endif
}


// gboolean
// This function informs Rodent by returning TRUE that the double click
// action will be processed by the module. If function returns FALSE
// (or is not defined in the module) then Rodent will attempt the default
// double click action.
// Parameter p is the view's widgets_p pointer.
// Parameter q is the icon's record entry.
G_MODULE_EXPORT
void *
double_click(void * p, void *q){
    passfile_double_click(p, q);
    return NULL;
}


G_MODULE_EXPORT 
void *
reload (void *p) {
#if 0
    // FIXME: reload is borked...
    view_t *view_p = p;
    smb_data_t *smb_data_p = 
	g_object_get_data(G_OBJECT(view_p->widgets.paper), MODULE_DATA_ID);
    
    g_mutex_lock(mastersIP_mutex);
    GSList *list= mastersIP;
    for (; list && list->data; list=list->next){
	g_free(list->data);
    }
    g_slist_free(mastersIP);
    mastersIP = NULL;
    g_mutex_unlock(mastersIP_mutex);

    g_mutex_lock(smb_data_p->mutex);
    if (smb_data_p) smb_data_p->condition = RELOAD;
    g_mutex_unlock(smb_data_p->mutex);
#endif
    return NULL; 
}

