/*
 * Edscott Wilson Garcia Copyright 2011
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
// This is a thread function, must have GDK mutex set for gtk commands...
static void 
stdout_nmb_ip (void *user_data, void *stream, int childFD){
// thread function
    widgets_t *widgets_p = user_data;
    view_t *view_p = widgets_p->view_p;
    smb_data_t *smb_data_p = 
	g_object_get_data(G_OBJECT(view_p->widgets.paper), MODULE_DATA_ID);

    char *line;
    line = (char *)stream;
    NOOP ("FORK stdout: %s\n", line);

    if(line[0] == '\n')
        return;

    if(strncmp (line, "Tubo-id exit:", strlen ("Tubo-id exit:")) == 0) {
            if(strchr (line, '\n')) *strchr (line, '\n') = 0;

GDK_THREADS_ENTER ();
            rfm_diagnostics (widgets_p, "xffm/stock_stop", NULL);
            rfm_diagnostics (widgets_p, "xffm_tag/command_id", strchr (line, ':') + 1, ".", NULL);
            rfm_diagnostics (widgets_p, NULL, "\n", NULL);
GDK_THREADS_LEAVE ();
        if (mastersIP == NULL) {
GDK_THREADS_ENTER ();
            rfm_diagnostics (widgets_p, "xffm/stock_dialog-error", NULL);
            rfm_diagnostics (widgets_p, "xffm_tag/stderr", "Is NMB daemon active?", NULL);
	    rfm_diagnostics (widgets_p, "xffm_tag/green"," ", "(maybe: /etc/init.d/samba start)", "\n", NULL);
	    rfm_diagnostics (widgets_p, "xffm_tag/blue", "Queries performed with nmblookup will be send to the given broadcast address. Without this option the default behavior is to send the queries to the broadcast address of the network interface that was either auto-detected or defined in the \"interfaces\" parameter of the smb.conf file.", "\n", NULL);
GDK_THREADS_LEAVE ();
	} else {
	    g_mutex_lock(smb_data_p->mutex);
	    smb_data_p->condition |= QUERY_DONE; 
	    smb_data_p->condition |= RELOAD; 
	    DBG( "Now condition is set to 0x%x\n",
		    smb_data_p->condition);
	    g_cond_signal(smb_data_p->signal);
	    g_mutex_unlock(smb_data_p->mutex);
	}
    
    } else {
GDK_THREADS_ENTER ();
          rfm_diagnostics (widgets_p, NULL, line, NULL);
GDK_THREADS_LEAVE ();
	if (strstr (line, "__MSBROWSE__") && strstr (line, "<01>")) {
	  gchar *buffer = g_strdup(line);
	  if (strchr(buffer,' ')) {
	      *strchr(buffer,' ') = 0;
GDK_THREADS_ENTER ();
	      rfm_diagnostics(widgets_p, "xffm_tag/red", _("Found:"), " ", NULL);
	      rfm_diagnostics(widgets_p, "xffm_tag/green", buffer, "\n", NULL);
GDK_THREADS_LEAVE ();
	      g_mutex_lock(mastersIP_mutex);
	      GSList *tmp = mastersIP;
	      gboolean found = FALSE;
	      for (; tmp && tmp->data; tmp=tmp->next){
		  if (strcmp(buffer, (gchar *)tmp->data)==0) {
		      found = TRUE;
		      break;
		  }
	      }
	      if (!found) {
		  mastersIP = 
		    g_slist_prepend(mastersIP, g_strdup(buffer));
	      }
	      g_mutex_unlock(mastersIP_mutex);
	  } 
	  g_free(buffer);

	}
    }
    return;
}

static
void *
query_masters(void *data){
    smb_data_t *smb_data_p = data;
#if 0
  // If we want to reload, we just clear the list...
	      g_mutex_lock(mastersIP_mutex);
  if (mastersIP) {
      g_slist_free(mastersIP);
      mastersIP = NULL;
  }
	      g_mutex_unlock(mastersIP_mutex);
#endif

/*  gboolean query_done = FALSE;
  g_mutex_lock(mastersIP_mutex);
  if (mastersIP && g_slist_length(mastersIP)!=0){
      query_done = TRUE;
  }
  g_mutex_unlock(mastersIP_mutex);
    
  if (query_done) {
      g_mutex_lock(plugin_data_mutex);
      smb_data_p->condition |= QUERY_IPS_DONE;
      g_mutex_unlock(plugin_data_mutex);
      return NULL;
  }*/
	      

  gchar *argument[5];
  argument[0]=  "nmblookup";
  argument[1]=  "-M";
  argument[2]=  "--";
  argument[3]=  "-";
  argument[4]=  0;

  widgets_t *widgets_p = &(smb_data_p->view_p->widgets);
GDK_THREADS_ENTER ();
  rfm_show_text(widgets_p);
#ifdef DEBUG
  rfm_diagnostics(widgets_p, NULL, "Looking for master browsers...\n", NULL); 
#endif

  rfm_diagnostics (widgets_p, "xffm/status_network-transmit", NULL);
  rfm_diagnostics (widgets_p, "xffm_tag/command", " nmblookup -M -- -\n", NULL);
GDK_THREADS_LEAVE ();

  rfm_thread_run_argv_with_stdout (widgets_p, argument, FALSE, stdout_nmb_ip);
  
  return NULL;

}

