//
//

/********/
#define MNTTYPE_PROCFS	"proc"
#define MNTTYPE_SMBFS	"smbfs"
#define MNTTYPE_DEV	"devpts"
#define MNTTYPE_SHM	"tmpfs"
#define	MNTTYPE_CDFS	"iso9660"
#define MNTTYPE_SWAP	"swap"
#define MNTTYPE_NFS	"nfs"

#define MNTTYPE_CACHEFS	"cachefs"       // proc
#define MNTTYPE_HSFS	"hsfs"  // proc

#define MNTTYPE_CODAFS	"coda"  //nfs
#define MNTTYPE_CDFS_AIX "cdrfs"        /* AIX */
#define MNTTYPE_KERNFS	"kernfs"        // proc
#define MNTTYPE_MFS	"mfs"   //proc

static void *private_is_mounted (void *p);
static gboolean is_user_type (const gchar * mnt_point);
static void * fstab_is_in_fstab (void *p);

static int
get_fstab_type (const char *type) {

    if(strstr (type, MNTTYPE_NFS)) {
        TRACE ("    got %s type for fstab item %s\n", MNTTYPE_NFS, type);
        return __NFS_TYPE;
    } else if(strstr (type, MNTTYPE_SMBFS)) {
        TRACE ("    got %s type for fstab item %s\n", MNTTYPE_SMBFS, type);
        return __SMB_TYPE;
    } else if(strstr (type, MNTTYPE_PROCFS)) {
        TRACE ("    got %s type for fstab item %s\n", MNTTYPE_PROCFS, type);
        return __PROC_TYPE;
    } else if(strstr (type, MNTTYPE_DEV)) {
        TRACE ("    got %s type for fstab item %s\n", MNTTYPE_DEV, type);
        return __PROC_TYPE;
    } else if(strstr (type, MNTTYPE_SHM)) {
        TRACE ("    got %s type for fstab item %s\n", MNTTYPE_SHM, type);
        return __PROC_TYPE;
    } else if(strstr (type, MNTTYPE_CDFS)) {
        TRACE ("    got %s type for fstab item%s\n", MNTTYPE_CDFS, type);
        return __CDFS_TYPE;
    } else if(strstr (type, MNTTYPE_CDFS_AIX))
        return __CDFS_TYPE;
    else if(strstr (type, MNTTYPE_CACHEFS))
        return __PROC_TYPE;
    else if(strstr (type, MNTTYPE_HSFS))
        return __PROC_TYPE;
    else if(strstr (type, MNTTYPE_KERNFS))
        return __PROC_TYPE;
    else if(strstr (type, MNTTYPE_MFS))
        return __PROC_TYPE;
    else if(strstr (type, MNTTYPE_MFS))
        return __NFS_TYPE;

    return 1;
}

///////////   common code:

static void *
fstab_do_properties (void *p, void *q) {
    
    widgets_t *widgets_p = p;
    if (!q){
	g_warning("!q");
	return NULL;
    }
    GList * select_list=q;
    TRACE("do_prop\n");
    
    record_entry_t *en = select_list->data;

    
    if(IS_PARTITION_TYPE (en->type)) {
        gchar *sudo = g_find_program_in_path ("sudo");
        if(!sudo){
	    g_warning("sudo command not found");
            goto done;
	}
        g_free (sudo);

        gchar *device = g_strdup (en->path);
	TRACE("*device = %s", device);
        while(strlen (device) && isdigit (device[strlen (device) - 1])) {
            device[strlen (device) - 1] = 0;
	    TRACE("device => %s", device);
        }
        gchar *argv[] = { "sudo", "-A", "fdisk", "-l", device, NULL };
	TRACE("%s -A fdisk -l %s", sudo, device);
	rfm_show_text (widgets_p);

        rfm_thread_run_argv (widgets_p, argv, FALSE);
        g_free (device);
        goto done;
    } else {
	TRACE("IS_PARTITION_TYPE (en->type) == FALSE\n");
        return NULL;
    }
done:

    return GINT_TO_POINTER (1);
}

static void *
fstab_hide_local_menu_items (void *p, void *q) {
    record_entry_t *en = q;
    widgets_t *widgets_p = p;
    view_t *view_p=widgets_p->view_p;
    if(!q)
        return NULL;

    // nothing selected:
    gchar *symbols_null[] = {
        "paste_menuitem",
        NULL
    };

    /*gchar *symbols[] = { "copy_menuitem", "cut_menuitem",
       "rename_menuitem", "duplicate_menuitem", "touch_menuitem",
       "symlink_menuitem", "remove_menuitem","autotype_Prun",
       "file_separator",    "ejecutar1",  "ejecutar2", "ejecutar3",
       "ejecutar4", "ejecutar5", "ejecutar6", "ejecutar7",
       "ejecutar8", "ejecutar9", "ejecutar10",
       "file_separator2", "navigation_separator",  "view_separator",
       "file_separator",
       NULL
       };  */
    gchar *symbols[] = {
        "cut_menuitem",
        "rename_menuitem",
        "autotype_Prun",
        "paste_menuitem",
        NULL
    };

    gchar *symbols_partition[] = {
        "open_with_menuitem",
        "copy_menuitem",
        "duplicate_menuitem",
        "symlink_menuitem",
        "touch_menuitem",
        "navigation_separator",
        "view_separator", "file_separator2",
        //"properties2",
        NULL
    };
    gchar *symbols_multiple_select[] = {
        "copy_menuitem",
        "remove_menuitem",
        "properties2", "find2",
        "open_with_menuitem",
        "ejecutar1", "ejecutar2", "ejecutar3",
        "ejecutar4", "ejecutar5", "ejecutar6", "ejecutar7",
        "ejecutar8", "ejecutar9", "ejecutar10",
        "file_separator2", "navigation_separator", "view_separator",
        "file_separator",

        NULL
    };
/*    gchar *symbols_mixed[] = { 
	"copy_menuitem",
	"remove_menuitem",
	NULL
    };*/

    gchar *symbols_dir[] = {
        "module1_menu",
        NULL
    };

    gchar **pp;
    if(!p) {
        for(pp = symbols_null; *pp; pp++) {
            HIDE_IT (widgets_p->paper, *pp);
        }
        return NULL;
    }

    for(pp = symbols; *pp; pp++) {
        HIDE_IT (widgets_p->paper, *pp);
    }
    for(pp = symbols_partition; *pp; pp++) {
        if(IS_PARTITION_TYPE (en->type)) {
            HIDE_IT (widgets_p->paper, *pp);
        }
    }
    for(pp = symbols_dir; *pp; pp++) {
        if(!IS_PARTITION_TYPE (en->type)) {
            HIDE_IT (widgets_p->paper, *pp);
        }
    }
    if(g_slist_length (view_p->selection_list) > 1) {
        for(pp = symbols_multiple_select; *pp; pp++) {
            HIDE_IT (widgets_p->paper, *pp);
        }
    }
    return GINT_TO_POINTER (1);
}

static gchar *
get_mnt_point(widgets_t *widgets_p, record_entry_t *en) {
        gchar *f = g_build_filename (MOUNT_DBH_FILE, NULL);
        gchar *device = g_path_get_basename (en->path);
        gchar *default_mount;
        if( en->tag && g_path_is_absolute (en->tag)){
            default_mount = g_strdup (en->tag);
	} else {
	    const gchar *user = getenv("USER");
	    if (!user) user="rodent";
            default_mount = g_build_filename (g_get_tmp_dir (), user, "mnt", device, NULL);
	}

	gchar *real_default = realpath(default_mount, NULL);
	if (real_default) {
	    if (strcmp(real_default, default_mount)==0){
		g_free(real_default);
	    } else {
		g_free(default_mount);
		default_mount = real_default;
	    }
	}


        g_free (device);
	gchar *extra_text = g_strdup_printf(_("Edit mount point for %s"), en->path);
        const gchar *g = rodent_get_response_history (widgets_p, _("Select mount point"),
						_("Mount Point"), 
						extra_text,
						f,
                                                NULL,
                                                default_mount,
                                                NULL, NULL,
                                                GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER,
                                                "/",
						MATCH_FILE);
	g_free(extra_text);
        g_free (default_mount);
        g_free (f);
        if(g == NULL) {
            return NULL;
        }
        if(g_mkdir_with_parents (g, 0700) < 0) {
	    rfm_show_text(widgets_p);
            rfm_diagnostics (widgets_p, "xffm/stock_dialog-error",  NULL);
            rfm_diagnostics (widgets_p, "xffm_tag/stderr", "mkdir(", g, "): ",strerror (errno), "\n", NULL);
            return NULL;
        }
	// is mount point already mounted?
	if (private_is_mounted((void *)g)){
	    rfm_show_text(widgets_p);
            rfm_diagnostics (widgets_p, "xffm/stock_dialog-error", NULL);
            rfm_diagnostics (widgets_p, "xffm_tag/stderr", g, ": ", _("Unable to mount location"), " (", _("address already in use"), ")", "\n", NULL);
            return NULL;
	}

        return g_strdup(g);

}

#ifdef THIS_IS_LINUX
static gchar *types[]={ "auto", "adfs",  "affs",  "autofs",  "cifs",  "coda",  
	"cramfs", "debugfs", "devpts", "efs", "ext", "ext2", "ext3", "ext4",
        "hfs", "hfsplus", "hpfs", "iso9660", "jfs", "minix", "msdos", "ncpfs",
        "nfs", "nfs4", "ntfs", "ntfs3g", "proc", "qnx4", "ramfs", "reiserfs",
        "romfs", "squashfs",  "smbfs",  "sysv",  "tmpfs",  "ubifs", "udf", 
        "ufs", "umsdos", "usbfs", "vfat", "xfs", "xiafs", NULL};
#else
static gchar *types[]={"auto", "cd9660", "mfs", "msdosfs",
       	"nfs", "ntfs", "nwfs", "nullfs", "oldnfs", "portalfs",
        "smbfs", "udf", "unionfs", NULL};
#endif

static gchar *
get_mnt_type(widgets_t * widgets_p, gchar *mnt_device){
    gchar *title_txt = g_strdup_printf("%s %s", _("Mount"), mnt_device);
    gchar *type = rodent_get_radio_response (widgets_p, title_txt, _("Type"), types);
    g_free(title_txt);
    NOOP(stderr, "selected type is %s\n", type);

    return type;
}

#ifndef THIS_IS_LINUX
static GStaticMutex mntmutex = G_STATIC_MUTEX_INIT;
static gchar *
get_bsd_partition(const gchar *p){
    gchar *mnt_point = realpath((gchar *)p, NULL);
    if (!mnt_point) return NULL;

    g_static_mutex_lock(&mntmutex);
    struct statfs *mnt_buf;
    size_t mnt_items = getmntinfo(&mnt_buf, MNT_NOWAIT);

    gint i=0;
    gchar *mnt_partition = NULL;
    for (;i<mnt_items; i++){
        if(strcmp (mnt_point, (mnt_buf+i)->f_mntonname) == 0 ||
           strcmp (mnt_point, (mnt_buf+i)->f_mntfromname) == 0) {
	    mnt_partition = g_strdup((mnt_buf+i)->f_mntfromname);
	    break;
	}
    }
    g_static_mutex_unlock(&mntmutex);
    g_free(mnt_point);
    return mnt_partition;
}
#endif

static void *
private_fstab_mount (widgets_t *widgets_p, record_entry_t *en) {
    gchar *argument[MAX_COMMAND_ARGS];
    gchar **ap;
    gchar *umount = "umount";
    gchar *mount = "mount";
    gchar *mnt_src = NULL;
    gchar *mnt_tgt = NULL;

    SETWD();

    if(!widgets_p) return NULL;

    if(!en) return NULL;

    mnt_src = realpath(en->path, NULL);
    if (!mnt_src) mnt_src = g_strdup (en->path);
    mnt_tgt = NULL;

    // user option check for mount point
    // this is necesary for mount/umount command outside of
    // the fstab module directory
    if(is_user_type (mnt_src)) {
        SET_USER_TYPE (en->type);
    }

    gchar *options = NULL;
    gchar *mount_type = NULL;
    if(IS_PARTITION_TYPE (en->type) && private_is_mounted ((void *)mnt_src) == NULL && !IS_USER_TYPE (en->type)) {
	mount_type = get_mnt_type (widgets_p, mnt_src);
	if (!mount_type) {
	    return NULL; // cancel from mount type dialog.
	}
#ifdef THIS_IS_LINUX
	if (strcmp(mount_type, "vfat")==0)
	    options = g_strdup_printf ("uid=%d", geteuid ());
#else
	if (strcmp(mount_type, "msdosfs")==0)
	    options = g_strdup_printf ("-m=644,-M=755");
#endif
	if (strcmp(mount_type, "auto")==0){
	    g_free(mount_type);
	    mount_type = NULL;
	}

	mnt_tgt=get_mnt_point(widgets_p, en);
	if (mnt_tgt == NULL) {
            g_free (mnt_src);
            return NULL;
	}
        //options = get_mnt_type (widgets_p, mnt_src);
    } // end of partition type condition.

    // isofs:
    if (is_iso_image(en)) {
	mnt_tgt=get_mnt_point(widgets_p, en);
	if (mnt_tgt == NULL) {
            g_free (mnt_src);
            return NULL;
	}
	options = g_strdup("loop");
    }
    TRACE ("MOUNT: mnt_src=%s mnt_tgt=%s\n", mnt_src, mnt_tgt);

    ap = argument;

    // Sudo check...
    // 
    // BSD not necessary if vfs.usermount?
#ifdef THIS_IS_LINUX
    gboolean use_sudo = TRUE;
#else
    int old_p=0;
    gboolean use_sudo = FALSE;
    size_t size=sizeof(int);

    if (sysctlbyname("vfs.usermount", &old_p, &size, NULL, 0) < 0){
	NOOP(stderr, "use_sudo: failed command: sysctlbyname(\"vfs.usermount\"\n");
	// Check access privileges to device
	use_sudo = TRUE;
    } else {
	if (old_p != 1){
	    NOOP(stderr, "use_sudo: old_p != 1\n");
	    rfm_diagnostics(widgets_p, "xffm/stock_dialog-warning", NULL);
	    rfm_diagnostics(widgets_p, "xffm_tag/stderr", "sysctl vfs.usermount=0", "\n", NULL);
	    rfm_diagnostics(widgets_p, "xffm/stock_help", NULL);
	    rfm_diagnostics(widgets_p, "xffm_tag/green", 
			_("Use sysctl or add this line to \"/etc/sysctl.conf\":"),"\n", NULL);
	    rfm_diagnostics(widgets_p, "xffm_tag/magenta", 
		    "   ","vfs.usermount=1","\n", NULL);
	    rfm_diagnostics(widgets_p, "xffm/stock_dialog-info", NULL);
	    rfm_diagnostics(widgets_p, "xffm_tag/stderr", _("Using sudo"), "...", "\n", NULL);

	   use_sudo = TRUE;
	} else {
	    struct stat st;
	    // get mount partition.
	    gchar *mnt_partition = get_bsd_partition(mnt_src);
	    stat((mnt_partition)?mnt_partition:mnt_src, &st);
	    if (!(st.st_mode & S_IWGRP)){
		rfm_diagnostics(widgets_p, "xffm/stock_dialog-warning", NULL);
		rfm_diagnostics(widgets_p, "xffm_tag/stderr", _("No write access to "),
			mnt_src, "\n", NULL);
		rfm_diagnostics(widgets_p, "xffm/stock_help", NULL);
		rfm_diagnostics(widgets_p, "xffm_tag/green", 
			_("Add these lines to /etc/devfs.rules:"),"\n", NULL);
		rfm_diagnostics(widgets_p, "xffm_tag/magenta", 
			"[localrules=5]","\n", NULL);
		rfm_diagnostics(widgets_p, "xffm_tag/magenta", 
			_("add path 'da*' mode 0660 group operator"),"\n", NULL);
		rfm_diagnostics(widgets_p, "xffm/stock_help", NULL);
		rfm_diagnostics(widgets_p, "xffm_tag/green", 
			_("Add this line to /etc/rc.conf:"),"\n", NULL);
		rfm_diagnostics(widgets_p, "xffm_tag/magenta", 
			"   ","devfs_system_ruleset=\"localrules\"","\n", NULL);
		rfm_diagnostics(widgets_p, "xffm/stock_dialog-info", NULL);
		rfm_diagnostics(widgets_p, "xffm_tag/stderr", _("Using sudo"), "...", "\n", NULL);
		DBG("No write access to %s\n",mnt_src);
		NOOP(stderr, "use_sudo: No write access to %s\n",mnt_src);
		use_sudo = TRUE;
	    }
	}
    }

#endif
    // not for root
    if(!getuid ()){
        use_sudo = FALSE;
    }
    // not for general user mounts
    else if(IS_USER_TYPE (en->type) && fstab_is_in_fstab(en->path)){
        use_sudo = FALSE;
    }
    // sudo not installed
    else {
        char *p = g_find_program_in_path ("sudo");
        if(p == NULL) {
            use_sudo = FALSE;
            rfm_diagnostics (widgets_p, "xffm/stock_dialog-warning", strerror (ENOENT), ": sudo", "\n", NULL);
        } else {
            g_free (p);
        }
    }

    if(use_sudo) {
        *ap++ = "sudo";
        *ap++ = "-A";
    }


#if 10
    if(private_is_mounted ((void *)mnt_src)) {
        *ap++ = umount;
    } else {
        *ap++ = mount;
	// Here we set the mounted type. This remains set until
	// monitor unsets it along with the greenball...
	SET_MOUNTED_TYPE(en->type);
	if (mount_type) {
            *ap++ = "-t";
            *ap++ = mount_type;

	}
        if(options) {
            *ap++ = "-o";
            *ap++ = options;
        }
    }
    memset(en->st, 0, sizeof(struct stat));

    *ap++ = (gchar *) mnt_src;
    if(mnt_tgt) {
        *ap++ = mnt_tgt;
    }
    *ap++ = NULL;
#if 0
    TRACE ("MOUNT:");
    rfm_diagnostics (widgets_p, "xffm/stock_dialog-info", NULL);
    int i;
    for(i = 0; argument[i]; i++) {
        TRACE (" %s", argument[i]);
        if(strstr (argument[i], "username="))
            rfm_diagnostics (widgets_p, NULL, " username=*****", NULL);
        else
            rfm_diagnostics (widgets_p, NULL, " ", argument[i], NULL);
    }
    TRACE ("\n");
    rfm_diagnostics (widgets_p, NULL, "\n", NULL);
#endif

#endif

    rfm_cursor_wait (widgets_p->window);
    rfm_thread_run_argv (widgets_p, argument, FALSE);
    rfm_cursor_reset (widgets_p->window);
    //g_free (bash_command);



    TRACE ("fstab_mount %s done ", mnt_src);
    g_free (mnt_src);
    g_free (mnt_tgt);
    g_free (options);
    g_free (mount_type);
    return GINT_TO_POINTER (1);
}

static void *
fstab_double_click (void *p, void *q) {
    record_entry_t *en = (record_entry_t *) q;
    widgets_t *widgets_p = (widgets_t *) p;
    if(IS_PARTITION_TYPE (en->type)) {
        private_fstab_mount (widgets_p, en);
        return GINT_TO_POINTER (1);
    }
    return NULL;
}


static void *
fstab_module_stat (void *p, void *q) {
    TRACE("fstab_module_stat now, p=%s q=0x%x\n", (gchar *)p, GPOINTER_TO_INT(q));
    const gchar *path = p;
    // if p is NULL, then the function checks the top level stat file
    // and extra fstab file. (two files, yes)
    if(path == NULL && q != NULL) {
	struct stat st[2];
	if(stat ("/etc/fstab", st) < 0) {
	    g_warning ("stat(%s): %s", "/etc/fstab", strerror (errno));
	    return NULL;
	}
	if(stat ("/etc/mtab", st+1) < 0) {
	    g_warning ("stat(%s): %s", "/etc/mtab", strerror (errno));
	    return NULL;
	}
	st->st_mtime += (st+1)->st_mtime;
	st->st_ctime += (st+1)->st_ctime;
	st->st_size += (st+1)->st_size;
	st->st_mode += (st+1)->st_mode;
	st->st_nlink += (st+1)->st_nlink;
	st->st_uid += (st+1)->st_uid;
	st->st_gid += (st+1)->st_gid;
	memcpy(q, st, sizeof(struct stat));
	return GINT_TO_POINTER (1);
    } else if (path == NULL) {
	path="/etc/mtab";
    }
    struct stat st_v;
    struct stat *st = q;
    // if q is NULL, then the function just checks if the stat is possible.
    if(st == NULL) {
        st = &st_v;
    }
    if(!rfm_g_file_test (path, G_FILE_TEST_EXISTS)){
	// this happens when usb item is unplugged, so
	// it merits not a warning....
	// g_warning("%s does not exist", path);
        return NULL;
    }
    // XXX blocks:
    if(stat (path, st) < 0) {
        g_warning ("stat(%s): %s", path, strerror (errno));
        return NULL;
    }
    return GINT_TO_POINTER (1);
}

static gint 
malloc_items(xfdir_t *xfdir_p, gint count){
    gint first = 1;
    /* up item: */
    xfdir_p->pathc = count + first;
    /* fuse item: */
    if (rfm_void(PLUGIN_DIR, "fuse", "module_active")){
	xfdir_p->pathc++;
	first++;
    }

    xfdir_p->gl = (dir_t *) malloc (xfdir_p->pathc * sizeof (dir_t));
    if (!xfdir_p->gl) g_error("malloc: %s\n", strerror(errno));
    memset (xfdir_p->gl, 0, xfdir_p->pathc * sizeof (dir_t));
    
    xfdir_p->gl[0].en = NULL;
    xfdir_p->gl[0].pathv = g_strdup (g_get_host_name ());
    if (rfm_void(PLUGIN_DIR, "fuse", "module_active")){
	xfdir_p->gl[1].en=rfm_mk_entry(0);
	xfdir_p->gl[1].en->st = NULL;
	xfdir_p->gl[1].en->parent_module = MODULE_NAME;
	xfdir_p->gl[1].en->module = "fuse";
	gchar *g = rfm_void(PLUGIN_DIR, "fuse", "module_label");
	if (!g) g=g_strdup_printf("FIXME: no module label for \"%s\"", "fuse");
	xfdir_p->gl[1].en->path=g;
	xfdir_p->gl[1].pathv = g_strdup(g);
	// Up icon qualifier (for special icon treatment)
	// SET_UP_TYPE (xfdir_p->gl[1].en->type);
	// Dummy type qualifier (for paper placement at 0,0 treatment)
	SET_DUMMY_TYPE (xfdir_p->gl[1].en->type);
    }
    return first;
}
#if 0

void *
is_mounted_with_timeout (gchar *path) {
    return private_is_mounted(path);
}

#else

// XXX does not do the trick if running under gdb:
// The thread exit will be held back by blockage, 
// and the holding back of the exit will block the main thread...

typedef struct heartbeat_t{
    gboolean condition;
    GMutex *mutex;
    GCond *signal;
    GThread *thread;
    gchar *path;
} heartbeat_t;

static void *
heartbeat_is_mounted(gpointer data){
    heartbeat_t *heartbeat_p = data;

    // This function call may block
    void *retval = private_is_mounted(heartbeat_p->path);
    
 	    
    g_mutex_lock(heartbeat_p->mutex);
    heartbeat_p->condition = TRUE;
    g_cond_signal(heartbeat_p->signal);
    g_mutex_unlock(heartbeat_p->mutex);
    return retval;

}

static 
void *wait_on_thread(gpointer data){
    heartbeat_t *heartbeat_p = data;
    void *value = g_thread_join(heartbeat_p->thread);

    g_mutex_free(heartbeat_p->mutex);
    g_cond_free(heartbeat_p->signal);
    g_free (heartbeat_p->path);
    g_free (heartbeat_p);
    return value;
}



G_MODULE_EXPORT
void *
is_mounted_with_timeout (gchar *path) {
    heartbeat_t *heartbeat_p = (heartbeat_t *)malloc(sizeof(heartbeat_t));
    if (!heartbeat_p) g_error("malloc heartbeat_p: %s\n",strerror(errno));
    memset(heartbeat_p, 0, sizeof(heartbeat_t));

    heartbeat_p->mutex = g_mutex_new();
    heartbeat_p->signal = g_cond_new();
    heartbeat_p->condition = 0;
    heartbeat_p->path = g_strdup(path);

    g_mutex_lock(heartbeat_p->mutex);
    TRACE("Creating thread with wait for heartbeat_is_mounted: %s\n",
	    path);
    heartbeat_p->thread =
	g_thread_create(heartbeat_is_mounted, heartbeat_p, TRUE, NULL);
    if (!heartbeat_p->condition) {
	gint load_timeout = 1;

#if GLIB_MAJOR_VERSION==2 && GTK_MINOR_VERSION<32
	GTimeVal tv;
	g_get_current_time (&tv);
	tv.tv_sec += load_timeout;
	if (!g_cond_timed_wait(heartbeat_p->signal, heartbeat_p->mutex, &tv))
#else
	gint64 end_time;
	end_time = g_get_monotonic_time () + load_timeout * G_TIME_SPAN_SECOND;
	if (!g_cond_wait_until (heartbeat_p->signal, heartbeat_p->mutex, end_time))
#endif
	{
	    g_mutex_unlock(heartbeat_p->mutex);
	    DBG("dead heartbeat: is_mounted\n");
	    // Dead heartbeat:
	    // Fire off a wait and cleanup thread.
	    THREAD_CREATE(wait_on_thread, heartbeat_p, "wait_on_thread");
	    DBG("dead heartbeat: returning NULL\n");
	    return NULL;
	}
    }
    g_mutex_unlock(heartbeat_p->mutex);
    return (wait_on_thread(heartbeat_p));
}

#endif

