//
//

#include <fstab.h>
#include <sys/param.h>
#include <sys/ucred.h>
#include <sys/mount.h>

static GStaticMutex fsmutex = G_STATIC_MUTEX_INIT;
static GMutex *infomutex=NULL;


static void *
private_is_mounted (void *p) {
    if(!p) {
        g_warning ("fstab.i:private_is_mounted() mnt_point != NULL not met!");
        return NULL;
    }
    gchar *mnt_partition = get_bsd_partition(p);
    if (mnt_partition){
	g_free(mnt_partition);
	return GINT_TO_POINTER(TRUE);
    }
    return NULL;

}
	    

static gboolean
is_user_type (const gchar * mnt_point) {
    return FALSE;
}

static gboolean
include_in_xfdir (struct fstab *fs) {
    if(strcmp (MNTTYPE_SWAP, fs->fs_vfstype) == 0)
        return FALSE;
    if(!rfm_g_file_test (fs->fs_file, G_FILE_TEST_IS_DIR))
        return FALSE;
    return TRUE;
}

static void
set_fs_type(record_entry_t *en, const gchar *fs_vfstype){
    SET_FSTAB_TYPE (en->type);
    if(strcmp (MNTTYPE_CDFS, fs_vfstype) == 0) SET_CDFS_TYPE (en->type);
    else if(strcmp (MNTTYPE_CODAFS, fs_vfstype) == 0) SET_NFS_TYPE (en->type);
    else if(strcmp (MNTTYPE_KERNFS, fs_vfstype) == 0) SET_PROC_TYPE (en->type);
    else if(strcmp (MNTTYPE_MFS, fs_vfstype) == 0) SET_PROC_TYPE (en->type);
    else if(strcmp (MNTTYPE_NFS, fs_vfstype) == 0) SET_NFS_TYPE (en->type);
    else if(strcmp (MNTTYPE_PROCFS, fs_vfstype) == 0) SET_PROC_TYPE (en->type);
    else if(strcmp (MNTTYPE_SMBFS, fs_vfstype) == 0) SET_SMB_TYPE (en->type);
    return;
}

static GSList *
elements_list (void) {
    GSList *list=NULL;
    g_static_mutex_lock(&fsmutex);
    if(!setfsent ()) {
	g_static_mutex_unlock(&fsmutex);
	return (0);
    }
    struct fstab *fs;
    int i;
    for(i = 0, fs = getfsent (); fs != NULL; fs = getfsent ()) {
        if(!include_in_xfdir (fs)) continue;
	record_entry_t *en = rfm_stat_entry(fs->fs_file, 0);
	set_fs_type(en, fs->fs_vfstype);
	list = g_slist_prepend(list, en); 
        i++;
    }
    endfsent ();
    g_static_mutex_unlock(&fsmutex);
    if (!infomutex) infomutex = g_mutex_new();
    g_mutex_lock(infomutex);
    struct statfs *mntbuf;
    gint count = getmntinfo(&mntbuf,  MNT_NOWAIT);
    if (count){
	gint j;
	for (j=0; j<count; j++){
	    GSList *tmp;
	    for (tmp=list; tmp && tmp->data; tmp = tmp->next){
		record_entry_t *en = tmp->data;
		if (strcmp(en->path, (mntbuf+j)->f_mntonname)==0) break;
	    }
	    if (!tmp) {
		record_entry_t *en = rfm_stat_entry((mntbuf+j)->f_mntonname, 0);
		set_fs_type(en, (mntbuf+j)-> f_fstypename);
		list=g_slist_prepend(list, en);
	    }
	}
    }
    g_mutex_unlock(infomutex);
    return list;
}

static GSList *
partitions_list (void) {
    GSList *list=NULL;
    g_static_mutex_lock(&fsmutex);

    NOOP(stderr, "count partitions...\n");
    DIR *directory;
    struct dirent *d;
    directory = opendir ("/dev");
    if(!directory){
	DBG("cannot open /dev for read...\n");
        return 0;
    }
    while((d = readdir (directory)) != NULL) {
        if( strncmp (d->d_name, "da", strlen("da")) &&
	    strncmp (d->d_name, "ad", strlen("ad"))) continue;
        if(!strchr (d->d_name, 's') && !strchr (d->d_name, 'p')) continue;
	NOOP(stderr, "gotcha: %s\n", d->d_name);
	gchar *device = g_strdup_printf("/dev/%s", d->d_name);
	record_entry_t *en = rfm_stat_entry(device, 0);
	g_free(device);
	SET_PARTITION_TYPE(en->type);
	SET_SBLK(en->type);
        en->mimetype = g_strdup ("xffm/stock_harddisk");// hack
	list = g_slist_prepend(list, en); 

    }
    closedir (directory);
    
    g_static_mutex_unlock(&fsmutex);

    return list;
}


static void
clear_slist(GSList **list_p){
    GSList *tmp;
    for (tmp=*list_p; tmp && tmp->data; tmp = tmp->next){
	record_entry_t *en = tmp->data;
	NOOP(stderr, "clearing item: %s\n", en->path);
	rfm_destroy_entry(en);
    }
    g_slist_free(*list_p);
    return;
}

static gint
count_elements (void) {
    GSList *list = elements_list();
    gint count = g_slist_length(list);
    clear_slist(&list);
    return count;
}

static int
count_partitions (void) {
    NOOP(stderr, "count partitions...\n");
    GSList *list = partitions_list();
    gint count = g_slist_length(list);
    clear_slist(&list);
    return count;
}

static gchar *
fstab_get_mnt_dir (gchar * mnt_fsname) {
    struct fstab *fs;
    g_static_mutex_lock(&fsmutex);

    if(!setfsent ()) {
	g_static_mutex_unlock(&fsmutex);
	return (0);
    }

    gchar *mnt_dir = NULL;
    for(fs = getfsent (); fs != NULL; fs = getfsent ()) {
        if(!include_in_xfdir (fs))
            continue;

        if(strcmp (mnt_fsname, fs->fs_spec) == 0) {
            //if(strcmp (mnt_fsname, mnt_struct->mnt_fsname) == 0) {
            // hit: multiple entries use first listed 
            // user types have preference and use last listed 
            if(strstr (fs->fs_mntops, "user")) {
                g_free (mnt_dir);
                mnt_dir = g_strdup (fs->fs_file);
            }
            if(!mnt_dir) {
                mnt_dir = g_strdup (fs->fs_file);
            }
        }
    }

    endfsent ();
    g_static_mutex_unlock(&fsmutex);
    return mnt_dir;
}

static  gchar *
fstab_get_mnt_fsname (gchar * mnt_dir) {
    struct fstab *fs;
    g_static_mutex_lock(&fsmutex);

    if(!setfsent ()) {
	g_static_mutex_unlock(&fsmutex);
	return (0);
    }


    gchar *mnt_fsname = NULL;

    for(fs = getfsent (); fs != NULL; fs = getfsent ()) {
        if(!include_in_xfdir (fs))
            continue;
        if(strcmp (mnt_dir, fs->fs_file) == 0) {
            //if(strcmp (mnt_dir, mnt_struct->mnt_dir) == 0) {
            // hit: multiple entries use first listed 
            // user types have preference and use last listed 
            if(strstr (fs->fs_mntops, "user")) {
                g_free (mnt_fsname);
                mnt_fsname = g_strdup (fs->fs_spec);
            }
            if(!mnt_fsname) {
                mnt_fsname = g_strdup (fs->fs_spec);
            }
        }
    }
    endfsent ();
    g_static_mutex_unlock(&fsmutex);
    return mnt_fsname;
}

//BSD

static xfdir_t *
private_get_xfdir (xfdir_t * xfdir_p) {
    struct fstab *fs;

    GSList *list = elements_list ();
    gint elements = g_slist_length(list);
    GSList *p_list = partitions_list ();
    gint partitions = g_slist_length(p_list);

 
    gint first = malloc_items(xfdir_p, elements+partitions);
    // g_error taken care of within function.
    GSList *tmp=list;

    gint i;
    for(i = first; tmp && tmp->data; tmp=tmp->next) {
	record_entry_t *en = tmp->data;
	xfdir_p->gl[i].en = en;
        xfdir_p->gl[i].pathv = g_strdup (en->path);
        TRACE ("fstab: %d --> %s\n", i, fs_file);
        i++;
    }
    tmp=p_list;
    for(; tmp && tmp->data; tmp=tmp->next) {
	record_entry_t *en = tmp->data;
	xfdir_p->gl[i].en = en;
        xfdir_p->gl[i].pathv = g_strdup (en->path);
        TRACE ("fstab: %d --> %s\n", i, fs_file);
        i++;
    }

    g_slist_free(list);
    g_slist_free(p_list);
    return (xfdir_p);
}

static void *
fstab_is_in_fstab (void *p) {
    int result = 0;
    struct fstab *fs;
    const gchar *path = (const gchar *)p;
    g_static_mutex_lock(&fsmutex);

    if(!setfsent ()) {
	g_static_mutex_unlock(&fsmutex);
	return (0);
    }


    for(fs = getfsent (); fs != NULL; fs = getfsent ()) {
        if(strcmp (MNTTYPE_SWAP, fs->fs_vfstype) == 0)
            continue;
        if(!rfm_g_file_test (fs->fs_file, G_FILE_TEST_IS_DIR))
            continue;

        if(strcmp (path, fs->fs_file) == 0) {
            if(strcmp (MNTTYPE_CDFS, fs->fs_vfstype) == 0)
                result = __CDFS_TYPE;
            else if(strcmp (MNTTYPE_CODAFS, fs->fs_vfstype) == 0)
                result = __NFS_TYPE;
            else if(strcmp (MNTTYPE_KERNFS, fs->fs_vfstype) == 0)
                result = __PROC_TYPE;
            else if(strcmp (MNTTYPE_MFS, fs->fs_vfstype) == 0)
                result = __PROC_TYPE;
            else if(strcmp (MNTTYPE_NFS, fs->fs_vfstype) == 0)
                result = __NFS_TYPE;
            else if(strcmp (MNTTYPE_PROCFS, fs->fs_vfstype) == 0)
                result = __PROC_TYPE;
            else if(strcmp (MNTTYPE_SMBFS, fs->fs_vfstype) == 0)
                result = __SMB_TYPE;
            else
                result = -1;
            break;
        }
    }
    endfsent ();
    g_static_mutex_unlock(&fsmutex);
    return GINT_TO_POINTER (result);
}


static gchar *
fstab_df (void) {
    gchar *df_string = NULL;
    int line_count = 0;
    char line[2048];
    FILE *pipe;
    memset ((void *)line, 0, 2048);
    gchar *command = g_find_program_in_path ("df");
    pipe = popen (command, "r");
    g_free (command);
    if(!pipe) {
        g_warning ("unable to pipe df");
        return "";
    }
    while(fgets (line, 2047, pipe) && !feof (pipe)) {
        line_count++;
/*	if (df_string) df_string=g_strconcat(df_string,line,NULL);
	else df_string=g_strdup(line);*/
    }
    pclose (pipe);
    df_string = g_strdup_printf ("line_count=%d", line_count);
    TRACE ("DF: %s\n", df_string);
    return df_string;
}


static void *
fstab_entry_tip (void *p) {
    record_entry_t *en = (record_entry_t *) p;
    if(!en) return NULL;
    gchar *mnt_point = realpath(en->path, NULL);
    if (!mnt_point) return NULL;
    
    


    g_static_mutex_lock(&mntmutex);
    struct statfs *mnt_buf;
    size_t mnt_items = getmntinfo(&mnt_buf, MNT_NOWAIT);

    gchar *mnt_to=NULL;
    gchar *mnt_from=NULL;
    gint item=-1;
    gint i=0;
    for (;i<mnt_items; i++){
	NOOP(stderr, "%s == %s or %s\n", mnt_point,
	    (mnt_buf+i)->f_mntonname, (mnt_buf+i)->f_mntfromname);
    
        if(strcmp (mnt_point, (mnt_buf+i)->f_mntonname) == 0 ||
           strcmp (mnt_point, (mnt_buf+i)->f_mntfromname) == 0) {
	    NOOP(stderr, "match\n");
	    mnt_to = g_strdup((mnt_buf+i)->f_mntonname);
	    mnt_from = g_strdup((mnt_buf+i)->f_mntfromname);
	    item = i;
	    break;
	}
    }
    g_static_mutex_unlock(&mntmutex);
    NOOP(stderr, "item = %d\n", item);
    if (item < 0){
	return mnt_point;
    }
    
    gchar *text = g_strdup_printf("%s%s \n%s%s\n",
	    _("Mount point: "), mnt_to?mnt_to:"none",
	    _("Mount device: "), mnt_from?mnt_from:"none");
    g_free(mnt_point);
    g_free(mnt_to);
    g_free(mnt_from);
#if 0
    {
	struct passwd *pwd = getpwuid((mnt_buf+item)->f_owner);

	text = g_strdup_printf(
	    "%s%s \n%s%s\n%s%s\n%s%s \n%s%d\n%s%d\n%s%d",
	    _("Mounted by: "), pwd->pw_name,
	    //_("Filesystem id: "),  (gint)((mnt_buf+i)->f_fsid),

	    _("Filesystem type: "), (mnt_buf+item)->f_fstypename,
	    _("Mount point: "), (mnt_buf+item)->f_mntonname,
	    _("Mount device: "), (mnt_buf+item)->f_mntfromname,

	    _("Free blocks: "), (mnt_buf+item)->f_bfree,
	    _("Available blocks: "), (mnt_buf+item)->f_bavail,
	    _("Maximum filename length: "), (mnt_buf+item)->f_namemax
	    );

    }
#endif
    return (void *) text;
}


