//
//
// obex submodule option dialog window y anexas.
/*
 * Edscott Wilson Garcia Copyright 2012
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


typedef struct hci_fork_t{
    GtkWidget *dialog;
    widgets_t *widgets_p;
    GSList *list[2];
    GtkWidget *comboentry[2];
}hci_fork_t;
static void
mount_url (widgets_t *widgets_p, const gchar *url);

// thread function
static void
operate_stdout (void *user_data, void *stream, int childFD) {
    hci_fork_t *hci_fork_p = user_data;
    if (hci_fork_p->dialog ==NULL) {
	NOOP(stderr, "hci_fork_p->dialog ==NULL\n");
	return;
    }
    widgets_t *widgets_p = hci_fork_p->widgets_p;
    char *line;
    line = (char *)stream;
    NOOP ("FORK stdout: %s\n", line);

    if(line[0] == '\n')
        return;
    NOOP(stderr, "line=%s\n", line);


    if(strncmp (line, "Tubo-id exit:", strlen ("Tubo-id exit:")) == 0) {
            if(strchr (line, '\n')) *strchr (line, '\n') = 0;
GDK_THREADS_ENTER ();
            rfm_diagnostics (widgets_p, "xffm/stock_stop", NULL);
            rfm_diagnostics (widgets_p, "xffm_tag/command_id", strchr (line, ':') + 1, ".", NULL);
            rfm_diagnostics (widgets_p, NULL, "\n", NULL);
GDK_THREADS_LEAVE ();
    } else {
GDK_THREADS_ENTER ();
        rfm_diagnostics (widgets_p, NULL, line, NULL);
        if(strncmp (line, "Scanning", strlen("Scanning"))!=0){
	    if (strchr(line, ':') && strchr(line, '\t')){
		gchar **a = rfm_split(line, '\t');
		gint i;
		for (i=0;i<2;i++){
		    g_strstrip(a[i]);
		    hci_fork_p->list[i] = 
			g_slist_prepend(hci_fork_p->list[i], g_strdup(a[i]));
		}
		g_free(a);
	    }
        }

GDK_THREADS_LEAVE ();
    }
    return;
}
// thread function
static void
operate_stderr (void *user_data, void *stream, int childFD) {
    hci_fork_t *hci_fork_p = user_data;
    if (hci_fork_p->dialog ==NULL) return;
    widgets_t *widgets_p = hci_fork_p->widgets_p;
    char *line;
    line = (char *)stream;
    NOOP ("FORK stdout: %s\n", line);

    if(line[0] == '\n')
        return;


    if(strncmp (line, "Tubo-id exit:", strlen ("Tubo-id exit:")) == 0) {
            if(strchr (line, '\n')) *strchr (line, '\n') = 0;
GDK_THREADS_ENTER ();
            rfm_diagnostics (widgets_p, "xffm/stock_stop", NULL);
            rfm_diagnostics (widgets_p, "xffm_tag/command_id", strchr (line, ':') + 1, ".", NULL);
            rfm_diagnostics (widgets_p, NULL, "\n", NULL);
GDK_THREADS_LEAVE ();
    } else {
GDK_THREADS_ENTER ();
        rfm_diagnostics (widgets_p, NULL, line, NULL);
GDK_THREADS_LEAVE ();
    }
    return;
}


static
void
fork_finished_function (void *user_data) {
    // Valid widget test.
    hci_fork_t *hci_fork_p = user_data;
    if (hci_fork_p->dialog !=NULL){
GDK_THREADS_ENTER ();
	rfm_cursor_reset(hci_fork_p->dialog);
	gtk_widget_set_sensitive(hci_fork_p->dialog, TRUE);
GDK_THREADS_LEAVE ();
    }
#if 10
    gint i;
GDK_THREADS_ENTER ();
    for (i=0;i<2;i++){
    
	GSList *list = hci_fork_p->list[i];
	GtkWidget *comboentry = hci_fork_p->comboentry[i];
	if (list == NULL){
	    gchar *text = g_strdup_printf("<b>%s\n</b>\n<i>%s\n</i>",
		    _("could not find the Bluetooth device."), _("Turn Bluetooth On"));
	    rfm_confirm(hci_fork_p->widgets_p, GTK_MESSAGE_ERROR, text, NULL, NULL);
	    g_free(text);
	    GtkWidget *box = g_object_get_data(G_OBJECT(hci_fork_p->dialog), "OBEX_PIN_BOX");
	    gtk_widget_set_sensitive(box, FALSE);
	    break;
	} else {
	DBG("MAC = %s\n", (gchar *)list->data);
	    GSList *tmp=list;
	    for (; tmp && tmp->data; tmp= tmp->next){
		DBG("prepend MAC = %s\n", (gchar *)tmp->data);
#if GTK_MAJOR_VERSION==2 && GTK_MINOR_VERSION<24
		gtk_combo_box_prepend_text(GTK_COMBO_BOX(comboentry),
			(gchar *)tmp->data); 
#else
		gtk_combo_box_text_prepend_text(GTK_COMBO_BOX_TEXT(comboentry),
			(gchar *)tmp->data); 
#endif
		g_free(tmp->data);
	    }
	    g_slist_free(list);
	    gtk_combo_box_set_active (GTK_COMBO_BOX(comboentry), 0);
	    GtkWidget *box = g_object_get_data(G_OBJECT(hci_fork_p->dialog), "OBEX_PIN_BOX");
	    gtk_widget_set_sensitive(box, TRUE);
	    gtk_widget_set_sensitive(hci_fork_p->comboentry[i], TRUE);
	}
    }
    rfm_diagnostics(hci_fork_p->widgets_p, "xffm/status_bluetooth-active",NULL);
    rfm_diagnostics(hci_fork_p->widgets_p, "xffm_tag/blue",_("Operation finished."), "\n",NULL);
GDK_THREADS_LEAVE ();
#endif
    g_free(hci_fork_p);
}


static GMutex *fork_mutex=NULL;
static void
fork_function (void *data) {
    gchar **argv = (char **)data;

    gint i = 0;
    static gchar *sudo_cmd=NULL;
    if (!fork_mutex) fork_mutex=g_mutex_new();
    g_mutex_lock(fork_mutex);
    g_free(sudo_cmd);
    sudo_cmd=NULL;
    for(i=0; argv && argv[i]; i++) {
	if(!sudo_cmd && (strstr (argv[i], "sudo"))) {
	    sudo_cmd=g_strdup_printf("<b>%s</b>",_("Command:"));
	} 	
	if (sudo_cmd){
	    if (strchr(argv[i], '&')){
	        gchar **a = g_strsplit(argv[i], "&", -1);
		gchar **p=a;
		for (;p && *p; p++){
		    gchar *space = (strlen(*p))?" ":"";
		    gchar *amp = (*(p+1))?"&amp;":"";
		    gchar *g = g_strconcat(sudo_cmd,  space, "<i>",*p, amp, "</i>", NULL);
		    g_free(sudo_cmd);
		    sudo_cmd=g;
		}
		g_strfreev(a);
	    } else {
		gchar *g = g_strconcat(sudo_cmd,  " <i>",argv[i], "</i>", NULL);
		g_free(sudo_cmd);
		sudo_cmd=g;
	    }
	}
    }


    if (i>=MAX_COMMAND_ARGS - 1) {
    	NOOP(stderr,"%s: (> %d)\n", strerror(E2BIG), MAX_COMMAND_ARGS);
	argv[MAX_COMMAND_ARGS - 1]=NULL;
    }

    if (sudo_cmd) {
	gchar *g = g_strconcat(sudo_cmd,  "\n", NULL);
	g_free(sudo_cmd);
	sudo_cmd = g;
	setenv("RFM_SUDO_COMMAND", sudo_cmd, 1);
    }
    g_mutex_unlock(fork_mutex);
    NOOP (stderr, "fork_function...%s %s\n", argv[0], argv[1]);
    execvp (argv[0], argv);
    g_warning ("CHILD could not execvp: this should not happen\n");
    g_warning("Do you have %s in your path?\n", argv[0]);
    rfm_threadwait ();
    _exit (123);
}


static void
get_hci_scan(GtkButton * button, gpointer data){
    widgets_t *widgets_p = g_object_get_data(G_OBJECT(button), "widgets_p");
    GtkWidget *dialog = g_object_get_data(G_OBJECT(button), "dialog");
    if (!FUSE_check_program(widgets_p, "hcitool")){
	return;
    }
    rfm_cursor_wait(dialog);
    gtk_widget_set_sensitive(dialog, FALSE);
    gchar *argv[]={"hcitool", "scan", NULL};
    rfm_show_text(widgets_p);
    hci_fork_t *hci_fork_p = (hci_fork_t *)malloc(sizeof(hci_fork_t));
    if (!hci_fork_p) g_error("Cannot allocate hci_fork_p\n");
    memset(hci_fork_p, 0, sizeof(hci_fork_t));
    hci_fork_p->dialog = dialog;
    hci_fork_p->widgets_p = widgets_p;
    hci_fork_p->comboentry[0] = g_object_get_data(G_OBJECT(dialog),"OBEX_MAC");
    hci_fork_p->comboentry[1] = g_object_get_data(G_OBJECT(dialog),"OBEX_NAME");

    rfm_diagnostics(widgets_p, "xffm/status_bluetooth-active",NULL);
    rfm_diagnostics(widgets_p, "xffm_tag/blue",_("Command:"), NULL);
    rfm_diagnostics(widgets_p, NULL," hcitool scan\n", NULL);
    rfm_diagnostics(widgets_p, "xffm/status_bluetooth-active",NULL);
    rfm_diagnostics(widgets_p, "xffm_tag/blue",_("Waiting for operation to finish..."), "\n",NULL);

#if 10
#ifdef USE_GTK2
	    // XXX: This is a known bug due to gtk2 limitations.
	    // This will just remove first item... FIXME
# if GTK_MAJOR_VERSION==2 && GTK_MINOR_VERSION<24
	    gtk_combo_box_remove_text (GTK_COMBO_BOX(hci_fork_p->comboentry[0]), 0);
	    gtk_combo_box_remove_text (GTK_COMBO_BOX(hci_fork_p->comboentry[1]), 0);
# else
	    gtk_combo_box_text_remove  (GTK_COMBO_BOX_TEXT(hci_fork_p->comboentry[0]), 0);
	    gtk_combo_box_text_remove  (GTK_COMBO_BOX_TEXT(hci_fork_p->comboentry[1]), 0);
# endif

#else
	    // This is gtk3, and no bug is present.
	    gtk_combo_box_text_remove_all  (GTK_COMBO_BOX_TEXT(hci_fork_p->comboentry[0]));
	    gtk_combo_box_text_remove_all  (GTK_COMBO_BOX_TEXT(hci_fork_p->comboentry[1]));
#endif
#endif

    pid_t child = Tubo_threads (fork_function,
                                (void *)argv,
                                0,
                                operate_stdout,
                                operate_stderr, //stderr_f,
                                fork_finished_function,
                                (void *)hci_fork_p,
                                FALSE,
                                TRUE); 
    if (child == 0) {
	g_warning("get_hci_scan(): cannot fork command %s\n", argv[0]);
    }
    return;
}

static void
change_other (GtkComboBox *widget, gpointer data) {
    GtkComboBox *other = data;
    gint active = gtk_combo_box_get_active (widget);
    gint active_other = gtk_combo_box_get_active (other);
    if (active != active_other){
	gtk_combo_box_set_active (other, active);
    }
    // Set new url value.
   
    GtkWidget *dialog = g_object_get_data(G_OBJECT(widget), "dialog");
    fuse_data_t *fuse_data_p = g_object_get_data(G_OBJECT(dialog), "fuse_data_p");
    
    fuse_data_p->item_id = "OBEX_NAME";
    gchar *obex_name = FUSE_get_combo_text(fuse_data_p);
    fuse_data_p->item_id = "OBEX_MAC";
    gchar *obex_mac = FUSE_get_combo_text(fuse_data_p);

    GtkWidget *entry = g_object_get_data(G_OBJECT(dialog), "FUSE_URL");
    const gchar *url_template = g_object_get_data(G_OBJECT(dialog),"url_template");
    gchar *u =g_strconcat(url_template, "://", obex_name, "@",  obex_mac, NULL);
    gtk_entry_set_text(GTK_ENTRY(entry), u);
    g_free(u);
    g_free(obex_name);
    g_free(obex_mac);
}

static void
get_hci_dev(GtkButton * button, gpointer data){
    widgets_t *widgets_p = g_object_get_data(G_OBJECT(button), "widgets_p");
     if (!FUSE_check_program(widgets_p, "hcitool")){
	return;
    }
    GtkWidget *dialog = g_object_get_data(G_OBJECT(button), "dialog");
    rfm_diagnostics(widgets_p, "xffm/status_bluetooth-active",NULL);
    rfm_diagnostics(widgets_p, "xffm_tag/blue",_("Command:"), NULL);
    rfm_diagnostics(widgets_p, NULL," hcitool dev\n", NULL);
    // create dialog with text area for output
    //if (!get_hci(dialog, widgets_p, "dev")) return;
    GtkWidget *comboentry = data;
    // populate a entry combobox with devices or alert
    GSList *list=NULL;

    FILE *pipe = popen ("hcitool dev", "r");
    if(pipe) {
#define PAGE_LINE 256
        gchar line[PAGE_LINE];
        line[PAGE_LINE - 1] = 0;
        while(fgets (line, PAGE_LINE - 1, pipe) && !feof (pipe)) {
            if(strncmp (line, "Devices:", strlen("Devices:"))==0) continue;
	    if (!strchr(line, ':')) continue;
	    g_strchug(line);
	    if (strchr(line, ' ')) *strchr(line, ' ') = 0;
	    if (strchr(line, '\t')) *strchr(line, '\t') = 0;
	    list = g_slist_prepend(list, g_strdup(line));
        }
        pclose (pipe);
    }  

    gchar *argv[]={"hciconfig", NULL};
    
    rfm_thread_run_argv(widgets_p, argv, FALSE);
    gchar *argv2[]={"rfkill", "list", NULL};
    
    rfm_thread_run_argv(widgets_p, argv2, FALSE);

    if (list == NULL){
	gchar *text = g_strdup_printf("<b>%s\n</b>\n<i>%s\n</i>",
		_("No bluetooth adapter has been found"), _("Turn Bluetooth On"));
	rfm_confirm(widgets_p, GTK_MESSAGE_ERROR, text, NULL, NULL);
	g_free(text);
	GtkWidget *box = g_object_get_data(G_OBJECT(dialog), "OBEX_MAC_BOX");
	gtk_widget_set_sensitive(box, FALSE);
	box = g_object_get_data(G_OBJECT(dialog), "OBEX_NAME_BOX");
	gtk_widget_set_sensitive(box, FALSE);
    } else {
	DBG("device = %s\n", (gchar *)list->data);
#ifdef USE_GTK2
	// XXX: This is a known bug due to gtk2 limitations.
	// This will just remove first item...
	// (only a problem if more than one bluetooth is present)
# if GTK_MAJOR_VERSION==2 && GTK_MINOR_VERSION<24
	gtk_combo_box_remove_text (GTK_COMBO_BOX(comboentry), 0);
# else
	gtk_combo_box_text_remove  (GTK_COMBO_BOX_TEXT(comboentry), 0);
# endif

#else
	// This is gtk3, and no bug is present.
	gtk_combo_box_text_remove_all  (GTK_COMBO_BOX_TEXT(comboentry));
#endif
	GSList *tmp=list;
	for (; tmp && tmp->data; tmp= tmp->next){
	    DBG("prepend device = %s\n", (gchar *)tmp->data);
#if GTK_MAJOR_VERSION==2 && GTK_MINOR_VERSION<24
	    gtk_combo_box_prepend_text(GTK_COMBO_BOX(comboentry),
		    (gchar *)tmp->data); 
#else
	    gtk_combo_box_text_prepend_text(GTK_COMBO_BOX_TEXT(comboentry),
		    (gchar *)tmp->data); 
#endif
	    g_free(tmp->data);
	}
	g_slist_free(list);
	gtk_combo_box_set_active (GTK_COMBO_BOX(comboentry), 0);
	GtkWidget *box = g_object_get_data(G_OBJECT(dialog), "OBEX_MAC_BOX");
	gtk_widget_set_sensitive(box, TRUE);
	box = g_object_get_data(G_OBJECT(dialog), "OBEX_NAME_BOX");
	gtk_widget_set_sensitive(box, TRUE);
	box = g_object_get_data(G_OBJECT(dialog), "OBEX_DEVICE");
	gtk_widget_set_sensitive(box, TRUE);
    }

}


static void
agent(GtkButton * button, gpointer data){
    gboolean use_sudo = GPOINTER_TO_INT(data);
    widgets_t *widgets_p = g_object_get_data(G_OBJECT(button), "widgets_p");
    //GtkWidget *dialog = g_object_get_data(G_OBJECT(button), "dialog");

    if (!FUSE_check_program(widgets_p, "rfm-simple-agent")){
	return;
    }
    if (use_sudo){
	gchar *argv[]={"sudo", "-A", "rfm-simple-agent",NULL};
	rfm_thread_run_argv(widgets_p, argv, TRUE);
    } else {
	gchar *argv[]={"rfm-simple-agent",NULL};
	rfm_thread_run_argv(widgets_p, argv, TRUE);
    }
}

#if 10

static gchar *
accept (fuse_data_t *fuse_data_p, const gchar *url){

    // Extra obex stuff:
    fuse_data_p->item_id = "OBEX_NAME";
    gchar *computer = FUSE_get_combo_text(fuse_data_p);
    if (!computer || !strlen(computer)) return NULL;
    fuse_data_p->item_id = "OBEX_DEVICE";
    gchar *device = FUSE_get_combo_text(fuse_data_p);
    if (!device || !strlen(device)) return NULL;
    fuse_data_p->item_id = "OBEX_MAC";
    gchar *mac = FUSE_get_combo_text(fuse_data_p);
    if (!mac || !strlen(mac)) return NULL;
    // Synonym for computer: OBEX_NAME
    fuse_data_p->computer = computer;
    // url is the keyfile group
    fuse_data_p->url = url;
    if (!FUSE_get_login_info (fuse_data_p)) return NULL;

    // Put extra stuff into open keyfile.
    key_options_t *key_options_p = 
	g_object_get_data(G_OBJECT(fuse_data_p->dialog), "key_options_p");
    if (!key_options_p) g_error("key_options_p cannot be null\n");
	
    g_key_file_set_value (key_options_p->key_file,  key_options_p->group, 
	    "OBEX_DEVICE", device);
    g_key_file_set_value (key_options_p->key_file,  key_options_p->group, 
	    "OBEX_NAME", computer);
    g_key_file_set_value (key_options_p->key_file,  key_options_p->group, 
	    "OBEX_MAC", mac);   


    // FLAG_0 is done.

    // FLAG_1: fuse options.    
    fuse_data_p->flag_id = 1;
    fuse_data_p->options_p = fuse_options;
    fuse_data_p->options_keys_p = &fuse_option_keys;
    FUSE_set_options(fuse_data_p);     
    // FLAG_2: module options
    fuse_data_p->flag_id = 2;
    fuse_data_p->options_p = module_options;
    fuse_data_p->options_keys_p = &module_option_keys;
    FUSE_set_options(fuse_data_p);     
   
    // Here we save and cleanup key_file.
    gchar *new_url = FUSE_save_keyfile(fuse_data_p);
    g_free(computer);
    g_free(device);
    g_free(mac);
    return new_url;
}

#else
#endif


static
fuse_data_t *
confirm_obex_host_dialog (widgets_t * widgets_p, const gchar *url) {
    fuse_data_t *fuse_data_p = (fuse_data_t *)FUSE_data_new(NULL);
    if (!fuse_data_p) g_error("cannot allocate fuse_data_p\n");

    fuse_data_p->widgets_p = widgets_p;
    fuse_data_p->url = url;
    fuse_data_p->info1 = OBEX_INFO1;
    fuse_data_p->info2 = OBEX_INFO2;

    fuse_data_p->dialog = FUSE_init_dialog(fuse_data_p);

    g_object_set_data(G_OBJECT(fuse_data_p->dialog), 
	    "fuse_data_p", fuse_data_p);
    g_object_set_data(G_OBJECT(fuse_data_p->dialog), 
	    "url_template", "obex");

    // Obex specifics

    GtkWidget *hbox;
    GtkWidget *vbox = g_object_get_data(G_OBJECT(fuse_data_p->dialog), "vbox");
    GKeyFile *key_file = g_object_get_data(G_OBJECT(fuse_data_p->dialog), 
	    "key_file");
     // Obex adaptor box
    gchar *pre_set_device = NULL;
    if (key_file) {
	pre_set_device = g_key_file_get_value(key_file, url, "OBEX_DEVICE", NULL);
    }
    fuse_data_p->item_id = "OBEX_DEVICE";
    fuse_data_p->item_string = OBEX_DEVICE;
    fuse_data_p->default_value = NULL;
    hbox = FUSE_add_combo(fuse_data_p);
    g_object_set_data(G_OBJECT(fuse_data_p->dialog), "OBEX_DEVICE_BOX", hbox); 

    GtkWidget *button =
	gtk_button_new_with_label(_("Click to select device..."));
    GtkWidget *combodevice = g_object_get_data(G_OBJECT(fuse_data_p->dialog), "OBEX_DEVICE");
    g_signal_connect(G_OBJECT(button), "clicked", G_CALLBACK(get_hci_dev), combodevice);
    g_object_set_data(G_OBJECT(button), "widgets_p", widgets_p); 
    g_object_set_data(G_OBJECT(button), "dialog", fuse_data_p->dialog); 
    gtk_widget_show(button);
    gtk_box_pack_start (GTK_BOX (hbox), button, FALSE, FALSE, 0);

    // Obex devices "MAC address" box
    // #~ msgid "Scanning... Please wait."
    fuse_data_p->item_id = "OBEX_MAC";
    fuse_data_p->item_string = OBEX_MAC;
    fuse_data_p->default_value = NULL;
    hbox = FUSE_add_combo(fuse_data_p);
    g_object_set_data(G_OBJECT(fuse_data_p->dialog), "OBEX_MAC_BOX", hbox); 

    button =
	gtk_button_new_with_label(_("Scan for Devices"));
    GtkWidget *combomac = g_object_get_data(G_OBJECT(fuse_data_p->dialog), "OBEX_MAC");
    g_signal_connect(G_OBJECT(button), "clicked", G_CALLBACK(get_hci_scan), combomac);
    g_object_set_data(G_OBJECT(button), "widgets_p", widgets_p); 
    g_object_set_data(G_OBJECT(button), "dialog", fuse_data_p->dialog); 
    g_object_set_data(G_OBJECT(combomac), "dialog", fuse_data_p->dialog);
    gtk_widget_show(button);
    gtk_box_pack_start (GTK_BOX (hbox), button, FALSE, FALSE, 0);
    
    // Obex devices "names" box
    fuse_data_p->item_id = "OBEX_NAME";
    fuse_data_p->item_string = OBEX_NAME;
    fuse_data_p->default_value = NULL;
    hbox = FUSE_add_combo(fuse_data_p);
    g_object_set_data(G_OBJECT(fuse_data_p->dialog), "OBEX_NAME_BOX", hbox); 

    button =
	gtk_button_new_with_label(_("Scan for Devices"));
    GtkWidget *comboname = g_object_get_data(G_OBJECT(fuse_data_p->dialog), "OBEX_NAME");
    g_signal_connect(G_OBJECT(button), "clicked", G_CALLBACK(get_hci_scan), comboname);
    g_object_set_data(G_OBJECT(button), "widgets_p", widgets_p); 
    g_object_set_data(G_OBJECT(button), "dialog", fuse_data_p->dialog); 
    g_object_set_data(G_OBJECT(comboname), "dialog", fuse_data_p->dialog);
    gtk_widget_show(button);
    gtk_box_pack_start (GTK_BOX (hbox), button, FALSE, FALSE, 0);    

    // Bind both combos:
    g_signal_connect(G_OBJECT(combomac), "changed", G_CALLBACK(change_other), comboname);
    g_signal_connect(G_OBJECT(comboname), "changed", G_CALLBACK(change_other), combomac);

    // Make boxes insensitive if no bluetooth device selected.
    gtk_widget_set_sensitive(
	    g_object_get_data(G_OBJECT(fuse_data_p->dialog), "OBEX_MAC_BOX"), 
	    gtk_widget_get_sensitive(combodevice));
    gtk_widget_set_sensitive(
	    g_object_get_data(G_OBJECT(fuse_data_p->dialog), "OBEX_NAME_BOX"), 
	    gtk_widget_get_sensitive(combodevice));
        
    // Obex devices "PIN" box
    hbox = rfm_hbox_new(FALSE,FALSE);
    g_object_set_data(G_OBJECT(fuse_data_p->dialog), "OBEX_PIN_BOX", hbox); 
    GtkWidget *label = gtk_label_new(OBEX_PIN);
    gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
    label = gtk_label_new(": ");
    gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
    /*
    entry=gtk_entry_new();
    gtk_box_pack_start (GTK_BOX (hbox), entry, FALSE, FALSE, 0);
    g_object_set_data(G_OBJECT(fuse_data_p->dialog), "OBEX_PIN", entry); */

    // PIN Agent
    button =
	gtk_button_new_with_label(_("Agent"));
    g_object_set_data(G_OBJECT(button), "widgets_p", widgets_p); 
    g_object_set_data(G_OBJECT(button), "dialog", fuse_data_p->dialog); 
    g_signal_connect(G_OBJECT(button), "clicked", G_CALLBACK(agent), NULL);
    gtk_widget_show(button);
    gtk_box_pack_start (GTK_BOX (hbox), button, FALSE, FALSE, 0);

    gchar *sudo_agent = g_strconcat(_("sudo"), " ", _("Agent"), NULL);
     
    button =
	gtk_button_new_with_label(sudo_agent);
    g_free(sudo_agent);
    g_object_set_data(G_OBJECT(button), "widgets_p", widgets_p); 
    g_object_set_data(G_OBJECT(button), "dialog", fuse_data_p->dialog); 
    g_signal_connect(G_OBJECT(button), "clicked", G_CALLBACK(agent), GINT_TO_POINTER(1));
    gtk_widget_show(button);
    gtk_box_pack_start (GTK_BOX (hbox), button, FALSE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
    gtk_widget_show_all(hbox);
   
    

    //  general fuse items

    fuse_data_p->item_string = FUSE_MOUNT_POINT;
    fuse_data_p->item_id = "FUSE_MOUNT_POINT";
    hbox =
	FUSE_add_entry(fuse_data_p);
    if (rfm_void(PLUGIN_DIR, "fstab", "module_active")) {
	gtk_widget_set_sensitive(hbox, FALSE);
    }


    fuse_data_p->item_string = FUSE_URL;
    fuse_data_p->item_id = "FUSE_URL";
    FUSE_add_entry(fuse_data_p);

    GtkWidget *entry = g_object_get_data(G_OBJECT(fuse_data_p->dialog), "FUSE_URL");
    if (url) gtk_entry_set_text(GTK_ENTRY(entry), url);
    gtk_widget_set_sensitive(entry, FALSE);

    
    fuse_data_p->extra_text = FUSE_CAUTION;
    fuse_data_p->item_string = FUSE_MONITOR;
    fuse_data_p->item_id = "FUSE_MONITOR";
    FUSE_add_check(fuse_data_p);

    fuse_data_p->label = _("FUSE");
    fuse_data_p->options_p = fuse_options;
    fuse_data_p->flag_id = 1;
    FUSE_add_option_page(fuse_data_p);
 
    fuse_data_p->label = _("Module");
    fuse_data_p->options_p = module_options;
    fuse_data_p->flag_id = 2;
    FUSE_add_option_page(fuse_data_p);
 

    // This here will clear out the memory key_file, so do any stuff on
    // keyfile before this function call.
    FUSE_reset_url_field(fuse_data_p);
    return fuse_data_p;
}

static gboolean
confirm_obex_host (widgets_t * widgets_p, const gchar *url) {
    GCond *signal = fuse_hold_monitor(widgets_p);
    fuse_data_t *fuse_data_p = confirm_obex_host_dialog (widgets_p, url);
    if(!fuse_data_p || !fuse_data_p->dialog){
        return FALSE;
    }
    gint response;
retry:
    response = gtk_dialog_run (GTK_DIALOG (fuse_data_p->dialog));
    gtk_widget_hide (fuse_data_p->dialog);

    gboolean retval;
    if(response == GTK_RESPONSE_YES || response == GTK_RESPONSE_APPLY){
	gchar *new_url = accept(fuse_data_p, url);
	if (!new_url) {
	    gtk_widget_show (fuse_data_p->dialog);
	    goto retry;
	}
	if(response == GTK_RESPONSE_YES) {
	    mount_url(widgets_p, new_url);
	}
	gtk_widget_destroy (fuse_data_p->dialog);
	view_t *view_p = widgets_p->view_p;
	record_entry_t *t_en = rfm_copy_entry(view_p->en);
	if(!rodent_refresh (widgets_p, t_en)) {
	    rfm_destroy_entry(t_en);
	}
	g_free(new_url);
        retval = TRUE;
    } else {
	gtk_widget_destroy (fuse_data_p->dialog);
        retval = FALSE;
    }
    g_cond_signal(signal);
    return retval;
}
////////////////////////////////////////

