#ifndef GROUP_OPTIONS_H
#define GROUP_OPTIONS_H
#define GroupOptions group_options_t

typedef struct group_options_t {
    gint sensitive;
    const gchar *flag;
    const gchar *id;
    const gchar *text;
    const gchar *entry;
    const gchar *tip;
}group_options_t;

void
group_options_write_keyfile(GKeyFile *key_file);

GtkWidget *
group_options_box(GtkWidget *dialog, 
	group_options_t *options_p,
	GKeyFile *key_file, 
	const gchar *group, 
	gint flag_id);

gchar **
group_option_keys(group_options_t *options_p);

GHashTable *
group_options_get_option_hash(GtkWidget *dialog, 
	gchar **option_keys,
	guint64 *flag_p);

gchar *
group_options_get_key_value(const gchar *group, 
	const gchar *key);

gchar *
group_options_set_key_value(const gchar *group, 
	const gchar *key, 
	gchar *value);

gboolean
group_options_get_key_boolean(const gchar *group, 
	const gchar *key);

gboolean
group_options_remove_group(const gchar *group);

gchar **
group_options_get_key_options(const gchar *group, 
	gint flag_id, 
	group_options_t *group_options_p);
#endif
