//
//

static gchar **ftp_option_keys = NULL;
static  GroupOptions ftp_options[]={
//FTP options:

    {
	.sensitive = FALSE, .flag = "-o", .id = "user=", 
        .tip=N_("Specify   user  and  password  to  use for server authentication.  Overrides netrc configuration.") ,
	.text = N_("set server user and password"), 
	.entry = "<user:password>"
    },
    {
	.sensitive = FALSE, .flag = "-o", .id = "proxy=", 
	.tip = N_("Use  specified  HTTP  proxy.  If  the port number is  not specified, it is assumed at port 1080.\n\n This  option  overrides  existing  environment  variables that  sets  proxy  to  use.  If  there's  an  environment variable  setting  a proxy, you can set proxy  to  \"\"  to override it.\n\n This options implies the proxytunnel option.\n\n Starting  with libcurl version 7.14.1, the proxy host can be specified the exact same way as the proxy  environment variables,    including  protocol  prefix  (http://) and embedded user + password."),
        .text = N_("HTTP proxy"), 
	.entry = "<host[:port]>"
    },
    {
	.sensitive = 1, .flag = "-o", .id = "proxy_user=", 
	.tip = N_("Specify user and password to use  for  proxy  authentication."),
        .text = N_("proxy user and password"), 
	.entry = "<user:password>"
    },
    {
	.sensitive = 1, .flag = "-o", .id = "proxy_basic", 
	.tip = N_("Tells curlftpfs to use  HTTP  Basic  authentication  when communicating  with the given proxy. Basic is the default authentication method curlftpfs is used with proxies."),
        .text = N_("Basic proxy authentication"), 
	.entry = NULL
    },
    {
	.sensitive = 1, .flag = "-o", .id = "proxy_anyauth", 
        .tip=N_("Tells curl to pick a suitable authentication method  when communicating  with the  given  proxy.  This  will  cause an  extra request/response round-trip."),
	.text = N_("\"any\" proxy authentication"), 
	.entry = NULL
    },
    {
	.sensitive = 1, .flag = "-o", .id = "proxy_digest", 
        .tip=N_("Tells  curlftpfs to use HTTP Digest  authentication  when communicating with the given proxy.") ,     
	.text = N_("Digest proxy authentication"), 
	.entry = NULL
    },
    {
	.sensitive = 1, .flag = "-o", .id = "proxy_ntlm", 
        .tip=N_("Tells  curlftpfs  to  use HTTP NTLM  authentication  when communicating with the given proxy.") ,     
	.text = N_("NTLM proxy authentication"), 
	.entry = NULL
    },
    {
	.sensitive = 1, .flag = "-o", .id = "proxytunnel", 
        .tip=N_("Tells curlftpfs to use a tunnel  proxy.  This  option  is implied  by the proxy option but you need to set it manually if you use the proxy environment variable.") ,     
	.text = N_("Operate through a HTTP proxy tunnel (using CONNECT)"), 
	.entry = NULL
    },
    {
	.sensitive = FALSE, .flag = "-o", .id = "httpproxy", 
        .tip=N_("Set the proxy type to HTTP. This is the default type.") ,  
	.text = N_("use a HTTP proxy (default)"), 
	.entry = NULL
    },
    {
	.sensitive = 1, .flag = "-o", .id = "socks4", 
        .tip=N_("Set the proxy type to SOCKS4.") ,
	.text = N_("use a SOCKS4 proxy"), 
	.entry = NULL
    },
    {
	.sensitive = 1, .flag = "-o", .id = "socks5", 
        .tip=N_("Set the proxy type to SOCKS5.") ,   
	.text = N_("use a SOCKS5 proxy"), 
	.entry = NULL
    },
   {
	.sensitive = 1, .flag = "-o", .id = "ftpfs_debug", 
        .tip=N_("Make curlftpfs print lots of  debug  information.  Useful only in conjunction with the -d option.") ,  
	.text = N_("print some debugging information"), 
	.entry = NULL
    },
    {
	.sensitive = 1, .flag = "-o", .id = "transform_symlinks", 
        .tip=N_("Append  path  to the absolute symlinks so that they still point inside the ftp directory structure. Otherwise those links will very probably be broken.") ,  
	.text = N_("Prepend mountpoint to absolute symlink targets"), 
	.entry = NULL
    },
    {
	.sensitive = FALSE, .flag = "-o", .id = "disable_epsv", 
        .tip=N_("Tell curlftpfs to disable the use  of  the  EPSV  command when doing passive FTP transfers. This is the default.") ,   
	.text = N_("use PASV, without trying EPSV first (default)"), 
	.entry = NULL
    },
    {
	.sensitive = 1, .flag = "-o", .id = "enable_epsv", 
        .tip=N_("Tell curlftpfs to enable the use of the EPSV command when doing passive FTP transfers. Curlftpfs will first attempt to use EPSV before PASV.") ,
	.text = N_("try EPSV before reverting to PASV"), 
	.entry = NULL
    },
    {
	.sensitive = 1, .flag = "-o", .id = "skip_pasv_ip", 
        .tip=N_("Tell  curlftpfs to not use the IP address the server suggests in its response to curlftpfs\'s  PASV  command  when curlftpfs   connects   the   data   connection.   Instead curlftpfs will re-use the same IP address it already uses for the control connection.") , 
	    .text = N_("skip the IP address for PASV"), 
	.entry = NULL
    },
    {
	.sensitive = 1, .flag = "-o", .id = "ftp_port=", 
        .tip=N_("Reverses  the  initiator/listener  roles  when connecting with ftp. This switch makes curlftpfs use the  PORT  com- mand  instead of PASV. In practice, PORT tells the server to connect to the client's specified  address  and  port, while  PASV asks the server for an ip address and port to connect to. <address> should be one of:\n\n \tinterface\n \t\ti.e \"eth0\" to specify which interface\'s IP address you want to use\n\n \tIP address\n \t\ti.e \"192.168.10.1\" to specify exact IP number\n\n \thost name\n \t\ti.e \"my.host.domain\" to specify machine\n\n \t-\n      \t\tmake  curlftpfs  pick  the same IP address \n\t\tthat is already used for the control connection\n\n \tDisable the attempt to use the EPRT  command  instead  of\n \tPORT by using disable_eprt.  EPRT is really PORT++.  ") ,     .text = N_("use PORT with address instead of PASV"), 
	.entry = "<address>"
    },
    {
	.sensitive = 1, .flag = "-o", .id = "disable_eprt", 
        .tip=N_("Tell  curlftpfs  to  disable the use of the EPRT and LPRT commands when doing active FTP transfers. Curlftpfs  will normally  always  first  attempt  to  use EPRT, then LPRT before using PORT, but with this option, it will use PORT right  away. EPRT and LPRT are extensions to the original FTP protocol, may not work on all servers but enable more functionality  in  a better way than the traditional PORT command.") ,   
	.text = N_("use PORT, without trying EPRT first"), 
	.entry = NULL
    },
    {
	.sensitive = 1, .flag = "-o", .id = "multicwd", 
        .tip=N_("Control  what method curlftpfs should use to reach a file on the server: multicwd --- curlftpfs  does  a  single  CWD operation for each path part in the given URL. For  deep  hierarchies this means very many commands. This is how RFC1738 says it should be done. This is  the  default  but the slowest behavior.  ") ,  
	.text = N_("[multicwd/singlecwd] ftp_method: Control CWD usage"), 
	.entry =  NULL
    },
    {
	.sensitive = 1, .flag = "-o", .id = "singlecwd", 
        .tip=N_("Control  what method curlftpfs should use to reach a file on the server:singlecwd --- curlftpfs does one CWD with the full target directory and then  operates  on  the  file  \"normally\" (like in the multicwd case).") ,  
	.text = N_("[multicwd/singlecwd] ftp_method: Control CWD usage"), 
	.entry =  NULL
    },
    {
	.sensitive = 1, .flag = "-o", .id = "custom_list=", 
        .tip=N_("Command  used  by curlftpfs to list files. The default is \"LIST -a\" but some servers might require  extra  options, e.g. \"LIST -la\".") ,   
	.text = N_("Command used to list files. Defaults to \"LIST -a\""), 
	.entry = "<command>"
    },
    {
	.sensitive = 1, .flag = "-o", .id = "tcp_nodelay", 
        .tip=N_("Turn on the TCP_NODELAY option. See the curl_easy_setopt(3)  man  page  for  details  about  this option.") ,    
	.text = N_("use the TCP_NODELAY option"), 
	.entry = NULL
    },
    {
	.sensitive = 2, .flag = "-o", .id = "connect_timeout=", 
        .tip=N_("Maximum time in seconds that you allow the connection  to the  server  to  take.   This  only limits the connection phase, once curlftpfs has connected this option is of  no more use.") , 
	.text = N_("maximum time allowed for connection in seconds"), 
	.entry = "5" // was 10 (off)
    },  
    {
	.sensitive = 1, .flag = "-o", .id = "ssl", 
        .tip=N_("Make curlftpfs use SSL/TLS for both control and data connections.") , 
	.text = N_("enable SSL/TLS for both control and data connections"), 
	.entry = NULL
    },
    {
	.sensitive = 1, .flag = "-o", .id = "ssl_control", 
        .tip=N_("Make  curlftpfs  use SSL/TLS only for the control connection.") ,   
	.text = N_("enable SSL/TLS only for control connection"), 
	.entry = NULL
    },
    {
	.sensitive = 1, .flag = "-o", .id = "ssl_try", 
        .tip=N_("Curlftpfs will try to use SSL/TLS for  both  the  control and  data  connections  but if the server doesn\'t support it, it will still connect unencrypted.") , 
	.text = N_("try SSL/TLS first but connect anyway"), 
	.entry = NULL
    },
    {
	.sensitive = 1, .flag = "-o", .id = "no_verify_hostname", 
        .tip=N_("(SSL)  Curlftpfs  will  not verify the hostname when connecting to a SSL enabled server.") , 
	.text = N_("does not verify the hostname (SSL)"), 
	.entry = NULL
    },
    {
	.sensitive = 1, .flag = "-o", .id = "no_verify_peer", 
        .tip=N_("(SSL) Curlftpfs will not verify the certificate when connecting to a SSL enabled server.") ,     
	.text = N_("does not verify the peer (SSL)"), 
	.entry = NULL
    },
    {
	.sensitive = 1, .flag = "-o", .id = "cert=", 
        .tip=N_("(SSL)  Tells  curlftpfs  to use the specified certificate file. The default format is \"PEM\" and can be changed with cert_type.") , 
	.text = N_("client certificate file (SSL)"), 
	.entry = "<certificate>"
    },
    {
	.sensitive = 1, .flag = "-o", .id = "cert_type=", 
        .tip=N_("(SSL)  Tells curlftpfs what certificate type the provided certificate is in.   PEM,  DER  and  ENG  are  recognized types.") ,   
	.text = N_("certificate file type (DER/PEM/ENG) (SSL)"), 
	.entry = "<type>"
    },
    {
	.sensitive = 1, .flag = "-o", .id = "key=", 
        .tip=N_("(SSL) Private key file name. Allows you to  provide  your private key in this separate file. The  default format is \"PEM\" and can be changed with key_type."),
	.text = N_("private key file name (SSL)"), 
	.entry = "<key>"
    },
    {
	.sensitive = 1, .flag = "-o", .id = "key_type=", 
        .tip=N_("(SSL) Pass a string in the format of  your  private  key.  Supported  formats are \"PEM\", \"DER\" and \"ENG\".\n\n The  format  \"ENG\"  enables  you  to load the private key from a crypto engine.  In this case key  is  used  as  an identifier   passed to  the  engine.  You have to set the crypto engine with engine option.  \"DER\" format key  file currently  does not work because of a bug in OpenSSL.") , 
	.text = N_("private key file type (DER/PEM/ENG) (SSL)"), 
	.entry = "<type>"
    },
    {
	.sensitive = 1, .flag = "-o", .id = "pass=", 
        .text = N_("pass phrase for the private key (SSL)"), 
	.entry = "<password>"
    },
    {
	.sensitive = 1, .flag = "-o", .id = "engine=", 
        .tip=N_("Select   the   OpenSSL  crypto  engine  to use for cipher operations.  Use:\n\n\t curl --engine list\n\n to  print  a  list  of   build-time   supported  engines.  Note   that   not  all   (or  none) of the engines may be available at run-time.") ,
	.text = N_("crypto engine to use (SSL)"), 
	.entry = "<name>"
    },
    {
	.sensitive = 1, .flag = "-o", .id = "cacert=", 
        .tip=N_("(SSL) Pass a string naming a file  holding  one  or  more certificates to verify the peer with.\n\n Note   that   option   is   by  default set to the system path where libcurl\'s  cacert  bundle  is  assumed  to  be stored, as  established at build time.") ,  
	.text = N_("file with CA certificates to verify the peer (SSL)"), 
	.entry = "<file>"
    },
    {
	.sensitive = 1, .flag = "-o", .id = "capath=", 
        .tip=N_("(SSL)  Tells  curlftpfs  to use the specified certificate directory to verify the peer. The certificates must be in PEM  format,  and  the directory must have been processed using  the  c_rehash  utility  supplied   with   openssl.  Using capath can allow curlftpfs to make connections much more efficiently than using  cacert  if the  cacert  file contains many CA certificates.") ,
	.text = N_("CA directory to verify peer against (SSL)"), 
	.entry = "<directory>"
    },
    {
	.sensitive = 1, .flag = "-o", .id = "ciphers=", 
        .tip=N_("(SSL)  Specifies  which ciphers to use in the connection.  The list must be syntactically correct,  it  consists  of one  or  more cipher strings separated  by colons. Commas or spaces are also acceptable separators but  colons  are normally  used,  ,  -  and  + can be  used  as operators.  Valid  examples   of   cipher  lists  include  \'RC4-SHA\', \'SHA1+DES\',  \'TLSv1\'  and  \'DEFAULT\'. The default list is normally set when you compile OpenSSL.\n\n Read  up  on  SSL  cipher  list  details  on  this   URL: http://www.openssl.org/docs/apps/ciphers.html ") ,
	.text = N_("SSL ciphers to use (SSL)"), 
	.entry = "<list of ciphers>"
    },
    {
	.sensitive = 1, .flag = "-o", .id = "interface=", 
        .tip=N_("Pass  a  string as parameter. This set the interface name to  use as  outgoing network  interface.  The   name  can be an interface name, an IP address or a host name.") ,
	.text = N_("specify network interface/address to use"), 
	.entry = "<name>"
    },
    {
	.sensitive = 1, .flag = "-o", .id = "krb4=", 
        .tip=N_("Enable  kerberos4  authentication and use. The level must be entered and should be one of \'clear\', \'safe\',  \'confidential\'   or  \'private\'.  Should  you  use  a level that is not one of these, \'private\' will instead be used.\n\n This option requires that the libcurl library  was  built with  kerberos4 support.  This is  not  very common.  ") ,
	.text = N_("enable krb4 with specified security level"), 
	.entry = "<level>"
    },
    {
	.sensitive = 1, .flag = "-o", .id = "tlsv1", 
        .tip=N_("(SSL) Forces curlftpfs to use TLS version 1 when  negotiating with a remote TLS server.") ,
	.text = N_("use TLSv1 (SSL)"), 
	.entry = NULL
    },
    {
	.sensitive = 1, .flag = "-o", .id = "sslv3", 
        .tip=N_("Forces curlftpfs to use SSL version  3  when  negotiating with a remote SSL server.") ,
	.text = N_("use SSLv3 (SSL)"), 
	.entry = NULL
    },
    {
	.sensitive = 1, .flag = "-o", .id = "ipv4", 
        .tip=N_("If  libcurl  is  capable  of resolving an address to multiple  IP  versions  (which it is if it is ipv6-capable), this option  tells libcurl  to  resolve names   to   IPv4 addresses only.") ,
	.text = N_("resolve name to IPv4 address"), 
	.entry = NULL
    },
    {
	.sensitive = 1, .flag = "-o", .id = "ipv6", 
        .tip=N_("If  libcurl  is  capable  of resolving an address to multiple IP versions (which it is if  it  is  ipv6-capable), this  option   tells libcurl  to  resolve names  to  IPv6 addresses only.") ,
	.text = N_("resolve name to IPv6 address"), 
	.entry = NULL
    },
    {
	.sensitive = 1, .flag = "-o", .id = "utf8", 
        .tip=N_("Try to transfer file list with UTF-8 encoding. Send  OPTS UTF8 ON at the beginning of file list transfer.") ,
	.text = N_("try to transfer file list with utf-8 encoding"), 
	.entry = NULL
    },
    {
	.sensitive = 1, .flag = "-o", .id = "codepage=", 
        .tip=N_("Sets  the  encoding  the  ftp  server uses to encode file names.") ,
	.text = N_("set the codepage the server uses"), 
	.entry = "<name>"
    },
    {
	.sensitive = 1, .flag = "-o", .id = "iocharset=", 
        .tip=N_("Sets  the charset used by the client side for codepage to charset translation.  Default: UTF8.  ") ,
	.text = N_("set the charset used by the client"), 
	.entry = "<name>"
    },
    {.sensitive = 1, NULL, NULL, NULL, .entry = NULL}
};

static gchar **curlftpfs_option_keys = NULL;
static  GroupOptions curlftpfs_options[]={

// CurlFtpFS cache options:  
    {
    .sensitive = 2, .flag = "-o", .id = "cache=", 
        .tip= N_("Enable/disable cache (yes|no)."), 
	.entry = "yes"// (off)
    },
    {
    .sensitive = 2, .flag = "-o", .id = "cache_timeout=", 
        .tip = N_("Set timeout for stat, dir, link at once."),
	.entry = "3" // was 10 (off)
    },
    {
    .sensitive = 2, .flag = "-o", .id = "cache_stat_timeout=", 
        .tip = N_("Set stat timeout."), 
	.entry = "3" // was 10 (off)
    },
    {
    .sensitive = 2, .flag = "-o", .id = "cache_dir_timeout=", 
        .tip = N_("Set dir timeout."), 
	.entry = "3" // was 10 (off)
    },
    {
    .sensitive = 2, .flag = "-o", .id = "cache_link_timeout=", 
        .tip = N_("Set link timeout."), 
	.entry = "3" // was 10 (off)
    },
    {.sensitive = 1, NULL, NULL, NULL, .entry = NULL}
};

