//linux options:

static gchar **efs_option_keys = NULL;
static  GroupOptions efs_options[]={
    {
	.sensitive = 1, .flag = "-o", .id = "ecryptfs_sig=", 
        .tip = N_("Specify  the  signature  of the mount wide authentication token. The authentication token must be in the  kernel  keyring  before the  mount  is performed. ecryptfs-manager or the eCryptfs mount helper can be used to construct the authentication token and add it to the keyring prior to mounting."), 
	.entry = N_("(fekek_sig)")
    },
    
    {
	.sensitive = 1, .flag = "-o", .id = "ecryptfs_fnek_sig=", 
        .tip = N_("Specify  the  signature  of  the mount wide authentication token used for filename crypto. The authentication must be in the kernel keyring before mounting."), 
	.entry = N_("(fnek_sig)")
    },
    
    {
	.sensitive = 2, .flag = "-o", .id = "ecryptfs_cipher=", 
	.text = "aes | blowfish | des3_ede | cast6 | cast5",
        .tip = N_("Specify the symmetric cipher to be used on a per file basis. "), 
	.entry = "aes"
    },
    
    {
	.sensitive = 2, .flag = "-o", .id = "ecryptfs_key_bytes=", 
        .tip = N_("Specify  the keysize to be used with the selected cipher. If the cipher only has one keysize the keysize  does  not  need  to  be specified.\n\n\taes: blocksize = 16; min keysize = 16; max keysize = 32\n\tblowfish: blocksize = 16; min keysize = 16; max keysize = 56\n\tdes3_ede: blocksize = 8; min keysize = 24; max keysize = 24\n\tcast6: blocksize = 16; min keysize = 16; max keysize = 32\n\tcast5: blocksize = 8; min keysize = 5; max keysize = 16\n\t"), 
	.entry = "16"
    },
    
    {
	.sensitive = 0, .flag = "-o", .id = "ecryptfs_passthrough=", 
        .tip = N_("Allows for non-eCryptfs files to be read and written from within an eCryptfs mount. This option is turned off by default."), 
	.entry = "no"
    },
    
    {
	.sensitive = -1, .flag = "-o", .id = "no_sig_cache", 
        .tip = N_("Do not check the mount key signature against the values  in  the user's  ~/.ecryptfs/sig-cache.txt  file. This is useful for such things as non-interactive  setup  scripts,  so  that  the  mount helper  does  not stop and prompt the user in the event that the key sig is not in the cache."), 
	.entry = NULL
    },
    
    {
	.sensitive = 1, .flag = "-o", .id = "ecryptfs_encrypted_view", 
        .tip = N_("This option provides a unified  encrypted  file  format  of  the eCryptfs  files in the lower mount point.  Currently, it is only useful if the lower mount point contains files with the metadata stored in the extended attribute.  Upon a file read in the upper mount point, the encrypted version of the file will be presented with  the  metadata  in  the  file  header instead of the xattr.  Files cannot be opened for writing when this option is enabled."),
	.entry = NULL
    },
    
    {
	.sensitive = 1, .flag = "-o", .id = "ecryptfs_xattr", 
        .tip = N_("Store the metadata in the extended attribute of the lower  files rather than the header region of the lower files."), 
	.entry = NULL
    },
    
    {
	.sensitive = 1, .flag = "-o", .id = "verbose", 
        .tip = N_("Log  ecryptfs  information  to  /var/log/messages.   Do  not run eCryptfs in verbose-mode unless you are doing so  for  the  sole purpose  of development, since secret values will be written out to the system log in that case."), 
	.entry = NULL
    },
        
    {
	.sensitive = 0, .flag = "-o", .id = "ecryptfs_enable_filename_crypto=", 
        .tip = N_("Specify whether filename encryption should be enabled.  If  not, the  mount  helper  will  not  prompt  the user for the filename encryption key signature."), 
	.entry = "no"
    },
    
    {
	.sensitive = -1, .flag = "-o", .id = "verbosity=", 
        .tip = N_("If verbosity=1, the mount helper will ask you for missing values (default).  Otherwise, if verbosity=0, it will not ask for missing values and will fail if required values are omitted.  "), 
	.entry = "1"
    },
    
    {
	.sensitive = 1, .flag = "-o", .id = "passphrase_passwd=", 
        .tip = N_("The actual password is passphrase. Since the password is visible to utilities (like ps under Unix) this form should only be  used where security is not important."), 
	.entry = N_("(passphrase)")
    },
    
    {
	.sensitive = 1, .flag = "-o", .id = "passphrase_passwd_file=", 
        .tip = N_("The    password   should   be   specified   in   a   file   with passwd=(passphrase). It is highly reccomended that the  file  be stored on a secure medium such as a personal usb key."), 
	.entry = N_("(filename)")
    },
    
    {
	.sensitive = 1, .flag = "-o", .id = "passphrase_passwd_fd=", 
        .tip = N_("The password is specified through the specified file descriptor."), 
	.entry = N_("(file descriptor)")
    },
    
    {
	.sensitive = 1, .flag = "-o", .id = "passphrase_salt=", 
        .tip = N_("The salt should be specified as a 16 digit hex value.  "), 
	.entry = N_("(hex value)")
    },
    
    {
	.sensitive = 1, .flag = "-o", .id = "openssl_keyfile=", 
        .tip = N_("The   password   should   be   specified   in   a   file    with openssl_passwd=(openssl-password). It is highly reccomended that the file be stored on a secure medium such  as  a  personal  usb key."), 
	.entry = N_("(filename)")
    },
    
    
    
    {
	.sensitive = 1, .flag = "-o", .id = "openssl_passwd_file=", 
        .tip = N_("The   password   should   be   specified   in   a   file    with openssl_passwd=(openssl-password). It is highly reccomended that the file be stored on a secure medium such  as  a  personal  usb key."), 
	.entry = N_("(filename)")
    },
    {
	.sensitive = 1, .flag = "-o", .id = "openssl_passwd_fd=", 
        .tip = N_("The password is specified through the specified file descriptor."), 
	.entry = N_("(file descriptor)")
    },
    {
	.sensitive = 1, .flag = "-o", .id = "openssl_passwd=", 
        .tip = N_("The  password  can  be  specified on the command line. Since the password is visible in the process list,  it  is  highly  recommended to use this option only for testing purposes."), 
	.entry = N_("(password)")
    },
    
    {.sensitive = 1, NULL, NULL, NULL, .entry = NULL}
};

/////////////////////////////////////////////////////////////////////////////////////


