//
//
/*
 * Copyright (c) 2006-2012 Edscott Wilson Garcia <edscott@xfce.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 */


#define SETTINGS_TIMERVAL 500

static void
clear_bgimage (GtkButton * button, gpointer data) {
    settings_t *settings_p=data;
    gtk_file_chooser_set_filename(GTK_FILE_CHOOSER(settings_p->desktopimage_button), "gtk gives a warning if we use NULL here (that is not good) so we just use this text to set to NULL");
}

void 
margin_changed (GtkSpinButton *spinbutton, gpointer data)  {
    settings_t *settings_p=g_object_get_data(G_OBJECT(spinbutton), "settings_p");
    if(!settings_p || settings_p->disable_options){
        return;
    }
    gint which_margin = GPOINTER_TO_INT(data);


    if(rfm_options[which_margin].value)
        g_free (rfm_options[which_margin].value);

    gdouble value=gtk_spin_button_get_value (spinbutton);
    TRACE ("margin:changed(): %4.0lf\n", value);
    rfm_options[which_margin].value = g_strdup_printf ("%lf", value);
    mcs_manager_set_string (mcs_manager, rfm_options[which_margin].name,
	    CHANNEL, rfm_options[which_margin].value);
    mcs_manager_notify (mcs_manager, CHANNEL);

    return;

}

static gboolean
transparency_changed (GtkRange * range, 
	GtkScrollType scroll, 
	gdouble value, 
	gpointer user_data)
{
    settings_t *settings_p=g_object_get_data(G_OBJECT(range), "settings_p");
    if(settings_p->disable_options)
        return FALSE;
    int i = (int)((long)user_data);
    if(rfm_options[i].value)
        g_free (rfm_options[i].value);
    rfm_options[i].value = g_strdup_printf ("%lf", value);
    mcs_manager_set_string (mcs_manager, rfm_options[i].name,
	    CHANNEL, rfm_options[i].value);
    mcs_manager_notify (mcs_manager, CHANNEL);

    return FALSE;
}

static gint
settings_monitor (gpointer data) {
    NOOP("g_timeout: settings-module.i settings_monitor()\n");
    mcs_shm_t *mcs_shm_p = (mcs_shm_t *) mp->m;
    if(shm_settings_serial < 0)
        return FALSE;
    if(shm_settings_serial != mcs_shm_p->serial) {
        int i;
        for(i = 0; i < RFM_OPTIONS; i++) {
            if(mcs_shm_p->data[i].value) {
                g_free (rfm_options[i].value);
                rfm_options[i].value = g_strdup (mcs_shm_p->data[i].value);
                rfm_setenv (rfm_options[i].name, rfm_options[i].value, TRUE);
            } else {
                rfm_setenv (rfm_options[i].name, NULL, TRUE);
            }
	    if (strlen(rfm_options[i].value)){
		TRACE ("settings_monitor(): serial %d (was %d)  %s->%s\n",
		    mcs_shm_p->serial, shm_settings_serial, 
		    rfm_options[i].name, rfm_options[i].value);
	    }
	
        }
        shm_settings_serial = mcs_shm_p->serial;
    } else {
        COMMENT("shm_settings_serial OK\n"); 
    }
    return TRUE;
}

static int
mcs_shm_fileread (void) {
    static gchar *rcfile = NULL;

    if(!rcfile) {
        rcfile = g_build_filename (MCS_SHM_PLUGIN_FILE, NULL);
    }

    if(rfm_g_file_test (rcfile, G_FILE_TEST_EXISTS)) {
        FILE *f;
        TRACE("mcs_shm_fileread(): %s\n", rcfile);
        f = fopen (rcfile, "r");
        if(f) {
            if(fread (mp->m, sizeof (mcs_shm_t), 1, f) == 0)
                g_warning ("fread: %s", strerror (errno));
            fclose (f);
        }
        msync (mp->m, sizeof (mcs_shm_t), MS_SYNC);
        return 1;
    } 
    return 0;
}

static int
mcs_shm_filewrite (void) {
    FILE *f;
    static gchar *rcfile = NULL;

    if(!rcfile) {
        rcfile = g_build_filename (MCS_SHM_PLUGIN_FILE, NULL);
    }
    TRACE ("mcs_shm_filewrite(): %s\n", rcfile);
    msync (mp->m, sizeof (mcs_shm_t), MS_SYNC);
    f = fopen (rcfile, "w");
    if(f) {
        mcs_shm_t *mcs_shm_p = (mcs_shm_t *) mp->m;
        mcs_shm_p->serial++;
        if(fwrite (mp->m, sizeof (mcs_shm_t), 1, f) < 1)
            g_warning ("fwrite: %s", strerror (errno));
        fclose (f);
        return 1;
    }
    msync (mp->m, sizeof (mcs_shm_t), MS_SYNC);
    return 0;
}

static void
mcs_shm_bringforth (void) {
    int i,
      j;
    mcs_shm_t *mcs_shm_p = (mcs_shm_t *) mp->m;
    COMMENT ("mcs_shm_bringforth\n");
    for(i = 0; i < RFM_OPTIONS; i++) {
        g_free (rfm_options[i].value);
        rfm_options[i].value = g_strdup ("");
    }
    for(i = 0; i < RFM_OPTIONS; i++){
        for(j = 0; j < RFM_OPTIONS; j++) {
            if(rfm_options[i].name && mcs_shm_p->data[j].name) {
                if(strcmp (rfm_options[i].name, mcs_shm_p->data[j].name))
                    continue;
                g_free (rfm_options[i].value);
                rfm_options[i].value = g_strdup (mcs_shm_p->data[j].value);
		if (strlen(rfm_options[i].value)) {
		    TRACE ("mcs_shm_bringforth:  %s->%s\n", 
			    rfm_options[i].name, rfm_options[i].value);
		}
                break;
            }
        }
    }
}

static void
mcs_shm_init (void) {
    int i;
    mcs_shm_t *mcs_shm_p = (mcs_shm_t *) mp->m;
    COMMENT ("mcs_shm_init\n");
    for(i = 0; i < RFM_OPTIONS; i++) {
        memset (mcs_shm_p->data[i].name, 0, SHM_STRING_LENGTH);
        memset (mcs_shm_p->data[i].value, 0, SHM_VALUE_LENGTH);
        strncpy (mcs_shm_p->data[i].name, rfm_options[i].name, SHM_STRING_LENGTH);
        if(rfm_options[i].value) {
            strncpy (mcs_shm_p->data[i].value, rfm_options[i].value, SHM_VALUE_LENGTH);
            mcs_shm_p->data[i].value[SHM_VALUE_LENGTH - 1] = 0;
        }
        COMMENT ("*SETTINGS: initialising %s->%s\n",
		rfm_options[i].name, rfm_options[i].value);
    }
    msync (mp->m, sizeof (mcs_shm_t), MS_SYNC);
}

static void
start_desktop (gboolean on) {
    // Automatic on/off is only applicable for local displays.
    if (!localhost_check()) {
	return;
    }

    Window xid;
    Display *display=gdk_x11_display_get_xdisplay(gdk_display_get_default());
    GError *error = NULL;
    if(on) {
        Atom selection_atom = XInternAtom (display, "RODENT_DESK_ATOM", False);
        if((xid = XGetSelectionOwner (display, selection_atom))) {
            TRACE ("start_desktop(): rodent-desk already running\n");
        } else if(!g_spawn_command_line_async ("rodent-desk", &error)) {
            g_warning ("start_desktop(): %s", error->message);
        } else {
	    TRACE("start_desktop(): rodent-desk\n");
	}
    } else {
        if(!g_spawn_command_line_async ("killall rodent-desk", &error)) {
            g_warning ("%s", error->message);
            g_error_free (error);
        }
    }

}

static void
mcs_manager_set_string (McsManager * mcs_m, 
	const gchar * setting_name, 
	const gchar * channel, 
	const gchar * setting_value) 
{
    mcs_shm_t *mcs_shm_p = (mcs_shm_t *) mp->m;
    int i;
    COMMENT ("mcs_manager_set_string\n");

    for(i = 0; i < RFM_OPTIONS; i++) {
        COMMENT ("%d/%d %s==%s?\n",
		i+1, RFM_OPTIONS, setting_name, mcs_shm_p->data[i].name);
        if(strcmp (setting_name, mcs_shm_p->data[i].name) == 0) {
            memset (mcs_shm_p->data[i].value, 0, SHM_VALUE_LENGTH);
            if(setting_value) {
              if(strlen (setting_value) > 0) {
		TRACE ("mcs_manager_set_string(): %s -> %s (%zd)",
		    setting_name, setting_value, strlen (setting_value));
	      }
              if(i == RFM_ENABLE_DESKTOP) {
                if(strlen (setting_value) > 0) {
                    TRACE ("mcs_manager_set_string(): Start desktop (%ld)\n",
			    (long)strlen (setting_value));
                    start_desktop (TRUE);
                } else {
                    TRACE ("mcs_manager_set_string(): Kill desktop (%ld)\n", 
			    (long)strlen (setting_value));
                    start_desktop (FALSE);
                }
              }

              strncpy (mcs_shm_p->data[i].value, setting_value, SHM_VALUE_LENGTH);
              mcs_shm_p->data[i].value[SHM_VALUE_LENGTH - 1] = 0;
              g_free (rfm_options[i].value);
              rfm_options[i].value = g_strdup (setting_value);
            }
        }
    }
    msync (mp->m, sizeof (mcs_shm_t), MS_SYNC);
    /* here we update the shmblock */
    return;
}

static void
mcs_manager_notify (McsManager * mcs_m, const gchar * channel) {
    /* here we ++ the shmblock serial (or something), this should be
     * monitored by other instances so that changes are ACK.*/
    COMMENT ("mcs_manager_notify\n");
    mcs_shm_t *mcs_shm_p = (mcs_shm_t *) mp->m;
    mcs_shm_p->serial++;
    msync (mp->m, sizeof (mcs_shm_t), MS_SYNC);
    mcs_shm_filewrite ();
    return;
}

/* the dialog ******************************************/
static void
add_spacer (GtkBox * box) {
    GtkWidget *eventbox = gtk_alignment_new (0, 0, 0, 0);

    gtk_widget_set_size_request (eventbox, SKIP, SKIP);
    gtk_widget_show (eventbox);
    gtk_box_pack_start (box, eventbox, FALSE, TRUE, 0);
}

static void update_tree (GtkTreeModel *model, gint id);

static gboolean
test_command(const gchar *command){
    if (!command) return FALSE;
    gchar *c=g_strdup(command);
    if (strchr(c, ' ')) *strchr(c, ' ') = 0;
    gchar *cmd = g_find_program_in_path (c);
    g_free(c);
    if (!cmd) return FALSE;
    g_free(cmd);
    return TRUE;
}

static gboolean
environment_changed (GtkCellRendererText * cell, 
	const gchar * path_string, 
	const gchar * new_text, 
	gpointer data) {
    settings_t *settings_p=data;
    if(settings_p->disable_options)
        return FALSE;

    GtkTreeModel *model = GTK_TREE_MODEL(settings_p->model);
    GtkTreePath *path = gtk_tree_path_new_from_string (path_string);
    GtkTreeIter iter;

    gint *column;

    column = g_object_get_data (G_OBJECT (cell), "column");

    gtk_tree_model_get_iter (model, &iter, path);

    if(GPOINTER_TO_INT (column) == COLUMN_VALUE) {
        COMMENT ("column=%d path=%s newtext=%s",
		GPOINTER_TO_INT (column), path_string, new_text);

        gint i;
        gchar *old_text;

        gtk_tree_model_get (model, &iter, column, &old_text, -1);
        g_free (old_text);
        old_text = NULL;
        i = gtk_tree_path_get_indices (path)[0];

        if(new_text && strlen (new_text) >= SHM_VALUE_LENGTH) {
            g_warning ("strlen($%s) <  %d not met. Ignoring it.", rfm_options[i].name, SHM_VALUE_LENGTH);
            gtk_list_store_set (GTK_LIST_STORE (model), &iter, column, rfm_options[i].value, -1);
            return FALSE;
        }
        /* test for valid commands */
        if(i == TERMINAL_CMD || i == EDITOR) {
            gboolean dump = FALSE;
            if(!new_text || !test_command(new_text)){
                    dump = TRUE;
            }
            if(dump) {
		
		gchar *g=g_strdup_printf("%s: Command not found", (new_text)?new_text:"");
		rfm_show_text(settings_p->widgets_p);
		rfm_diagnostics(settings_p->widgets_p, "xffm/stock_dialog-error", NULL);
		rfm_diagnostics(settings_p->widgets_p, "xffm_tag/stderr", g, "\n", NULL);
		g_free(g);
                gtk_list_store_set (GTK_LIST_STORE (model), &iter, column, rfm_options[i].value, -1);
                return FALSE;
            }
        }
        /* test for valid iconsizes */
        if(i == RFM_DEFAULT_ICON_SIZE) {
	    // New values entered in advanced mode: should they be
	    // input in translated or nontranslated form?
	    // Non translated, of course.
            gboolean dump = TRUE;
            if(new_text) {
		const gchar **p=icon_sizes_v;
		for (;p && *p; p++){
		    if (strcmp(*p, new_text) == 0){
			dump = FALSE; 
			break;
		    }
		}
            }
            if(dump) {
                gtk_list_store_set (GTK_LIST_STORE (model),
			&iter, column, rfm_options[i].value, -1);
                return FALSE;
            }
        }
        if(i == RFM_DIAGNOSTICS_FONT_SIZE) {
	    // New values entered in advanced mode: should they be
	    // input in translated or nontranslated form?
	    // Non translated, of course.
            gboolean dump = TRUE;
            if(new_text) {
		const gchar **p=font_sizes_v;
		for (;p && *p; p++){
		    if (strcmp(*p, new_text) == 0){
			dump = FALSE; 
			break;
		    }
		}
            }
            if(dump) {
                gtk_list_store_set (GTK_LIST_STORE (model),
			&iter, column, rfm_options[i].value, -1);
                return FALSE;
            }
        }

        if(rfm_options[i].value) {
            g_free (rfm_options[i].value);
            rfm_options[i].value = NULL;
        }
        if(new_text && strlen (new_text)) {
            rfm_options[i].value = g_strdup (new_text);
        } else {
            rfm_options[i].value = g_strdup ("");
        }
	COMMENT ("environment_changed:  %s->%s\n",
		rfm_options[i].name, rfm_options[i].value);
        gtk_list_store_set (GTK_LIST_STORE (model), &iter, column, rfm_options[i].value, -1);
        mcs_manager_set_string (mcs_manager, rfm_options[i].name, CHANNEL, rfm_options[i].value);
        mcs_manager_notify (mcs_manager, CHANNEL);
        /*write_options(); */
    }
    gtk_tree_path_free (path);

    return FALSE;
}

/* the dialog */
static void
dialog_delete (GtkWidget * dialog, gpointer data) {
    GError *error = NULL;
    if((int)((long)data) == 1) {
	// confirm
        g_spawn_command_line_async ("rodent-mime", &error);
    } else if((int)((long)data) == 2) {
        /* directory cache */
	gchar *t=g_strdup_printf("%s: %s",_("Restart"), rfm_global_p->argv[0]);
	if (rfm_confirm (NULL, GTK_MESSAGE_QUESTION, t, _("Cancel"), _("Restart"))){ 
          gchar *cache_dir = g_build_filename (RFM_CACHE_DIR, NULL);
          TRACE ("dialog_delete(): clearing directory cache: %s", cache_dir);
          gchar *command = g_strdup_printf ("rm -rf \"%s\"", cache_dir);
          g_spawn_command_line_async (command, &error);
          g_free (cache_dir);
          g_free (command);
          /* thumbnail cache */
          cache_dir = g_build_filename (RFM_THUMBNAIL_DIR, NULL);
          TRACE ("dialog_delete(): clearing image cache: %s", cache_dir);
          command = g_strdup_printf ("rm -rf \"%s\"", cache_dir);
          g_spawn_command_line_async (command, &error);
          g_free (cache_dir);
          g_free (command);
	  execvp(rfm_global_p->argv[0],rfm_global_p->argv);
	}
	g_free(t);
    }
    widgets_t *widgets_p=g_object_get_data(G_OBJECT(dialog), "widgets_p");
    if (widgets_p) {
        g_free(widgets_p->diagnostics);
	g_free(widgets_p);
    }
    g_object_set_data(G_OBJECT(dialog), "widgets_p", NULL);
    settings_t *settings_p=g_object_get_data(G_OBJECT(dialog), "settings_p");
    g_free(settings_p);
    g_object_set_data(G_OBJECT(dialog), "settings_p", NULL);
    settings_dialog=NULL;
    gtk_widget_destroy (dialog);
}

static void
update_combo (GtkComboBox * combo_box, gint id, gboolean translated) {
    const gchar *string=(translated)?_(rfm_options[id].value):rfm_options[id].value;
    GSList *list=g_object_get_data(G_OBJECT(combo_box), "list");
    GSList *tmp=list;
    gint item=0;
    for (;tmp && tmp->data; tmp=tmp->next, item++){
	if (strcmp(string, (gchar *)tmp->data)==0) {
	    break;
	}
    }

    // Is the string in the combobox list?
    gboolean in_combobox = (item < g_slist_length(list));
	// Yes. Then it must be selected.
    if (in_combobox) {
	gtk_combo_box_set_active (combo_box, item);
    } else {
	// No. The string is not in the combobox list, the string must
	// be inserted and selected.
	COMMENT("Adding %s\n",  string);
#if GTK_MAJOR_VERSION==2 && GTK_MINOR_VERSION<24
	gtk_combo_box_insert_text (combo_box, 0, string);
#else
	gtk_combo_box_text_insert_text (GTK_COMBO_BOX_TEXT(combo_box), 0, string);
#endif
	gtk_combo_box_set_active (combo_box, 0);
    }
}

static void
update_tree (GtkTreeModel *model, gint id) {
    GtkTreePath *treepath = gtk_tree_path_new_from_indices (id, -1);
    GtkTreeIter iter;
    if(gtk_tree_model_get_iter (model, &iter, treepath)) {
        gtk_list_store_set (GTK_LIST_STORE(model), &iter,
		COLUMN_VALUE, g_strdup (rfm_options[id].value), 
		COLUMN_EDITABLE, TRUE, -1);
    }
    gtk_tree_path_free (treepath);
}

gdouble get_spin_value(gint i){
    gdouble value;
    if (getenv(environ_v[i].env_var) && strlen(getenv(environ_v[i].env_var))) {
	value = atof(getenv(environ_v[i].env_var));
	COMMENT("got env_var=%s\n", getenv(environ_v[i].env_var));
    } else if (environ_v[i].env_string) {
	value = atof(environ_v[i].env_string);
	COMMENT("got env_string=%s\n", environ_v[i].env_string);
    }
    return value;
}

GtkWidget *toggle_button[RFM_OPTIONS];
static void
set_option_buttons ( settings_t *settings_p) {

    int i;
    settings_p->disable_options = TRUE;

    // spin buttons:
    for (i = RFM_DESKTOP_TOP_MARGIN; i <= RFM_DESKTOP_LEFT_MARGIN; i++){
	gdouble value = get_spin_value(i);
	gtk_spin_button_set_value (
		GTK_SPIN_BUTTON(settings_p->desktop_margin_spinbutton[i-RFM_DESKTOP_TOP_MARGIN]),
                value);
	update_tree (GTK_TREE_MODEL(settings_p->model), i);
    }

    for(i = 0; i < RFM_OPTIONS; i++)
        if(toggle_button[i]) {
            if(rfm_options[i].value && strlen (rfm_options[i].value)) {
                gtk_toggle_button_set_active ((GtkToggleButton *)
                                              toggle_button[i], TRUE);
            } else {
                gtk_toggle_button_set_active ((GtkToggleButton *)
                                              toggle_button[i], FALSE);
            }
            GtkTreePath *treepath = gtk_tree_path_new_from_indices (i, -1);
            GtkTreeIter iter;
            if(gtk_tree_model_get_iter (
			GTK_TREE_MODEL(settings_p->model), &iter, treepath))
	    {
                gtk_list_store_set (settings_p->model, &iter, 
			COLUMN_VALUE, g_strdup (rfm_options[i].value), 
			COLUMN_EDITABLE, TRUE, -1);
            }
            gtk_tree_path_free (treepath);
        }
#ifdef GNU_CP
    int index = 0;
    if(strcmp (rfm_options[VERSION_CONTROL].value, "numbered") == 0)
        index = 1;
    else if(strcmp (rfm_options[VERSION_CONTROL].value, "existing") == 0)
        index = 2;
    else if(strcmp (rfm_options[VERSION_CONTROL].value, "none") == 0)
        index = 3;
    else if(strcmp (rfm_options[VERSION_CONTROL].value, "simple")) {
        g_free (rfm_options[VERSION_CONTROL].value);
        rfm_options[VERSION_CONTROL].value = g_strdup ("simple");
    }
    gtk_combo_box_set_active (GTK_COMBO_BOX(settings_p->combo_box), index);
#endif
    update_combo (GTK_COMBO_BOX(settings_p->fontsize_box), RFM_DIAGNOSTICS_FONT_SIZE, TRUE);
    update_combo (GTK_COMBO_BOX(settings_p->iconsize_box), RFM_DEFAULT_ICON_SIZE, TRUE);
    update_combo (GTK_COMBO_BOX(settings_p->terminal_box), TERMINAL_CMD, FALSE);
    update_combo (GTK_COMBO_BOX(settings_p->editor_box), EDITOR, FALSE);
    if(getenv ("RFM_DESKTOP_DIR") && strlen (getenv ("RFM_DESKTOP_DIR"))) {
	COMMENT("set_option_buttons: setting %s\n",getenv ("RFM_DESKTOP_DIR"));
        gtk_entry_set_text (GTK_ENTRY (settings_p->desktopdir_entry), 
		getenv ("RFM_DESKTOP_DIR"));
    }
    if(getenv ("RFM_DESKTOP_IMAGE") && strlen (getenv ("RFM_DESKTOP_IMAGE"))) {
        gtk_file_chooser_set_filename (GTK_FILE_CHOOSER (settings_p->desktopimage_button),
		getenv ("RFM_DESKTOP_IMAGE"));
    } 
    if(getenv ("RFM_DESKTOP_COLOR") && strlen (getenv ("RFM_DESKTOP_COLOR"))) {
        GdkColor color;
        if(gdk_color_parse (getenv ("RFM_DESKTOP_COLOR"), &color)) {
            gtk_color_button_set_color (
		    GTK_COLOR_BUTTON(settings_p->desktopcolor_button), &color);
        }
    }
    if(getenv ("RFM_ICONVIEW_COLOR") && strlen (getenv ("RFM_ICONVIEW_COLOR"))) {
        GdkColor color;
        if(gdk_color_parse (getenv ("RFM_ICONVIEW_COLOR"), &color)) {
            gtk_color_button_set_color (
		    GTK_COLOR_BUTTON(settings_p->iconviewcolor_button), &color);
        }
    }

#ifdef GNU_CP
    update_tree (GTK_TREE_MODEL(settings_p->model), VERSION_CONTROL);
#endif
    update_tree (GTK_TREE_MODEL(settings_p->model),RFM_DIAGNOSTICS_FONT_SIZE );
    update_tree (GTK_TREE_MODEL(settings_p->model), RFM_DEFAULT_ICON_SIZE);
    update_tree (GTK_TREE_MODEL(settings_p->model), TERMINAL_CMD);
    update_tree (GTK_TREE_MODEL(settings_p->model), EDITOR);
    update_tree (GTK_TREE_MODEL(settings_p->model), RFM_DESKTOP_DIR);
    update_tree (GTK_TREE_MODEL(settings_p->model), RFM_DESKTOP_IMAGE);
    update_tree (GTK_TREE_MODEL(settings_p->model), RFM_DESKTOP_COLOR);



    settings_p->disable_options = FALSE;

}

static void
option_toggled (GtkToggleButton * togglebutton, gpointer user_data) {
    settings_t *settings_p=g_object_get_data(G_OBJECT(togglebutton), "settings_p");
    if(settings_p->disable_options)
        return;
    int i = (int)((long)user_data);

    if(rfm_options[i].value) {
        g_free (rfm_options[i].value);
    }
    if(gtk_toggle_button_get_active (togglebutton)) {
        rfm_options[i].value = g_strdup ("yes");
    } else {
        rfm_options[i].value = g_strdup ("");
    }
    mcs_manager_set_string (mcs_manager, rfm_options[i].name, 
	    CHANNEL, rfm_options[i].value);
    mcs_manager_notify (mcs_manager, CHANNEL);
    /*write_options(); */

}

static void
switch_page (GtkNotebook * notebook, GtkWidget * page, guint page_num, gpointer user_data) {
    settings_t *settings_p=g_object_get_data(G_OBJECT(notebook), "settings_p");
    //    if (page_num < )
    {
        COMMENT("pagenum=%d",page_num);
        set_option_buttons (settings_p);

    }
}

static void
gint_changed (GtkComboBox * combo_box, gint id) {
    settings_t *settings_p=g_object_get_data(G_OBJECT(combo_box), "settings_p");
    if(settings_p->disable_options){
        return;
    }
#if GTK_MAJOR_VERSION==2 && GTK_MINOR_VERSION<24
    gchar *gint_selected_translated = gtk_combo_box_get_active_text (combo_box);
#else
    gchar *gint_selected_translated = gtk_combo_box_text_get_active_text (GTK_COMBO_BOX_TEXT(combo_box));
#endif
    if (!gint_selected_translated) {
	g_warning("gint_changed(): this should never happen");
	return;
    }
    gchar *gint_selected=NULL;
    if (strcmp(_("Normal"), gint_selected_translated)==0){
	gint_selected=g_strdup("Normal");
    } else 
    if (strcmp(_("Compact"), gint_selected_translated)==0){
	gint_selected=g_strdup("Compact");
    } else 
    if (strcmp(_("Details"), gint_selected_translated)==0){
	gint_selected=g_strdup("Details");
    } else 
    if (strcmp(_("Big"), gint_selected_translated)==0){
	gint_selected=g_strdup("Big");
    } else 
    if (strcmp(_("Huge"), gint_selected_translated)==0){
	gint_selected=g_strdup("Huge");
    } else {
	gint_selected=g_strdup("");
    }

    if(rfm_options[id].value){
        g_free (rfm_options[id].value);
    }
    rfm_options[id].value = gint_selected;
    COMMENT ("gint_changed:  %s->%s\n", rfm_options[id].name, rfm_options[id].value);

    mcs_manager_set_string (mcs_manager, rfm_options[id].name, CHANNEL, gint_selected);
    mcs_manager_notify (mcs_manager, CHANNEL);
    rfm_show_text(settings_p->widgets_p);
    rfm_diagnostics(settings_p->widgets_p, "xffm/stock_dialog-info", NULL);
    rfm_diagnostics(settings_p->widgets_p, "xffm_tag/stderr", _("Please be patient"), ": ",
	    _("Reload All Tabs in All Windows"), ".  ", NULL);
    rfm_diagnostics(settings_p->widgets_p, "xffm_tag/blue", _("Default Size"), " --> ", gint_selected_translated, "\n",NULL);
    g_free(gint_selected_translated);
}

static void
path_changed (GtkComboBox * combo_box, gint id) {
    settings_t *settings_p=g_object_get_data(G_OBJECT(combo_box), "settings_p");
    if(settings_p->disable_options)
        return;
#if GTK_MAJOR_VERSION==2 && GTK_MINOR_VERSION<24
    gchar *path_selected = gtk_combo_box_get_active_text (combo_box);
#else
    gchar *path_selected = gtk_combo_box_text_get_active_text (GTK_COMBO_BOX_TEXT(combo_box));
#endif
    if(!test_command(path_selected)) {
        gchar *m = g_strdup_printf ("%s (%s): %s", strerror (ENOEXEC), path_selected,
                                    strerror (ENOENT));
        rfm_confirm (NULL, GTK_MESSAGE_ERROR, m, NULL, NULL);
        g_free (m);
        return;
    }

    if(rfm_options[id].value)
        g_free (rfm_options[id].value);
    rfm_options[id].value = path_selected;
    COMMENT ("path_changed:  %s->%s\n", rfm_options[id].name, rfm_options[id].value);

    mcs_manager_set_string (mcs_manager, rfm_options[id].name, CHANNEL, path_selected);
    mcs_manager_notify (mcs_manager, CHANNEL);
}

static void
terminal_changed (GtkComboBox * combo_box, gpointer user_data) {
    path_changed (combo_box, TERMINAL_CMD);
}

static void
editor_changed (GtkComboBox * combo_box, gpointer user_data) {
    path_changed (combo_box, EDITOR);
}

static void
 iconsize_changed(GtkComboBox * combo_box, gpointer user_data) {
     gint_changed (combo_box, RFM_DEFAULT_ICON_SIZE);
}

static void
 fontsize_changed(GtkComboBox * combo_box, gpointer user_data) {
   settings_t *settings_p=g_object_get_data(G_OBJECT(combo_box), "settings_p");
    if(settings_p->disable_options){
        return;
    }
#if GTK_MAJOR_VERSION==2 && GTK_MINOR_VERSION<24
    gchar *selected = gtk_combo_box_get_active_text (combo_box);
#else
    gchar *selected = gtk_combo_box_text_get_active_text (GTK_COMBO_BOX_TEXT(combo_box));
#endif
    if (!selected) {
	g_warning("fontsize_changed(): this should never happen");
	return;
    }
    if(rfm_options[RFM_DIAGNOSTICS_FONT_SIZE].value){
        g_free (rfm_options[RFM_DIAGNOSTICS_FONT_SIZE].value);
    }
    rfm_options[RFM_DIAGNOSTICS_FONT_SIZE].value = selected;
    COMMENT ("RFM_DIAGNOSTICS_FONT_SIZE:  %s->%s\n", 
	    rfm_options[RFM_DIAGNOSTICS_FONT_SIZE].name,
	    rfm_options[RFM_DIAGNOSTICS_FONT_SIZE].value);

    mcs_manager_set_string (mcs_manager, 
	    rfm_options[RFM_DIAGNOSTICS_FONT_SIZE].name,
	    CHANNEL, selected);
    mcs_manager_notify (mcs_manager, CHANNEL);
}

#ifdef GNU_CP
static void
combo_changed (GtkComboBox * combo_box, gpointer user_data) {
    settings_t *settings_p=g_object_get_data(G_OBJECT(combo_box), "settings_p");
    if(settings_p->disable_options)
        return;
    int i = (int)((long)VERSION_CONTROL);
    if(rfm_options[i].value)
        g_free (rfm_options[i].value);

#if GTK_MAJOR_VERSION==2 && GTK_MINOR_VERSION<24
    rfm_options[i].value = 
	g_strdup (gtk_combo_box_get_active_text (combo_box));
#else
    rfm_options[i].value = 
	g_strdup (gtk_combo_box_text_get_active_text (GTK_COMBO_BOX_TEXT(combo_box)));
#endif

    mcs_manager_set_string (mcs_manager, rfm_options[i].name, CHANNEL, rfm_options[i].value);
    mcs_manager_notify (mcs_manager, CHANNEL);
}
#endif

static void
deskdir_entry (GtkEntry * entry, gpointer user_data) {
    settings_t *settings_p=user_data;
    if(settings_p->disable_options) return;
    const gchar *new_value=gtk_entry_get_text(entry);
    if (new_value && strchr(new_value, '/') && new_value[strlen(new_value)-1]=='/')
    {
	gchar *v=g_strdup(new_value);
	*strrchr(v, '/')=0;
	gtk_entry_set_text(entry, v);
	g_free(v);
	new_value=gtk_entry_get_text(entry);
    }


    if (strcmp(new_value, rfm_options[RFM_DESKTOP_DIR].value)==0){
	return;
    }
    if(rfm_options[RFM_DESKTOP_DIR].value){
        g_free (rfm_options[RFM_DESKTOP_DIR].value);
    }
    rfm_options[RFM_DESKTOP_DIR].value = g_strdup(new_value);
    
    COMMENT ("2.file_set:  %s->%s\n", rfm_options[RFM_DESKTOP_DIR].name, rfm_options[RFM_DESKTOP_DIR].value);
    mcs_manager_set_string (mcs_manager, rfm_options[RFM_DESKTOP_DIR].name, 
	    CHANNEL, rfm_options[RFM_DESKTOP_DIR].value);
    mcs_manager_notify (mcs_manager, CHANNEL);
}

static void
deskdir_filechooser (GtkButton * button, gpointer user_data) {
    settings_t *settings_p = user_data;
    GtkWidget *dialog = gtk_file_chooser_dialog_new (
	    _("Select Folder"), 
	    NULL, //parent
            GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER,
            GTK_STOCK_CANCEL,
            GTK_RESPONSE_CANCEL,
            GTK_STOCK_OPEN,
            GTK_RESPONSE_ACCEPT,
            NULL);
    gtk_file_chooser_set_use_preview_label(GTK_FILE_CHOOSER (dialog), FALSE);
    gtk_file_chooser_set_preview_widget_active (GTK_FILE_CHOOSER (dialog), FALSE);
    // XXX gtk_file_chooser_set_show_hidden isn't working. Gtk bug or what?
    gtk_file_chooser_set_show_hidden(GTK_FILE_CHOOSER (dialog), TRUE);
    g_object_set(G_OBJECT(dialog), "show-hidden", TRUE, NULL);

    gtk_file_chooser_set_filename (GTK_FILE_CHOOSER (dialog), rfm_options[RFM_DESKTOP_DIR].value);

    if(gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT) {
        gchar *filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));
        COMMENT ("Got %s\n", filename);
	// if entry changed, set entry
	gtk_entry_set_text(GTK_ENTRY(settings_p->desktopdir_entry), filename);
	// entry activate callback, do your thing
	deskdir_entry (GTK_ENTRY(settings_p->desktopdir_entry), settings_p);
        g_free (filename);
    } 	
    gtk_widget_destroy (dialog);

}

static void
file_set (GtkFileChooserButton * chooser, gpointer user_data) {
    settings_t *settings_p=g_object_get_data(G_OBJECT(chooser), "settings_p");
    if(settings_p->disable_options)
        return;
    gint i = GPOINTER_TO_INT(user_data);
    gchar *g=gtk_file_chooser_get_filename (GTK_FILE_CHOOSER(chooser));
    COMMENT ("1.file_set:  %s->%s (got: %s)\n", rfm_options[i].name, rfm_options[i].value, g);

      
    if(rfm_options[i].value){
        g_free (rfm_options[i].value);
    }
    rfm_options[i].value = g;
    
    COMMENT ("2.file_set:  %s->%s\n", rfm_options[i].name, rfm_options[i].value);
    mcs_manager_set_string (mcs_manager, rfm_options[i].name, 
	    CHANNEL, rfm_options[i].value);
    mcs_manager_notify (mcs_manager, CHANNEL);
}

static void
value_clear(GtkButton * button, gpointer user_data){
    gint i=GPOINTER_TO_INT(user_data);
    if(rfm_options[i].value){
        g_free (rfm_options[i].value);
    }
    rfm_options[i].value = g_strdup("");
    
    COMMENT ("bg_image_clear:  %s->%s\n", rfm_options[i].name, rfm_options[i].value);
    mcs_manager_set_string (mcs_manager, rfm_options[i].name, 
	    CHANNEL, rfm_options[i].value);
    mcs_manager_notify (mcs_manager, CHANNEL);

}

static void
color_changed (GtkColorButton * chooser, gpointer user_data) {
    settings_t *settings_p=g_object_get_data(G_OBJECT(chooser), "settings_p");
    if(settings_p->disable_options)
        return;
    int i = (int)((long)user_data);
    if(rfm_options[i].value)
        g_free (rfm_options[i].value);
    GdkColor color;
    gtk_color_button_get_color ((GtkColorButton *) chooser, &color);
    rfm_options[i].value = gdk_color_to_string (&color);
    mcs_manager_set_string (mcs_manager, rfm_options[i].name, 
	    CHANNEL, rfm_options[i].value);
    mcs_manager_notify (mcs_manager, CHANNEL);
}


static void
command_help (GtkWidget * button, gpointer data) {
    GtkWidget *dialog=g_object_get_data(G_OBJECT(button), "dialog");
    widgets_t *widgets_p=g_object_get_data(G_OBJECT(dialog), "widgets_p");
    gchar *argv[]={data, "--help", NULL};
    rfm_show_text (widgets_p); 
    rfm_thread_run_argv_with_stderr (widgets_p, argv, FALSE, rfm_dump_output);
}


static void
rtfm (GtkWidget * button, gpointer data) {
    GtkWidget *dialog=g_object_get_data(G_OBJECT(button), "dialog");
    widgets_t *widgets_p=g_object_get_data(G_OBJECT(dialog), "widgets_p");
    gchar *argv[]={"man", data, NULL};
    rfm_show_text (widgets_p); 
    rfm_thread_run_argv_with_stderr (widgets_p, argv, FALSE, rfm_dump_output);
}

