/*  rfm_settings_dialog.c
 *
 *  Copyright (C) 2003-2012 edscott wilson garcia <edscott@xfce.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#define SETTINGS_MODULE_C

#include "rfm_libs.h"
#include "settings-module.h"

#ifndef RFM_MCS_PLUGIN
# define RFM_MCS_PLUGIN
#endif

// Change the channel when you change the Module directory...
#define CHANNEL  MODULE_DIR

#define BORDER 6
#define SKIP BORDER

static gboolean running=FALSE;

typedef struct {
    gchar *variable;
    gchar *value;
    gboolean editable;
} Item;

enum {
    COLUMN_VARIABLE,
    COLUMN_VALUE,
    COLUMN_EDITABLE,
    NUM_COLUMNS
};

typedef struct settings_t{
    widgets_t *widgets_p;
    GtkWidget *desktop_margin_spinbutton[4];
    GtkWidget *desktopcolor_button;
    GtkWidget *iconviewcolor_button;
    GtkWidget *desktopimage_button;
    GtkWidget *desktopdir_button;
    GtkWidget *desktopdir_entry;
    GtkWidget *combo_box;
    GtkWidget *fontsize_box;
    GtkWidget *iconsize_box;
    GtkWidget *terminal_box;
    GtkWidget *editor_box;
    GtkListStore *model;
    GtkWidget *dialog;
    gboolean disable_options;
    gboolean stable_deskdir; // XXX gtk+ bug workaround: see file_set()
}settings_t;
    
static GtkWidget *settings_dialog=NULL;
static gint shm_settings_serial = 0;
static gint settings_timer = 0;

LIBRFM_MODULE

/********************************************************/



static McsManager *mcs_manager = NULL;
static McsPlugin *mp = NULL;

void *localhost_check(void);
void *run_rfm_settings_dialog (void);
#include "settings-module.i"
//  
//


static void 
subtitle(GtkWidget *parent, GtkWidget *dialog, const gchar *text, gchar *button_command){
     
    GtkWidget *label_box=rfm_hbox_new(FALSE, 0);
    gtk_box_pack_start ((GtkBox *) parent, label_box, FALSE, FALSE, 0);
    gchar *tab_text = g_strdup_printf ("<b><i>%s</i></b>   ", text);
    GtkWidget *label = gtk_label_new (tab_text);
    gtk_label_set_use_markup (GTK_LABEL (label), TRUE);
    //gtk_frame_set_label_widget (GTK_FRAME (framebox), label);
    gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
    gtk_box_pack_start ((GtkBox *) label_box, label, FALSE, FALSE, 0);
    if (button_command){
	GtkWidget *button = rfm_dialog_button ("xffm/stock_help", NULL);
	g_object_set_data(G_OBJECT(button), "dialog", dialog);
	g_signal_connect (G_OBJECT (button), "clicked", G_CALLBACK (rtfm), button_command);
	gchar *g=g_strdup_printf("man %s", button_command);
	gtk_widget_set_tooltip_text(button, g);
	g_free(g);
	gtk_box_pack_start ((GtkBox *) label_box, button, FALSE, FALSE, 0);
	gtk_widget_show(button);
        gboolean do_help_button=FALSE;
#ifdef GNU_CP
        if (strcmp(button_command, "cp")==0) do_help_button=TRUE;
#endif
#ifdef GNU_LN
        if (strcmp(button_command, "ln")==0) do_help_button=TRUE;
#endif
#ifdef GNU_MV
        if (strcmp(button_command, "mv")==0) do_help_button=TRUE;
#endif
#ifdef GNU_RM
        if (strcmp(button_command, "rm")==0) do_help_button=TRUE;
#endif


        if (do_help_button) {
            button = rfm_dialog_button ("xffm/stock_dialog-question", NULL);
            g_object_set_data(G_OBJECT(button), "dialog", dialog);
            g_signal_connect (G_OBJECT (button), "clicked", G_CALLBACK (command_help), button_command);
            g=g_strdup_printf("%s --help", button_command);
            gtk_widget_set_tooltip_text(button, g);
            g_free(g);
            gtk_box_pack_start ((GtkBox *) label_box, button, FALSE, FALSE, 0);
            gtk_widget_show(button);
        }
    }
    gtk_widget_show_all (label_box);
    g_free(tab_text);
}

 
G_MODULE_EXPORT void *
module_active (void){
    return GINT_TO_POINTER(1);
}


G_MODULE_EXPORT
void *
localhost_check(void){
    gboolean auto_valid=FALSE;
    const gchar *display_env = getenv("DISPLAY");
    if (display_env){
	if (strncmp(display_env, ":0",strlen(":0"))==0) auto_valid=TRUE;
	else if (strncmp(display_env, "127.0.0.1:", strlen("127.0.0.1:"))==0)
	    auto_valid=TRUE;
	else if (strncmp(display_env, "localhost:", strlen("localhost:"))==0) 
	    auto_valid=TRUE;
	else {
	    gchar *g=g_strconcat(g_get_host_name(), ":", NULL);
	    if (strncmp(display_env, g, strlen(g))==0) auto_valid=TRUE;
	    g_free(g);
	}
    }
    TRACE("localhost_check(): %d DISPLAY=%s\n", 
	    auto_valid, display_env);
    return GINT_TO_POINTER(auto_valid);
}

static GtkWidget *
create_tab (GtkNotebook * notebook, char *label, char *frame_label) {
    GtkWidget *tab_label1 = gtk_label_new (label);
    gtk_widget_show (tab_label1);
    GtkWidget *page_box = rfm_vbox_new (FALSE, 6);
    GtkWidget *sw = gtk_scrolled_window_new (NULL, NULL);
    gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (sw), GTK_SHADOW_ETCHED_IN);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (sw), 
	    GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
    gtk_widget_show (sw);
    if(gtk_notebook_append_page (notebook, sw, tab_label1) < 0) {
        g_error ("Cannot append page to gtk_notebook!");
    }

    gtk_scrolled_window_add_with_viewport ((GtkScrolledWindow *) sw, page_box);
    gtk_widget_show (page_box);

    add_spacer (GTK_BOX (page_box));

    GtkWidget *header = gtk_label_new ("");
    gchar *g = g_strdup_printf("<b>%s</b>", frame_label);
    gtk_label_set_markup (GTK_LABEL(header), g);  
    g_free(g);
    GtkWidget *hbox = rfm_hbox_new(FALSE, 3);
    gtk_box_pack_start (GTK_BOX (page_box), hbox, FALSE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX (hbox), header, FALSE, FALSE, 0);
    GtkWidget *vbox = rfm_vbox_new (FALSE, 2);
    gtk_box_pack_start (GTK_BOX (page_box), vbox, FALSE, FALSE, 0);

    gtk_widget_show (vbox);
#if 0
    GtkWidget *frame = xfce_framebox_new (frame_label, TRUE);
    GtkWidget *frame = rfm_vbox_new (frame_label, TRUE);
    gtk_widget_show (frame);
    gtk_box_pack_start (GTK_BOX (page_box), frame, FALSE, FALSE, 0);

    GtkWidget *vbox = rfm_vbox_new (FALSE, 6);
    xfce_framebox_add (XFCE_FRAMEBOX (frame), vbox);
#endif
    return vbox;

}

static GtkWidget *
make_gint_combo_box (GtkWidget * vbox, gint id, const gchar **options, void *callback) {
#if GTK_MAJOR_VERSION==2 && GTK_MINOR_VERSION<24
    // this is deprecated...
    GtkWidget *box = gtk_combo_box_new_text ();
#else
    GtkWidget *box = gtk_combo_box_text_new ();
#endif
    int place = 0;
    GtkWidget *hbox = rfm_hbox_new (FALSE, 6);
    gchar *text;
    if (id == RFM_DEFAULT_ICON_SIZE) {
	text = g_strdup_printf("%s (%s)", 
		_(environ_v[id].env_text), _("Icons"));
    } else if (id == RFM_DIAGNOSTICS_FONT_SIZE) {
	text = g_strdup_printf("%s (%s)", 
		_(environ_v[id].env_text), _("Terminal Integration"));
    }  else {
	text = g_strdup(_(environ_v[id].env_text));
    }
    GtkWidget *label = gtk_label_new (text);
    g_free(text);
    gtk_box_pack_start (GTK_BOX(hbox), label, FALSE, FALSE, 0);
    GSList *list=NULL;

    const gchar **p=options;
    if(getenv (environ_v[id].env_var)
       && strlen (getenv (environ_v[id].env_var))) {
	for (;p && *p; p++){
	    if (strcmp(*p, environ_v[id].env_var)==0) {
#if GTK_MAJOR_VERSION==2 && GTK_MINOR_VERSION<24
		gtk_combo_box_insert_text (GTK_COMBO_BOX(box), 
			place++, _(environ_v[id].env_var));
#else
		 gtk_combo_box_text_insert_text (GTK_COMBO_BOX_TEXT(box), 
			place++, _(environ_v[id].env_var));
#endif
		list=g_slist_prepend(list, _(environ_v[id].env_var));
		break;
	    }
	}

    }
    
    for(p = options; *p; p++) {
       if(place == 0) {
	    /* default values. Null values are not functionally acceptable */
#if GTK_MAJOR_VERSION==2 && GTK_MINOR_VERSION<24
	    gtk_combo_box_insert_text (GTK_COMBO_BOX(box), place++, _(*p));
#else
	    gtk_combo_box_text_insert_text (GTK_COMBO_BOX_TEXT(box), place++, _(*p));
#endif
	    list=g_slist_prepend(list, (void *)_(*p));
	    if(!rfm_options[id].value || !strlen (rfm_options[id].value)) {
		g_free (rfm_options[id].value);
		rfm_options[id].value = g_strdup (_(*p));
		mcs_manager_set_string (mcs_manager, rfm_options[id].name,
			CHANNEL, *p);
		mcs_manager_notify (mcs_manager, CHANNEL);
	    }
	} else {
	    list=g_slist_append(list, (void *)_(*p));
#if GTK_MAJOR_VERSION==2 && GTK_MINOR_VERSION<24
	    gtk_combo_box_append_text (GTK_COMBO_BOX(box), _(*p));
#else
	    gtk_combo_box_text_append_text (GTK_COMBO_BOX_TEXT(box), _(*p));
#endif
	}
    }

    g_object_set_data(G_OBJECT(box), "list", list);
    gtk_combo_box_set_active (GTK_COMBO_BOX(box), 0);
    gtk_box_pack_start (GTK_BOX(hbox), box, FALSE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
    g_signal_connect (box, "changed", G_CALLBACK (callback), NULL);
    return box;
}

static GtkWidget *
make_exec_combo_box (GtkWidget * vbox, gint id, const gchar **options, void *callback) {
#if GTK_MAJOR_VERSION==2 && GTK_MINOR_VERSION<24
    GtkWidget *box = gtk_combo_box_new_text ();
#else
    GtkWidget *box = gtk_combo_box_text_new ();
#endif
    GtkWidget *hbox = rfm_hbox_new (FALSE, 6);
    GtkWidget *label = gtk_label_new (_(environ_v[id].env_text));
    gtk_box_pack_start (GTK_BOX(hbox), label, FALSE, FALSE, 0);
    GSList *list=NULL;
    gint place=0;

    if(getenv (environ_v[id].env_var)
       && strlen (getenv (environ_v[id].env_var))) {
        if(test_command(getenv (environ_v[id].env_var)) ){
	    gchar *path = g_strdup (getenv (environ_v[id].env_var));
#if GTK_MAJOR_VERSION==2 && GTK_MINOR_VERSION<24
            gtk_combo_box_insert_text (GTK_COMBO_BOX(box), place++, path);
#else
            gtk_combo_box_text_insert_text (GTK_COMBO_BOX_TEXT(box), place++, path);
#endif
	    list=g_slist_prepend(list, path);
	}
    }
    const gchar **p;
    for(p = options; *p; p++) {
        if(test_command(*p)) {
            if(place){
		list=g_slist_append(list, (void *)*p);
#if GTK_MAJOR_VERSION==2 && GTK_MINOR_VERSION<24
                gtk_combo_box_append_text (GTK_COMBO_BOX(box), (void *)*p);

#else
                gtk_combo_box_text_append_text (GTK_COMBO_BOX_TEXT(box), (void *)*p);
#endif
	    } else {
		list=g_slist_prepend(list, (void *)*p);
#if GTK_MAJOR_VERSION==2 && GTK_MINOR_VERSION<24
                gtk_combo_box_insert_text (GTK_COMBO_BOX(box), place++, *p);
#else
                gtk_combo_box_text_insert_text (GTK_COMBO_BOX_TEXT(box), place++, *p);
#endif
                if(!rfm_options[id].value || !strlen (rfm_options[id].value)) {
                    g_free (rfm_options[id].value);
		}
                rfm_options[id].value = g_strdup (*p);
                mcs_manager_set_string (mcs_manager, rfm_options[id].name,
			    CHANNEL, *p);
                mcs_manager_notify (mcs_manager, CHANNEL);
            } 
        }
    }

    g_object_set_data(G_OBJECT(box), "list", list);
    gtk_combo_box_set_active (GTK_COMBO_BOX(box), 0);
    gtk_box_pack_start (GTK_BOX(hbox), box, FALSE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
    g_signal_connect (box, "changed", G_CALLBACK (callback), NULL);
    return box;
}



static GtkWidget *
make_file_chooser_button (int id, gboolean is_folder, GtkWidget * hbox) {
    GtkWidget *label = gtk_label_new (_(environ_v[id].env_text));
    gtk_box_pack_start (GTK_BOX(hbox), label, FALSE, FALSE, 0);
    GtkWidget *button;
    if(is_folder) {
        button = gtk_file_chooser_button_new (_("Select a folder"), 
		GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER);
    } else {
        button = gtk_file_chooser_button_new (_("Select Files..."), 
		GTK_FILE_CHOOSER_ACTION_OPEN);
    }


    if (rfm_options[id].value && 
		rfm_g_file_test(rfm_options[id].value, G_FILE_TEST_EXISTS)){
	COMMENT(stderr, "1.make_file_chooser_button: setting %s->%s\n",rfm_options[id].name,rfm_options[id].value);
	if (rfm_g_file_test(rfm_options[id].value, G_FILE_TEST_IS_DIR)){
	    gtk_file_chooser_set_current_folder (
		GTK_FILE_CHOOSER (button), rfm_options[id].value);
	} else {
	    gtk_file_chooser_set_filename (
		GTK_FILE_CHOOSER (button), rfm_options[id].value);
	}
    } 
    gtk_file_chooser_button_set_title ((GtkFileChooserButton *) (button), 
	    (const gchar *)_(environ_v[id].env_text));
    gtk_file_chooser_button_set_width_chars ((GtkFileChooserButton *) button, 15);
    gtk_box_pack_start (GTK_BOX(hbox), button, FALSE, FALSE, 0);
     


    g_signal_connect (button, 
	    "file-set", G_CALLBACK (file_set), GINT_TO_POINTER(id));
    return button;
}

// This is a thread function, must have GDK mutex set for gtk commands...
static gpointer
thread_run_rfm_settings_dialog (gpointer data) {
    if (!running) return NULL;
    settings_t *settings_p=data;
GDK_THREADS_ENTER();
    settings_dialog = settings_p->dialog = 
	gtk_dialog_new_with_buttons (mp->caption,
                                          NULL, 0,
                                          //_("Clear History"), 2,
					  _("Icons"),
					  1, _("Close"), 0, NULL);
    g_object_set_data(G_OBJECT(settings_p->dialog), "settings_p", settings_p);
    widgets_t *widgets_p = (widgets_t *)malloc(sizeof(widgets_t));
    if (!widgets_p) g_error("malloc: %s", strerror(errno));
    settings_p->widgets_p = widgets_p;
    memset(widgets_p, 0, sizeof(widgets_t));
    g_object_set_data(G_OBJECT(settings_p->dialog), "widgets_p", widgets_p);
    gtk_window_stick(GTK_WINDOW (settings_p->dialog));
    gtk_window_set_keep_above(GTK_WINDOW (settings_p->dialog), TRUE);

    g_signal_connect (settings_p->dialog, 
	    "response", G_CALLBACK (dialog_delete), NULL);
    g_signal_connect (settings_p->dialog, 
	    "delete_event", G_CALLBACK (dialog_delete), NULL);
    g_signal_connect (settings_p->dialog, 
	    "destroy", G_CALLBACK (dialog_delete), NULL);
    //vbox = GTK_DIALOG (settings_p->dialog)->vbox;
#if 10
    int i;
    GtkTreeIter iter;
    GtkCellRenderer *renderer;
    GtkWidget *treeview;
    GtkWidget *label;
    GtkWidget *vbox = rfm_vbox_new (FALSE, 6);
    gtk_box_pack_start (
	    GTK_BOX (gtk_dialog_get_content_area(GTK_DIALOG (settings_p->dialog))), 
	    vbox, TRUE, TRUE, 0);
    gtk_widget_show(vbox);
    GtkWidget *hbox = rfm_hbox_new (FALSE, 6);
    gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, TRUE, 0);
    gtk_widget_show(hbox);

    /* Jazman's pretty header */
    //GtkWidget *header = xfce_create_header (mp->icon, mp->caption);
    GtkWidget *header = gtk_label_new ("");
    gtk_label_set_markup (GTK_LABEL(header), mp->caption);       
    GdkPixbuf *pixbuf = rfm_get_pixbuf("xffm/preferences_personal", 96);
    if (pixbuf){
	GtkWidget *image = gtk_image_new_from_pixbuf (pixbuf);
	gtk_box_pack_start (GTK_BOX (hbox), image, FALSE, TRUE, 0);
    }
    gtk_box_pack_start (GTK_BOX (hbox), header, FALSE, TRUE, 0);
    
    widgets_p->vpane = rfm_vpaned_new ();
    gtk_widget_show (widgets_p->vpane);
    gtk_box_pack_start (GTK_BOX (vbox), widgets_p->vpane, TRUE, TRUE, 0);
    gtk_paned_set_position (GTK_PANED (widgets_p->vpane), 1000);
    vbox = rfm_vbox_new (FALSE, 6);
    gtk_paned_pack1 (GTK_PANED (widgets_p->vpane), 
	    GTK_WIDGET (vbox), FALSE, TRUE);
    gtk_widget_show(vbox);

    widgets_p->diagnostics =
		    (GtkWidget **)malloc(sizeof(GtkWidget *));
    if (!widgets_p->diagnostics) g_error("malloc: %s", strerror(errno));
    *(widgets_p->diagnostics) = gtk_text_view_new ();
    GtkWidget *scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
    gtk_widget_show (scrolledwindow);
    gtk_widget_show (*(widgets_p->diagnostics));
    gtk_paned_pack2 (GTK_PANED (widgets_p->vpane), scrolledwindow, TRUE, TRUE);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow), 
	    GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

    gtk_container_add (GTK_CONTAINER (scrolledwindow), *(widgets_p->diagnostics));
    gtk_container_set_border_width (GTK_CONTAINER (*(widgets_p->diagnostics)), 2);
    gtk_widget_set_can_focus(*(widgets_p->diagnostics), FALSE);
    gtk_text_view_set_wrap_mode (GTK_TEXT_VIEW (*(widgets_p->diagnostics)), GTK_WRAP_WORD);
    gtk_text_view_set_cursor_visible (GTK_TEXT_VIEW (*(widgets_p->diagnostics)), FALSE);


    GtkNotebook *notebook = GTK_NOTEBOOK(gtk_notebook_new ());
    g_object_set_data(G_OBJECT(notebook), "settings_p", settings_p);
    gtk_notebook_set_scrollable (notebook, TRUE);
    gtk_notebook_popup_enable (notebook);
    gtk_box_pack_start (GTK_BOX (vbox), GTK_WIDGET (notebook), TRUE, TRUE, 0);

    ////////////////// General
    //
    vbox = create_tab (notebook, _("General"), _("General Options"));
    for(i = RFM_DOUBLE_CLICK_NAVIGATION; i <= RFM_ENABLE_LABEL_TIPS; i++) {

	if (i == RFM_USE_GTK_ICON_THEME) {
	    // barrier will deadlock here... rfm_request_barrier();
	    GtkIconTheme *icon_theme = gtk_icon_theme_get_default ();
	    GtkIconInfo *icon_info =
		gtk_icon_theme_lookup_icon(icon_theme, "folder", SIZE_DIALOG, 0);
	    if (icon_info) {
		const gchar *path = gtk_icon_info_get_filename(icon_info);
		GdkPixbuf *pixbuf=rfm_get_pixbuf(path, SIZE_DIALOG);
		GtkWidget *image=gtk_image_new_from_pixbuf(pixbuf);
		gchar *d=g_path_get_dirname(path);
		gchar *dd=g_path_get_dirname(d);
		g_free(d);
		d=g_path_get_dirname(dd);
		g_free(dd);
		gchar *themename=g_path_get_basename(d);
		g_free(d);
		gchar *label_text=g_strdup_printf("%s (%s)", 
			_(environ_v[i].env_text), themename);
		g_free(themename);
		toggle_button[i] = gtk_check_button_new_with_label (label_text);
		gtk_box_pack_start (GTK_BOX(vbox), toggle_button[i], FALSE, FALSE, 0);
		gtk_box_pack_start (GTK_BOX(vbox), image, FALSE, FALSE, 0);
	        gtk_icon_info_free (icon_info); 
		gchar *rodent_theme = g_strdup_printf("%s/%s/%s/%s",
			PACKAGE_DATA_DIR, "icons", "Rodent", "index.theme");
		if (!rfm_g_file_test(rodent_theme, G_FILE_TEST_EXISTS)){
		    gtk_widget_set_sensitive(toggle_button[i], FALSE);
		    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(toggle_button[i]), TRUE);
		}
		g_free(rodent_theme);	
	    } else {
		gchar *label_text=g_strdup_printf("%s (%s)",
			_(environ_v[i].env_text), _("none detected"));
		toggle_button[i] = gtk_check_button_new_with_label (label_text);
		gtk_widget_set_sensitive(toggle_button[i], FALSE);
		gtk_box_pack_start (GTK_BOX(vbox), toggle_button[i], FALSE, FALSE, 0);
	    }
	    //rfm_release_barrier();
	} else {
	    gchar *text;
	    if (i == RFM_CONTENT_FOLDER_ICONS) {
		text = g_strdup_printf("%s (%s)", 
		    _(environ_v[i].env_text), _("Content Type"));
	    } else if (i == RFM_ENABLE_TIPS) {
		text = g_strdup_printf("%s (%s)",
			_(environ_v[i].env_text), _("Icons"));
	    } else if (i == RFM_ENABLE_LABEL_TIPS) {
		text = g_strdup_printf("%s (%s)",
			_(environ_v[i].env_text), _("Labels"));
	    } else {
		text = g_strdup(_(environ_v[i].env_text));
	    }

	    toggle_button[i] = gtk_check_button_new_with_label (text);
	    g_free(text);
	    gtk_box_pack_start (GTK_BOX(vbox), toggle_button[i], FALSE, FALSE, 0);
	}
	g_object_set_data(G_OBJECT(toggle_button[i]), "settings_p", settings_p);
        g_signal_connect (toggle_button[i], 
		"toggled", G_CALLBACK (option_toggled), GINT_TO_POINTER(i));
    }

    settings_p->fontsize_box = 
	make_gint_combo_box (vbox, RFM_DIAGNOSTICS_FONT_SIZE, font_sizes_v, (void *)fontsize_changed);
    g_object_set_data(G_OBJECT(settings_p->fontsize_box), "settings_p", settings_p);

    settings_p->iconsize_box = 
	make_gint_combo_box (vbox, RFM_DEFAULT_ICON_SIZE, icon_sizes_v, (void *)iconsize_changed);
    g_object_set_data(G_OBJECT(settings_p->iconsize_box), "settings_p", settings_p);
    settings_p->terminal_box = 
	make_exec_combo_box (vbox, TERMINAL_CMD, terminals_v, (void *)terminal_changed);
    g_object_set_data(G_OBJECT(settings_p->terminal_box), "settings_p", settings_p);
    settings_p->editor_box = 
	make_exec_combo_box (vbox, EDITOR, editors_v, (void *)editor_changed);
    g_object_set_data(G_OBJECT(settings_p->editor_box), "settings_p", settings_p);
    ////
    hbox = rfm_hbox_new (FALSE, 6);
    label = gtk_label_new (_(environ_v[RFM_ICONVIEW_COLOR].env_text));
    gtk_box_pack_start (GTK_BOX(hbox), label, FALSE, FALSE, 0);
    settings_p->iconviewcolor_button = gtk_color_button_new ();
    if(getenv ("RFM_ICONVIEW_COLOR") && strlen (getenv ("RFM_ICONVIEW_COLOR"))) {
        GdkColor color;
        if(gdk_color_parse (getenv ("RFM_ICONVIEW_COLOR"), &color)) {
            gtk_color_button_set_color (
		    GTK_COLOR_BUTTON(settings_p->iconviewcolor_button), &color);
        }
    }
    gtk_color_button_set_title (GTK_COLOR_BUTTON(settings_p->iconviewcolor_button), 
	    (const gchar *) _(environ_v[RFM_ICONVIEW_COLOR].env_text));
    gtk_box_pack_start (GTK_BOX(hbox), settings_p->iconviewcolor_button, 
	    FALSE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
    g_object_set_data(G_OBJECT(settings_p->iconviewcolor_button), "settings_p", settings_p);
    g_signal_connect (settings_p->iconviewcolor_button, 
	    "color-set", G_CALLBACK (color_changed), 
	    GINT_TO_POINTER(RFM_ICONVIEW_COLOR));
    if(gtk_widget_is_composited (settings_p->dialog)) {
        hbox = rfm_hbox_new (FALSE, 6);
        label = gtk_label_new (_(environ_v[RFM_TRANSPARENCY].env_text));
        gtk_box_pack_start (GTK_BOX(hbox), label, FALSE, FALSE, 0);
        double transparency;
        if(getenv ("RFM_TRANSPARENCY") && strlen (getenv ("RFM_TRANSPARENCY"))) {
            errno = 0;
            transparency = strtod (getenv ("RFM_TRANSPARENCY"), NULL);
            if(errno != 0 || transparency < 0.0)
                transparency = 0.0;
            else if(transparency > 0.75)
                transparency = 0.75;
        }
        GtkWidget *transparency_slider = rfm_hscale_new_with_range (0.0, 0.75, 0.01);
	g_object_set_data(G_OBJECT(transparency_slider), "settings_p", settings_p);
        gtk_scale_set_digits (GTK_SCALE(transparency_slider), 2);
        gtk_range_set_value (GTK_RANGE(transparency_slider), transparency);
        gtk_box_pack_start (GTK_BOX(hbox), transparency_slider, TRUE, TRUE, 0);
        gtk_box_pack_start (GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
        g_signal_connect (transparency_slider, "change-value",
                          G_CALLBACK (transparency_changed), 
			  GINT_TO_POINTER(RFM_TRANSPARENCY));

    }

    gtk_widget_show_all (vbox);

    ///////////////////////// Desktop options
    gchar *tab_text = g_strdup_printf(" %s:", _("Options"));
    vbox = create_tab (notebook, _("Desktop"),  tab_text);
    g_free(tab_text);

    for(i = RFM_ENABLE_DESKTOP; i <= RFM_NAVIGATE_DESKTOP; i++) {
	gchar *text;
	if (i == RFM_NAVIGATE_DESKTOP) {
	    text = g_strdup_printf("%s (%s)", 
		_(environ_v[i].env_text), _("Allow"));
	} else if (i == RFM_ENABLE_DESKTOP) {
	    text = g_strdup_printf("%s (%s)", 
		_(environ_v[i].env_text), _("localhost"));
	} else {
	    text = g_strdup(_(environ_v[i].env_text));
	}
	toggle_button[i] = 
		gtk_check_button_new_with_label (text);
	g_free(text);
	
	g_object_set_data(G_OBJECT(toggle_button[i]), "settings_p", settings_p);
        g_signal_connect (toggle_button[i], 
		"toggled", G_CALLBACK (option_toggled), GINT_TO_POINTER(i));
        gtk_box_pack_start (GTK_BOX(vbox), toggle_button[i], FALSE, FALSE, 0);
	if (i==RFM_ENABLE_DESKTOP && !localhost_check()){
	    gtk_widget_set_sensitive(toggle_button[i], FALSE);
	}
    }

   // desktop image selection
    hbox = rfm_hbox_new (FALSE, 6);
    gtk_box_pack_start (GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
    settings_p->desktopimage_button = make_file_chooser_button (RFM_DESKTOP_IMAGE, FALSE, hbox);
    g_object_set_data(G_OBJECT(settings_p->desktopimage_button), "settings_p", settings_p);
    gchar *g=g_strdup_printf("%s (%s)", _("Clear"), _("Background image"));
    GtkWidget *clear_button = rfm_mk_little_button ("xffm/stock_clear",
	    clear_bgimage, settings_p, g);
    gtk_widget_show(clear_button);
    g_free(g);
    gtk_box_pack_start (GTK_BOX(hbox), clear_button, FALSE, FALSE, 0);
    g_signal_connect (clear_button, 
	    "clicked", G_CALLBACK (value_clear), 
	    GINT_TO_POINTER(RFM_DESKTOP_IMAGE));


    // desktop directory selection
    hbox = rfm_hbox_new (FALSE, 6);
    gtk_box_pack_start (GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
    label=gtk_label_new(_(environ_v[RFM_DESKTOP_DIR].env_text));
    settings_p->desktopdir_entry = gtk_entry_new();
    g_signal_connect (settings_p->desktopdir_entry, 
	    "activate", G_CALLBACK (deskdir_entry), settings_p);

    settings_p->desktopdir_button = 
	rfm_mk_little_button ("xffm/apps_file-manager",
	    deskdir_filechooser, settings_p, _("Select Folder"));
    g_object_set_data(G_OBJECT(settings_p->desktopdir_button), "settings_p", settings_p);
    gtk_box_pack_start (GTK_BOX(hbox), label, FALSE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX(hbox), settings_p->desktopdir_entry, FALSE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX(hbox), settings_p->desktopdir_button, FALSE, FALSE, 0);
    



     ////
    hbox = rfm_hbox_new (FALSE, 6);
    label = gtk_label_new (_(environ_v[RFM_DESKTOP_COLOR].env_text));
    gtk_box_pack_start (GTK_BOX(hbox), label, FALSE, FALSE, 0);
    settings_p->desktopcolor_button = gtk_color_button_new ();
    if(getenv ("RFM_DESKTOP_COLOR") && strlen (getenv ("RFM_DESKTOP_COLOR"))) {
        GdkColor color;
        if(gdk_color_parse (getenv ("RFM_DESKTOP_COLOR"), &color)) {
            gtk_color_button_set_color ((GtkColorButton *) settings_p->desktopcolor_button, &color);
        }
    }
    gtk_color_button_set_title ((GtkColorButton *) (settings_p->desktopcolor_button), (const gchar *)
                                _(environ_v[RFM_DESKTOP_COLOR].env_text));
    gtk_box_pack_start (GTK_BOX(hbox), settings_p->desktopcolor_button, FALSE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
    g_object_set_data(G_OBJECT(settings_p->desktopcolor_button), "settings_p", settings_p);
    g_signal_connect (settings_p->desktopcolor_button, 
	    "color-set", G_CALLBACK (color_changed), GINT_TO_POINTER(RFM_DESKTOP_COLOR));

    // spin buttons: margins
    for (i = RFM_DESKTOP_TOP_MARGIN; i <= RFM_DESKTOP_LEFT_MARGIN; i++){
	hbox = rfm_hbox_new (FALSE, 6);
	label = gtk_label_new (_(environ_v[i].env_text));
	gtk_box_pack_start (GTK_BOX(hbox), label, FALSE, FALSE, 0);
	settings_p->desktop_margin_spinbutton[i-RFM_DESKTOP_TOP_MARGIN] =
	    gtk_spin_button_new_with_range (0.0, 200.0, 1.0);
	gdouble value = get_spin_value(i);

	gtk_spin_button_set_value (
		GTK_SPIN_BUTTON(settings_p->desktop_margin_spinbutton[i-RFM_DESKTOP_TOP_MARGIN]),
                value);
	gtk_box_pack_start (GTK_BOX(hbox), settings_p->desktop_margin_spinbutton[i-RFM_DESKTOP_TOP_MARGIN], FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
	g_object_set_data(
		G_OBJECT(settings_p->desktop_margin_spinbutton[i-RFM_DESKTOP_TOP_MARGIN]),
		"settings_p", settings_p);
	g_object_set_data(
		G_OBJECT(settings_p->desktop_margin_spinbutton[i-RFM_DESKTOP_TOP_MARGIN]),
		"which_margin", GINT_TO_POINTER(i));
        g_signal_connect (settings_p->desktop_margin_spinbutton[i-RFM_DESKTOP_TOP_MARGIN], 
    	    "value-changed", G_CALLBACK (margin_changed), GINT_TO_POINTER(i));
    }


    //////////////////////// Copy options
    gchar *tab_label=g_strdup_printf("%s/%s", _("Copy"), _("Move"));
    tab_text = g_strdup_printf(" %s:", _("Options"));
    vbox = create_tab (notebook, tab_label, tab_text);
    g_free(tab_label);
    g_free(tab_text);

    subtitle(vbox, settings_dialog, _("Copy"), "cp");

    for(i = RFM_CP_A; i <= RFM_CP_HH; i++)
    {
        toggle_button[i] = gtk_check_button_new_with_label (_(environ_v[i].env_text));
	g_object_set_data(G_OBJECT(toggle_button[i]), "settings_p", settings_p);
        g_signal_connect (toggle_button[i], 
		"toggled", G_CALLBACK (option_toggled), GINT_TO_POINTER(i));
        gtk_box_pack_start (GTK_BOX(vbox), toggle_button[i], FALSE, FALSE, 0);
    }

    tab_text = g_strdup_printf("%s", _("Move"));
    subtitle(vbox, settings_dialog, tab_text, "mv");
    g_free(tab_text);
#ifdef GNU_CP
    for(i = RFM_MV_B; i <= RFM_MV_N; i++)
#else
    for(i = RFM_MV_N; i <= RFM_MV_N; i++)
#endif
    {
        toggle_button[i] = gtk_check_button_new_with_label (_(environ_v[i].env_text));
	g_object_set_data(G_OBJECT(toggle_button[i]), "settings_p", settings_p);
        g_signal_connect (toggle_button[i], 
		"toggled", G_CALLBACK (option_toggled), GINT_TO_POINTER(i));
        gtk_box_pack_start (GTK_BOX(vbox), toggle_button[i], FALSE, FALSE, 0);
    }


    subtitle(vbox, settings_dialog, _("Symbolic Link"), "ln");
    for(i = RFM_LN_S; i <= RFM_LN_N; i++)
    {
        toggle_button[i] = gtk_check_button_new_with_label (_(environ_v[i].env_text));
	g_object_set_data(G_OBJECT(toggle_button[i]), "settings_p", settings_p);
        g_signal_connect (toggle_button[i], 
		"toggled", G_CALLBACK (option_toggled), GINT_TO_POINTER(i));
        gtk_box_pack_start (GTK_BOX(vbox), toggle_button[i], FALSE, FALSE, 0);
    }

    tab_text = g_strdup_printf("%s/%s/%s", _("Copy"), _("Move"), _("Symbolic Link"));
    subtitle(vbox, settings_dialog, tab_text, NULL);
    g_free(tab_text);
#ifdef GNU_CP
    //Version control
    hbox = rfm_hbox_new (FALSE, 6);
    label = gtk_label_new (_(environ_v[i].env_text));
    gtk_box_pack_start (GTK_BOX(hbox), label, FALSE, FALSE, 0);


#if GTK_MAJOR_VERSION==2 && GTK_MINOR_VERSION<24
    settings_p->combo_box = gtk_combo_box_new_text ();
    g_object_set_data(G_OBJECT(settings_p->combo_box), "settings_p", settings_p);    gtk_combo_box_insert_text (GTK_COMBO_BOX(settings_p->combo_box), 0, "simple");
    gtk_combo_box_append_text (GTK_COMBO_BOX(settings_p->combo_box), "numbered");
    gtk_combo_box_append_text (GTK_COMBO_BOX(settings_p->combo_box), "existing");
    gtk_combo_box_append_text (GTK_COMBO_BOX(settings_p->combo_box), "none");
#else
    settings_p->combo_box = gtk_combo_box_text_new ();
    g_object_set_data(G_OBJECT(settings_p->combo_box), "settings_p", settings_p);    gtk_combo_box_text_insert_text (GTK_COMBO_BOX_TEXT(settings_p->combo_box), 0, "simple");
    gtk_combo_box_text_append_text (GTK_COMBO_BOX_TEXT(settings_p->combo_box), "numbered");
    gtk_combo_box_text_append_text (GTK_COMBO_BOX_TEXT(settings_p->combo_box), "existing");
    gtk_combo_box_text_append_text (GTK_COMBO_BOX_TEXT(settings_p->combo_box), "none");
#endif
    gtk_box_pack_start (GTK_BOX(hbox), settings_p->combo_box, FALSE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX(vbox), hbox, FALSE, FALSE, 0);

    g_signal_connect (settings_p->combo_box, 
	    "changed", G_CALLBACK (combo_changed), GINT_TO_POINTER(VERSION_CONTROL));
#endif    
    for(i = RFM_CP_VERBOSE; i <=RFM_CP_VERBOSE ; i++)
    {
        toggle_button[i] = gtk_check_button_new_with_label (_(environ_v[i].env_text));
	g_object_set_data(G_OBJECT(toggle_button[i]), "settings_p", settings_p);
        g_signal_connect (toggle_button[i], 
		"toggled", G_CALLBACK (option_toggled), GINT_TO_POINTER(i));
        gtk_box_pack_start (GTK_BOX(vbox), toggle_button[i], FALSE, FALSE, 0);
    }

    gtk_widget_show_all (vbox);

    //////////////////////// remove/shred options
#ifdef GNU_SHRED
    tab_label=g_strdup_printf("%s/%s", _("Delete"), _("Shred"));
#else
    tab_label=g_strdup_printf("%s", _("Delete"));
#endif
    tab_text = g_strdup_printf(" %s:", _("Options"));

    vbox = create_tab (notebook, tab_label, tab_text);
    g_free(tab_label);
    g_free(tab_text);

    subtitle(vbox, settings_dialog, _("Delete"), "rm");

#ifdef GNU_RM
    for(i = RFM_RM_ONE_FILE_SYSTEM; i <= RFM_RM_VERBOSE; i++) 
#else
    for(i = RFM_RM_VERBOSE; i <= RFM_RM_VERBOSE; i++) 
#endif
    {
        toggle_button[i] = gtk_check_button_new_with_label (_(environ_v[i].env_text));
	g_object_set_data(G_OBJECT(toggle_button[i]), "settings_p", settings_p);
        g_signal_connect (toggle_button[i], 
		"toggled", G_CALLBACK (option_toggled), GINT_TO_POINTER(i));
        gtk_box_pack_start (GTK_BOX(vbox), toggle_button[i], FALSE, FALSE, 0);
    }

#ifdef GNU_SHRED
    subtitle(vbox, settings_dialog, _("Shred"), "shred");


    for(i = RFM_SHRED_REMOVE; i <= RFM_SHRED_VERBOSE; i++) {
        toggle_button[i] = gtk_check_button_new_with_label (_(environ_v[i].env_text));
	g_object_set_data(G_OBJECT(toggle_button[i]), "settings_p", settings_p);
        g_signal_connect (toggle_button[i], "toggled", 
		G_CALLBACK (option_toggled), GINT_TO_POINTER(i));
        gtk_box_pack_start (GTK_BOX(vbox), toggle_button[i], FALSE, FALSE, 0);
    }
#endif
    gtk_widget_show_all (vbox);

    ///////////////////////////
    //    advanced options (environment variables)
    ///////////////////////////
     vbox = create_tab (notebook, _("Advanced options"),
               _("Edit the list of environment variables and associated values"));

    GtkWidget *sw = gtk_scrolled_window_new (NULL, NULL);
    gtk_widget_set_size_request(sw, -1 , 275);
    gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (sw), GTK_SHADOW_ETCHED_IN);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (sw), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
    gtk_widget_show (sw);
    gtk_box_pack_start (GTK_BOX (vbox), sw, TRUE, TRUE, 0);

    settings_p->model = gtk_list_store_new (NUM_COLUMNS, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_BOOLEAN);
    for(i = 0; i < RFM_OPTIONS; i++) {
        gtk_list_store_append (settings_p->model, &iter);
        gtk_list_store_set (settings_p->model, &iter,
                            COLUMN_VARIABLE,
                            g_strdup (rfm_options[i].name),
                            COLUMN_VALUE, g_strdup (rfm_options[i].value),
			    COLUMN_EDITABLE, TRUE, -1);
    }
    treeview = gtk_tree_view_new_with_model (GTK_TREE_MODEL (settings_p->model));
    g_object_unref (G_OBJECT (settings_p->model));
    gtk_tree_view_set_rules_hint (GTK_TREE_VIEW (treeview), TRUE);
    gtk_tree_selection_set_mode (gtk_tree_view_get_selection (GTK_TREE_VIEW (treeview)), 
	    GTK_SELECTION_SINGLE);
    /* variable column */
    renderer = gtk_cell_renderer_text_new ();
    g_signal_connect (G_OBJECT (renderer), "edited", G_CALLBACK (environment_changed), settings_p);
    g_object_set_data (G_OBJECT (renderer), "column", (gint *) COLUMN_VARIABLE);

    gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (treeview),
                                                 -1, _("Variable"), renderer, "text", 
						 COLUMN_VARIABLE, NULL);
    /* value column */
    renderer = gtk_cell_renderer_text_new ();
    g_signal_connect (G_OBJECT (renderer), "edited", G_CALLBACK (environment_changed), settings_p);
    g_object_set_data (G_OBJECT (renderer), "column", (gint *) COLUMN_VALUE);

    gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (treeview),
                                                 -1, _("Value"), renderer, "text", 
						 COLUMN_VALUE, "editable", 
						 COLUMN_EDITABLE, NULL);

    gtk_widget_set_size_request (treeview, 300, 200);
    gtk_widget_show (treeview);
    gtk_container_add (GTK_CONTAINER (sw), treeview);

    set_option_buttons (settings_p);
    g_signal_connect (notebook, "switch-page", G_CALLBACK (switch_page), NULL);

    gtk_widget_set_size_request (settings_p->dialog, 550, 500);
    gtk_window_set_decorated (GTK_WINDOW (settings_p->dialog), TRUE);
    gtk_window_set_type_hint (GTK_WINDOW (settings_p->dialog), GDK_WINDOW_TYPE_HINT_NORMAL);
    gtk_window_set_destroy_with_parent (GTK_WINDOW (settings_p->dialog), TRUE);
    gtk_window_stick (GTK_WINDOW (settings_p->dialog));
    gchar *title = g_strdup_printf ("%s %s (%s)",
            PACKAGE_NAME, TAG, _("Personal settings"));
    gtk_window_set_title (GTK_WINDOW (settings_p->dialog), title);
    g_free (title);
    GdkPixbuf *icon_pixbuf = rfm_get_pixbuf ("xffm/stock_preferences", SIZE_ICON);
    if(icon_pixbuf) {
        gtk_window_set_icon (GTK_WINDOW (settings_p->dialog), icon_pixbuf);
    }

#endif
    gtk_widget_show_all (settings_p->dialog);
GDK_THREADS_LEAVE();
    return (void *)(settings_p->dialog);
}


G_MODULE_EXPORT 
void *
run_rfm_settings_dialog (void){
    // only one should be allowed at a time (for the time being)
    if (settings_dialog) {
	gtk_window_deiconify (GTK_WINDOW(settings_dialog));
	gtk_window_stick (GTK_WINDOW(settings_dialog));     
	gtk_window_set_keep_above  (GTK_WINDOW(settings_dialog), TRUE);
	return NULL;
    }
    settings_t *settings_p=(settings_t *)malloc(sizeof(settings_t));
    if (!settings_p) g_error("malloc: %s", strerror(errno));
    memset(settings_p, 0, sizeof(settings_t));
    THREAD_CREATE(thread_run_rfm_settings_dialog, settings_p, "thread_run_rfm_settings_dialog");
    return GINT_TO_POINTER(1);
}

G_MODULE_EXPORT 
void *
mcs_set_var (const gchar * setting_name, const gchar * setting_value) {
    if (!running) return NULL;
    DBG ("mcs_set_var(): %s -> %s\n", setting_name, setting_value);
    mcs_manager_set_string (mcs_manager, setting_name, CHANNEL, setting_value);
    mcs_manager_notify (mcs_manager, CHANNEL);
    return GINT_TO_POINTER (1);
}

G_MODULE_EXPORT 
void *
mcs_shm_stop (void) {
    if (!running) return NULL;
    TRACE ("mcs_shm_stop().\n");
    if(mp) {
        munmap (mp->m, sizeof (mcs_shm_t));
    }
    shm_settings_serial = -1;
    return GINT_TO_POINTER (1);
}

G_MODULE_EXPORT 
void *
mcs_shm_start (void) {
    COMMENT(stderr, "mcs_shm_start().\n");
    gchar *shm_settings_file = g_strdup_printf ("/%d-%s", (int)getuid (), MCS_FILE_NAME);
    if(!mp) {
        int i;
        COMMENT(stderr, "starting instance of mcs-shm\n");
        mp = (McsPlugin *) malloc (sizeof (McsPlugin));
	if (!mp) g_error("malloc: %s", strerror(errno));
        memset (mp, 0, sizeof (McsPlugin));
        mp->manager = (McsManager *) malloc (sizeof (McsManager));
	if (!mp->manager) g_error("malloc: %s", strerror(errno));
        memset (mp->manager, 0, sizeof (McsManager));
        mcs_manager = mp->manager;
        mp->plugin_name = g_strdup (CHANNEL);
        mp->caption = g_strdup_printf ("<b><big>%s\n%s %s</big>\n(<i>%s %s</i>)</b>",
		 _("Personal settings"), PACKAGE_NAME, VERSION, TAG, BUILD);
        //mp->run_dialog = run_rfm_settings_dialog;
	//
	// This will start the icon module, if present.
	//
        mp->icon = rfm_get_pixbuf ("xffm/stock_preferences", 48);

        COMMENT(stderr, "shm_open %s\n", shm_settings_file);
        mp->shm = shm_open (shm_settings_file, O_RDWR, 0700);
        if(mp->shm < 0) {
            COMMENT(stderr, "shm_open failed, now creating...\n");
            mcs_shm_t *mcs_shm_p;
            mp->shm = shm_open (shm_settings_file, O_CREAT | O_RDWR, 0700);
            if(mp->shm < 0) {
                free (mp->manager);
                free (mp);
                mp = NULL;
                return NULL;
            }
            if(ftruncate (mp->shm, sizeof (mcs_shm_t)) < 0)
                g_warning ("ftruncate: %s", strerror (errno));

            mp->m = mmap (0, sizeof (mcs_shm_t), PROT_READ | PROT_WRITE, MAP_SHARED, mp->shm, 0);
            memset (mp->m, 0, sizeof (mcs_shm_t));
            mcs_shm_p = (mcs_shm_t *) mp->m;

            mcs_shm_p->serial = 1;
            if(mcs_shm_fileread ()) {
                mcs_shm_bringforth ();
            } else {
                mcs_shm_init ();
            }

            msync (mp->m, sizeof (mcs_shm_t), MS_SYNC);
            COMMENT(stderr, "creating new shm block\n");
        } else {
            COMMENT(stderr, "using preexisting shm block\n");
            mp->m = mmap (0, sizeof (mcs_shm_t), PROT_READ | PROT_WRITE, MAP_SHARED, mp->shm, 0);
            mcs_shm_bringforth ();
        }

        /* read environment... */
        COMMENT(stderr, "read environment\n");
        for(i = 0; i < RFM_OPTIONS; i++) {
	    COMMENT(stderr, "environment %s -> %s\n", 
		    rfm_options[i].name, getenv(rfm_options[i].name));
            {
                mcs_shm_t *mcs_shm_p = (mcs_shm_t *) mp->m;
                if(mcs_shm_p->data[i].value) {
		    if (strlen(mcs_shm_p->data[i].value)) {
			TRACE("mcs_shm_start(): setting %s from hardcode to %s\n",
			    rfm_options[i].name, mcs_shm_p->data[i].value);
		    }
                    g_free (rfm_options[i].value);

		    rfm_options[i].value = 
			    g_strdup (mcs_shm_p->data[i].value);
                    rfm_setenv (rfm_options[i].name, rfm_options[i].value, TRUE);
                } else {
#if 0
		    // if default value is null, try to get it from the current
		    // environment...
		    if (getenv("rfm_options[i].name")){
			rfm_setenv (rfm_options[i].name, "rfm_options[i].name", TRUE);
		    } else {	
			rfm_setenv (rfm_options[i].name, NULL, TRUE);
		    }
 		    DBG("mcs_shm_start(): setting %s from environment\n",
			    rfm_options[i].name);
#endif
               }
		COMMENT(stderr, "mcs_shm_start:  %s->%s\n", rfm_options[i].name, rfm_options[i].value);
            }
        }

    }
    //
    // Here we add a main thread timeout event for settings_monitor()
    //
    mcs_shm_t *mcs_shm_p = NULL;
    if(mp) {
        mcs_shm_p = (mcs_shm_t *) mp->m;
        shm_settings_serial = mcs_shm_p->serial;
        settings_timer = g_timeout_add (SETTINGS_TIMERVAL, settings_monitor, NULL);
    }
    TRACE ("mcs_shm_start(%s): mcs_shm_p->serial=%d\n", 
	    shm_settings_file,
	    (mcs_shm_p)?mcs_shm_p->serial:0);
    g_free(shm_settings_file);

    running=TRUE;
    return mp;
}

G_MODULE_EXPORT 
const gchar *
g_module_check_init (GModule * module) {
    static gsize initialized = 0;
    if (g_once_init_enter (&initialized)){
        TRACE ("g_module_check_init(): g_once_init_enter().\n");
        int i;
        for(i = 0; i < RFM_OPTIONS; i++) {
            COMMENT(stderr, "g_module_check_init():%d/%d  %s <-> %s <-> %s\n", i+1, RFM_OPTIONS, environ_v[i].env_var, environ_v[i].env_string, environ_v[i].env_text);

            rfm_options[i].name = environ_v[i].env_var;
            if(environ_v[i].env_string){
                rfm_options[i].value = g_strdup (environ_v[i].env_string);
	    } else {
		if (i==RFM_DESKTOP_DIR) {
		    rfm_options[i].value = 
			g_build_filename (DEFAULT_DESKTOP_DIR, NULL);
		} else {	
		    rfm_options[i].value = NULL;
		}
	    }
            COMMENT(stderr, "g_module_check_init:  %s->%s\n", rfm_options[i].name, rfm_options[i].value);
        }
	g_once_init_leave (&initialized, 1);
    }
    mcs_shm_start ();
    return NULL;
}
