/*
 * 
 * Copyright 2003-2012 under GNU/GPL v3 or later, which means what it means.
 * Edscott Wilson Garcia 
 *
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


#include "rodent_libs.h"
/* this should be first 2 lines after headers: */
G_MODULE_EXPORT LIBRFM_MODULE 

/* Public */
gint
m_make_overwrite_dialog (widgets_t * widgets_p, const gchar * target, const gchar * src);

void *
m_cp (void *p);

void *
m_mk_text_entry (view_t *view_p, const population_t *population_p, void *caso_p);

void *
m_remove (void *p);

/* Private */
#include "ops.i"

/////////////////////////////////
gint
m_make_overwrite_dialog (widgets_t * widgets_p, const gchar * target, const gchar * src) {
    struct stat st;
    lstat (target, &st);
    gchar *mess;
    gchar *ss1 = rfm_time_to_string (st.st_mtime);
    gchar *ss2 = rfm_sizetag ((off_t) st.st_size, -1);
    if(src) {
        struct stat s_st;
        if(lstat (src, &s_st) < 0) {
            g_warning ("cannot stat %s", src);
        }
        gchar *s1 = rfm_time_to_string (s_st.st_mtime);
        gchar *s2 = rfm_sizetag ((off_t) s_st.st_size, -1);
        gchar *t1 = rfm_utf_string (target);
        gchar *t2 = rfm_utf_string (src); 

        mess = g_strdup_printf ("%s:\n%s\n(%s %s)\n--->\n%s\n(%s %s)",
                _("Overwrite"), 
                t2, s1, s2,
                t1, ss1, ss2);
        g_free (s1);
        g_free (s2);
        g_free (t1);
        g_free (t2);
    } else {
        mess = g_strdup_printf ("%s\n(%s %s)", target, ss1, ss2);
    }

    g_free (ss1);
    g_free (ss2);

    gint result = rfm_confirm (widgets_p, 
	GTK_MESSAGE_WARNING,  
	mess, 
        _("Cancel"), // if NULL, button not shown
	NULL   // if NULL, "Ok" button shown
	);
    g_free(mess);
    return result;
}

void *
m_cp (void *p) {
    void **arg = p;
    gint mode = GPOINTER_TO_INT(arg[0]);
    widgets_t *widgets_p = arg[1];
    GList * in_list = arg[2];
    const gchar *target_path = arg[3];

    GSList *verified_list = NULL;
    TRACE ("CPY: rodent_cp\n");
    verify_list (widgets_p, in_list, &verified_list, target_path);
    if(verified_list == NULL) {
        TRACE ("CPY: verified_list == NULL\n");
	g_free(p);
        return GINT_TO_POINTER(FALSE);
    }

    private_rodent_cp (mode, widgets_p, &verified_list, target_path);
    g_free(p);
    return GINT_TO_POINTER(TRUE);
}


/* entry function: */
void *
m_mk_text_entry (view_t *view_p, const population_t *population_p, void *caso_p) {
    gint caso = GPOINTER_TO_INT(caso_p);

    GtkWidget *entry;
    GtkWidget *hbox;

    widgets_t *widgets_p=&(view_p->widgets);
    
    GdkRectangle frame_extent;
    GdkRectangle window_extent;

    gint delta_y;
    gint delta_h;
    gint y_offset;
    gdk_window_get_position (gtk_widget_get_window(widgets_p->window), 
    	&window_extent.x, &window_extent.y);
    Drawable drawable = 
        GDK_WINDOW_XID(gtk_widget_get_window(widgets_p->window)); 
    rfm_get_drawable_geometry(drawable, NULL, NULL, &window_extent.width, &window_extent.height, NULL);
    TRACE("window_geometry:  x=%d,  y=%d, w=%d, h=%d", window_extent.x, window_extent.y, window_extent.width, window_extent.height); 

    gdk_window_get_frame_extents (gtk_widget_get_window(widgets_p->window),&frame_extent);
    TRACE("window_frame_extents: x=%d, y=%d, w=%d, h=%d\n", 
    	frame_extent.x, frame_extent.y, frame_extent.width, frame_extent.height); 


    delta_y = window_extent.y - frame_extent.y;
    delta_h = frame_extent.height - window_extent.height;
    y_offset = delta_y + delta_h;
    TRACE("window: delta_y=%d, delta_h=%d, y_offset=%d\n", 
    	delta_y, delta_h, y_offset); 


    TRACE ("rodent_mk_text_entry...\n");
    if(!population_p || !population_p->en || !population_p->en->path){
	NOOP(stderr, "rodent_mk_text_entry: invalid population\n");
        return NULL;
    }

    /* caso=0, rename; caso=1, duplicate; caso=2, symlink */

    entry = gtk_entry_new ();
    hbox = rfm_hbox_new (FALSE, 0);
    view_p->widgets.rename = gtk_window_new (GTK_WINDOW_POPUP);

    gint x_coordinate;
    gint y_coordinate;
    /* change relative coordinates to absolute coordinates and place entry window */
    {
        gint y;
        double sh=0;
        if(GTK_IS_SCROLLED_WINDOW (view_p->widgets.scrolled_window)) {
            sh = gtk_adjustment_get_value (gtk_scrolled_window_get_vadjustment (view_p->widgets.scrolled_window));
        }
        gtk_window_get_position ((GtkWindow *) view_p->widgets.window, &x_coordinate, &y);
        x_coordinate += ((frame_extent.width - window_extent.width)/2);
	//FIXME: y_coordinate is not quite right. We get different behaviour
	//       for desktop and gridview (check last term of the sum)
        y_coordinate=population_p->labelY + frame_extent.y - sh 
                    + y_offset + (view_p->view_layout.text_height+TEXTSPACING);
        gtk_window_move ((GtkWindow *) view_p->widgets.rename,
                         population_p->labelX + x_coordinate, 
			 y_coordinate);
	
    }

    gtk_window_set_resizable (GTK_WINDOW (view_p->widgets.rename), FALSE);
    gtk_container_set_border_width (GTK_CONTAINER (view_p->widgets.rename), 0);
    gtk_window_set_modal (GTK_WINDOW (view_p->widgets.rename), FALSE);

    gchar *g = NULL;
    gchar *b = g_path_get_basename (population_p->en->path);
    gchar *path = g_strdup (population_p->en->path);
    g_object_set_data (G_OBJECT (view_p->widgets.rename), "path", path);
    g_object_set_data (G_OBJECT (view_p->widgets.rename), "caso", GINT_TO_POINTER(caso));

    if(caso == 0) {
        g = g_strdup (b);
        rfm_status (&(view_p->widgets), "xffm/stock_dialog-warning", b, ": ", _("Rename"), "...", NULL);
        g_signal_connect (G_OBJECT (entry), "activate", G_CALLBACK (entry_activate_rename), view_p);
	NOOP(stderr, "Rename...\n");
    } else if(caso == 1) {
        gchar *dir = g_path_get_dirname (population_p->en->path);
        g = g_strdup_printf (_("Copy of %s"), b);
        g_free (dir);
        rfm_status (&(view_p->widgets), "xffm/stock_dialog-warning", b, ": ", _("Duplicate"), "...", NULL);
	NOOP(stderr, "Duplicate...\n");
        g_signal_connect (G_OBJECT (entry), "activate", G_CALLBACK (entry_activate_duplicate), view_p);
    } else if(caso == 2) {
        g = g_strdup_printf (_("Link to %s"), b);
        rfm_status (&(view_p->widgets), "xffm/stock_dialog-warning", b, ": ", _("Create Symbolic Link"), "...", NULL);
	NOOP(stderr, "Symlink...\n");
        g_signal_connect (G_OBJECT (entry), "activate", G_CALLBACK (entry_activate_symlink), view_p);
    }
    gchar *q = rfm_utf_string (g);
    gchar *p=q;
    double extra=0;

    while (p && *p) {  //hack: gtk bug workaround
    gunichar up=g_utf8_get_char_validated (p, -1);
    if (up > 0) {
    if (g_unichar_isupper(up)) extra += 0.3;
    //if (g_unichar_islower(up)) extra -= 0.1;
    if (g_unichar_iswide(up)) extra += 1.0;
    if (g_unichar_ispunct(up)) extra -= 0.2;
    if (g_unichar_iszerowidth(up)) extra -= 1.0;
    }
    p++;
    }
    extra += 0.5;
    int chars = extra + g_utf8_strlen (q, -1);
    if (chars < 7) chars=7;

    gtk_entry_set_width_chars ((GtkEntry *)entry, chars);
    gtk_entry_set_text ((GtkEntry *) entry, q);
    g_free (q);
    g_free (b);
    g_free (g);

    gtk_editable_set_editable ((GtkEditable *) entry, TRUE);

    gtk_container_set_border_width (GTK_CONTAINER (hbox), 0);
    gtk_container_add (GTK_CONTAINER (view_p->widgets.rename), hbox);

    gtk_box_pack_start (GTK_BOX (hbox), entry, TRUE, FALSE, 0);

    g_signal_connect (G_OBJECT (view_p->widgets.rename), "destroy-event", G_CALLBACK (destroy_dialog), view_p);
    g_signal_connect (G_OBJECT (view_p->widgets.rename), "key_press_event", G_CALLBACK (on_key_press), view_p);
    g_signal_connect (G_OBJECT (view_p->widgets.rename), "delete-event", G_CALLBACK (destroy_dialog), view_p);


    g_signal_connect (G_OBJECT (entry), "enter-notify-event", G_CALLBACK (grab_focus), view_p);
    entry_aid(view_p, caso, population_p->labelY);
    TRACE ("now showing view_p->widgets.rename \n");
    gtk_widget_show_all (view_p->widgets.rename);
    gdk_flush();
        gint endpos;
        g = gtk_editable_get_chars ((GtkEditable *) entry, 0, -1);
        if(strchr (g, '.')) {
            gtk_editable_select_region ((GtkEditable *) entry, 0, 0);
            for(endpos = strlen (g) - 1; g[endpos] >= 0; endpos--) {
                if(g[endpos] == '.')
                    break;
            }
            TRACE ("entry box: endpos=%d\n", endpos);
            gtk_editable_select_region ((GtkEditable *) entry, 0, endpos);
        }
        g_free (g);    

    /* this sucks: gtk_widget_grab_focus (view_p->widgets.rename); */
    XSetInputFocus (gdk_x11_display_get_xdisplay(gdk_display_get_default()), 
	    GDK_WINDOW_XID (gtk_widget_get_parent_window (entry)), RevertToParent, CurrentTime);

    gtk_window_set_transient_for (GTK_WINDOW (view_p->widgets.rename), GTK_WINDOW (view_p->widgets.window));
    
    rfm_get_drawable_geometry(gdk_x11_get_default_root_xwindow(), NULL, NULL, &window_extent.width, &window_extent.height, NULL);


    //test 1, is the box larger than the root window?
    GtkAllocation allocation;
    gtk_widget_get_allocation (view_p->widgets.rename, &allocation);
    
    if (allocation.width > window_extent.width) {
        gtk_widget_set_size_request(entry, window_extent.width-6, -1);
        gtk_widget_set_size_request(view_p->widgets.rename, window_extent.width, -1);
        x_coordinate=0;
        // this does not do what I think it should do (show start of truncated text):
        //gtk_entry_set_alignment((GtkEntry *)entry, 0);
    } else { // it fits, try to place it.
        int center = x_coordinate + population_p->labelX;
        // overspill?
        if (center + allocation.width > window_extent.width) x_coordinate = window_extent.width - allocation.width;
        // center is OK
        else x_coordinate=center;
    }


    gtk_window_move ((GtkWindow *) view_p->widgets.rename,
                x_coordinate, //    population_p->labelX + x, 
		y_coordinate);
    XGrabPointer (gdk_x11_display_get_xdisplay(gdk_display_get_default()),
                  GDK_WINDOW_XID (gtk_widget_get_parent_window (entry)),
                  TRUE, 0, GrabModeSync, GrabModeAsync,
                  GDK_WINDOW_XID (gtk_widget_get_parent_window (entry)),
                  None, CurrentTime);
    XUngrabPointer(gdk_x11_display_get_xdisplay(gdk_display_get_default()),CurrentTime);

    return NULL;
}

/////////////////////  RM  /////////////////////////////////////


#define is_digit(x) ((x)>='0' && (x)<='9')

// this is the thread function called by the callback,
// and it is consecutively called if "apply to all"
// toggle is unset.
// This is a thread function, must have GDK mutex set for gtk commands...
void *
m_remove (void *pp) {
    subthread_t *subthread_p = pp;
    if(!subthread_p){
        return NULL;
    }
    if(!subthread_p->selection_list) {
	g_free(subthread_p);
	subthread_p=NULL;
        TRACE ("NULL selection list for remove\n");
        return NULL;
    }
    if(g_slist_length(subthread_p->selection_list)==0) {
	g_slist_free(subthread_p->selection_list);
	g_free(subthread_p);
        TRACE ("subthread_p->selection_list)==0 for remove\n");
        return NULL;
    }
    // since this thread is called consecutively, we should 
    // test for widgets_p validity first.
    gboolean valid_widgets=subthread_p->widgets.diagnostics && *(subthread_p->widgets.diagnostics);
    // If test fails, it still could be a DESKVIEW_TYPE
    if (!valid_widgets){
	if (subthread_p->widgets.diagnostics_window) valid_widgets=TRUE;
    }


    if (valid_widgets)
    { 
	make_dialog (subthread_p);
    } else {
	// this is a bit unlikeable, but so it is
	// if widgets_p is no longer valid, silently
	// discard the rest of the delete command 
	GSList *tmp=subthread_p->selection_list;
	for (;tmp && tmp->data; tmp=tmp->next){
	    TRACE("cleanup free %s\n",(gchar *)tmp->data);
	    g_free(tmp->data);
	}
	g_slist_free(subthread_p->selection_list);
	g_free(subthread_p);
	subthread_p=NULL;
    }
    
    return NULL;

}



