/*
 * Copyright (C) 2002-2012 Edscott Wilson Garcia
 * EMail: edscott@xfce.org
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */



#define GRIDVIEW_C

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "rodent_libs.h"
#include "gridview_lib.h"

/* private symbols */

#include "gridview-callbacks.i"
#include "gridview-lpterm.i"
#include "gridview-notebook.i"

GtkWidget *create_gridview ( void); 

view_t *create_iconview ( record_entry_t * en);

static 
view_t *
load(record_entry_t *en){
    NOOP("en=0x%x\n", GPOINTER_TO_INT(en));

    view_t *view_p = create_iconview (en);
    
    if(en){
        view_p->module = en->module;
    }
    NOOP ("module=%s", view_p->module);
    //gtk_widget_realize (view_p->widgets.window);
    view_preferences_t *view_preferences_p = 
	rfm_get_view_preferences (view_p->flags.type, en);
    rfm_set_view_preferences (view_p, view_preferences_p);
    g_free(view_preferences_p);
    rodent_full_reload_view (view_p, en);
    rodent_monitor ((gpointer) g_thread_self ());
    return view_p;
}

/* public symbols (listed in gridview_lib.h) */
GtkWidget *
create_gridview ( void) {
    view_t *view_p = NULL;
    gint type =  __ROOT_TYPE;
    record_entry_t *en = NULL;
    gchar *exec = g_path_get_basename (rfm_global_p->argv[0]);

    TRACE ("create_gridview(): exec is %s, argc=%d\n",exec,rfm_global_p->argc);
    gint i;
    for (i=0;i<rfm_global_p->argc; i++){
	NOOP("%d: %s\n", i, rfm_global_p->argv[i]);
    }

    // main thread...
    //GThread *self=g_thread_self();
    //NOOP("MAIN thread self=0x%lu\n",(long unsigned)self);
    //Look for module executables (not for rodent nor rodent-forked)
	    
    NOOP(stderr, "exec is ---- %s\n", exec);
    if(exec && strcmp (exec, "rodent") && strcmp (exec, "rodent-forked")) {
        const gchar *path = rfm_global_p->argv[1];
        if(!path){
            path = "/";
	}
        GSList *plugin_list = rfm_find_plugins ();
        en = rfm_mk_entry (type);
        en->path = g_strdup (path);
	// Check for local type.
        for(; plugin_list; plugin_list = plugin_list->next) {
	    const gchar *module_name = plugin_list->data;
	    gchar *exec_name = g_strdup_printf("rodent-%s", module_name);
	    NOOP(stderr, "---- %s : %s\n", exec, exec_name);
	    if (strcmp(exec, exec_name)==0 && 
		    rfm_void(PLUGIN_DIR, module_name, "module_active")){
                en->module = rfm_void (PLUGIN_DIR, module_name, "module_name");
		if(rfm_natural (PLUGIN_DIR, en->module, en, "module_path"))
			en->path = g_strdup (rfm_natural (PLUGIN_DIR, 
				en->module, en, "module_path"));
		else if(rfm_void (PLUGIN_DIR, en->module, "module_label"))
			en->path = g_strdup (rfm_void (PLUGIN_DIR, en->module,
				    "module_label"));		      
		if (rfm_global_p->argv[1] != NULL){
		    // Allow modules to specify internals on the command line
		    // this is intended to put in a button from the terminate
		    // dialog to enter the proc module at the point of the
		    // controlling rodent thread.
		    //
		    // In this case the 
		    NOOP("rfm_global_p->argv[1]=%s\n", rfm_global_p->argv[1]);
		    rfm_rational(PLUGIN_DIR, en->module, en, 
			    rfm_global_p->argv, "module_argv");
		} 
		view_p = load(en);
		g_free(exec);
		return (view_p)?view_p->widgets.window:NULL;
            }
        }
        g_warning ("There is no plugin with exec_name = %s", rfm_global_p->argv[0]);
	exit(1);
    }

    if (rfm_global_p->argc == 1 && strcmp (exec, "rodent")==0) {
        en = rfm_stat_entry (g_get_home_dir(), 0);
    }

    else if(rfm_global_p->argc >= 2  ) {
	NOOP("argv[1]=%s \n",rfm_global_p->argv[1]);
        if(rfm_g_file_test (rfm_global_p->argv[1], G_FILE_TEST_IS_DIR)) {
	    // strip trailing slash (hack)
	    if (strlen(rfm_global_p->argv[1]) > 1 && 
		rfm_global_p->argv[1][strlen(rfm_global_p->argv[1])-1]=='/'){
		rfm_global_p->argv[1][strlen(rfm_global_p->argv[1])-1]=0;
	    }
	    en = rfm_stat_entry (rfm_global_p->argv[1], 0);
	} else { 
	    // specified directory does not exist.
	    if (strcmp (exec, "rodent-forked")==0){ // forked, defaults to root
		//warning 
		    NOOP (stderr, _("%s does not exist."), rfm_global_p->argv[1]);
		    NOOP (stderr, "\n");
	    } else { //plain rodent, defaults to homedir
		gchar *wd = g_get_current_dir ();
		gchar *path = g_build_filename (wd, rfm_global_p->argv[1], NULL);
		g_free (wd);
		if(!rfm_g_file_test (path, G_FILE_TEST_IS_DIR)) {
		    NOOP (stderr, _("%s does not exist."), path);
		    NOOP (stderr, "\n");
		    en = rfm_stat_entry (g_get_home_dir(), 0);
		} else {
		    en = rfm_stat_entry (path, 0);
		}
		g_free (path);
	    }
	} 
    }

    g_free (exec);
    NOOP(stderr, "loading...\n");
  

    view_p=load(en);

    // create extra tabs (if applicable)
    //
    if (view_p && rfm_global_p->argc > 2) {
	for (i=2; i<rfm_global_p->argc; i++){
	    DBG("tab for %s\n",rfm_global_p->argv[i]);
	    if (rfm_g_file_test(rfm_global_p->argv[i], G_FILE_TEST_EXISTS)){
		record_entry_t *new_en=rfm_stat_entry(rfm_global_p->argv[i], 0);
		new_en->path=g_strdup(rfm_global_p->argv[i]);
		view_t *v_p = create_notebook_page (view_p->widgets.window, 
			*(view_p->widgets.notebook), new_en);

		view_preferences_t *view_preferences_p = 
		    rfm_get_view_preferences (v_p->flags.type, en);
		rfm_set_view_preferences (v_p, view_preferences_p);
		g_free(view_preferences_p);

		rodent_full_reload_view (v_p, new_en);
		gdk_flush ();
	    }
	}
    }
    NOOP(stderr, "load done...\n");
    
    return (view_p)?view_p->widgets.window:NULL;
}

static gboolean
watch_preferences ( gpointer data) {
    NOOP("g_timeout: gridview.c, watch_preferences()\n");
    static gboolean running=FALSE;
    if (running) return TRUE;

    running=TRUE;
    GtkWidget *window = data;
    static gchar *window_color = NULL;
    static double window_transparency = 0.0;
    static gchar *rfm_default_icon_size=NULL;
    if (!rfm_default_icon_size) {
	rfm_default_icon_size =
		    g_strdup(getenv ("RFM_DEFAULT_ICON_SIZE"));
    }

    if (!data) {
	running=FALSE;
        return FALSE;
    }
    if (!G_IS_OBJECT (data)) {
	running=FALSE;
        return FALSE;
    }
	
    g_static_rw_lock_reader_lock (&(rfm_global_p->view_list_lock));
    GSList *view_list = rfm_global_p->window_view_list;

    for(; view_list; view_list = view_list->next) {
        view_t *view_p = view_list->data;
	
	g_mutex_lock(view_p->mutexes.status_mutex);
	gboolean status = view_p->flags.status;
	g_mutex_unlock(view_p->mutexes.status_mutex);

	if (status == STATUS_EXIT) continue;
	increment_view_ref(view_p);
	
	if (rfm_diagnostics_is_visible (&(view_p->widgets)) ) {
	    gtk_widget_show(view_p->widgets.clear_button);
	} else {
	    gtk_widget_hide(view_p->widgets.clear_button);
	}
	
        if(getenv ("RFM_ICONVIEW_COLOR") && strlen (getenv ("RFM_ICONVIEW_COLOR"))) {
            if(!window_color || strcmp (window_color, getenv ("RFM_ICONVIEW_COLOR"))) {
                NOOP ("DESK: watch_root now reloading RFM_ICONVIEW_COLOR %s\n", getenv ("RFM_ICONVIEW_COLOR"));
                g_free (window_color);
                window_color = g_strdup (getenv ("RFM_ICONVIEW_COLOR"));
		
		GdkRectangle rect;
		gtk_widget_get_allocation (view_p->widgets.window, &rect);
		rect.x = rect.y = 0;
		rfm_thread_expose_rect (view_p, &rect);


                // may crash on gtk race: rodent_expose_all (view_p);
            }
        }
        if(getenv ("RFM_PASTEBOARD_SERIAL") && strlen (getenv ("RFM_PASTEBOARD_SERIAL"))) {
	    //NOOP("got pasteboard serial=%s\n",getenv ("RFM_PASTEBOARD_SERIAL"));
            errno = 0;
            long value = strtol (getenv ("RFM_PASTEBOARD_SERIAL"), NULL, 0);
            if(errno != 0 || value != view_p->flags.pasteboard_serial) {
                view_p->flags.pasteboard_serial = value;
                rfm_update_pasteboard (view_p);
                rodent_update_cut_icons (view_p);
            }
        }
        if(getenv ("RFM_DEFAULT_ICON_SIZE") && strlen (getenv ("RFM_DEFAULT_ICON_SIZE"))) {
	    if (strcmp(getenv ("RFM_DEFAULT_ICON_SIZE"), rfm_default_icon_size)!=0)
	    {
		g_free(rfm_default_icon_size);
		rfm_default_icon_size=
		    g_strdup(getenv ("RFM_DEFAULT_ICON_SIZE"));
		// We need to do a hard reload here, but hard reloads
		// are only permissible on explicit user request. 
	/*	rfm_show_text(&(view_p->widgets));
		rfm_diagnostics(&(view_p->widgets), "xffm/stock_dialog-warning",NULL);
		rfm_diagnostics(&(view_p->widgets), "xffm_tag/blue",
			_("Reload"),": ",	"Default icon size", 
			" (", getenv("RFM_DEFAULT_ICON_SIZE"), ")\n",
			NULL);*/
		// XXX a hard reload is necessary here, but not possible.
		NOOP("default icon size changed\n");
	    }
        }


	rodent_bookmark_monitor(view_p);
	decrement_view_ref_no_signal(view_p);
    }
    g_static_rw_lock_reader_unlock (&(rfm_global_p->view_list_lock));

    if(getenv ("RFM_TRANSPARENCY") && strlen (getenv ("RFM_TRANSPARENCY"))) {
        errno = 0;
        double value = strtod (getenv ("RFM_TRANSPARENCY"), NULL);
        if(errno != 0 || value < 0.0) {
            value = 0.0;
        } else if(value > 0.75)
            value = 0.75;
        if(value != window_transparency) {
            window_transparency = value;
            gtk_window_set_opacity ((GtkWindow *) window, 1.00 - window_transparency);
            gdk_flush ();
        }
    }

    running=FALSE;
    return TRUE;
}

view_t *
create_iconview ( record_entry_t * en) {
    NOOP (">> create_iconview\n");
//   view_p->widgets.window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
    GtkWidget *window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    gtk_widget_set_has_tooltip (window, TRUE);
    // or:
    // g_object_set_property (G_OBJECT (window), "has-tooltip", TRUE);
    // 
    GtkWidget *vbox1 = rfm_vbox_new (FALSE, 0);
    gtk_container_add (GTK_CONTAINER (window), vbox1);

// NOTEBOOK creation
    GtkWidget *notebook = gtk_notebook_new ();
    g_object_set_data(G_OBJECT(window), "notebook", notebook);
    //   gtk_notebook_set_tab_pos ((GtkNotebook *)notebook, GTK_POS_BOTTOM);
    gtk_notebook_popup_enable ((GtkNotebook *) notebook);
    gtk_notebook_set_scrollable ((GtkNotebook *) notebook, TRUE);
    g_object_set (notebook,
                  "enable-popup", TRUE, 
                  "can-focus", FALSE,
                  "scrollable", TRUE, 
                 // "homogeneous", FALSE, 
                  "show-border", FALSE,
                  "show-tabs", 
                  TRUE, "tab-pos",
                  GTK_POS_TOP, NULL);

    //   g_object_set (notebook,  "show-tabs", FALSE, NULL);
    //   g_object_set (notebook,  "homogeneous", TRUE, NULL); 
    //   "tab-label"

    gtk_box_pack_start (GTK_BOX (vbox1), notebook, TRUE, TRUE, 0);
    gtk_widget_show (vbox1);
    gtk_widget_show (notebook);
// end NOTEBOOK creation
//
// add contents to notebook page
//
    view_t *view_p = create_notebook_page (window, notebook, en);
    g_signal_connect (notebook, "switch-page", G_CALLBACK (switch_page), window);

    if(getenv ("RFM_TRANSPARENCY") && strlen (getenv ("RFM_TRANSPARENCY"))) {
        errno = 0;
        double value = strtod (getenv ("RFM_TRANSPARENCY"), NULL);
        if(errno != 0 || value < 0.0) {
            value = 0.0;
        } else if(value > 0.75)
            value = 0.75;
        gtk_window_set_opacity ((GtkWindow *) window, 1.00 - value);
    }

// NOTEBOOK plus page
    GtkWidget *button = gtk_button_new ();
    GdkPixbuf *pb;
    GtkWidget *image;
    pb = rfm_get_pixbuf ("xffm/stock_add", SIZE_BUTTON);
    image = gtk_image_new_from_pixbuf (pb);
    gtk_widget_show (image);
    gtk_container_add (GTK_CONTAINER (button), image);
    g_object_set (button, "can-focus", FALSE, "relief", GTK_RELIEF_NONE, NULL);

    gtk_widget_show (button);
    g_signal_connect (G_OBJECT (button), "clicked", G_CALLBACK (newpage), window);
    gtk_notebook_set_action_widget (GTK_NOTEBOOK (notebook), button, GTK_PACK_END);

// NOTEBOOK end
    g_signal_connect (G_OBJECT (window), "query-tooltip", G_CALLBACK (rodent_tip_function), NULL);
    g_signal_connect (G_OBJECT (window), "key-press-event", G_CALLBACK (signal_keyboard_event), NULL);
    g_signal_connect (G_OBJECT (window), "destroy_event", G_CALLBACK (signal_destroy_event), NULL);
    g_signal_connect (G_OBJECT (window), "delete_event", G_CALLBACK (signal_destroy_event), NULL);
    /*   g_signal_connect(G_OBJECT(window), "size-allocate",
       G_CALLBACK(signal_on_size_window), view_p); */
    /* pointer events */
    g_signal_connect (G_OBJECT (window), "configure-event", G_CALLBACK (signal_on_configure_window), NULL);

    // XXX is this data of any use?
    //g_object_set_data(G_OBJECT(window), "view_p",
    //                  (gpointer) view_p->widgets.paper);

    /* set minimum window size: */
    gtk_widget_set_size_request ((GtkWidget *) window, 1.3 * CELLHEIGHT(view_p), 1.5 * CELLHEIGHT(view_p));

    view_geometry_t *iconview_geometry_p = rodent_get_view_geometry_p (view_p);
    if(iconview_geometry_p) {
        gtk_window_set_default_size ((GtkWindow *) window, iconview_geometry_p->w, iconview_geometry_p->h);
        NOOP ("window... default size=%d,%d\n", iconview_geometry_p->w, iconview_geometry_p->h);
	g_free(iconview_geometry_p);
    } else {
        gtk_window_set_default_size ((GtkWindow *) window, DEFAULT_WIDTH, DEFAULT_HEIGHT);
        NOOP ("window... default size=%d,%d\n", DEFAULT_WIDTH, DEFAULT_HEIGHT);
    }
    gtk_window_set_resizable ((GtkWindow *) window, TRUE);
    gtk_widget_show (window);
    g_timeout_add (160, watch_preferences, window);

    gdk_flush ();
    NOOP ("----Done with create_iconview\n");
    gtk_widget_grab_focus (view_p->widgets.paper);
    NOOP ("POP_SEM:  sem_init(&(view_p->population_sem),0,1)\n");

    return view_p;
}
