//
//
static void
print_suggestion (
    widgets_t * widgets_p,
    const char *data,
    int i,
    gboolean cr
) {
    gchar *element = g_strdup_printf ("%d", i);
    rfm_diagnostics (widgets_p, NULL, "[", NULL);
    rfm_diagnostics (widgets_p, "xffm_tag/green", element, NULL);
    rfm_diagnostics (widgets_p, NULL, "] ", NULL);
    rfm_diagnostics (widgets_p, "xffm_tag/blue", data, NULL);
    if(cr)
        rfm_diagnostics (widgets_p, NULL, "\n", NULL);

    g_free (element);
}

static gboolean
internal_cd ( widgets_t * widgets_p, gchar ** argvp) {
    view_t *view_p = widgets_p->view_p;
    gchar *gg=NULL;

    if(argvp[1]) {
	if (*argvp[1] == '~'){
	    if (strcmp(argvp[1], "~")==0 || 
		    strncmp(argvp[1], "~/", strlen("~/"))==0){
		gg = g_strdup_printf("%s%s", g_get_home_dir (), argvp[1]+1);
	    } else {
		//gchar *tilde_dir = rfm_get_tilde_dir(argvp[1]);
		gchar *tilde_dir = 
		    rfm_natural(MODULE_DIR, "completion", 
			    argvp[1], "rfm_get_tilde_dir");
		if (tilde_dir) gg = g_strconcat(tilde_dir, 
			strchr(argvp[1], '/')+1, NULL);
		else gg = g_strdup(argvp[1]);
		g_free(tilde_dir);	
	    }
	} else {
	    gg = g_strdup(argvp[1]);
	}

    } else {
        gg = g_strdup(g_get_home_dir ());
    }
    rfm_show_text (widgets_p);
    TRACE ("CD: gg=%s argv[1]=%s\n", gg, argvp[1]);

    // must allow relative paths too.
    if (!g_path_is_absolute(gg)){
	if(!view_p->en || ! view_p->en->path ||  
	    !rfm_g_file_test_with_wait (view_p->en->path, G_FILE_TEST_IS_DIR)) 
	{
	    rfm_diagnostics (widgets_p, "xffm/stock_dialog-error", NULL);
	    rfm_diagnostics (widgets_p, "xffm_tag/stderr", "* ", gg, ": ", strerror (ENOENT), "\n", NULL);
	    g_free (gg);
	    return TRUE;
        } 
	gchar *fullpath = g_strconcat(view_p->en->path, "/", gg, NULL);
	g_free(gg);
	gg = fullpath;
	TRACE("CD: fullpath=%s\n", fullpath);
    }

    if (gg[strlen(gg)-1]=='/' || strstr(gg, "/..")){
	gchar *rpath = realpath(gg, NULL);
	g_free(gg);
	gg=rpath;
    }
    rfm_diagnostics (widgets_p, "xffm_tag/command", "cd", " ", NULL);
    rfm_diagnostics (widgets_p, "xffm_tag/green", gg, "\n", NULL);
    gdk_flush ();
    if (!rfm_g_file_test_with_wait (gg, G_FILE_TEST_IS_DIR)){
	rfm_diagnostics (widgets_p, "xffm/stock_dialog-error", NULL);
	rfm_diagnostics (widgets_p, "xffm_tag/stderr", "+", gg, ": ", strerror (ENOENT), "\n", NULL);
	g_free (gg);
	return TRUE;
    }
    gtk_widget_grab_focus (widgets_p->paper);
    rodent_push_view_go_history (view_p);
    record_entry_t *new_en = rfm_stat_entry (gg, 0);
    view_p->module = NULL;
    if (!rodent_refresh (widgets_p, new_en)){
	rfm_destroy_entry(new_en); 
	rfm_save_to_go_history ((gchar *) gg);
	gchar *command = g_strdup_printf ("cd %s", gg);
	rfm_save_sh_command_history (view_p, command);
    }
    g_free (gg);
    return TRUE;
}

static void
print_history (
    widgets_t * widgets_p
) {
    int i;
    view_t *view_p = widgets_p->view_p;
    GList *p;
    rfm_diagnostics (widgets_p, "xffm_tag/command", "history:", "\n", NULL);

    for(i = 1, p = g_list_first (view_p->sh_command); p && p->data; p = p->next, i++) {
        print_suggestion (widgets_p, (char *) p->data, i, TRUE);
    }

}

static void
print_tab ( widgets_t * widgets_p, gchar * text, gchar *text2) {
    int tab_len = 18;
    rfm_diagnostics (widgets_p, "xffm_tag/red", text, text2, NULL);
    gint string_length = (text)?strlen(text):0 + (text2)?strlen(text2):0;
    for(tab_len = tab_len - string_length; tab_len > 0; tab_len--)
        rfm_diagnostics (widgets_p, NULL, " ", NULL);
}

static void
print_history_help (
    widgets_t * widgets_p
) {
    rfm_diagnostics (widgets_p, "xffm_tag/command", 
	    _("History"), " (", _("Get help..."), "):\n", NULL);
    print_tab (widgets_p, "?",NULL);
    rfm_diagnostics (widgets_p, "xffm_tag/green",
	    _("Show help about options"), "\n", NULL);

    print_tab (widgets_p, "!",NULL);
    rfm_diagnostics (widgets_p, "xffm_tag/green",
	    _("Show History"), "\n", NULL);

    print_tab (widgets_p, "!","n");
    rfm_diagnostics (widgets_p, "xffm_tag/green",
	    _("Line Number"),  " (", _("Command Line"), ") ", NULL);
    rfm_diagnostics (widgets_p, "xffm_tag/red", 
	    "n", NULL);
    rfm_diagnostics (widgets_p, "xffm_tag/green",
	    ".", "\n", NULL);

    print_tab (widgets_p, "!",_("STRING"));
    rfm_diagnostics (widgets_p, "xffm_tag/green",
	    _("Complete Match"), NULL);
    rfm_diagnostics (widgets_p, "xffm_tag/red", 
	    " ", _("STRING"), NULL);
    rfm_diagnostics (widgets_p, "xffm_tag/green", ".", "\n", NULL);

    print_tab (widgets_p, "!?",_("STRING"));
    rfm_diagnostics (widgets_p, "xffm_tag/green", 
	    _("Anywhere"),  NULL);
    rfm_diagnostics (widgets_p, "xffm_tag/red", " ",
	    _("STRING"), NULL);
    rfm_diagnostics (widgets_p, "xffm_tag/green", ".", "\n", NULL);

    print_tab (widgets_p, _("STRING"),"<CTRL+TAB>");
    rfm_diagnostics (widgets_p, "xffm_tag/green", 
	    _("Completion mode:")," ", _("Command Line"), NULL);
    //rfm_diagnostics (widgets_p, "xffm_tag/red",  _("STRING"), NULL);
    rfm_diagnostics (widgets_p, "xffm_tag/green", ".", "\n", NULL);

    print_tab (widgets_p, _("STRING"),"<TAB>");
    rfm_diagnostics (widgets_p, "xffm_tag/green", 
	    _("Completion mode:")," ", "bash", NULL);
    //rfm_diagnostics (widgets_p, "xffm_tag/red",  _("STRING"), NULL);
    rfm_diagnostics (widgets_p, "xffm_tag/green", ".", "\n", NULL);


    print_tab (widgets_p, "!!", NULL);
    rfm_diagnostics (widgets_p, "xffm_tag/green", 
	    _("Clear History"), " (", _("Current"), ")", "\n", NULL);

    print_tab (widgets_p, "!!!", NULL);
    rfm_diagnostics (widgets_p, "xffm_tag/green", 
	    _("Clear History"), " (", _("Disk"), ")", "\n", NULL);
}

static void
suggest_command (
    widgets_t * widgets_p,
    const char *complete,
    gboolean anywhere
) {
    view_t *view_p = widgets_p->view_p;
    GList *p;
    char *suggest = NULL;
    for(p = g_list_last (view_p->sh_command); p && p->data; p = p->prev) {
        char *data = (char *) p->data;
        if((anywhere && strstr (data, complete)) || (!anywhere && strncmp (complete, data, strlen (complete)) == 0)) {
            suggest = g_strdup (data);
            break;
        }
        TRACE ("COMPLETE: ?? %s\n", data);
    }
    if(suggest) {
        rfm_status (widgets_p, "xffm/apps_terminal", suggest, NULL);
        g_object_set_data (G_OBJECT (widgets_p->status), "clean", NULL);
        g_free (suggest);
    }
}

static gboolean
internal_history (
    widgets_t * widgets_p,
    gchar ** argvp
) {
    view_t *view_p = widgets_p->view_p;
    // list history
    if(strcmp (argvp[0], "!") == 0) {
        print_history (widgets_p);
        rfm_status (widgets_p, "xffm/apps_terminal", "", NULL);
        g_object_set_data (G_OBJECT (widgets_p->status), "clean", NULL);
        return TRUE;
    }
    // history help
    if(strcmp (argvp[0], "!?") == 0 || strncmp (argvp[0], "?", 1) == 0) {
        print_history_help (widgets_p);
        rfm_status (widgets_p, "xffm/apps_terminal", "", NULL);
        g_object_set_data (G_OBJECT (widgets_p->status), "clean", NULL);
        return TRUE;
    }
    if(strcmp (argvp[0], "!!") == 0 || strcmp (argvp[0], "!!!") == 0) {
        gboolean disk_too = FALSE;
        if(strcmp (argvp[0], "!!!") == 0)
            disk_too = TRUE;
        rfm_clear_sh_command_history (widgets_p->view_p, disk_too);
        rfm_diagnostics (widgets_p, "xffm_tag/command", "history clear: ", NULL);
        rfm_diagnostics (widgets_p, NULL, "[", NULL);
        rfm_diagnostics (widgets_p, "xffm_tag/green", "OK", NULL);
        rfm_diagnostics (widgets_p, NULL, "]", "\n", NULL);
        rfm_status (widgets_p, "xffm/apps_terminal", "", NULL);
        g_object_set_data (G_OBJECT (widgets_p->status), "clean", NULL);
        return TRUE;
    }
    // 
    const char *b = argvp[0] + 1;
    //   errno = 0;
    long n = strtol (b, NULL, 10);
    TRACE ("COMPLETE: n=%ld\n", n);
/*    if (errno)  {
	      rfm_diagnostics (widgets_p, "xffm/stock_dialog-warning", b, ": ",
				 strerror (errno), NULL);
	      return TRUE;
    }*/
    if(n > 1 && n <= g_list_length (view_p->sh_command)) {
        GList *p = g_list_nth (view_p->sh_command, n - 1);
        if(p && p->data) {
            rfm_status (widgets_p, "xffm/apps_terminal", (char *) p->data, NULL);
            g_object_set_data (G_OBJECT (widgets_p->status), "clean", NULL);
        }
    } else {
        if(*b != '?') {
            suggest_command (widgets_p, b, FALSE);
        } else {
            suggest_command (widgets_p, b + 1, TRUE);
        }
    }
    return TRUE;

}

static gboolean
process_internal_commands ( widgets_t * widgets_p, gchar ** command) {
    gchar *command2=NULL;
    if (strchr(*command, ';')){
	// split command in two.
	command2 = g_strdup(strchr(*command, ';') + 1);
	*strchr(*command, ';')=0;
    }
    gint argcp;
    gchar **argvp;
    GError *error = NULL;
    if(!g_shell_parse_argv (*command, &argcp, &argvp, &error)) {
        rfm_diagnostics (widgets_p, "xffm/stock_dialog-error", error->message, "\n", NULL);
        g_error_free (error);
	if (command2){
	    g_free(*command);
	    *command=command2;
	    return FALSE;
	}
        return TRUE;
    } else {
        // shortcircuit chdir and history commands 
        gboolean is_internal = FALSE;
        if(strcmp (argvp[0], "cd") == 0) {
            internal_cd (widgets_p, argvp);
            TRACE ("CD: command=%s argv[1]=%s\n", *command, argvp[1]);
            is_internal = TRUE;
        } else if(strncmp (argvp[0], "history", strlen ("history")) == 0) {
            print_history_help (widgets_p);
            is_internal = TRUE;
        } else if(strncmp (argvp[0], "!", 1) == 0 || strncmp (argvp[0], "?", 1) == 0) {
            internal_history (widgets_p, argvp);
            is_internal = TRUE;
        }

	if (command2){
	    g_free(*command);
	    *command=command2;
	    return FALSE;
	}
        g_strfreev (argvp);
        return is_internal;
    }
}

static 
gchar *sudo_fix(gchar *command){
    if (strstr(command, "sudo ") && 
	    strncmp(strstr(command, "sudo "), "sudo -A ", strlen("sudo -A "))!=0)
    {
	    gchar *original_head=g_strdup(command);
	    *strstr(original_head, "sudo ") = 0;
	    gchar *tail=g_strdup(strstr(command, "sudo ")+strlen("sudo "));
	    tail=sudo_fix(tail);
	    gchar *new_command = g_strconcat(original_head, "sudo -A ", tail, NULL);

	    g_free(tail);
	    g_free(original_head);
	    g_free(command);
	    command = new_command;
    }
    return command;
}

static gint
on_status_key_press (
    GtkWidget * textview,
    GdkEventKey * event,
    gpointer data
) {
    widgets_t *widgets_p = (widgets_t *) data;
    view_t *view_p = widgets_p->view_p;
    if(!event) {
        TRACE ("STATUS: returning on event==0\n");
        //status_grab_focus (widgets_p->view_p, 0);
        return TRUE;
    }
    // backspace must not erase icon
    TRACE ("STATUS: * on_status_key_press: got key= 0x%x\n", event->keyval);
    if(event->keyval == GDK_KEY_Home) {
        GtkTextIter iter;
        GtkTextBuffer *buffer = gtk_text_view_get_buffer ((GtkTextView *) (widgets_p->status));
        gtk_text_buffer_get_iter_at_offset (buffer, &iter, 2);
        gtk_text_buffer_place_cursor (buffer, &iter);
        return TRUE;
    }
    if(event->keyval == GDK_KEY_BackSpace || event->keyval == GDK_KEY_Left) {
        gint intval;
        GtkTextBuffer *buffer = gtk_text_view_get_buffer ((GtkTextView *) widgets_p->status);
        g_object_get (G_OBJECT (buffer), "cursor-position", &intval, NULL);
        TRACE ("STATUS: cursor-position =%d\n", intval);
        if(intval > 2) {
            // offset==1 is the icon and offset==2 is the space after icon
            return FALSE;
        }
        return TRUE;
    }
    // CTRL-TAB for command history completion
    if(event->keyval == GDK_KEY_Tab && event->state & GDK_CONTROL_MASK) {
        // do history completion ...
        gchar *complete = get_current_text ((GtkTextView *) widgets_p->status);
        //gchar *suggest = rfm_history_completion (widgets_p, complete);
        gchar *suggest = rfm_rational(MODULE_DIR,
		"completion", widgets_p, complete,
		"rfm_history_completion");
        g_free (complete);
        if(suggest) {
            rfm_status (widgets_p, "xffm/apps_terminal", suggest, NULL);
            g_free (suggest);
        }
        g_object_set_data (G_OBJECT (widgets_p->status), "clean", NULL);
        return TRUE;
    }
    // tab for bash completion
    if(event->keyval == GDK_KEY_Tab) {
	gchar *head=get_text_to_cursor(GTK_TEXT_VIEW(widgets_p->status));
	gint head_len = strlen(head);
        gchar *token = get_current_text (GTK_TEXT_VIEW(widgets_p->status));
	gint token_len = strlen(token);

	//gchar *tail=get_text_from_cursor(GTK_TEXT_VIEW(widgets_p->status));
        g_free (head);
	//gchar *suggest = rfm_bash_complete(widgets_p, token, head_len);
	gchar *suggest = rfm_complex(MODULE_DIR, "completion",
		widgets_p, token, GINT_TO_POINTER(head_len),
		"rfm_bash_complete");
        g_free (token);

	if (suggest) {
	    gint suggest_len = strlen(suggest);
	    GtkTextIter end;
	    GtkTextBuffer *buffer = 
		gtk_text_view_get_buffer (GTK_TEXT_VIEW(widgets_p->status));
	    gint offset = -1;
	    // +2 is icon and space...
	    offset = head_len + (suggest_len - token_len) + 2;
            rfm_status (widgets_p, "xffm/apps_terminal", suggest, NULL);
	    gtk_text_buffer_get_iter_at_offset (buffer, &end, offset);
	    gtk_text_buffer_place_cursor(buffer, &end);	
	}
	g_free(suggest);

        g_object_set_data (G_OBJECT (widgets_p->status), "clean", NULL);
        return TRUE;
    }
    // up and down arrows, history command (glist)
    // 
    if(event->keyval == GDK_KEY_Up) {
        void *p = g_list_nth_data (view_p->sh_command, view_p->sh_command_counter - 1);
        TRACE ("get nth sh_command_counter=%d\n", view_p->sh_command_counter - 1);
        if(p) {
            view_p->sh_command_counter--;
            rfm_status (widgets_p, "xffm/apps_terminal", (char *) p, NULL);
            g_object_set_data (G_OBJECT (textview), "clean", NULL);
            gtk_widget_grab_focus (widgets_p->status);
        }

        return TRUE;
    }

    if(event->keyval == GDK_KEY_Down) {
        void *p = g_list_nth_data (view_p->sh_command, view_p->sh_command_counter + 1);
        if(p) {
            view_p->sh_command_counter++;
            rfm_status (widgets_p, "xffm/apps_terminal", (char *) p, NULL);
            g_object_set_data (G_OBJECT (textview), "clean", NULL);
        }
        return TRUE;
    }
    if(event->keyval == GDK_KEY_Return || event->keyval == GDK_KEY_KP_Enter) {
        if(g_object_get_data (G_OBJECT (textview), "clean") == NULL) {
            // get the command
            gchar *command = get_current_text ((GtkTextView *) widgets_p->status);
            if(command && strlen (command)) {
                // show the lp output area        
                rfm_show_text (widgets_p);

                // first process internal commands for cd and history
                if(process_internal_commands (widgets_p, &command))
                    return TRUE;

                // command is now external for /bin/sh
                // printstatus with the run icon run.png
                // this is already done in run.c
                // rfm_diagnostics(widgets_p, "run.png",command,"\n",NULL);

                // run the command (in a shell)
		// XXX This will block if located at a remote directory with
		// a broken network connection.
                if(widgets_p->workdir) {
                    g_free (widgets_p->workdir);
                }
                view_t *view_p = widgets_p->view_p;
                if (!view_p->en || !view_p->en->path || ! rfm_g_file_test(view_p->en->path, G_FILE_TEST_IS_DIR)){
                    widgets_p->workdir = g_strdup (g_get_home_dir());
;
                } else {
                    widgets_p->workdir = g_strdup (view_p->en->path);
                }
		// Fix any sudo commands to use the -A option
		command = sudo_fix(command);
                RFM_THREAD_RUN (widgets_p, command, FALSE);
                g_free (command);
            }
        }
        rfm_status (widgets_p, "xffm/apps_terminal", NULL);
        g_object_set_data (G_OBJECT (textview), "clean", NULL);
        return TRUE;
    }
    if(g_object_get_data (G_OBJECT (textview), "clean")) {
        rfm_status (widgets_p, "xffm/apps_terminal", NULL);
    }
    // set unclean status...
    g_object_set_data (G_OBJECT (textview), "clean", NULL);
    return FALSE;
}
