//
//
/**********************************************************************/
/* Copyright Edscott Wilson Garcia 2005-2011
 * See attached GPL licence for further information.
 * 
 * ********************************************************************/

/*******************************************************************/

static void
child_constructor ( widgets_t * widgets_p, gchar *in_path) {
    rodent_new_gridview(widgets_p, in_path);
}

static view_t *
create_deskview (
) {
    view_t *view_p = rfm_new_view();

    view_p->flags.serial = 1;
    /* initializations: */

    view_p->view_layout.icon_size = SMALL_ICON_SIZE;
    view_p->widgets.view_p = view_p;

    /* exported functions: */
    view_p->constructor = NULL;
    view_p->child_constructor = child_constructor;

    view_p->widgets.diagnostics_window = 
	    (GtkWidget **)malloc(sizeof(GtkWidget *));
    if (!view_p->widgets.diagnostics_window) g_error("malloc: %s", strerror(errno));
    *(view_p->widgets.diagnostics_window)=NULL;
    view_p->widgets.diagnostics = 
	    (GtkWidget **)malloc(sizeof(GtkWidget *));
    if (!view_p->widgets.diagnostics) g_error("malloc: %s", strerror(errno));
    *(view_p->widgets.diagnostics)=NULL;

    view_p->widgets.window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    gtk_widget_set_has_tooltip (view_p->widgets.window, TRUE);
    gtk_window_set_decorated ((GtkWindow *) view_p->widgets.window, FALSE);
    /* this doesn't do the trick with twm, so we'll just lower the window
       at the monitor step: */
    /*gdk_window_set_keep_below (((GtkWidget *)view_p->widgets.window)->window,TRUE); */
    view_p->flags.type = DESKVIEW_TYPE;
    gtk_window_set_title (GTK_WINDOW (view_p->widgets.window), "Rodent-desk");
#if 0
    view_p->widgets.scrolled_window = (GtkScrolledWindow *) gtk_scrolled_window_new (NULL, NULL);
    gtk_scrolled_window_set_policy (view_p->widgets.scrolled_window, GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
    gtk_container_add (GTK_CONTAINER (view_p->widgets.window), GTK_WIDGET (view_p->widgets.scrolled_window));
    gtk_widget_show (GTK_WIDGET (view_p->widgets.scrolled_window));
#endif

    view_p->widgets.paper = gtk_drawing_area_new ();
    if(gtk_widget_get_double_buffered(view_p->widgets.paper))
        gtk_widget_set_double_buffered (view_p->widgets.paper, FALSE);
    gtk_widget_show (view_p->widgets.paper);

#if 0
    gtk_scrolled_window_add_with_viewport (view_p->widgets.scrolled_window, view_p->widgets.paper);
#else
    gtk_container_add (GTK_CONTAINER (view_p->widgets.window), GTK_WIDGET (view_p->widgets.paper));
#endif

    rfm_get_drawable_geometry (gdk_x11_get_default_root_xwindow (), NULL, NULL, &view_p->view_layout.root_w, &view_p->view_layout.root_h, &view_p->view_layout.root_d);
    gtk_window_set_default_size ((GtkWindow *) view_p->widgets.window, view_p->view_layout.root_w, view_p->view_layout.root_h);

    // This is only good on fixed size servers. Totally borked on virtualized
    // systems where resizing the server is too easy:	
    //gtk_window_set_resizable ((GtkWindow *) view_p->widgets.window, FALSE);


    view_p->view_layout.paperX = view_p->view_layout.root_w;
    view_p->view_layout.paperY = view_p->view_layout.root_h;
    if (view_p->view_layout.icon_size >= SMALL_ICON_SIZE) {  
        view_p->view_layout.column_width = ICON_SIZE(view_p) * 2;       
	// this is CELLWIDTH(view_p) !!!
    } else if (view_p->view_layout.icon_size >= TINY_ICON_SIZE) {
	view_p->view_layout.column_width = SMALL_ICON_SIZE * 4; 
    } else {
	GdkRectangle allocation;
	gtk_widget_get_allocation (view_p->widgets.window, &allocation);
	view_p->view_layout.column_width = allocation.width; 
    }

    

    TRACE ("paperX=%d\n", view_p->view_layout.paperX);
    TRACE ("paperY=%d\n", view_p->view_layout.paperY);
    gtk_widget_set_size_request (view_p->widgets.paper, view_p->view_layout.paperX, view_p->view_layout.paperY);

    do_atoms (view_p);

    gtk_widget_add_events (view_p->widgets.paper,
                           GDK_POINTER_MOTION_MASK |
                           GDK_BUTTON_MOTION_MASK |
                           GDK_BUTTON_PRESS_MASK |
                           GDK_BUTTON_RELEASE_MASK |
                           GDK_ENTER_NOTIFY_MASK | GDK_LEAVE_NOTIFY_MASK | GDK_SCROLL_MASK | GDK_EXPOSURE_MASK);

    g_signal_connect (G_OBJECT (view_p->widgets.window), "query-tooltip", G_CALLBACK (rodent_tip_function), NULL);
    g_signal_connect (G_OBJECT (view_p->widgets.paper), "scroll-event", G_CALLBACK (scroll_cb), NULL);
    g_signal_connect (G_OBJECT (view_p->widgets.paper), "configure-event", G_CALLBACK (on_configure), view_p);
    g_signal_connect (G_OBJECT (view_p->widgets.paper), "size-allocate", G_CALLBACK (on_size), view_p);

#ifdef USE_GTK2
    g_signal_connect (G_OBJECT (view_p->widgets.paper), "expose-event", G_CALLBACK (rodent_expose), view_p);
#else 
    g_signal_connect (G_OBJECT (view_p->widgets.paper), "draw", G_CALLBACK (rodent_draw), view_p);
#endif
//    g_signal_connect (G_OBJECT (view_p->widgets.paper), "configure-event", G_CALLBACK (rodent_expose), view_p);

    g_signal_connect (G_OBJECT (view_p->widgets.paper), "button-press-event", G_CALLBACK (rodent_signal_on_button_press), view_p);
    g_signal_connect (G_OBJECT (view_p->widgets.paper), "button-release-event", G_CALLBACK (rodent_signal_on_button_release), view_p);
    g_signal_connect (G_OBJECT (view_p->widgets.paper), "enter-notify-event", G_CALLBACK (rodent_signal_on_enter), view_p);
    g_signal_connect (G_OBJECT (view_p->widgets.paper), "leave-notify-event", G_CALLBACK (rodent_signal_on_leave), view_p);
    g_signal_connect (G_OBJECT (view_p->widgets.paper), "motion-notify-event", G_CALLBACK (rodent_signal_on_motion), view_p);

    g_signal_connect (G_OBJECT (view_p->widgets.paper), "drag-data-received", G_CALLBACK (rodent_signal_drag_data), view_p);
    g_signal_connect (G_OBJECT (view_p->widgets.paper), "drag-data-get", G_CALLBACK (rodent_signal_drag_data_get), view_p);
    g_signal_connect (G_OBJECT (view_p->widgets.paper), "drag-motion", G_CALLBACK (rodent_signal_drag_motion), view_p);
    g_signal_connect (G_OBJECT (view_p->widgets.paper), "drag-end", G_CALLBACK (rodent_signal_drag_end), view_p);
    g_signal_connect (G_OBJECT (view_p->widgets.paper), "drag-begin", G_CALLBACK (rodent_signal_drag_begin), view_p);
    g_signal_connect (G_OBJECT (view_p->widgets.paper), "drag-leave", G_CALLBACK (rodent_signal_drag_leave), view_p);
    g_signal_connect (G_OBJECT (view_p->widgets.paper), "drag-data-delete", G_CALLBACK (rodent_signal_drag_delete), view_p);
//    g_signal_connect(G_OBJECT(view_p->widgets.paper), "drag-drop",
//          G_CALLBACK(rodent_signal_drag_drop), view_p);

    g_signal_connect (G_OBJECT (view_p->widgets.window), "destroy_event", G_CALLBACK (destroy_event), view_p);
    g_signal_connect (G_OBJECT (view_p->widgets.window), "delete_event", G_CALLBACK (destroy_event), view_p);

    rodent_create_target_list (view_p);
#if 0
    {
        TRACE ("hscrollbar=%d\n", view_p->widgets.scrolled_window->hscrollbar->allocation.height);
        TRACE ("vscrollbar=%d\n", view_p->widgets.scrolled_window->vscrollbar->allocation.width);
    }
#endif
    /* now lets get the text height from pango */
    {
        PangoLayout *layout;
        PangoRectangle logical_rect;
        const gchar *tag = "HECHO EN MEXICO";
        layout = gtk_widget_create_pango_layout (view_p->widgets.paper, tag);
        pango_layout_get_pixel_extents (layout, NULL, &(logical_rect));
        view_p->view_layout.text_height = logical_rect.height;
        g_object_unref (layout);
    }

    gtk_widget_show_all (view_p->widgets.window);
    //rodent_clean_paper (view_p);
    screen_set_selection (view_p);
    /* get around fvwm margins: */
    gtk_window_move ((GtkWindow *) (view_p->widgets.window), 0, 0);

#if 0
    /* Make the root window send events to me */
    gdk_window_set_user_data (GDK_ROOT_PARENT (), view_p->widgets.paper);
    XSelectInput (GDK_DISPLAY (), GDK_ROOT_WINDOW (), PropertyChangeMask);
    g_signal_connect (G_OBJECT (view_p->widgets.paper), "property-notify-event", G_CALLBACK (handle_property_notify), view_p);
#endif
    TRACE ("create_deskview done----------------------------\n");
    TRACE ("POP_SEM:  sem_init(&(view_p->population_sem),0,1)\n");

    return view_p;
}


/*********************************************************************/
