#define COMMENT(...) G_STMT_START{ (void)0; }G_STMT_END
#define NOOP(...) G_STMT_START{ (void)0; }G_STMT_END

#ifdef DEBUG

#include <sys/resource.h>
# ifdef NO_RFM_GLOBAL_P
#  define DBG(...)   \
    G_STMT_START{ \
	fprintf(stdout, "?:");\
	fprintf(stdout, __VA_ARGS__); \
	fflush(stdout);\
    }G_STMT_END
#  define ALERT(...) \
    G_STMT_START{ \
	gchar *text=g_strdup_printf (__VA_ARGS__); \
	g_warning(text); \
	g_free(text); \
    }G_STMT_END

# else
#  define DBG(...)  \
    G_STMT_START{ \
      if (rfm_global_p && rfm_global_p->argv[0] && !strstr(rfm_global_p->argv[0], "rodent-getpass")) {\
	if (rfm_global_p && g_thread_self() == rfm_global_p->self) {\
	    fprintf(stdout, "DBG MAIN: "); \
	} else {\
	    fprintf(stdout, "DBG CHILD: "); \
	}\
	fprintf(stdout, __VA_ARGS__); \
	fflush(stdout);\
      } \
      else { (void)0; }\
    }G_STMT_END
#  define ALERT(...) \
    G_STMT_START{ \
	gchar *text=g_strdup_printf(__VA_ARGS__); \
	rfm_confirm(widgets_p, GTK_MESSAGE_WARNING, text, NULL, _("Accept")); \
	g_free(text); \
    }G_STMT_END
# endif
#else
# define DBG(...)   G_STMT_START{ (void)0; }G_STMT_END
# define ALERT(...) G_STMT_START{\
    fprintf (stderr, "++ Warning: ");\
    fprintf (stderr, __VA_ARGS__); \
}G_STMT_END
#endif



#ifdef DEBUG_TRACE
#include <sys/resource.h>
# define THREAD_CREATE(X,Y,Z) \
    TRACE("THREAD CREATED %s (0x%x)\n", \
	    Z, \
	    GPOINTER_TO_INT(g_thread_create(X, Y, FALSE, NULL)))
# ifdef NO_RFM_GLOBAL_P
#  define TRACE(...)   \
    G_STMT_START{ \
	fprintf(stdout, "?:");\
	fprintf(stdout, __VA_ARGS__); \
	fflush(stdout);\
    }G_STMT_END
# else
#  define TRACE(...)  \
    G_STMT_START{ \
      if (rfm_global_p && rfm_global_p->argv[0] && !strstr(rfm_global_p->argv[0], "rodent-getpass")) {\
	if (rfm_global_p && g_thread_self() == rfm_global_p->self) {\
	    fprintf(stdout, "TRACE MAIN: "); \
	} else {\
	    fprintf(stdout, "TRACE CHILD: "); \
	}\
	fprintf(stdout, __VA_ARGS__); \
	fflush(stdout);\
      } \
      else { (void)0; }\
    }G_STMT_END
# endif
#else
/*
# define THREAD_CREATE(X,Y,Z) \
    fprintf(stderr, "thread 0x%x created: %s\n", \
	    GPOINTER_TO_INT(g_thread_create(X, Y, FALSE, NULL)),\
	    Z) 
*/
# define THREAD_CREATE(X,Y,Z) g_thread_create(X, Y, FALSE, NULL)

# define TRACE(...)   G_STMT_START{ (void)0; }G_STMT_END
#endif


