/* vim: set cino= fo=croql sw=8 ts=8 sts=0 noet cin fdm=syntax : */

/*
 * Copyright (c) 2010 Ali Polatel <alip@exherbo.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#if 0
# vim: set ro :

# *********************************************************
# THIS IS A GENERATED FILE! DO NOT EDIT THIS FILE DIRECTLY!
# *********************************************************
#
#endif


#ifndef PINKTRACE_GUARD_BITNESS_H
#define PINKTRACE_GUARD_BITNESS_H 1

/**
 * \file
 * Pink's bitness modes
 **/

#include <sys/types.h>

#include <pinktrace/gcc.h>

/**
 * Bitness modes
 **/
typedef enum {
	/** Unknown bitness ( error with #pink_bitness_get ) **/
	PINK_BITNESS_UNKNOWN = -1,
	/** 32 bit mode **/
	PINK_BITNESS_32,
	/** 64 bit mode **/
	PINK_BITNESS_64,
} pink_bitness_t;

/**
 * Default bitness (eg #PINK_BITNESS_64 on x86_64, #PINK_BITNESS_32 on i386)
 **/
#define PINKTRACE_BITNESS_DEFAULT PINK_BITNESS_64

/**
 * Number of supported bitnesses (eg 2 on x86_64, 1 on i386)
 **/
#define PINKTRACE_BITNESS_COUNT_SUPPORTED 2

/**
 * Non-zero if 64bit is supported, 0 otherwise (eg 1 on x86_64, 0 on i386)
 **/
#define PINKTRACE_BITNESS_64_SUPPORTED 1

/**
 * Non-zero if 32bit is supported, 0 otherwise (eg 1 on i386, 0 on ia64)
 **/
#define PINKTRACE_BITNESS_32_SUPPORTED 1

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/**
 * Return the bitness of the given process ID.
 *
 * \param pid Process ID of the process whose bitness is to be returned.
 *
 * \return One of PINK_BITNESS_* constants.
 **/
pink_bitness_t
pink_bitness_get(pid_t pid);

/**
 * Return the string representation of the given bitness.
 *
 * \param bitness The bitness to be stringified.
 *
 * \return String representation of the bitness.
 **/
PINK_PURE
const char *
pink_bitness_name(pink_bitness_t bitness);

/**
 * Return the word size of the given bitness.
 *
 * \param bitness Bitness of the child
 *
 * \return Word size of the bitness
 *
 * \since 0.0.3
 **/
PINK_PURE
unsigned short
pink_bitness_wordsize(pink_bitness_t bitness);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* !PINKTRACE_GUARD_BITNESS_H */
