/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.model.description;

import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.utils.external.ExternalFactoriesHelper;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.xml.model.property.converter.EnumConverter;
import org.eclipse.wb.internal.core.xml.model.property.converter.ExpressionConverter;
import org.eclipse.wb.internal.core.xml.model.property.editor.EnumPropertyEditor;

public class DescriptionPropertiesHelper {
    private static final String POINT_PROPERTY_EDITORS = "org.eclipse.wb.core.xml.propertyEditors";
    private static final String POINT_PROPERTY_CONVERTERS = "org.eclipse.wb.core.xml.propertyConverters";

    private DescriptionPropertiesHelper() {
    }

    public static PropertyEditor getEditorForType(Class<?> type) throws Exception {
        String typeName = ReflectionUtils.getFullyQualifiedName(type, (boolean)false);
        List elements = ExternalFactoriesHelper.getElements((String)POINT_PROPERTY_EDITORS, (String)"editor");
        for (IConfigurationElement element : elements) {
            if (!typeName.equals(element.getAttribute("type"))) continue;
            return (PropertyEditor)ExternalFactoriesHelper.createExecutableExtension((IConfigurationElement)element, (String)"class");
        }
        if (type.isEnum()) {
            return EnumPropertyEditor.INSTANCE;
        }
        return null;
    }

    public static PropertyEditor getConfigurableEditor(String id) throws Exception {
        List elements = ExternalFactoriesHelper.getElements((String)POINT_PROPERTY_EDITORS, (String)"configurableEditor");
        for (IConfigurationElement element : elements) {
            if (!id.equals(element.getAttribute("id"))) continue;
            return (PropertyEditor)ExternalFactoriesHelper.createExecutableExtension((IConfigurationElement)element, (String)"class");
        }
        return null;
    }

    public static ExpressionConverter getConverterForType(Class<?> type) throws Exception {
        String typeName = ReflectionUtils.getFullyQualifiedName(type, (boolean)false);
        List elements = ExternalFactoriesHelper.getElements((String)POINT_PROPERTY_CONVERTERS, (String)"converter");
        for (IConfigurationElement element : elements) {
            if (!typeName.equals(element.getAttribute("type"))) continue;
            return (ExpressionConverter)ExternalFactoriesHelper.createExecutableExtension((IConfigurationElement)element, (String)"class");
        }
        if (type.isEnum()) {
            return EnumConverter.INSTANCE;
        }
        return null;
    }
}

