/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.wtpbuilder;

import org.eclipse.wtp.releng.wtpbuilder.IBuildConstants;

public class Build
implements IBuildConstants {
    private boolean publicBuild;
    private String type;
    private String id;
    private String date;
    private String time;
    private String stream;

    public Build(boolean aPublicBuild, String aType, String anId, String aDate, String aTime, String aStream) {
        this.publicBuild = aPublicBuild;
        this.type = aType;
        this.id = anId;
        this.date = aDate;
        this.time = aTime;
        this.stream = aStream;
    }

    public boolean isPublicBuild() {
        return this.publicBuild;
    }

    public void setPublicBuild(boolean publicBuild) {
        this.publicBuild = publicBuild;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTime() {
        return this.time;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getStream() {
        return this.stream;
    }

    public void setStream(String stream) {
        this.stream = stream;
    }

    public boolean isNewer(Build build) {
        int thatDate;
        int thisDate = Integer.parseInt(this.date);
        if (thisDate == (thatDate = Integer.parseInt(build.getDate()))) {
            int thatTime;
            int thisTime = Integer.parseInt(this.time);
            if (thisTime == (thatTime = Integer.parseInt(build.getTime()))) {
                return this.getBuildTypeWeight(this.type) > this.getBuildTypeWeight(build.getType());
            }
            return thisTime > thatTime;
        }
        return thisDate > thatDate;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.type);
        sb.append("-");
        sb.append(this.id);
        sb.append("-");
        sb.append(this.date);
        sb.append(this.time);
        return sb.toString();
    }

    private int getBuildTypeWeight(String buildType) {
        if ("S".equals(buildType)) {
            return 40;
        }
        if ("I".equals(buildType)) {
            return 30;
        }
        if ("M".equals(buildType)) {
            return 20;
        }
        if ("N".equals(buildType)) {
            return 10;
        }
        return 0;
    }
}

