/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.annotation.internal.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jst.j2ee.ejb.annotation.internal.messages.IEJBAnnotationConstants;
import org.eclipse.jst.j2ee.ejb.annotation.internal.model.CMPAttributeDelegate;
import org.eclipse.jst.j2ee.ejb.annotation.internal.model.ContainerManagedEntityBeanDelegate;
import org.eclipse.jst.j2ee.ejb.annotation.internal.model.EnterpriseBeanClassDataModelProvider;
import org.eclipse.jst.j2ee.ejb.annotation.internal.model.IContainerManagedEntityBeanDataModelProperties;
import org.eclipse.jst.j2ee.ejb.annotation.internal.operations.AddContainerManagedEntityBeanOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public class ContainerManagedEntityBeanDataModelProvider
extends EnterpriseBeanClassDataModelProvider
implements IContainerManagedEntityBeanDataModelProperties {
    public static final String DEFAULT_EJB_SUPERCLASS = "java.lang.Object";
    public static final String[] DEFAULT_EJB_INTERFACES = new String[]{"javax.ejb.EntityBean"};
    private List interfaceList;

    public IDataModelOperation getDefaultOperation() {
        AddContainerManagedEntityBeanOperation operation = new AddContainerManagedEntityBeanOperation(this.getDataModel());
        this.getDataModel().getProperty("IEjbCommonDataModel.MODELDELEGATE");
        return operation;
    }

    public Set getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("EntityBeanDataModel.DATASOURCE");
        propertyNames.add("EntityBeanDataModel.SCHEMA");
        propertyNames.add("EntityBeanDataModel.TABLE");
        propertyNames.add("EntityBeanDataModel.ATTRIBUTES");
        propertyNames.add("EntityBeanDataModel.VERSION");
        propertyNames.add("EntityBeanDataModel.EJB_INTERFACES");
        return propertyNames;
    }

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("IAnnotationsDataModel.useAnnotations")) {
            return Boolean.FALSE;
        }
        if (propertyName.equals("EntityBeanDataModel.DATASOURCE")) {
            return this.getProperty("IEjbCommonDataModel.JNDI_NAME");
        }
        if (propertyName.equals("IEjbCommonDataModel.EJB_TYPE")) {
            return "EntityBean";
        }
        if (propertyName.equals("NewJavaClassDataModel.MODIFIER_ABSTRACT")) {
            return Boolean.FALSE;
        }
        if (propertyName.equals("NewJavaClassDataModel.SUPERCLASS")) {
            return DEFAULT_EJB_SUPERCLASS;
        }
        if (propertyName.equals("EntityBeanDataModel.EJB_INTERFACES")) {
            return DEFAULT_EJB_INTERFACES;
        }
        if (propertyName.equals("EntityBeanDataModel.SCHEMA")) {
            return this.getProperty("IEjbCommonDataModel.EJB_NAME") + "SCHEMA";
        }
        if (propertyName.equals("EntityBeanDataModel.TABLE")) {
            return "MYTABLE";
        }
        if (propertyName.equals("EntityBeanDataModel.ATTRIBUTES")) {
            return new ArrayList();
        }
        if (propertyName.equals("EntityBeanDataModel.VERSION")) {
            return "2.x";
        }
        return super.getDefaultProperty(propertyName);
    }

    public IStatus validate(String propertyName) {
        if (propertyName.equals("EntityBeanDataModel.DATASOURCE")) {
            return this.validateJndiName(this.getStringProperty(propertyName));
        }
        if (propertyName.equals("EntityBeanDataModel.TABLE")) {
            return this.validateTable(this.getStringProperty(propertyName));
        }
        if (propertyName.equals("EntityBeanDataModel.SCHEMA")) {
            return this.validateJndiName(this.getStringProperty(propertyName));
        }
        if (propertyName.equals("EntityBeanDataModel.ATTRIBUTES")) {
            return this.validateAttributes(this.getProperty(propertyName));
        }
        if (propertyName.equals("EntityBeanDataModel.VERSION")) {
            return this.validateVersion((String)this.getProperty(propertyName));
        }
        return super.validate(propertyName);
    }

    protected IStatus validateTable(String prop) {
        if (prop == null || prop.trim().length() == 0 || prop.indexOf(" ") >= 0) {
            String msg = IEJBAnnotationConstants.ERR_CMP_INVALID_TABLE;
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    protected IStatus validateVersion(String prop) {
        if (prop == null || prop.trim().length() == 0 || prop.indexOf(" ") >= 0) {
            String msg = IEJBAnnotationConstants.ERR_CMP_INVALID_VERSION;
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        if (!"1.x".equals(prop) && !"2.x".equals(prop)) {
            String msg = IEJBAnnotationConstants.ERR_CMP_INVALID_VERSION;
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    private IStatus validateAttributes(Object property) {
        ArrayList attributes = (ArrayList)property;
        if (attributes == null || attributes.size() == 0) {
            String msg = IEJBAnnotationConstants.ERR_NO_ATTRIBUTES;
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        Iterator attributeNames = attributes.iterator();
        boolean duplicate = false;
        block0: while (attributeNames.hasNext() && !duplicate) {
            CMPAttributeDelegate aRow = (CMPAttributeDelegate)attributeNames.next();
            Iterator otherNames = attributes.iterator();
            while (otherNames.hasNext()) {
                CMPAttributeDelegate otherRow = (CMPAttributeDelegate)otherNames.next();
                if (aRow != otherRow && aRow.getName().equals(otherRow.getName())) {
                    duplicate = true;
                    continue block0;
                }
                if (aRow == otherRow || !aRow.getColumnName().equals(otherRow.getColumnName())) continue;
                duplicate = true;
                continue block0;
            }
        }
        if (duplicate) {
            return WTPCommonPlugin.createErrorStatus((String)IEJBAnnotationConstants.ERR_DUPLICATE_ATTRIBUTES);
        }
        attributeNames = attributes.iterator();
        int primaryKey = 0;
        while (attributeNames.hasNext() && !duplicate) {
            CMPAttributeDelegate aRow = (CMPAttributeDelegate)attributeNames.next();
            if (!aRow.isKey()) continue;
            ++primaryKey;
        }
        if (primaryKey == 0) {
            return WTPCommonPlugin.createErrorStatus((String)IEJBAnnotationConstants.ERR_NO_KEY);
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    public List getCMPAttributes() {
        List attributes = (List)this.getProperty("EntityBeanDataModel.ATTRIBUTES");
        return attributes;
    }

    protected List getEJBInterfaces() {
        if (this.interfaceList == null) {
            this.interfaceList = new ArrayList();
            int i = 0;
            while (i < ((String[])this.getProperty("EntityBeanDataModel.EJB_INTERFACES")).length) {
                this.interfaceList.add(((String[])this.getProperty("EntityBeanDataModel.EJB_INTERFACES"))[i]);
                ++i;
            }
        }
        return this.interfaceList;
    }

    protected void initializeDelegate() {
        ContainerManagedEntityBeanDelegate delegate = new ContainerManagedEntityBeanDelegate();
        delegate.setDataModel(this.getDataModel());
        this.setProperty("IEjbCommonDataModel.MODELDELEGATE", delegate);
        this.setProperty("EntityBeanDataModel.DATASOURCE", this.getProperty("EntityBeanDataModel.DATASOURCE"));
        this.setProperty("EntityBeanDataModel.SCHEMA", this.getProperty("EntityBeanDataModel.SCHEMA"));
        this.setProperty("EntityBeanDataModel.TABLE", this.getProperty("EntityBeanDataModel.TABLE"));
        this.setProperty("EntityBeanDataModel.ATTRIBUTES", this.getProperty("EntityBeanDataModel.ATTRIBUTES"));
        this.setProperty("EntityBeanDataModel.VERSION", this.getProperty("EntityBeanDataModel.VERSION"));
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        boolean result = super.propertySet(propertyName, propertyValue);
        if (propertyName.equals("IEjbCommonDataModel.EJB_NAME")) {
            if (!this.isPropertySet("EntityBeanDataModel.DATASOURCE")) {
                this.getDataModel().notifyPropertyChange("EntityBeanDataModel.DATASOURCE", 2);
            }
            if (!this.isPropertySet("EntityBeanDataModel.SCHEMA")) {
                this.getDataModel().notifyPropertyChange("EntityBeanDataModel.SCHEMA", 2);
            }
        }
        return result;
    }
}

