/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.generic.core.internal;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourcePathComputerDelegate;
import org.eclipse.debug.core.sourcelookup.containers.FolderSourceContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;

public class GenericServerSourcePathComputerDelegate
implements ISourcePathComputerDelegate {
    public ISourceContainer[] computeSourceContainers(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        IRuntimeClasspathEntry[] unresolvedEntries = JavaRuntime.computeUnresolvedSourceLookupPath((ILaunchConfiguration)configuration);
        ArrayList<FolderSourceContainer> sourcefolderList = new ArrayList<FolderSourceContainer>();
        IServer server = ServerUtil.getServer((ILaunchConfiguration)configuration);
        IModule[] modules = server.getModules();
        ArrayList<IJavaProject> javaProjectList = new ArrayList<IJavaProject>();
        int i = 0;
        while (i < modules.length) {
            IProject project = modules[i].getProject();
            if (project != null) {
                IFolder moduleFolder = project.getFolder(modules[i].getName());
                if (moduleFolder.exists()) {
                    sourcefolderList.add(new FolderSourceContainer((IContainer)moduleFolder, true));
                } else {
                    try {
                        if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                            IJavaProject javaProject = (IJavaProject)project.getNature("org.eclipse.jdt.core.javanature");
                            javaProjectList.add(javaProject);
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            ++i;
        }
        IRuntimeClasspathEntry[] projectEntries = new IRuntimeClasspathEntry[javaProjectList.size()];
        int i2 = 0;
        while (i2 < javaProjectList.size()) {
            projectEntries[i2] = JavaRuntime.newProjectRuntimeClasspathEntry((IJavaProject)((IJavaProject)javaProjectList.get(i2)));
            ++i2;
        }
        IRuntimeClasspathEntry[] entries = new IRuntimeClasspathEntry[projectEntries.length + unresolvedEntries.length];
        System.arraycopy(unresolvedEntries, 0, entries, 0, unresolvedEntries.length);
        System.arraycopy(projectEntries, 0, entries, unresolvedEntries.length, projectEntries.length);
        IRuntimeClasspathEntry[] resolved = JavaRuntime.resolveSourceLookupPath((IRuntimeClasspathEntry[])entries, (ILaunchConfiguration)configuration);
        ISourceContainer[] javaSourceContainers = JavaRuntime.getSourceContainers((IRuntimeClasspathEntry[])resolved);
        if (!sourcefolderList.isEmpty()) {
            ISourceContainer[] combinedSourceContainers = new ISourceContainer[javaSourceContainers.length + sourcefolderList.size()];
            sourcefolderList.toArray(combinedSourceContainers);
            System.arraycopy(javaSourceContainers, 0, combinedSourceContainers, sourcefolderList.size(), javaSourceContainers.length);
            javaSourceContainers = combinedSourceContainers;
        }
        return javaSourceContainers;
    }
}

