/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.refactor.actions;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameRefactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.ui.actions.GlobalBuildAction;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.refactor.XMLRefactoringComponent;
import org.eclipse.wst.xsd.ui.internal.refactor.actions.XSDSelectionDispatchAction;
import org.eclipse.wst.xsd.ui.internal.refactor.rename.RenameComponentProcessor;
import org.eclipse.wst.xsd.ui.internal.refactor.wizard.RefactoringWizardMessages;
import org.eclipse.wst.xsd.ui.internal.refactor.wizard.RenameRefactoringWizard;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDTypeDefinition;
import org.w3c.dom.Node;

public class RenameComponentAction
extends XSDSelectionDispatchAction {
    private XSDNamedComponent selectedComponent;

    public RenameComponentAction(ISelection selection, Object aModel) {
        super(selection, aModel);
    }

    protected boolean canEnable(XSDConcreteComponent selectedObject) {
        this.selectedComponent = null;
        if (selectedObject instanceof XSDNamedComponent) {
            XSDElementDeclaration element;
            this.selectedComponent = (XSDNamedComponent)selectedObject;
            if (this.selectedComponent instanceof XSDElementDeclaration && (element = (XSDElementDeclaration)this.selectedComponent).isElementDeclarationReference()) {
                this.selectedComponent = null;
            }
            if (this.selectedComponent instanceof XSDTypeDefinition) {
                XSDAttributeDeclaration element2;
                XSDTypeDefinition type = (XSDTypeDefinition)this.selectedComponent;
                XSDConcreteComponent parent = type.getContainer();
                if (parent instanceof XSDElementDeclaration) {
                    XSDElementDeclaration element3 = (XSDElementDeclaration)parent;
                    if (element3.getAnonymousTypeDefinition().equals(type)) {
                        this.selectedComponent = null;
                    }
                } else if (parent instanceof XSDAttributeDeclaration && (element2 = (XSDAttributeDeclaration)parent).getAnonymousTypeDefinition().equals(type)) {
                    this.selectedComponent = null;
                }
            }
        }
        return this.canRun();
    }

    protected boolean canEnable(Object selectedObject) {
        if (selectedObject instanceof XSDConcreteComponent) {
            return this.canEnable((XSDConcreteComponent)selectedObject) && super.canEnable(selectedObject);
        }
        if (selectedObject instanceof Node) {
            Node node = (Node)selectedObject;
            if (this.getSchema() != null) {
                XSDConcreteComponent concreteComponent = this.getSchema().getCorrespondingComponent(node);
                return this.canEnable(concreteComponent) && super.canEnable(concreteComponent);
            }
        }
        return false;
    }

    public boolean canRun() {
        return this.selectedComponent != null;
    }

    public void run(ISelection selection) {
        if (this.selectedComponent.getName() == null) {
            this.selectedComponent.setName(new String());
        }
        if (this.selectedComponent.getSchema() == null && this.getSchema() != null) {
            this.getSchema().updateElement(true);
        }
        XMLRefactoringComponent component = new XMLRefactoringComponent(this.selectedComponent, (IDOMElement)this.selectedComponent.getElement(), this.selectedComponent.getName(), this.selectedComponent.getTargetNamespace());
        RenameComponentProcessor processor = new RenameComponentProcessor(component, this.selectedComponent.getName());
        RenameRefactoring refactoring = new RenameRefactoring((RenameProcessor)processor);
        try {
            RenameRefactoringWizard wizard = new RenameRefactoringWizard((Refactoring)refactoring, RefactoringWizardMessages.RenameComponentWizard_defaultPageTitle, RefactoringWizardMessages.RenameComponentWizard_inputPage_description, null);
            RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
            op.run(XSDEditorPlugin.getShell(), wizard.getDefaultPageTitle());
            RenameComponentAction.triggerBuild();
        }
        catch (InterruptedException interruptedException) {}
    }

    public static void triggerBuild() {
        if (ResourcesPlugin.getWorkspace().getDescription().isAutoBuilding()) {
            new GlobalBuildAction(XSDEditorPlugin.getPlugin().getWorkbench().getActiveWorkbenchWindow(), 10).run();
        }
    }
}

