/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.properties.sections;

import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.wst.xsd.ui.internal.common.commands.AddExtensionAttributeCommand;
import org.eclipse.wst.xsd.ui.internal.common.commands.AddExtensionCommand;
import org.eclipse.wst.xsd.ui.internal.common.commands.AddExtensionElementCommand;
import org.eclipse.wst.xsd.ui.internal.common.commands.RemoveExtensionNodeCommand;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.AbstractExtensionsSection;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.appinfo.DOMExtensionTreeLabelProvider;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.appinfo.ExtensionsSchemasRegistry;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.appinfo.XSDExtensionTreeContentProvider;
import org.eclipse.wst.xsd.ui.internal.common.util.Messages;
import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.text.XSDModelAdapter;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ExtensionsSection
extends AbstractExtensionsSection {
    XSDModelAdapter adapter = null;

    public ExtensionsSection() {
        this.setExtensionTreeLabelProvider((ILabelProvider)new DOMExtensionTreeLabelProvider());
        this.setExtensionTreeContentProvider(new XSDExtensionTreeContentProvider());
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        Element element;
        Object obj;
        super.setInput(part, selection);
        if (this.adapter == null && selection instanceof StructuredSelection && (obj = ((StructuredSelection)selection).getFirstElement()) instanceof XSDConcreteComponent && (element = ((XSDConcreteComponent)obj).getElement()) != null) {
            this.adapter = XSDModelAdapter.lookupOrCreateModelAdapter(element.getOwnerDocument());
            if (this.adapter != null) {
                this.adapter.getModelReconcileAdapter().addListener(this.internalNodeAdapter);
            }
        }
    }

    public void dispose() {
        super.dispose();
        if (this.adapter != null) {
            this.adapter.getModelReconcileAdapter().removeListener(this.internalNodeAdapter);
        }
    }

    protected AddExtensionCommand getAddExtensionCommand(Object o) {
        AddExtensionCommand addExtensionCommand = null;
        if (o instanceof XSDElementDeclaration) {
            XSDElementDeclaration element = (XSDElementDeclaration)o;
            addExtensionCommand = new AddExtensionElementCommand(Messages._UI_ACTION_ADD_APPINFO_ELEMENT, (XSDConcreteComponent)this.input, element);
        } else if (o instanceof XSDAttributeDeclaration) {
            XSDAttributeDeclaration attribute = (XSDAttributeDeclaration)o;
            addExtensionCommand = new AddExtensionAttributeCommand(Messages._UI_ACTION_ADD_APPINFO_ATTRIBUTE, (XSDConcreteComponent)this.input, attribute);
        }
        return addExtensionCommand;
    }

    protected Command getRemoveExtensionCommand(Object o) {
        RemoveExtensionNodeCommand command = null;
        try {
            if (o instanceof Node) {
                command = new RemoveExtensionNodeCommand(Messages._UI_ACTION_DELETE_APPINFO_ELEMENT, (Node)o);
                command.execute();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return command;
    }

    protected ExtensionsSchemasRegistry getExtensionsSchemasRegistry() {
        return XSDEditorPlugin.getDefault().getExtensionsSchemasRegistry();
    }

    protected boolean isTreeViewerInputElement(Element element) {
        if (this.input instanceof XSDConcreteComponent) {
            Node grandParent;
            XSDConcreteComponent component = (XSDConcreteComponent)this.input;
            Element componentElement = component.getElement();
            Node parent = element.getParentNode();
            Node node = grandParent = parent != null ? parent.getParentNode() : null;
            return componentElement == element || componentElement == parent || componentElement == grandParent;
        }
        return false;
    }
}

