/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.parser.wsil;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.wsil.Abstract;
import org.apache.wsil.Description;
import org.apache.wsil.Inspection;
import org.apache.wsil.Link;
import org.apache.wsil.Service;
import org.apache.wsil.WSILDocument;
import org.apache.wsil.WSILException;
import org.apache.wsil.extension.ExtensionElement;
import org.apache.wsil.extension.uddi.ServiceDescription;
import org.eclipse.wst.ws.internal.parser.disco.DISCOContractReference;
import org.eclipse.wst.ws.internal.parser.disco.DISCOParser;
import org.eclipse.wst.ws.internal.parser.disco.DISCOReference;
import org.eclipse.wst.ws.internal.parser.wsil.HTMLHeadHandler;
import org.eclipse.wst.ws.internal.parser.wsil.UDDIURIHelper;
import org.eclipse.wst.ws.internal.parser.wsil.WWWAuthenticationException;
import org.eclipse.wst.ws.internal.parser.wsil.WebServiceEntity;
import org.eclipse.wst.wsdl.WSDLPlugin;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import sun.misc.BASE64Encoder;

public class WebServicesParser {
    public static final int PARSE_NONE = 0;
    public static final int PARSE_WSIL = 1;
    public static final int PARSE_WSDL = 2;
    public static final int PARSE_LINKS = 4;
    public static final int PARSE_DISCO = 8;
    private String uri_;
    private Hashtable uriToEntityTable_;
    private String httpBasicAuthUsername_;
    private String httpBasicAuthPassword_;

    public WebServicesParser() {
        this(null);
    }

    public WebServicesParser(String uri) {
        this.uri_ = uri;
        this.uriToEntityTable_ = new Hashtable();
        this.httpBasicAuthUsername_ = null;
        this.httpBasicAuthPassword_ = null;
    }

    public String getURI() {
        return this.uri_;
    }

    public void setURI(String uri) {
        this.uri_ = uri;
    }

    public WebServiceEntity getWebServiceEntityByURI(String uri) {
        if (uri != null) {
            return (WebServiceEntity)this.uriToEntityTable_.get(uri);
        }
        return null;
    }

    public WSILDocument getWSILDocument(String wsilURI) {
        try {
            return this.getWSILDocumentVerbose(wsilURI);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public WSILDocument getWSILDocumentVerbose(String wsilURI) throws MalformedURLException, IOException, WWWAuthenticationException, WSILException {
        WSILDocument wsilDocument;
        WebServiceEntity wsEntity = this.getWebServiceEntityByURI(wsilURI);
        if (wsEntity == null) {
            wsEntity = new WebServiceEntity();
            wsEntity.setURI(wsilURI);
            this.uriToEntityTable_.put(wsilURI, wsEntity);
        }
        if ((wsilDocument = (WSILDocument)wsEntity.getModel()) == null) {
            byte[] b = this.getInputStreamAsByteArray(wsilURI);
            wsEntity.setBytes(b);
            this.setHTTPSettings(wsEntity);
            InputStreamReader isr = new InputStreamReader(new ByteArrayInputStream(b));
            wsilDocument = WSILDocument.newInstance();
            wsilDocument.read((Reader)isr);
            wsEntity.setType(1);
            wsEntity.setModel(wsilDocument);
        }
        return wsilDocument;
    }

    public Definition getWSDLDefinition(String wsdlURI) {
        try {
            return this.getWSDLDefinitionVerbose(wsdlURI);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public Definition getWSDLDefinitionVerbose(String wsdlURI) throws MalformedURLException, IOException, WWWAuthenticationException, WSDLException {
        Definition definition;
        WebServiceEntity wsEntity = this.getWebServiceEntityByURI(wsdlURI);
        if (wsEntity == null) {
            wsEntity = new WebServiceEntity();
            wsEntity.setURI(wsdlURI);
            this.uriToEntityTable_.put(wsdlURI, wsEntity);
        }
        if ((definition = (Definition)wsEntity.getModel()) == null) {
            byte[] b = this.getInputStreamAsByteArray(wsdlURI);
            wsEntity.setBytes(b);
            this.setHTTPSettings(wsEntity);
            ByteArrayInputStream bais = new ByteArrayInputStream(b);
            WSDLFactory factory = WSDLPlugin.INSTANCE.createWSDL4JFactory();
            WSDLReader wsdlReader = factory.newWSDLReader();
            definition = wsdlReader.readWSDL(wsdlURI, new InputSource(bais));
            wsEntity.setType(2);
            wsEntity.setModel(definition);
        }
        return definition;
    }

    public void parse() throws MalformedURLException, IOException, ParserConfigurationException, SAXException, WWWAuthenticationException {
        this.parseURL(15);
    }

    public void parse(int parseOption) throws MalformedURLException, IOException, ParserConfigurationException, SAXException, WWWAuthenticationException {
        this.parseURL(parseOption);
    }

    private void parseURL(int parseOption) throws MalformedURLException, IOException, ParserConfigurationException, SAXException, WWWAuthenticationException {
        WebServiceEntity wsEntity = new WebServiceEntity();
        String theUri = this.uri_;
        wsEntity.setURI(theUri);
        byte[] b = this.getInputStreamAsByteArray(theUri);
        wsEntity.setBytes(b);
        this.setHTTPSettings(wsEntity);
        this.uriToEntityTable_.put(theUri, wsEntity);
        HTMLHeadHandler headHandler = new HTMLHeadHandler(theUri);
        byte[] head = headHandler.harvestHeadTags(b);
        String byteEncoding = headHandler.getByteEncoding();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(false);
        factory.setValidating(false);
        SAXParser parser = factory.newSAXParser();
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(head);
            InputStreamReader isr = new InputStreamReader((InputStream)bais, byteEncoding);
            InputSource is = new InputSource(isr);
            parser.parse(is, (DefaultHandler)headHandler);
        }
        catch (Throwable throwable) {}
        String[] wsilURIs = headHandler.getWsils();
        String[] discoURIs = headHandler.getDiscos();
        if (wsilURIs.length > 0 || discoURIs.length > 0) {
            wsEntity.setType(0);
            int i = 0;
            while (i < wsilURIs.length) {
                String absoluteURI = this.convertToAbsoluteURI(theUri, wsilURIs[i]);
                WebServiceEntity wsilEntity = new WebServiceEntity();
                wsilEntity.setType(1);
                wsilEntity.setURI(absoluteURI);
                this.associate(wsEntity, wsilEntity);
                this.uriToEntityTable_.put(absoluteURI, wsilEntity);
                if ((parseOption | 1) == parseOption) {
                    try {
                        this.parseWSIL(absoluteURI, parseOption);
                    }
                    catch (Throwable throwable) {}
                }
                ++i;
            }
            i = 0;
            while (i < discoURIs.length) {
                WebServiceEntity discoEntity = new WebServiceEntity();
                discoEntity.setType(4);
                discoEntity.setURI(discoURIs[i]);
                this.associate(wsEntity, discoEntity);
                this.uriToEntityTable_.put(discoURIs[i], discoEntity);
                if ((parseOption | 8) == parseOption) {
                    try {
                        this.parseDISCO(discoURIs[i], parseOption);
                    }
                    catch (Throwable throwable) {}
                }
                ++i;
            }
        } else {
            try {
                this.parseWSIL(theUri, parseOption);
                wsEntity.setType(1);
            }
            catch (Throwable throwable) {
                try {
                    this.parseDISCO(theUri, parseOption);
                    wsEntity.setType(4);
                }
                catch (Throwable throwable2) {
                    try {
                        this.parseWSDL(theUri);
                        wsEntity.setType(2);
                    }
                    catch (Throwable throwable3) {}
                }
            }
        }
    }

    private void parseWSIL(String wsilURI, int parseOption) throws WSILException, MalformedURLException, IOException, WSDLException, WWWAuthenticationException {
        Abstract[] abstracts;
        String documentation;
        WebServiceEntity wsilEntity = this.getWebServiceEntityByURI(wsilURI);
        WSILDocument wsilDoc = (WSILDocument)wsilEntity.getModel();
        if (wsilDoc != null) {
            return;
        }
        wsilDoc = this.getWSILDocumentVerbose(wsilURI);
        Inspection inspection = wsilDoc.getInspection();
        Service[] services = inspection.getServices();
        int i = 0;
        while (i < services.length) {
            Description[] descs = services[i].getDescriptions();
            documentation = null;
            abstracts = services[i].getAbstracts();
            if (abstracts != null && abstracts.length > 0) {
                documentation = abstracts[0].getText();
            }
            int j = 0;
            while (j < descs.length) {
                ExtensionElement ee;
                String referencedNS = descs[j].getReferencedNamespace();
                abstracts = descs[j].getAbstracts();
                if (abstracts != null && abstracts.length > 0) {
                    documentation = abstracts[0].getText();
                }
                if ("http://schemas.xmlsoap.org/wsdl/".equals(referencedNS)) {
                    String location = descs[j].getLocation();
                    if (location != null && location.length() > 0) {
                        String absoluteURI = this.convertToAbsoluteURI(wsilURI, location);
                        WebServiceEntity wsdlEntity = new WebServiceEntity();
                        wsdlEntity.setType(2);
                        wsdlEntity.setURI(absoluteURI);
                        wsdlEntity.setDocumentation(documentation);
                        this.associate(wsilEntity, wsdlEntity);
                        this.uriToEntityTable_.put(absoluteURI, wsdlEntity);
                        if ((parseOption | 2) == parseOption) {
                            this.parseWSDL(absoluteURI);
                        }
                    }
                } else if ("urn:uddi-org:api_v2".equals(referencedNS) && (ee = descs[j].getExtensionElement()) instanceof ServiceDescription) {
                    ServiceDescription sd = (ServiceDescription)ee;
                    String inquiryURL = sd.getLocation();
                    String serviceKey = sd.getServiceKey().getText();
                    WebServiceEntity uddiServiceEntity = new WebServiceEntity();
                    uddiServiceEntity.setType(3);
                    String uddiServiceKeyURI = UDDIURIHelper.getServiceKeyURI(serviceKey, inquiryURL);
                    uddiServiceEntity.setURI(uddiServiceKeyURI);
                    uddiServiceEntity.setDocumentation(documentation);
                    this.associate(wsilEntity, uddiServiceEntity);
                    this.uriToEntityTable_.put(uddiServiceKeyURI, uddiServiceEntity);
                }
                ++j;
            }
            ++i;
        }
        Link[] links = inspection.getLinks();
        int i2 = 0;
        while (i2 < links.length) {
            if ("http://schemas.xmlsoap.org/ws/2001/10/inspection/".equals(links[i2].getReferencedNamespace())) {
                String linkLocation;
                String absoluteURI;
                WebServiceEntity wsilLinkEntity;
                documentation = null;
                abstracts = links[i2].getAbstracts();
                if (abstracts != null && abstracts.length > 0) {
                    documentation = abstracts[0].getText();
                }
                if ((wsilLinkEntity = this.getWebServiceEntityByURI(absoluteURI = this.convertToAbsoluteURI(wsilURI, linkLocation = links[i2].getLocation()))) == null) {
                    wsilLinkEntity = new WebServiceEntity();
                    wsilLinkEntity.setType(1);
                    wsilLinkEntity.setURI(absoluteURI);
                    wsilLinkEntity.setDocumentation(documentation);
                    this.uriToEntityTable_.put(absoluteURI, wsilLinkEntity);
                    if ((parseOption | 4) == parseOption) {
                        this.parseWSIL(absoluteURI, parseOption);
                    }
                }
                this.associate(wsilEntity, wsilLinkEntity);
            }
            ++i2;
        }
    }

    private void parseDISCO(String discoURI, int parseOption) throws MalformedURLException, WWWAuthenticationException, Exception {
        WebServiceEntity discoEntity = this.getWebServiceEntityByURI(discoURI);
        byte[] b = this.getInputStreamAsByteArray(discoURI);
        discoEntity.setBytes(b);
        this.setHTTPSettings(discoEntity);
        ByteArrayInputStream bais = new ByteArrayInputStream(b);
        DISCOParser parser = new DISCOParser();
        DISCOReference[] references = parser.parse(discoURI, new InputSource(bais));
        if (references != null && references.length > 0) {
            int i = 0;
            while (i < references.length) {
                if (references[i] instanceof DISCOContractReference) {
                    DISCOContractReference reference = (DISCOContractReference)references[i];
                    String ref = reference.getRef();
                    String docRef = reference.getDocRef();
                    WebServiceEntity wsdlEntity = new WebServiceEntity();
                    wsdlEntity.setType(2);
                    wsdlEntity.setURI(ref);
                    wsdlEntity.setDocumentation(docRef);
                    this.associate(discoEntity, wsdlEntity);
                    this.uriToEntityTable_.put(ref, wsdlEntity);
                    if ((parseOption | 2) == parseOption) {
                        this.parseWSDL(ref);
                    }
                } else {
                    String ref = references[i].getRef();
                    WebServiceEntity discoLinkEntity = this.getWebServiceEntityByURI(ref);
                    if (discoLinkEntity == null) {
                        discoLinkEntity = new WebServiceEntity();
                        discoLinkEntity.setType(4);
                        discoLinkEntity.setURI(ref);
                        this.uriToEntityTable_.put(ref, discoLinkEntity);
                        if ((parseOption | 4) == parseOption) {
                            this.parseDISCO(ref, parseOption);
                        }
                    }
                    this.associate(discoEntity, discoLinkEntity);
                }
                ++i;
            }
        }
    }

    private Definition parseWSDL(String wsdlURI) throws WSDLException, MalformedURLException, IOException, WWWAuthenticationException {
        return this.getWSDLDefinitionVerbose(wsdlURI);
    }

    private byte[] getInputStreamAsByteArray(String uriString) throws MalformedURLException, IOException, WWWAuthenticationException {
        String encoding;
        BASE64Encoder encoder;
        byte[] bytes;
        WebServiceEntity wsEntity = this.getWebServiceEntityByURI(uriString);
        if (wsEntity != null && (bytes = wsEntity.getBytes()) != null) {
            return bytes;
        }
        URL url = this.createURL(uriString);
        URLConnection conn = url.openConnection();
        String proxyUserName = System.getProperty("http.proxyUserName");
        String proxyPassword = System.getProperty("http.proxyPassword");
        if (proxyUserName != null && proxyPassword != null) {
            StringBuffer userNamePassword = new StringBuffer(proxyUserName);
            userNamePassword.append(':').append(proxyPassword);
            encoder = new BASE64Encoder();
            encoding = encoder.encode(userNamePassword.toString().getBytes());
            userNamePassword.setLength(0);
            userNamePassword.append("Basic ").append(encoding);
            conn.setRequestProperty("Proxy-authorization", userNamePassword.toString());
        }
        if (this.httpBasicAuthUsername_ != null && this.httpBasicAuthPassword_ != null) {
            StringBuffer sb = new StringBuffer(this.httpBasicAuthUsername_);
            sb.append(':').append(this.httpBasicAuthPassword_);
            encoder = new BASE64Encoder();
            encoding = encoder.encode(sb.toString().getBytes());
            sb.setLength(0);
            sb.append("Basic ").append(encoding);
            conn.setRequestProperty("Authorization", sb.toString());
        }
        InputStream is = null;
        try {
            is = conn.getInputStream();
            String wwwAuthMsg = conn.getHeaderField("WWW-Authenticate");
            if (wwwAuthMsg != null) {
                throw new WWWAuthenticationException(new IOException(), wwwAuthMsg, uriString);
            }
        }
        catch (IOException ioe) {
            String wwwAuthMsg = conn.getHeaderField("WWW-Authenticate");
            if (wwwAuthMsg != null) {
                throw new WWWAuthenticationException(ioe, wwwAuthMsg, uriString);
            }
            throw ioe;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] b = new byte[1024];
        int byteRead = is.read(b);
        while (byteRead != -1) {
            baos.write(b, 0, byteRead);
            byteRead = is.read(b);
        }
        is.close();
        return baos.toByteArray();
    }

    protected URL createURL(String url) throws MalformedURLException {
        return new URL(url);
    }

    private void associate(WebServiceEntity parent, WebServiceEntity child) {
        parent.addChild(child);
        child.setParent(parent);
    }

    private String convertToAbsoluteURI(String baseURI, String refURI) {
        if (refURI != null && refURI.indexOf(":") < 0) {
            StringBuffer absoluteURI = new StringBuffer(baseURI.substring(0, Math.max(baseURI.lastIndexOf(92), baseURI.lastIndexOf(47) + 1)));
            absoluteURI.append(refURI);
            return absoluteURI.toString();
        }
        return refURI;
    }

    private void setHTTPSettings(WebServiceEntity entity) {
        if (this.httpBasicAuthUsername_ != null && this.httpBasicAuthPassword_ != null) {
            entity.setHTTPUsername(this.httpBasicAuthUsername_);
            entity.setHTTPPassword(this.httpBasicAuthPassword_);
        }
    }

    public String getHTTPBasicAuthUsername() {
        return this.httpBasicAuthUsername_;
    }

    public void setHTTPBasicAuthUsername(String username) {
        this.httpBasicAuthUsername_ = username;
    }

    public String getHTTPBasicAuthPassword() {
        return this.httpBasicAuthPassword_;
    }

    public void setHTTPBasicAuthPassword(String password) {
        this.httpBasicAuthPassword_ = password;
    }
}

