/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.gen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.dali.db.Column;
import org.eclipse.dali.db.ForeignKey;
import org.eclipse.dali.db.Table;
import org.eclipse.dali.gen.EntityGenerator;
import org.eclipse.dali.gen.GenScope;
import org.eclipse.dali.gen.ManyToManyRelation;
import org.eclipse.dali.gen.ManyToOneRelation;
import org.eclipse.dali.gen.OneToManyRelation;
import org.eclipse.dali.internal.utility.CollectionTools;
import org.eclipse.dali.internal.utility.NameTools;
import org.eclipse.dali.internal.utility.StringTools;
import org.eclipse.dali.internal.utility.iterators.FilteringIterator;

class GenTable {
    private final GenScope scope;
    private final Table table;
    private final EntityGenerator.Config entityConfig;
    private final String entityName;
    private ManyToManyRelation joinTableRelation;
    private Collection ownedManyToManyRelations = new ArrayList();
    private Collection nonOwnedManyToManyRelations = new ArrayList();
    private Collection manyToOneRelations = new ArrayList();
    private Collection oneToManyRelations = new ArrayList();
    private Set foreignKeyColumns = new HashSet();
    private final Map fieldNames = new HashMap();
    private static final Object EMBEDDED_ID_VIRTUAL_COLUMN = new Object();

    GenTable(GenScope scope, Table table, EntityGenerator.Config entityConfig, Collection entityNames) {
        this.scope = scope;
        this.table = table;
        this.entityConfig = entityConfig;
        this.entityName = this.buildEntityName(entityNames);
    }

    private String buildEntityName(Collection entityNames) {
        String name = this.table.shortJavaClassName();
        if (this.entityConfig.convertToCamelCase()) {
            name = StringTools.convertUnderscoresToCamelCase((String)name);
        }
        name = NameTools.uniqueNameForIgnoreCase((String)name, (Collection)entityNames);
        entityNames.add(name);
        return name;
    }

    void configureManyToManyRelations() {
        if (this.table.foreignKeysSize() != 2) {
            return;
        }
        Iterator stream = this.table.columns();
        while (stream.hasNext()) {
            if (this.table.foreignKeyColumnsContains((Column)stream.next())) continue;
            return;
        }
        Iterator fKeys = this.table.foreignKeys();
        ForeignKey owningFK = (ForeignKey)fKeys.next();
        ForeignKey nonOwningFK = (ForeignKey)fKeys.next();
        GenTable owningTable = this.scope.genTable(owningFK.getReferencedTable());
        GenTable nonOwningTable = this.scope.genTable(nonOwningFK.getReferencedTable());
        if (owningTable == null || nonOwningTable == null) {
            return;
        }
        this.joinTableRelation = new ManyToManyRelation(this, owningFK, owningTable, nonOwningFK, nonOwningTable);
    }

    void addReferencedTablesTo(Set referencedTables) {
        Iterator stream = this.table.foreignKeys();
        while (stream.hasNext()) {
            ForeignKey fk = (ForeignKey)stream.next();
            GenTable genTable = this.scope.genTable(fk.getReferencedTable());
            if (genTable == null) continue;
            referencedTables.add(genTable);
        }
    }

    void clearJoinTableRelation() {
        this.joinTableRelation.clear();
        this.joinTableRelation = null;
    }

    void configureManyToOneRelations() {
        Iterator stream = this.table.foreignKeys();
        while (stream.hasNext()) {
            ForeignKey fk = (ForeignKey)stream.next();
            GenTable referencedtable = this.scope.genTable(fk.getReferencedTable());
            if (referencedtable == null) continue;
            this.manyToOneRelations.add(new ManyToOneRelation(this, fk, referencedtable));
        }
    }

    void configureFieldNames() {
        Set columns = CollectionTools.set((Iterator)this.table.columns());
        if (this.table.primaryKeyColumnsSize() > 1 && this.entityConfig.generateEmbeddedIdForCompoundPK()) {
            this.configureFieldName(EMBEDDED_ID_VIRTUAL_COLUMN, "pk");
        }
        this.configureManyToOneFieldNames(columns);
        this.configureBasicFieldNames(columns);
        this.configureOneToManyFieldNames();
        this.configureOwnedManyToManyFieldNames();
        this.configureNonOwnedManyToManyFieldNames();
    }

    public Iterator readOnlyPrimaryKeyColumns() {
        return new FilteringIterator(this.table.primaryKeyColumns()){

            protected boolean accept(Object o) {
                return GenTable.this.foreignKeyColumnsContains((Column)o);
            }
        };
    }

    Iterator writablePrimaryKeyColumns() {
        return new FilteringIterator(this.table.primaryKeyColumns()){

            protected boolean accept(Object o) {
                return !GenTable.this.foreignKeyColumnsContains((Column)o);
            }
        };
    }

    public Iterator nonPrimaryKeyBasicColumns() {
        return new FilteringIterator(this.table.columns()){

            protected boolean accept(Object o) {
                Column column = (Column)o;
                return !GenTable.this.primaryKeyColumnsContains(column) && !GenTable.this.foreignKeyColumnsContains(column);
            }
        };
    }

    Table getTable() {
        return this.table;
    }

    String getEntityName() {
        return this.entityName;
    }

    boolean isJoinTable() {
        return this.joinTableRelation != null;
    }

    void addOwnedManyToManyRelation(ManyToManyRelation relation) {
        this.ownedManyToManyRelations.add(relation);
    }

    void removeOwnedManyToManyRelation(ManyToManyRelation relation) {
        this.ownedManyToManyRelations.remove(relation);
    }

    void addNonOwnedManyToManyRelation(ManyToManyRelation relation) {
        this.nonOwnedManyToManyRelations.add(relation);
    }

    void removeNonOwnedManyToManyRelation(ManyToManyRelation relation) {
        this.nonOwnedManyToManyRelations.remove(relation);
    }

    void addOneToManyRelation(OneToManyRelation relation) {
        this.oneToManyRelations.add(relation);
    }

    String javaFieldName() {
        return this.table.javaFieldName();
    }

    Iterator manyToOneRelations() {
        return this.manyToOneRelations.iterator();
    }

    Iterator oneToManyRelations() {
        return this.oneToManyRelations.iterator();
    }

    Iterator ownedManyToManyRelations() {
        return this.ownedManyToManyRelations.iterator();
    }

    Iterator nonOwnedManyToManyRelations() {
        return this.nonOwnedManyToManyRelations.iterator();
    }

    private String fieldNameForInternal(Object o) {
        return (String)this.fieldNames.get(o);
    }

    String fieldNameForEmbeddedId() {
        return this.fieldNameForInternal(EMBEDDED_ID_VIRTUAL_COLUMN);
    }

    String fieldNameFor(Column column) {
        return this.fieldNameForInternal(column);
    }

    String fieldNameFor(ManyToOneRelation relation) {
        return this.fieldNameForInternal(relation);
    }

    String fieldNameFor(OneToManyRelation relation) {
        return this.fieldNameForInternal(relation);
    }

    String fieldNameFor(ManyToManyRelation relation) {
        return this.fieldNameForInternal(relation);
    }

    String name() {
        return this.table.getName();
    }

    private void configureManyToOneFieldNames(Set columns) {
        Iterator stream = this.manyToOneRelations.iterator();
        while (stream.hasNext()) {
            ManyToOneRelation relation = (ManyToOneRelation)stream.next();
            CollectionTools.removeAll((Collection)columns, (Iterator)relation.getForeignKey().nonPrimaryKeyBaseColumns());
            CollectionTools.addAll((Collection)this.foreignKeyColumns, (Iterator)relation.getForeignKey().baseColumns());
            relation.setMappedBy(this.configureFieldName(relation, relation.javaFieldName()));
        }
    }

    private String configureFieldName(Object o, String fieldName) {
        fieldName = this.camelCase(fieldName);
        fieldName = NameTools.uniqueNameFor((String)fieldName, this.fieldNames.values());
        this.fieldNames.put(o, fieldName);
        return fieldName;
    }

    private String camelCase(String name) {
        return this.entityConfig.convertToCamelCase() ? StringTools.convertUnderscoresToCamelCase((String)name, (boolean)false) : name;
    }

    private void configureBasicFieldNames(Set columns) {
        Iterator stream = columns.iterator();
        while (stream.hasNext()) {
            Column column = (Column)stream.next();
            this.configureFieldName(column, column.javaFieldName());
        }
    }

    private void configureOneToManyFieldNames() {
        Iterator stream = this.oneToManyRelations.iterator();
        while (stream.hasNext()) {
            OneToManyRelation relation = (OneToManyRelation)stream.next();
            this.configureFieldName(relation, relation.javaFieldName());
        }
    }

    private void configureOwnedManyToManyFieldNames() {
        Iterator stream = this.ownedManyToManyRelations.iterator();
        while (stream.hasNext()) {
            ManyToManyRelation relation = (ManyToManyRelation)stream.next();
            relation.setMappedBy(this.configureFieldName(relation, relation.javaFieldNameFor(this)));
        }
    }

    private void configureNonOwnedManyToManyFieldNames() {
        Iterator stream = this.nonOwnedManyToManyRelations.iterator();
        while (stream.hasNext()) {
            ManyToManyRelation relation = (ManyToManyRelation)stream.next();
            this.configureFieldName(relation, relation.javaFieldNameFor(this));
        }
    }

    boolean foreignKeyColumnsContains(Column column) {
        return this.foreignKeyColumns.contains(column);
    }

    boolean primaryKeyColumnsContains(Column column) {
        return this.table.primaryKeyColumnsContains(column);
    }
}

