/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.gen;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.dali.db.Table;
import org.eclipse.dali.gen.EntityGenerator;
import org.eclipse.dali.gen.GenTable;
import org.eclipse.dali.internal.utility.CollectionTools;
import org.eclipse.dali.internal.utility.iterators.FilteringIterator;

class GenScope {
    private final Map genTables = new HashMap();
    private IProgressMonitor progressMonitor;

    GenScope(Collection tables, EntityGenerator.Config entityConfig, IProgressMonitor progressMonitor) {
        this.initialize(tables, entityConfig, progressMonitor);
    }

    private void checkCanceled() {
        if (this.progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private void initialize(Collection tables, EntityGenerator.Config entityConfig, IProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
        this.buildGenTables(tables, entityConfig);
        this.checkCanceled();
        this.configureManyToManyRelations();
        this.checkCanceled();
        this.configureManyToOneRelations();
        this.checkCanceled();
        this.configureFieldNames();
        this.checkCanceled();
    }

    private void buildGenTables(Collection tables, EntityGenerator.Config entityConfig) {
        int size = tables.size();
        HashSet entityNames = new HashSet(size);
        Iterator stream = tables.iterator();
        while (stream.hasNext()) {
            this.buildGenTable((Table)stream.next(), entityConfig, entityNames);
            this.progressMonitor.worked(40 / size);
        }
    }

    private void buildGenTable(Table table, EntityGenerator.Config entityConfig, Collection entityNames) {
        this.genTables.put(table, new GenTable(this, table, entityConfig, entityNames));
    }

    private void configureManyToManyRelations() {
        int tablesSize = CollectionTools.size((Iterator)this.tables());
        Iterator stream = this.tables();
        while (stream.hasNext()) {
            this.checkCanceled();
            ((GenTable)stream.next()).configureManyToManyRelations();
            this.progressMonitor.worked(730 / tablesSize);
        }
        Set referencedTables = this.buildReferencedTables();
        tablesSize = CollectionTools.size((Iterator)this.joinTables());
        Iterator stream2 = this.joinTables();
        while (stream2.hasNext()) {
            GenTable joinGenTable = (GenTable)stream2.next();
            if (referencedTables.contains(joinGenTable)) {
                joinGenTable.clearJoinTableRelation();
            }
            this.progressMonitor.worked(40 / tablesSize);
        }
    }

    private void configureManyToOneRelations() {
        int tablesSize = CollectionTools.size((Iterator)this.entityTables());
        Iterator stream = this.entityTables();
        while (stream.hasNext()) {
            ((GenTable)stream.next()).configureManyToOneRelations();
            this.progressMonitor.worked(50 / tablesSize);
        }
    }

    private void configureFieldNames() {
        int tablesSize = CollectionTools.size((Iterator)this.entityTables());
        Iterator stream = this.entityTables();
        while (stream.hasNext()) {
            ((GenTable)stream.next()).configureFieldNames();
            this.progressMonitor.worked(50 / tablesSize);
        }
    }

    Iterator entityTables() {
        return new FilteringIterator(this.tables()){

            protected boolean accept(Object o) {
                return !((GenTable)o).isJoinTable();
            }
        };
    }

    int numEntityTables() {
        return CollectionTools.size((Iterator)this.entityTables());
    }

    GenTable genTable(Table table) {
        return (GenTable)this.genTables.get(table);
    }

    private Iterator tables() {
        return this.genTables.values().iterator();
    }

    private Iterator joinTables() {
        return new FilteringIterator(this.tables()){

            protected boolean accept(Object o) {
                return ((GenTable)o).isJoinTable();
            }
        };
    }

    private Set buildReferencedTables() {
        int size = CollectionTools.size((Iterator)this.tables());
        HashSet referencedTables = new HashSet(this.genTables.size());
        Iterator stream = this.tables();
        while (stream.hasNext()) {
            ((GenTable)stream.next()).addReferencedTablesTo(referencedTables);
            this.progressMonitor.worked(20 / size);
        }
        return referencedTables;
    }
}

