/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.binding;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dali.ui.binding.action.IEMFBindingAction;
import org.eclipse.dali.ui.internal.binding.EMFBinding;
import org.eclipse.dali.ui.selection.dispatcher.DispatcherFactory;
import org.eclipse.dali.ui.selection.dispatcher.ISelectionDispatcher;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class EMFSWTBinding
extends EMFBinding
implements Listener,
DisposeListener {
    private Control control;
    private int eventType;

    public EMFSWTBinding(IEMFBindingAction anAction, EClass anEClass, Control aControl, int anEventType) {
        super(anAction);
        Assert.isNotNull((Object)aControl);
        Assert.isLegal((!aControl.isDisposed() ? 1 : 0) != 0);
        this.control = aControl;
        this.eventType = anEventType;
        this.control.addDisposeListener((DisposeListener)this);
        ISelectionDispatcher dispatcher = DispatcherFactory.getSelectionDispatcher();
        Assert.isNotNull((Object)dispatcher);
        Assert.isNotNull((Object)anEClass);
        EObject eObj = dispatcher.getCurrentSelection(anEClass);
        Assert.isNotNull((Object)eObj);
        this.action.doInit(eObj, this.control, this);
        this.registerViewListeners();
    }

    protected void doViewAction(final Notification aNotification) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                if (!EMFSWTBinding.this.control.isDisposed()) {
                    EMFSWTBinding.this.deregisterViewListeners();
                    EMFSWTBinding.this.action.doView(aNotification, EMFSWTBinding.this.control, EMFSWTBinding.this);
                    EMFSWTBinding.this.registerViewListeners();
                }
            }
        });
    }

    protected void doInitAction(EObject anEObj) {
        this.action.doInit(anEObj, this.control, this);
    }

    protected void doDeinitAction(EObject anEObj) {
        this.action.doDeinit(anEObj, this.control, this);
    }

    private void deregisterViewListeners() {
        this.control.removeListener(this.eventType, (Listener)this);
    }

    private void registerViewListeners() {
        this.control.addListener(this.eventType, (Listener)this);
    }

    public void handleEvent(Event event) {
        this.doModelAction(this.control);
    }

    public void widgetDisposed(DisposeEvent e) {
        this.doDeinitAction((EObject)this.target);
    }
}

